/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Replaces the match of pattern in input with rewrite.
 * <p>
 * It follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
 */
@Operator
public final class RegexReplace extends PrimitiveOp implements Operand<String> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.RegexReplace}
   */
  public static class Options {
    
    /**
     * @param replaceGlobal If True, the replacement is global, otherwise the replacement
     * is done only on the first match.
     */
    public Options replaceGlobal(Boolean replaceGlobal) {
      this.replaceGlobal = replaceGlobal;
      return this;
    }
    
    private Boolean replaceGlobal;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new RegexReplace operation to the graph.
   * 
   * @param scope current graph scope
   * @param input The text to be processed.
   * @param pattern The regular expression to match the input.
   * @param rewrite The rewrite to be applied to the matched expresion.
   * @param options carries optional attributes values
   * @return a new instance of RegexReplace
   */
  public static RegexReplace create(Scope scope, Operand<String> input, Operand<String> pattern, Operand<String> rewrite, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("RegexReplace", scope.makeOpName("RegexReplace"));
    opBuilder.addInput(input.asOutput());
    opBuilder.addInput(pattern.asOutput());
    opBuilder.addInput(rewrite.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.replaceGlobal != null) {
          opBuilder.setAttr("replace_global", opts.replaceGlobal);
        }
      }
    }
    return new RegexReplace(opBuilder.build());
  }
  
  /**
   * @param replaceGlobal If True, the replacement is global, otherwise the replacement
   * is done only on the first match.
   */
  public static Options replaceGlobal(Boolean replaceGlobal) {
    return new Options().replaceGlobal(replaceGlobal);
  }
  
  /**
   * The text after applying pattern and rewrite.
   */
  public Output<String> output() {
    return output;
  }
  
  @Override
  public Output<String> asOutput() {
    return output;
  }
  
  private Output<String> output;
  
  private RegexReplace(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
