/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Quantizes then dequantizes a tensor.
 * <p>
 * This op simulates the precision loss from the quantized forward pass by:
 * <p>
 * 1. Quantizing the tensor to fixed point numbers, which should match the target
 *    quantization method when it is used in inference.
 * 2. Dequantizing it back to floating point numbers for the following ops, most
 *    likely matmul.
 * <p>
 * There are different ways to quantize. This version uses only scaling, so 0.0
 * maps to 0.
 * <p>
 * From the specified 'num_bits' in the quantized output type, it determines
 * minimum and maximum representable quantized values.
 * <p>
 * e.g.
 * <ul>
 * <li>
 * [-128, 127] for signed, num_bits = 8, or
 * </li>
 * <li>
 * [0, 255] for unsigned, num_bits = 8.
 * </li>
 * </ul>
 * If range_given == False, the initial input_min, input_max will be determined
 * automatically as the minimum and maximum values in the input tensor, otherwise
 * the specified values of input_min, input_max are used.
 * <p>
 * Note: If the input_min, input_max are specified, they do not need to equal the
 * actual minimum and maximum values in the tensor. e.g. in some cases it may be
 * beneficial to specify these values such that the low probability extremes of the
 * input distribution are clipped.
 * <p>
 * This op determines the maximum scale_factor that would map the initial
 * [input_min, input_max] range to a range that lies within the representable
 * quantized range.
 * <p>
 * It determines the scale from one of input_min and input_max, then updates the
 * other one to maximize the respresentable range.
 * <p>
 * e.g.
 * <ul>
 * <li>
 * if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
 *     5.0]: it would use a scale_factor of -128 / -10.0 = 12.8 In this case, it
 *     would update input_max to be 127 / 12.8 = 9.921875
 * </li>
 * <li>
 * if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
 *     10.0]: it would use a scale_factor of 127 / 10.0 = 12.7 In this case, it
 *     would update input_min to be 128.0 / 12.7 = -10.07874
 * </li>
 * <li>
 * if the output is unsigned, input_min is forced to be 0, and only the
 *     specified input_max is used.
 * </li>
 * </ul>
 * After determining the scale_factor and updating the input range, it applies the
 * following to each value in the 'input' tensor.
 * <p>
 * output = round(clamp(value, input_min, input_max) * scale_factor) / scale_factor.
 * <p>
 * The above round function rounds the value based on the given round_mode.
 * 
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class QuantizeAndDequantizeV2<T extends Number> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.QuantizeAndDequantizeV2}
   */
  public static class Options {
    
    /**
     * @param signedInput Whether the quantization is signed or unsigned. (actually this parameter should
     * have been called <b>`signed_output`</b>)
     */
    public Options signedInput(Boolean signedInput) {
      this.signedInput = signedInput;
      return this;
    }
    
    /**
     * @param numBits The bitwidth of the quantization.
     */
    public Options numBits(Long numBits) {
      this.numBits = numBits;
      return this;
    }
    
    /**
     * @param rangeGiven Whether the range is given or should be determined from the `input` tensor.
     */
    public Options rangeGiven(Boolean rangeGiven) {
      this.rangeGiven = rangeGiven;
      return this;
    }
    
    /**
     * @param roundMode The 'round_mode' attribute controls which rounding tie-breaking algorithm is
     * used when rounding float values to their quantized equivalents. The following
     * rounding modes are currently supported:
     * <ul>
     * <li>
     * HALF_TO_EVEN: this is the default round_mode.
     * </li>
     * <li>
     * HALF_UP: round towards positive. In this mode 7.5 rounds up to 8 and -7.5
     *     rounds up to -7.
     * 
     */
    public Options roundMode(String roundMode) {
      this.roundMode = roundMode;
      return this;
    }
    
    private Boolean signedInput;
    private Long numBits;
    private Boolean rangeGiven;
    private String roundMode;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new QuantizeAndDequantizeV2 operation to the graph.
   * 
   * @param scope current graph scope
   * @param input Tensor to quantize and then dequantize.
   * @param inputMin If `range_given == True`, this specifies the minimum input value that needs to
   * be represented, otherwise it is determined from the min value of the `input`
   * tensor.
   * @param inputMax If `range_given == True`, this specifies the maximum input value that needs to
   * be represented, otherwise it is determined from the max value of the `input`
   * tensor.
   * @param options carries optional attributes values
   * @return a new instance of QuantizeAndDequantizeV2
   */
  public static <T extends Number> QuantizeAndDequantizeV2<T> create(Scope scope, Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("QuantizeAndDequantizeV2", scope.makeOpName("QuantizeAndDequantizeV2"));
    opBuilder.addInput(input.asOutput());
    opBuilder.addInput(inputMin.asOutput());
    opBuilder.addInput(inputMax.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.signedInput != null) {
          opBuilder.setAttr("signed_input", opts.signedInput);
        }
        if (opts.numBits != null) {
          opBuilder.setAttr("num_bits", opts.numBits);
        }
        if (opts.rangeGiven != null) {
          opBuilder.setAttr("range_given", opts.rangeGiven);
        }
        if (opts.roundMode != null) {
          opBuilder.setAttr("round_mode", opts.roundMode);
        }
      }
    }
    return new QuantizeAndDequantizeV2<T>(opBuilder.build());
  }
  
  /**
   * @param signedInput Whether the quantization is signed or unsigned. (actually this parameter should
   * have been called <b>`signed_output`</b>)
   */
  public static Options signedInput(Boolean signedInput) {
    return new Options().signedInput(signedInput);
  }
  
  /**
   * @param numBits The bitwidth of the quantization.
   */
  public static Options numBits(Long numBits) {
    return new Options().numBits(numBits);
  }
  
  /**
   * @param rangeGiven Whether the range is given or should be determined from the `input` tensor.
   */
  public static Options rangeGiven(Boolean rangeGiven) {
    return new Options().rangeGiven(rangeGiven);
  }
  
  /**
   * @param roundMode The 'round_mode' attribute controls which rounding tie-breaking algorithm is
   * used when rounding float values to their quantized equivalents. The following
   * rounding modes are currently supported:
   * <ul>
   * <li>
   * HALF_TO_EVEN: this is the default round_mode.
   * </li>
   * <li>
   * HALF_UP: round towards positive. In this mode 7.5 rounds up to 8 and -7.5
   *     rounds up to -7.
   * 
   */
  public static Options roundMode(String roundMode) {
    return new Options().roundMode(roundMode);
  }
  
  /**
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private QuantizeAndDequantizeV2(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
