/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Prints a string scalar.
 * <p>
 * Prints a string scalar to the desired output_stream.
 */
@Operator
public final class PrintV2 extends PrimitiveOp {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.PrintV2}
   */
  public static class Options {
    
    /**
     * @param outputStream A string specifying the output stream or logging level to print to.
     */
    public Options outputStream(String outputStream) {
      this.outputStream = outputStream;
      return this;
    }
    
    private String outputStream;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new PrintV2 operation to the graph.
   * 
   * @param scope current graph scope
   * @param input The string scalar to print.
   * @param options carries optional attributes values
   * @return a new instance of PrintV2
   */
  public static PrintV2 create(Scope scope, Operand<String> input, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("PrintV2", scope.makeOpName("PrintV2"));
    opBuilder.addInput(input.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.outputStream != null) {
          opBuilder.setAttr("output_stream", opts.outputStream);
        }
      }
    }
    return new PrintV2(opBuilder.build());
  }
  
  /**
   * @param outputStream A string specifying the output stream or logging level to print to.
   */
  public static Options outputStream(String outputStream) {
    return new Options().outputStream(outputStream);
  }
  
  
  private PrintV2(Operation operation) {
    super(operation);
  }
}
