/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * A placeholder op for a value that will be fed into the computation.
 * <p>
 * N.B. This operation will fail with an error if it is executed. It is
 * intended as a way to represent a value that will always be fed, and to
 * provide attrs that enable the fed value to be checked at runtime.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class PlaceholderV2<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new PlaceholderV2 operation to the graph.
   * 
   * @param scope current graph scope
   * @param dtype The type of elements in the tensor.
   * @param shape The shape of the tensor. The shape can be any partially-specified
   * shape.  To be unconstrained, pass in a shape with unknown rank.
   * @return a new instance of PlaceholderV2
   */
  public static <T> PlaceholderV2<T> create(Scope scope, Class<T> dtype, Shape shape) {
    OperationBuilder opBuilder = scope.graph().opBuilder("PlaceholderV2", scope.makeOpName("PlaceholderV2"));
    opBuilder.setAttr("dtype", DataType.fromClass(dtype));
    opBuilder.setAttr("shape", shape);
    return new PlaceholderV2<T>(opBuilder.build());
  }
  
  /**
   * A placeholder tensor that must be replaced using the feed mechanism.
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private PlaceholderV2(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
