/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Greedily selects a subset of bounding boxes in descending order of score,
 * <p>
 * pruning away boxes that have high intersection-over-union (IOU) overlap
 * with previously selected boxes.  Bounding boxes with score less than
 * `score_threshold` are removed.  Bounding boxes are supplied as
 * [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
 * diagonal pair of box corners and the coordinates can be provided as normalized
 * (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
 * is agnostic to where the origin is in the coordinate system and more
 * generally is invariant to orthogonal transformations and translations
 * of the coordinate system; thus translating or reflections of the coordinate
 * system result in the same boxes being selected by the algorithm.
 * The output of this operation is a set of integers indexing into the input
 * collection of bounding boxes representing the selected boxes.  The bounding
 * box coordinates corresponding to the selected indices can then be obtained
 * using the `tf.gather operation`.  For example:
 *   selected_indices = tf.image.non_max_suppression_v2(
 *       boxes, scores, max_output_size, iou_threshold, score_threshold)
 *   selected_boxes = tf.gather(boxes, selected_indices)
 */
@Operator
public final class NonMaxSuppressionV3 extends PrimitiveOp implements Operand<Integer> {
  
  /**
   * Factory method to create a class to wrap a new NonMaxSuppressionV3 operation to the graph.
   * 
   * @param scope current graph scope
   * @param boxes A 2-D float tensor of shape `[num_boxes, 4]`.
   * @param scores A 1-D float tensor of shape `[num_boxes]` representing a single
   * score corresponding to each box (each row of boxes).
   * @param maxOutputSize A scalar integer tensor representing the maximum number of
   * boxes to be selected by non max suppression.
   * @param iouThreshold A 0-D float tensor representing the threshold for deciding whether
   * boxes overlap too much with respect to IOU.
   * @param scoreThreshold A 0-D float tensor representing the threshold for deciding when to remove
   * boxes based on score.
   * @return a new instance of NonMaxSuppressionV3
   */
  public static <T extends Number> NonMaxSuppressionV3 create(Scope scope, Operand<T> boxes, Operand<T> scores, Operand<Integer> maxOutputSize, Operand<Float> iouThreshold, Operand<Float> scoreThreshold) {
    OperationBuilder opBuilder = scope.graph().opBuilder("NonMaxSuppressionV3", scope.makeOpName("NonMaxSuppressionV3"));
    opBuilder.addInput(boxes.asOutput());
    opBuilder.addInput(scores.asOutput());
    opBuilder.addInput(maxOutputSize.asOutput());
    opBuilder.addInput(iouThreshold.asOutput());
    opBuilder.addInput(scoreThreshold.asOutput());
    return new NonMaxSuppressionV3(opBuilder.build());
  }
  
  /**
   * A 1-D integer tensor of shape `[M]` representing the selected
   * indices from the boxes tensor, where `M <= max_output_size`.
   */
  public Output<Integer> selectedIndices() {
    return selectedIndices;
  }
  
  @Override
  public Output<Integer> asOutput() {
    return selectedIndices;
  }
  
  private Output<Integer> selectedIndices;
  
  private NonMaxSuppressionV3(Operation operation) {
    super(operation);
    int outputIdx = 0;
    selectedIndices = operation.output(outputIdx++);
  }
}
