/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Greedily selects a subset of bounding boxes in descending order of score,
 * <p>
 * pruning away boxes that have high intersection-over-union (IOU) overlap
 * with previously selected boxes.  Bounding boxes are supplied as
 * [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
 * diagonal pair of box corners and the coordinates can be provided as normalized
 * (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
 * is agnostic to where the origin is in the coordinate system.  Note that this
 * algorithm is invariant to orthogonal transformations and translations
 * of the coordinate system; thus translating or reflections of the coordinate
 * system result in the same boxes being selected by the algorithm.
 * The output of this operation is a set of integers indexing into the input
 * collection of bounding boxes representing the selected boxes.  The bounding
 * box coordinates corresponding to the selected indices can then be obtained
 * using the `tf.gather operation`.  For example:
 *   selected_indices = tf.image.non_max_suppression(
 *       boxes, scores, max_output_size, iou_threshold)
 *   selected_boxes = tf.gather(boxes, selected_indices)
 */
@Operator
public final class NonMaxSuppression extends PrimitiveOp implements Operand<Integer> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.NonMaxSuppression}
   */
  public static class Options {
    
    /**
     * @param iouThreshold A float representing the threshold for deciding whether boxes
     * overlap too much with respect to IOU.
     */
    public Options iouThreshold(Float iouThreshold) {
      this.iouThreshold = iouThreshold;
      return this;
    }
    
    private Float iouThreshold;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new NonMaxSuppression operation to the graph.
   * 
   * @param scope current graph scope
   * @param boxes A 2-D float tensor of shape `[num_boxes, 4]`.
   * @param scores A 1-D float tensor of shape `[num_boxes]` representing a single
   * score corresponding to each box (each row of boxes).
   * @param maxOutputSize A scalar integer tensor representing the maximum number of
   * boxes to be selected by non max suppression.
   * @param options carries optional attributes values
   * @return a new instance of NonMaxSuppression
   */
  public static NonMaxSuppression create(Scope scope, Operand<Float> boxes, Operand<Float> scores, Operand<Integer> maxOutputSize, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("NonMaxSuppression", scope.makeOpName("NonMaxSuppression"));
    opBuilder.addInput(boxes.asOutput());
    opBuilder.addInput(scores.asOutput());
    opBuilder.addInput(maxOutputSize.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.iouThreshold != null) {
          opBuilder.setAttr("iou_threshold", opts.iouThreshold);
        }
      }
    }
    return new NonMaxSuppression(opBuilder.build());
  }
  
  /**
   * @param iouThreshold A float representing the threshold for deciding whether boxes
   * overlap too much with respect to IOU.
   */
  public static Options iouThreshold(Float iouThreshold) {
    return new Options().iouThreshold(iouThreshold);
  }
  
  /**
   * A 1-D integer tensor of shape `[M]` representing the selected
   * indices from the boxes tensor, where `M <= max_output_size`.
   */
  public Output<Integer> selectedIndices() {
    return selectedIndices;
  }
  
  @Override
  public Output<Integer> asOutput() {
    return selectedIndices;
  }
  
  private Output<Integer> selectedIndices;
  
  private NonMaxSuppression(Operation operation) {
    super(operation);
    int outputIdx = 0;
    selectedIndices = operation.output(outputIdx++);
  }
}
