/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Performs max pooling on the input and outputs both max values and indices.
 * <p>
 * The indices in `argmax` are flattened, so that a maximum value at position
 * `[b, y, x, c]` becomes flattened index
 * `((b * height + y) * width + x) * channels + c`.
 * <p>
 * The indices returned are always in `[0, height) x [0, width)` before flattening,
 * even if padding is involved and the mathematically correct answer is outside
 * (either negative or too large).  This is a bug, but fixing it is difficult to do
 * in a safe backwards compatible way, especially due to flattening.
 * 
 * @param <T> data type for {@code output()} output
 * @param <U> data type for {@code argmax()} output
 */
@Operator
public final class MaxPoolWithArgmax<T extends Number, U extends Number> extends PrimitiveOp {
  
  /**
   * Factory method to create a class to wrap a new MaxPoolWithArgmax operation to the graph.
   * 
   * @param scope current graph scope
   * @param input 4-D with shape `[batch, height, width, channels]`.  Input to pool over.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * input tensor.
   * @param Targmax 
   * @param padding The type of padding algorithm to use.
   * @return a new instance of MaxPoolWithArgmax
   */
  public static <T extends Number, U extends Number> MaxPoolWithArgmax<T, U> create(Scope scope, Operand<T> input, List<Long> ksize, List<Long> strides, Class<U> Targmax, String padding) {
    OperationBuilder opBuilder = scope.graph().opBuilder("MaxPoolWithArgmax", scope.makeOpName("MaxPoolWithArgmax"));
    opBuilder.addInput(input.asOutput());
    long[] ksizeArray = new long[ksize.size()];
    for (int i = 0; i < ksizeArray.length; ++i) {
      ksizeArray[i] = ksize.get(i);
    }
    opBuilder.setAttr("ksize", ksizeArray);
    long[] stridesArray = new long[strides.size()];
    for (int i = 0; i < stridesArray.length; ++i) {
      stridesArray[i] = strides.get(i);
    }
    opBuilder.setAttr("strides", stridesArray);
    opBuilder.setAttr("Targmax", DataType.fromClass(Targmax));
    opBuilder.setAttr("padding", padding);
    return new MaxPoolWithArgmax<T, U>(opBuilder.build());
  }
  
  /**
   * Factory method to create a class to wrap a new MaxPoolWithArgmax operation to the graph, using default output types.
   * 
   * @param scope current graph scope
   * @param input 4-D with shape `[batch, height, width, channels]`.  Input to pool over.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * input tensor.
   * @param padding The type of padding algorithm to use.
   * @return a new instance of MaxPoolWithArgmax
   */
  public static <T extends Number> MaxPoolWithArgmax<T, Long> create(Scope scope, Operand<T> input, List<Long> ksize, List<Long> strides, String padding) {
    return create(scope, input, ksize, strides, Long.class, padding);
  }
  
  /**
   * The max pooled output tensor.
   */
  public Output<T> output() {
    return output;
  }
  
  /**
   * 4-D.  The flattened indices of the max values chosen for each output.
   */
  public Output<U> argmax() {
    return argmax;
  }
  
  private Output<T> output;
  private Output<U> argmax;
  
  private MaxPoolWithArgmax(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
    argmax = operation.output(outputIdx++);
  }
}
