/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Converts the given string representing a handle to an iterator to a resource.
 */
@Operator
public final class IteratorFromStringHandle extends PrimitiveOp implements Operand<Object> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.IteratorFromStringHandle}
   */
  public static class Options {
    
    /**
     * @param outputShapes If specified, defines the shape of each tuple component in an
     * element produced by the resulting iterator.
     */
    public Options outputShapes(List<Shape> outputShapes) {
      this.outputShapes = outputShapes;
      return this;
    }
    
    private List<Shape> outputShapes;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new IteratorFromStringHandle operation to the graph.
   * 
   * @param scope current graph scope
   * @param stringHandle A string representation of the given handle.
   * @param outputTypes If specified, defines the type of each tuple component in an
   * element produced by the resulting iterator.
   * @param options carries optional attributes values
   * @return a new instance of IteratorFromStringHandle
   */
  public static IteratorFromStringHandle create(Scope scope, Operand<String> stringHandle, List<Class<?>> outputTypes, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("IteratorFromStringHandle", scope.makeOpName("IteratorFromStringHandle"));
    opBuilder.addInput(stringHandle.asOutput());
    DataType[] outputTypesArray = new DataType[outputTypes.size()];
    for (int i = 0; i < outputTypesArray.length; ++i) {
      outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
    }
    opBuilder.setAttr("output_types", outputTypesArray);
    if (options != null) {
      for (Options opts : options) {
        if (opts.outputShapes != null) {
          Shape[] outputShapesArray = new Shape[opts.outputShapes.size()];
          for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = opts.outputShapes.get(i);
          }
          opBuilder.setAttr("output_shapes", outputShapesArray);
        }
      }
    }
    return new IteratorFromStringHandle(opBuilder.build());
  }
  
  /**
   * @param outputShapes If specified, defines the shape of each tuple component in an
   * element produced by the resulting iterator.
   */
  public static Options outputShapes(List<Shape> outputShapes) {
    return new Options().outputShapes(outputShapes);
  }
  
  /**
   * A handle to an iterator resource.
   */
  public Output<?> resourceHandle() {
    return resourceHandle;
  }
  
  @Override
  @SuppressWarnings("unchecked")
  public Output<Object> asOutput() {
    return (Output<Object>) resourceHandle;
  }
  
  private Output<?> resourceHandle;
  
  private IteratorFromStringHandle(Operation operation) {
    super(operation);
    int outputIdx = 0;
    resourceHandle = operation.output(outputIdx++);
  }
}
