/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Gather slices from `params` axis `axis` according to `indices`.
 * <p>
 * `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
 * Produces an output tensor with shape `params.shape[:axis] + indices.shape +
 * params.shape[axis + 1:]` where:
 * <pre>{@code
 *     # Scalar indices (output is rank(params) - 1).
 *     output[a_0, ..., a_n, b_0, ..., b_n] =
 *       params[a_0, ..., a_n, indices, b_0, ..., b_n]
 * 
 *     # Vector indices (output is rank(params)).
 *     output[a_0, ..., a_n, i, b_0, ..., b_n] =
 *       params[a_0, ..., a_n, indices[i], b_0, ..., b_n]
 * 
 *     # Higher rank indices (output is rank(params) + rank(indices) - 1).
 *     output[a_0, ..., a_n, i, ..., j, b_0, ... b_n] =
 *       params[a_0, ..., a_n, indices[i, ..., j], b_0, ..., b_n]
 * }</pre>
 * <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
 * <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
 * </div>
 * <p>
 * Note that on CPU, if an out of bound index is found, an error is returned.
 * On GPU, if an out of bound index is found, a 0 is stored in the
 * corresponding output value.
 * <p>
 * See also `tf.batch_gather` and `tf.gather_nd`.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class GatherV2<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new GatherV2 operation to the graph.
   * 
   * @param scope current graph scope
   * @param params The tensor from which to gather values. Must be at least rank
   * `axis + 1`.
   * @param indices Index tensor. Must be in range `[0, params.shape[axis])`.
   * @param axis The axis in `params` to gather `indices` from. Defaults to the first
   * dimension. Supports negative indexes.
   * @return a new instance of GatherV2
   */
  public static <T, U extends Number, V extends Number> GatherV2<T> create(Scope scope, Operand<T> params, Operand<U> indices, Operand<V> axis) {
    OperationBuilder opBuilder = scope.graph().opBuilder("GatherV2", scope.makeOpName("GatherV2"));
    opBuilder.addInput(params.asOutput());
    opBuilder.addInput(indices.asOutput());
    opBuilder.addInput(axis.asOutput());
    return new GatherV2<T>(opBuilder.build());
  }
  
  /**
   * Values from `params` gathered from indices given by `indices`, with
   * shape `params.shape[:axis] + indices.shape + params.shape[axis + 1:]`.
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private GatherV2(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
