/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

/**
 * Returns the cardinality of `input_dataset`.
 * <p>
 * Returns the cardinality of `input_dataset`.
 */
public final class ExperimentalDatasetCardinality extends PrimitiveOp implements Operand<Long> {
  
  /**
   * Factory method to create a class to wrap a new ExperimentalDatasetCardinality operation to the graph.
   * 
   * @param scope current graph scope
   * @param inputDataset A variant tensor representing the dataset to return cardinality for.
   * @return a new instance of ExperimentalDatasetCardinality
   */
  public static ExperimentalDatasetCardinality create(Scope scope, Operand<?> inputDataset) {
    OperationBuilder opBuilder = scope.graph().opBuilder("ExperimentalDatasetCardinality", scope.makeOpName("ExperimentalDatasetCardinality"));
    opBuilder.addInput(inputDataset.asOutput());
    return new ExperimentalDatasetCardinality(opBuilder.build());
  }
  
  /**
   * The cardinality of `input_dataset`. Named constants are used to represent
   * infinite and unknown cardinality.
   */
  public Output<Long> cardinality() {
    return cardinality;
  }
  
  @Override
  public Output<Long> asOutput() {
    return cardinality;
  }
  
  private Output<Long> cardinality;
  
  private ExperimentalDatasetCardinality(Operation operation) {
    super(operation);
    int outputIdx = 0;
    cardinality = operation.output(outputIdx++);
  }
}
