/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Computes the Bessel i1e function of `x` element-wise.
 * <p>
 * Exponentially scaled modified Bessel function of order 0 defined as
 * `bessel_i1e(x) = exp(-abs(x)) bessel_i1(x)`.
 * <p>
 * This function is faster and numerically stabler than `bessel_i1(x)`.
 * 
 * @param <T> data type for {@code y()} output
 */
@Operator
public final class BesselI1e<T extends Number> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new BesselI1e operation to the graph.
   * 
   * @param scope current graph scope
   * @param x 
   * @return a new instance of BesselI1e
   */
  public static <T extends Number> BesselI1e<T> create(Scope scope, Operand<T> x) {
    OperationBuilder opBuilder = scope.graph().opBuilder("BesselI1e", scope.makeOpName("BesselI1e"));
    opBuilder.addInput(x.asOutput());
    return new BesselI1e<T>(opBuilder.build());
  }
  
  /**
   */
  public Output<T> y() {
    return y;
  }
  
  @Override
  public Output<T> asOutput() {
    return y;
  }
  
  private Output<T> y;
  
  private BesselI1e(Operation operation) {
    super(operation);
    int outputIdx = 0;
    y = operation.output(outputIdx++);
  }
}
