/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * @param <T> data type for {@code s()} output
 */
@Operator
public final class BatchSvd<T> extends PrimitiveOp {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.BatchSvd}
   */
  public static class Options {
    
    /**
     * @param computeUv 
     */
    public Options computeUv(Boolean computeUv) {
      this.computeUv = computeUv;
      return this;
    }
    
    /**
     * @param fullMatrices 
     */
    public Options fullMatrices(Boolean fullMatrices) {
      this.fullMatrices = fullMatrices;
      return this;
    }
    
    private Boolean computeUv;
    private Boolean fullMatrices;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new BatchSvd operation to the graph.
   * 
   * @param scope current graph scope
   * @param input 
   * @param options carries optional attributes values
   * @return a new instance of BatchSvd
   */
  public static <T> BatchSvd<T> create(Scope scope, Operand<T> input, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("BatchSvd", scope.makeOpName("BatchSvd"));
    opBuilder.addInput(input.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.computeUv != null) {
          opBuilder.setAttr("compute_uv", opts.computeUv);
        }
        if (opts.fullMatrices != null) {
          opBuilder.setAttr("full_matrices", opts.fullMatrices);
        }
      }
    }
    return new BatchSvd<T>(opBuilder.build());
  }
  
  /**
   * @param computeUv 
   */
  public static Options computeUv(Boolean computeUv) {
    return new Options().computeUv(computeUv);
  }
  
  /**
   * @param fullMatrices 
   */
  public static Options fullMatrices(Boolean fullMatrices) {
    return new Options().fullMatrices(fullMatrices);
  }
  
  /**
   */
  public Output<T> s() {
    return s;
  }
  
  /**
   */
  public Output<T> u() {
    return u;
  }
  
  /**
   */
  public Output<T> v() {
    return v;
  }
  
  private Output<T> s;
  private Output<T> u;
  private Output<T> v;
  
  private BatchSvd(Operation operation) {
    super(operation);
    int outputIdx = 0;
    s = operation.output(outputIdx++);
    u = operation.output(outputIdx++);
    v = operation.output(outputIdx++);
  }
}
