package org.tensorflow.op;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.tensorflow.Graph;
import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.core.Abort;
import org.tensorflow.op.core.Abs;
import org.tensorflow.op.core.AccumulateNV2;
import org.tensorflow.op.core.AccumulatorApplyGradient;
import org.tensorflow.op.core.AccumulatorNumAccumulated;
import org.tensorflow.op.core.AccumulatorSetGlobalStep;
import org.tensorflow.op.core.AccumulatorTakeGradient;
import org.tensorflow.op.core.Acos;
import org.tensorflow.op.core.Acosh;
import org.tensorflow.op.core.Add;
import org.tensorflow.op.core.AddManySparseToTensorsMap;
import org.tensorflow.op.core.AddN;
import org.tensorflow.op.core.AddSparseToTensorsMap;
import org.tensorflow.op.core.AddV2;
import org.tensorflow.op.core.AdjustContrast;
import org.tensorflow.op.core.AdjustHue;
import org.tensorflow.op.core.AdjustSaturation;
import org.tensorflow.op.core.All;
import org.tensorflow.op.core.AllCandidateSampler;
import org.tensorflow.op.core.Angle;
import org.tensorflow.op.core.AnonymousIterator;
import org.tensorflow.op.core.Any;
import org.tensorflow.op.core.ApplyAdadelta;
import org.tensorflow.op.core.ApplyAdagrad;
import org.tensorflow.op.core.ApplyAdagradDA;
import org.tensorflow.op.core.ApplyAdam;
import org.tensorflow.op.core.ApplyAddSign;
import org.tensorflow.op.core.ApplyCenteredRMSProp;
import org.tensorflow.op.core.ApplyFtrl;
import org.tensorflow.op.core.ApplyFtrlV2;
import org.tensorflow.op.core.ApplyGradientDescent;
import org.tensorflow.op.core.ApplyMomentum;
import org.tensorflow.op.core.ApplyPowerSign;
import org.tensorflow.op.core.ApplyProximalAdagrad;
import org.tensorflow.op.core.ApplyProximalGradientDescent;
import org.tensorflow.op.core.ApplyRMSProp;
import org.tensorflow.op.core.ApproximateEqual;
import org.tensorflow.op.core.ArgMax;
import org.tensorflow.op.core.ArgMin;
import org.tensorflow.op.core.AsString;
import org.tensorflow.op.core.Asin;
import org.tensorflow.op.core.Asinh;
import org.tensorflow.op.core.Assign;
import org.tensorflow.op.core.AssignAdd;
import org.tensorflow.op.core.AssignAddVariableOp;
import org.tensorflow.op.core.AssignSub;
import org.tensorflow.op.core.AssignSubVariableOp;
import org.tensorflow.op.core.AssignVariableOp;
import org.tensorflow.op.core.Atan;
import org.tensorflow.op.core.Atan2;
import org.tensorflow.op.core.Atanh;
import org.tensorflow.op.core.AudioSpectrogram;
import org.tensorflow.op.core.AudioSummary;
import org.tensorflow.op.core.AvgPool;
import org.tensorflow.op.core.AvgPool3D;
import org.tensorflow.op.core.AvgPool3DGrad;
import org.tensorflow.op.core.Barrier;
import org.tensorflow.op.core.BarrierClose;
import org.tensorflow.op.core.BarrierIncompleteSize;
import org.tensorflow.op.core.BarrierInsertMany;
import org.tensorflow.op.core.BarrierReadySize;
import org.tensorflow.op.core.BarrierTakeMany;
import org.tensorflow.op.core.Batch;
import org.tensorflow.op.core.BatchCholesky;
import org.tensorflow.op.core.BatchCholeskyGrad;
import org.tensorflow.op.core.BatchFFT;
import org.tensorflow.op.core.BatchFFT2D;
import org.tensorflow.op.core.BatchFFT3D;
import org.tensorflow.op.core.BatchIFFT;
import org.tensorflow.op.core.BatchIFFT2D;
import org.tensorflow.op.core.BatchIFFT3D;
import org.tensorflow.op.core.BatchMatMul;
import org.tensorflow.op.core.BatchMatrixBandPart;
import org.tensorflow.op.core.BatchMatrixDeterminant;
import org.tensorflow.op.core.BatchMatrixDiag;
import org.tensorflow.op.core.BatchMatrixDiagPart;
import org.tensorflow.op.core.BatchMatrixInverse;
import org.tensorflow.op.core.BatchMatrixSetDiag;
import org.tensorflow.op.core.BatchMatrixSolve;
import org.tensorflow.op.core.BatchMatrixSolveLs;
import org.tensorflow.op.core.BatchMatrixTriangularSolve;
import org.tensorflow.op.core.BatchNormWithGlobalNormalization;
import org.tensorflow.op.core.BatchNormWithGlobalNormalizationGrad;
import org.tensorflow.op.core.BatchSelfAdjointEig;
import org.tensorflow.op.core.BatchSelfAdjointEigV2;
import org.tensorflow.op.core.BatchSvd;
import org.tensorflow.op.core.BatchToSpace;
import org.tensorflow.op.core.BatchToSpaceND;
import org.tensorflow.op.core.BesselI0e;
import org.tensorflow.op.core.BesselI1e;
import org.tensorflow.op.core.Betainc;
import org.tensorflow.op.core.BiasAdd;
import org.tensorflow.op.core.BiasAddGrad;
import org.tensorflow.op.core.BigQueryReader;
import org.tensorflow.op.core.Bincount;
import org.tensorflow.op.core.Bitcast;
import org.tensorflow.op.core.BitwiseAnd;
import org.tensorflow.op.core.BitwiseOr;
import org.tensorflow.op.core.BitwiseXor;
import org.tensorflow.op.core.BroadcastDynamicShape;
import org.tensorflow.op.core.BroadcastTo;
import org.tensorflow.op.core.Bucketize;
import org.tensorflow.op.core.CTCBeamSearchDecoder;
import org.tensorflow.op.core.CTCGreedyDecoder;
import org.tensorflow.op.core.CTCLoss;
import org.tensorflow.op.core.Cast;
import org.tensorflow.op.core.Ceil;
import org.tensorflow.op.core.CheckNumerics;
import org.tensorflow.op.core.Cholesky;
import org.tensorflow.op.core.CholeskyGrad;
import org.tensorflow.op.core.ClipByValue;
import org.tensorflow.op.core.CompareAndBitpack;
import org.tensorflow.op.core.Complex;
import org.tensorflow.op.core.ComplexAbs;
import org.tensorflow.op.core.ComputeAccidentalHits;
import org.tensorflow.op.core.Concat;
import org.tensorflow.op.core.ConditionalAccumulator;
import org.tensorflow.op.core.Conj;
import org.tensorflow.op.core.ConjugateTranspose;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.ConsumeMutexLock;
import org.tensorflow.op.core.ControlTrigger;
import org.tensorflow.op.core.Conv2D;
import org.tensorflow.op.core.Conv2DBackpropFilter;
import org.tensorflow.op.core.Conv2DBackpropInput;
import org.tensorflow.op.core.Conv3D;
import org.tensorflow.op.core.Conv3DBackpropFilter;
import org.tensorflow.op.core.Conv3DBackpropFilterV2;
import org.tensorflow.op.core.Conv3DBackpropInput;
import org.tensorflow.op.core.Conv3DBackpropInputV2;
import org.tensorflow.op.core.Cos;
import org.tensorflow.op.core.Cosh;
import org.tensorflow.op.core.CountUpTo;
import org.tensorflow.op.core.CropAndResize;
import org.tensorflow.op.core.CropAndResizeGradBoxes;
import org.tensorflow.op.core.CropAndResizeGradImage;
import org.tensorflow.op.core.Cross;
import org.tensorflow.op.core.CudnnRNN;
import org.tensorflow.op.core.CudnnRNNBackprop;
import org.tensorflow.op.core.CudnnRNNCanonicalToParams;
import org.tensorflow.op.core.CudnnRNNParamsSize;
import org.tensorflow.op.core.CudnnRNNParamsToCanonical;
import org.tensorflow.op.core.Cumprod;
import org.tensorflow.op.core.Cumsum;
import org.tensorflow.op.core.DataFormatDimMap;
import org.tensorflow.op.core.DataFormatVecPermute;
import org.tensorflow.op.core.DebugGradientIdentity;
import org.tensorflow.op.core.DebugGradientRefIdentity;
import org.tensorflow.op.core.DecodeAndCropJpeg;
import org.tensorflow.op.core.DecodeBase64;
import org.tensorflow.op.core.DecodeBmp;
import org.tensorflow.op.core.DecodeCSV;
import org.tensorflow.op.core.DecodeCompressed;
import org.tensorflow.op.core.DecodeGif;
import org.tensorflow.op.core.DecodeJSONExample;
import org.tensorflow.op.core.DecodeJpeg;
import org.tensorflow.op.core.DecodePng;
import org.tensorflow.op.core.DecodeProtoV2;
import org.tensorflow.op.core.DecodeRaw;
import org.tensorflow.op.core.DecodeWav;
import org.tensorflow.op.core.DeepCopy;
import org.tensorflow.op.core.DeleteSessionTensor;
import org.tensorflow.op.core.DenseToDenseSetOperation;
import org.tensorflow.op.core.DenseToSparseSetOperation;
import org.tensorflow.op.core.DepthToSpace;
import org.tensorflow.op.core.DepthwiseConv2dNative;
import org.tensorflow.op.core.DepthwiseConv2dNativeBackpropFilter;
import org.tensorflow.op.core.DepthwiseConv2dNativeBackpropInput;
import org.tensorflow.op.core.Dequantize;
import org.tensorflow.op.core.DeserializeIterator;
import org.tensorflow.op.core.DeserializeManySparse;
import org.tensorflow.op.core.DeserializeSparse;
import org.tensorflow.op.core.DestroyResourceOp;
import org.tensorflow.op.core.DestroyTemporaryVariable;
import org.tensorflow.op.core.Diag;
import org.tensorflow.op.core.DiagPart;
import org.tensorflow.op.core.Digamma;
import org.tensorflow.op.core.Dilation2D;
import org.tensorflow.op.core.Dilation2DBackpropFilter;
import org.tensorflow.op.core.Dilation2DBackpropInput;
import org.tensorflow.op.core.Div;
import org.tensorflow.op.core.DivNoNan;
import org.tensorflow.op.core.DrawBoundingBoxes;
import org.tensorflow.op.core.DynamicPartition;
import org.tensorflow.op.core.DynamicStitch;
import org.tensorflow.op.core.EagerPyFunc;
import org.tensorflow.op.core.EditDistance;
import org.tensorflow.op.core.Elu;
import org.tensorflow.op.core.Empty;
import org.tensorflow.op.core.EmptyTensorList;
import org.tensorflow.op.core.EncodeBase64;
import org.tensorflow.op.core.EncodeJpeg;
import org.tensorflow.op.core.EncodePng;
import org.tensorflow.op.core.EncodeProto;
import org.tensorflow.op.core.EncodeWav;
import org.tensorflow.op.core.EnsureShape;
import org.tensorflow.op.core.Equal;
import org.tensorflow.op.core.Erf;
import org.tensorflow.op.core.Erfc;
import org.tensorflow.op.core.Exp;
import org.tensorflow.op.core.ExpandDims;
import org.tensorflow.op.core.Expm1;
import org.tensorflow.op.core.ExtractGlimpse;
import org.tensorflow.op.core.ExtractImagePatches;
import org.tensorflow.op.core.ExtractJpegShape;
import org.tensorflow.op.core.ExtractVolumePatches;
import org.tensorflow.op.core.FFT;
import org.tensorflow.op.core.FFT2D;
import org.tensorflow.op.core.FFT3D;
import org.tensorflow.op.core.FIFOQueue;
import org.tensorflow.op.core.Fact;
import org.tensorflow.op.core.FakeQuantWithMinMaxArgs;
import org.tensorflow.op.core.FakeQuantWithMinMaxArgsGradient;
import org.tensorflow.op.core.FakeQuantWithMinMaxVars;
import org.tensorflow.op.core.FakeQuantWithMinMaxVarsGradient;
import org.tensorflow.op.core.FakeQuantWithMinMaxVarsPerChannel;
import org.tensorflow.op.core.FakeQuantWithMinMaxVarsPerChannelGradient;
import org.tensorflow.op.core.Fill;
import org.tensorflow.op.core.FixedLengthRecordReader;
import org.tensorflow.op.core.FixedUnigramCandidateSampler;
import org.tensorflow.op.core.Floor;
import org.tensorflow.op.core.FloorDiv;
import org.tensorflow.op.core.FloorMod;
import org.tensorflow.op.core.FractionalAvgPool;
import org.tensorflow.op.core.FractionalMaxPool;
import org.tensorflow.op.core.FusedBatchNorm;
import org.tensorflow.op.core.FusedBatchNormGrad;
import org.tensorflow.op.core.FusedBatchNormGradV2;
import org.tensorflow.op.core.FusedBatchNormV2;
import org.tensorflow.op.core.FusedPadConv2D;
import org.tensorflow.op.core.FusedResizeAndPadConv2D;
import org.tensorflow.op.core.Gather;
import org.tensorflow.op.core.GatherNd;
import org.tensorflow.op.core.GatherV2;
import org.tensorflow.op.core.GcsConfigureBlockCache;
import org.tensorflow.op.core.GcsConfigureCredentials;
import org.tensorflow.op.core.GenerateBigQueryReaderPartitions;
import org.tensorflow.op.core.GenerateVocabRemapping;
import org.tensorflow.op.core.GetSessionHandle;
import org.tensorflow.op.core.GetSessionHandleV2;
import org.tensorflow.op.core.GetSessionTensor;
import org.tensorflow.op.core.Gradients;
import org.tensorflow.op.core.Greater;
import org.tensorflow.op.core.GreaterEqual;
import org.tensorflow.op.core.GuaranteeConst;
import org.tensorflow.op.core.HSVToRGB;
import org.tensorflow.op.core.HashTable;
import org.tensorflow.op.core.HistogramFixedWidth;
import org.tensorflow.op.core.HistogramSummary;
import org.tensorflow.op.core.IFFT;
import org.tensorflow.op.core.IFFT2D;
import org.tensorflow.op.core.IFFT3D;
import org.tensorflow.op.core.IRFFT;
import org.tensorflow.op.core.IRFFT2D;
import org.tensorflow.op.core.IRFFT3D;
import org.tensorflow.op.core.Identity;
import org.tensorflow.op.core.IdentityN;
import org.tensorflow.op.core.IdentityReader;
import org.tensorflow.op.core.Igamma;
import org.tensorflow.op.core.Igammac;
import org.tensorflow.op.core.Imag;
import org.tensorflow.op.core.ImageSummary;
import org.tensorflow.op.core.ImmutableConst;
import org.tensorflow.op.core.InTopK;
import org.tensorflow.op.core.InTopKV2;
import org.tensorflow.op.core.InitializeTable;
import org.tensorflow.op.core.InitializeTableFromTextFile;
import org.tensorflow.op.core.InplaceAdd;
import org.tensorflow.op.core.InplaceSub;
import org.tensorflow.op.core.InplaceUpdate;
import org.tensorflow.op.core.Inv;
import org.tensorflow.op.core.Invert;
import org.tensorflow.op.core.InvertPermutation;
import org.tensorflow.op.core.IsFinite;
import org.tensorflow.op.core.IsInf;
import org.tensorflow.op.core.IsNan;
import org.tensorflow.op.core.IsVariableInitialized;
import org.tensorflow.op.core.Iterator;
import org.tensorflow.op.core.IteratorFromStringHandle;
import org.tensorflow.op.core.IteratorGetNext;
import org.tensorflow.op.core.IteratorGetNextAsOptional;
import org.tensorflow.op.core.IteratorGetNextSync;
import org.tensorflow.op.core.IteratorToStringHandle;
import org.tensorflow.op.core.L2Loss;
import org.tensorflow.op.core.LMDBReader;
import org.tensorflow.op.core.LRN;
import org.tensorflow.op.core.LearnedUnigramCandidateSampler;
import org.tensorflow.op.core.LeftShift;
import org.tensorflow.op.core.Less;
import org.tensorflow.op.core.LessEqual;
import org.tensorflow.op.core.Lgamma;
import org.tensorflow.op.core.LinSpace;
import org.tensorflow.op.core.LoadAndRemapMatrix;
import org.tensorflow.op.core.Log;
import org.tensorflow.op.core.Log1p;
import org.tensorflow.op.core.LogMatrixDeterminant;
import org.tensorflow.op.core.LogSoftmax;
import org.tensorflow.op.core.LogUniformCandidateSampler;
import org.tensorflow.op.core.LogicalAnd;
import org.tensorflow.op.core.LogicalNot;
import org.tensorflow.op.core.LogicalOr;
import org.tensorflow.op.core.LookupTableExport;
import org.tensorflow.op.core.LookupTableFind;
import org.tensorflow.op.core.LookupTableImport;
import org.tensorflow.op.core.LookupTableInsert;
import org.tensorflow.op.core.LookupTableSize;
import org.tensorflow.op.core.LoopCond;
import org.tensorflow.op.core.Lu;
import org.tensorflow.op.core.MakeIterator;
import org.tensorflow.op.core.MapClear;
import org.tensorflow.op.core.MapIncompleteSize;
import org.tensorflow.op.core.MapPeek;
import org.tensorflow.op.core.MapSize;
import org.tensorflow.op.core.MapStage;
import org.tensorflow.op.core.MapUnstage;
import org.tensorflow.op.core.MapUnstageNoKey;
import org.tensorflow.op.core.MatMul;
import org.tensorflow.op.core.MatchingFiles;
import org.tensorflow.op.core.MatrixBandPart;
import org.tensorflow.op.core.MatrixDeterminant;
import org.tensorflow.op.core.MatrixDiag;
import org.tensorflow.op.core.MatrixDiagPart;
import org.tensorflow.op.core.MatrixInverse;
import org.tensorflow.op.core.MatrixSetDiag;
import org.tensorflow.op.core.MatrixSolve;
import org.tensorflow.op.core.MatrixSolveLs;
import org.tensorflow.op.core.MatrixSquareRoot;
import org.tensorflow.op.core.MatrixTriangularSolve;
import org.tensorflow.op.core.Max;
import org.tensorflow.op.core.MaxPool;
import org.tensorflow.op.core.MaxPool3D;
import org.tensorflow.op.core.MaxPool3DGrad;
import org.tensorflow.op.core.MaxPool3DGradGrad;
import org.tensorflow.op.core.MaxPoolGradGrad;
import org.tensorflow.op.core.MaxPoolGradGradV2;
import org.tensorflow.op.core.MaxPoolGradGradWithArgmax;
import org.tensorflow.op.core.MaxPoolGradV2;
import org.tensorflow.op.core.MaxPoolV2;
import org.tensorflow.op.core.MaxPoolWithArgmax;
import org.tensorflow.op.core.Maximum;
import org.tensorflow.op.core.Mean;
import org.tensorflow.op.core.Merge;
import org.tensorflow.op.core.MergeSummary;
import org.tensorflow.op.core.MergeV2Checkpoints;
import org.tensorflow.op.core.Mfcc;
import org.tensorflow.op.core.Min;
import org.tensorflow.op.core.Minimum;
import org.tensorflow.op.core.MirrorPad;
import org.tensorflow.op.core.Mod;
import org.tensorflow.op.core.Mul;
import org.tensorflow.op.core.Multinomial;
import org.tensorflow.op.core.Multiply;
import org.tensorflow.op.core.MutableDenseHashTable;
import org.tensorflow.op.core.MutableHashTable;
import org.tensorflow.op.core.MutableHashTableOfTensors;
import org.tensorflow.op.core.MutexLock;
import org.tensorflow.op.core.MutexV2;
import org.tensorflow.op.core.Neg;
import org.tensorflow.op.core.NegTrain;
import org.tensorflow.op.core.Negate;
import org.tensorflow.op.core.NextIteration;
import org.tensorflow.op.core.NoOp;
import org.tensorflow.op.core.NonMaxSuppression;
import org.tensorflow.op.core.NonMaxSuppressionV2;
import org.tensorflow.op.core.NonMaxSuppressionV3;
import org.tensorflow.op.core.NonMaxSuppressionV4;
import org.tensorflow.op.core.NonMaxSuppressionWithOverlaps;
import org.tensorflow.op.core.NotEqual;
import org.tensorflow.op.core.NthElement;
import org.tensorflow.op.core.OneHot;
import org.tensorflow.op.core.OnesLike;
import org.tensorflow.op.core.OptionalFromValue;
import org.tensorflow.op.core.OptionalGetValue;
import org.tensorflow.op.core.OptionalHasValue;
import org.tensorflow.op.core.OptionalNone;
import org.tensorflow.op.core.OrderedMapClear;
import org.tensorflow.op.core.OrderedMapIncompleteSize;
import org.tensorflow.op.core.OrderedMapPeek;
import org.tensorflow.op.core.OrderedMapSize;
import org.tensorflow.op.core.OrderedMapStage;
import org.tensorflow.op.core.OrderedMapUnstage;
import org.tensorflow.op.core.OrderedMapUnstageNoKey;
import org.tensorflow.op.core.Pad;
import org.tensorflow.op.core.PadV2;
import org.tensorflow.op.core.PaddingFIFOQueue;
import org.tensorflow.op.core.ParallelConcat;
import org.tensorflow.op.core.ParallelDynamicStitch;
import org.tensorflow.op.core.ParameterizedTruncatedNormal;
import org.tensorflow.op.core.ParseExample;
import org.tensorflow.op.core.ParseSequenceExample;
import org.tensorflow.op.core.ParseSingleExample;
import org.tensorflow.op.core.ParseSingleSequenceExample;
import org.tensorflow.op.core.ParseTensor;
import org.tensorflow.op.core.Placeholder;
import org.tensorflow.op.core.PlaceholderV2;
import org.tensorflow.op.core.PlaceholderWithDefault;
import org.tensorflow.op.core.Polygamma;
import org.tensorflow.op.core.PopulationCount;
import org.tensorflow.op.core.Pow;
import org.tensorflow.op.core.PreventGradient;
import org.tensorflow.op.core.Print;
import org.tensorflow.op.core.PrintV2;
import org.tensorflow.op.core.PriorityQueue;
import org.tensorflow.op.core.Prod;
import org.tensorflow.op.core.Qr;
import org.tensorflow.op.core.QuantizeAndDequantize;
import org.tensorflow.op.core.QuantizeAndDequantizeV2;
import org.tensorflow.op.core.QuantizeAndDequantizeV3;
import org.tensorflow.op.core.QuantizeDownAndShrinkRange;
import org.tensorflow.op.core.QuantizeV2;
import org.tensorflow.op.core.QuantizedAdd;
import org.tensorflow.op.core.QuantizedAvgPool;
import org.tensorflow.op.core.QuantizedBatchNormWithGlobalNormalization;
import org.tensorflow.op.core.QuantizedBiasAdd;
import org.tensorflow.op.core.QuantizedConcat;
import org.tensorflow.op.core.QuantizedConv2D;
import org.tensorflow.op.core.QuantizedInstanceNorm;
import org.tensorflow.op.core.QuantizedMatMul;
import org.tensorflow.op.core.QuantizedMaxPool;
import org.tensorflow.op.core.QuantizedMul;
import org.tensorflow.op.core.QuantizedRelu;
import org.tensorflow.op.core.QuantizedRelu6;
import org.tensorflow.op.core.QuantizedReluX;
import org.tensorflow.op.core.QuantizedReshape;
import org.tensorflow.op.core.QuantizedResizeBilinear;
import org.tensorflow.op.core.QueueClose;
import org.tensorflow.op.core.QueueDequeue;
import org.tensorflow.op.core.QueueDequeueMany;
import org.tensorflow.op.core.QueueDequeueUpTo;
import org.tensorflow.op.core.QueueEnqueue;
import org.tensorflow.op.core.QueueEnqueueMany;
import org.tensorflow.op.core.QueueIsClosed;
import org.tensorflow.op.core.QueueIsClosedV2;
import org.tensorflow.op.core.QueueSize;
import org.tensorflow.op.core.RFFT;
import org.tensorflow.op.core.RFFT2D;
import org.tensorflow.op.core.RFFT3D;
import org.tensorflow.op.core.RGBToHSV;
import org.tensorflow.op.core.RandomCrop;
import org.tensorflow.op.core.RandomGamma;
import org.tensorflow.op.core.RandomNormal;
import org.tensorflow.op.core.RandomPoisson;
import org.tensorflow.op.core.RandomPoissonV2;
import org.tensorflow.op.core.RandomShuffle;
import org.tensorflow.op.core.RandomShuffleQueue;
import org.tensorflow.op.core.RandomUniform;
import org.tensorflow.op.core.RandomUniformInt;
import org.tensorflow.op.core.Range;
import org.tensorflow.op.core.Rank;
import org.tensorflow.op.core.ReadFile;
import org.tensorflow.op.core.ReadVariableOp;
import org.tensorflow.op.core.ReaderNumRecordsProduced;
import org.tensorflow.op.core.ReaderNumWorkUnitsCompleted;
import org.tensorflow.op.core.ReaderRead;
import org.tensorflow.op.core.ReaderReadUpTo;
import org.tensorflow.op.core.ReaderReset;
import org.tensorflow.op.core.ReaderRestoreState;
import org.tensorflow.op.core.ReaderSerializeState;
import org.tensorflow.op.core.Real;
import org.tensorflow.op.core.RealDiv;
import org.tensorflow.op.core.Reciprocal;
import org.tensorflow.op.core.RecordInput;
import org.tensorflow.op.core.ReduceAll;
import org.tensorflow.op.core.ReduceAny;
import org.tensorflow.op.core.ReduceJoin;
import org.tensorflow.op.core.ReduceMax;
import org.tensorflow.op.core.ReduceMean;
import org.tensorflow.op.core.ReduceMin;
import org.tensorflow.op.core.ReduceProd;
import org.tensorflow.op.core.ReduceSum;
import org.tensorflow.op.core.RefNextIteration;
import org.tensorflow.op.core.RefSelect;
import org.tensorflow.op.core.RefSwitch;
import org.tensorflow.op.core.RegexFullMatch;
import org.tensorflow.op.core.RegexReplace;
import org.tensorflow.op.core.Relu;
import org.tensorflow.op.core.Relu6;
import org.tensorflow.op.core.RemoteFusedGraphExecute;
import org.tensorflow.op.core.RequantizationRange;
import org.tensorflow.op.core.Requantize;
import org.tensorflow.op.core.Reshape;
import org.tensorflow.op.core.ResizeArea;
import org.tensorflow.op.core.ResizeBicubic;
import org.tensorflow.op.core.ResizeBilinear;
import org.tensorflow.op.core.ResizeNearestNeighbor;
import org.tensorflow.op.core.ResourceApplyAdadelta;
import org.tensorflow.op.core.ResourceApplyAdagrad;
import org.tensorflow.op.core.ResourceApplyAdagradDA;
import org.tensorflow.op.core.ResourceApplyAdam;
import org.tensorflow.op.core.ResourceApplyAdamWithAmsgrad;
import org.tensorflow.op.core.ResourceApplyAddSign;
import org.tensorflow.op.core.ResourceApplyCenteredRMSProp;
import org.tensorflow.op.core.ResourceApplyFtrl;
import org.tensorflow.op.core.ResourceApplyFtrlV2;
import org.tensorflow.op.core.ResourceApplyGradientDescent;
import org.tensorflow.op.core.ResourceApplyKerasMomentum;
import org.tensorflow.op.core.ResourceApplyMomentum;
import org.tensorflow.op.core.ResourceApplyPowerSign;
import org.tensorflow.op.core.ResourceApplyProximalAdagrad;
import org.tensorflow.op.core.ResourceApplyProximalGradientDescent;
import org.tensorflow.op.core.ResourceApplyRMSProp;
import org.tensorflow.op.core.ResourceCountUpTo;
import org.tensorflow.op.core.ResourceGather;
import org.tensorflow.op.core.ResourceScatterAdd;
import org.tensorflow.op.core.ResourceScatterDiv;
import org.tensorflow.op.core.ResourceScatterMax;
import org.tensorflow.op.core.ResourceScatterMin;
import org.tensorflow.op.core.ResourceScatterMul;
import org.tensorflow.op.core.ResourceScatterNdAdd;
import org.tensorflow.op.core.ResourceScatterNdUpdate;
import org.tensorflow.op.core.ResourceScatterSub;
import org.tensorflow.op.core.ResourceScatterUpdate;
import org.tensorflow.op.core.ResourceSparseApplyAdadelta;
import org.tensorflow.op.core.ResourceSparseApplyAdagrad;
import org.tensorflow.op.core.ResourceSparseApplyAdagradDA;
import org.tensorflow.op.core.ResourceSparseApplyCenteredRMSProp;
import org.tensorflow.op.core.ResourceSparseApplyFtrl;
import org.tensorflow.op.core.ResourceSparseApplyFtrlV2;
import org.tensorflow.op.core.ResourceSparseApplyKerasMomentum;
import org.tensorflow.op.core.ResourceSparseApplyMomentum;
import org.tensorflow.op.core.ResourceSparseApplyProximalAdagrad;
import org.tensorflow.op.core.ResourceSparseApplyProximalGradientDescent;
import org.tensorflow.op.core.ResourceSparseApplyRMSProp;
import org.tensorflow.op.core.ResourceStridedSliceAssign;
import org.tensorflow.op.core.Restore;
import org.tensorflow.op.core.RestoreSlice;
import org.tensorflow.op.core.RestoreV2;
import org.tensorflow.op.core.Reverse;
import org.tensorflow.op.core.ReverseSequence;
import org.tensorflow.op.core.RightShift;
import org.tensorflow.op.core.Rint;
import org.tensorflow.op.core.Roll;
import org.tensorflow.op.core.Round;
import org.tensorflow.op.core.Rpc;
import org.tensorflow.op.core.Rsqrt;
import org.tensorflow.op.core.SampleDistortedBoundingBox;
import org.tensorflow.op.core.SampleDistortedBoundingBoxV2;
import org.tensorflow.op.core.Save;
import org.tensorflow.op.core.SaveSlices;
import org.tensorflow.op.core.SaveV2;
import org.tensorflow.op.core.ScalarSummary;
import org.tensorflow.op.core.ScatterAdd;
import org.tensorflow.op.core.ScatterDiv;
import org.tensorflow.op.core.ScatterMax;
import org.tensorflow.op.core.ScatterMin;
import org.tensorflow.op.core.ScatterMul;
import org.tensorflow.op.core.ScatterNd;
import org.tensorflow.op.core.ScatterNdAdd;
import org.tensorflow.op.core.ScatterNdNonAliasingAdd;
import org.tensorflow.op.core.ScatterNdSub;
import org.tensorflow.op.core.ScatterNdUpdate;
import org.tensorflow.op.core.ScatterSub;
import org.tensorflow.op.core.ScatterUpdate;
import org.tensorflow.op.core.SdcaFprint;
import org.tensorflow.op.core.SdcaOptimizer;
import org.tensorflow.op.core.SdcaShrinkL1;
import org.tensorflow.op.core.SegmentMax;
import org.tensorflow.op.core.SegmentMean;
import org.tensorflow.op.core.SegmentMin;
import org.tensorflow.op.core.SegmentProd;
import org.tensorflow.op.core.SegmentSum;
import org.tensorflow.op.core.SelfAdjointEig;
import org.tensorflow.op.core.Selu;
import org.tensorflow.op.core.SerializeIterator;
import org.tensorflow.op.core.SerializeManySparse;
import org.tensorflow.op.core.SerializeSparse;
import org.tensorflow.op.core.SerializeTensor;
import org.tensorflow.op.core.SetDiff1D;
import org.tensorflow.op.core.SetSize;
import org.tensorflow.op.core.ShapeN;
import org.tensorflow.op.core.ShardedFilename;
import org.tensorflow.op.core.ShardedFilespec;
import org.tensorflow.op.core.Sigmoid;
import org.tensorflow.op.core.Sign;
import org.tensorflow.op.core.Sin;
import org.tensorflow.op.core.Sinh;
import org.tensorflow.op.core.Size;
import org.tensorflow.op.core.Skipgram;
import org.tensorflow.op.core.Slice;
import org.tensorflow.op.core.Snapshot;
import org.tensorflow.op.core.Softmax;
import org.tensorflow.op.core.SoftmaxCrossEntropyWithLogits;
import org.tensorflow.op.core.Softplus;
import org.tensorflow.op.core.Softsign;
import org.tensorflow.op.core.SpaceToBatch;
import org.tensorflow.op.core.SpaceToBatchND;
import org.tensorflow.op.core.SpaceToDepth;
import org.tensorflow.op.core.SparseAccumulatorApplyGradient;
import org.tensorflow.op.core.SparseAccumulatorTakeGradient;
import org.tensorflow.op.core.SparseAdd;
import org.tensorflow.op.core.SparseAddGrad;
import org.tensorflow.op.core.SparseApplyAdadelta;
import org.tensorflow.op.core.SparseApplyAdagrad;
import org.tensorflow.op.core.SparseApplyAdagradDA;
import org.tensorflow.op.core.SparseApplyCenteredRMSProp;
import org.tensorflow.op.core.SparseApplyFtrl;
import org.tensorflow.op.core.SparseApplyFtrlV2;
import org.tensorflow.op.core.SparseApplyMomentum;
import org.tensorflow.op.core.SparseApplyProximalAdagrad;
import org.tensorflow.op.core.SparseApplyProximalGradientDescent;
import org.tensorflow.op.core.SparseApplyRMSProp;
import org.tensorflow.op.core.SparseConcat;
import org.tensorflow.op.core.SparseConditionalAccumulator;
import org.tensorflow.op.core.SparseCross;
import org.tensorflow.op.core.SparseDenseCwiseAdd;
import org.tensorflow.op.core.SparseDenseCwiseDiv;
import org.tensorflow.op.core.SparseDenseCwiseMul;
import org.tensorflow.op.core.SparseFillEmptyRows;
import org.tensorflow.op.core.SparseFillEmptyRowsGrad;
import org.tensorflow.op.core.SparseMatMul;
import org.tensorflow.op.core.SparseReduceMax;
import org.tensorflow.op.core.SparseReduceMaxSparse;
import org.tensorflow.op.core.SparseReduceSum;
import org.tensorflow.op.core.SparseReduceSumSparse;
import org.tensorflow.op.core.SparseReorder;
import org.tensorflow.op.core.SparseReshape;
import org.tensorflow.op.core.SparseSegmentMean;
import org.tensorflow.op.core.SparseSegmentMeanGrad;
import org.tensorflow.op.core.SparseSegmentMeanWithNumSegments;
import org.tensorflow.op.core.SparseSegmentSqrtN;
import org.tensorflow.op.core.SparseSegmentSqrtNGrad;
import org.tensorflow.op.core.SparseSegmentSqrtNWithNumSegments;
import org.tensorflow.op.core.SparseSegmentSum;
import org.tensorflow.op.core.SparseSegmentSumWithNumSegments;
import org.tensorflow.op.core.SparseSlice;
import org.tensorflow.op.core.SparseSliceGrad;
import org.tensorflow.op.core.SparseSoftmax;
import org.tensorflow.op.core.SparseSoftmaxCrossEntropyWithLogits;
import org.tensorflow.op.core.SparseSparseMaximum;
import org.tensorflow.op.core.SparseSparseMinimum;
import org.tensorflow.op.core.SparseSplit;
import org.tensorflow.op.core.SparseTensorDenseAdd;
import org.tensorflow.op.core.SparseTensorDenseMatMul;
import org.tensorflow.op.core.SparseToDense;
import org.tensorflow.op.core.SparseToSparseSetOperation;
import org.tensorflow.op.core.Split;
import org.tensorflow.op.core.SplitV;
import org.tensorflow.op.core.Sqrt;
import org.tensorflow.op.core.Square;
import org.tensorflow.op.core.SquaredDifference;
import org.tensorflow.op.core.Squeeze;
import org.tensorflow.op.core.Stack;
import org.tensorflow.op.core.Stage;
import org.tensorflow.op.core.StageClear;
import org.tensorflow.op.core.StagePeek;
import org.tensorflow.op.core.StageSize;
import org.tensorflow.op.core.StatelessMultinomial;
import org.tensorflow.op.core.StatelessRandomNormal;
import org.tensorflow.op.core.StatelessRandomUniform;
import org.tensorflow.op.core.StatelessTruncatedNormal;
import org.tensorflow.op.core.StopGradient;
import org.tensorflow.op.core.StridedSlice;
import org.tensorflow.op.core.StridedSliceAssign;
import org.tensorflow.op.core.StridedSliceGrad;
import org.tensorflow.op.core.StringFormat;
import org.tensorflow.op.core.StringJoin;
import org.tensorflow.op.core.StringLength;
import org.tensorflow.op.core.StringSplit;
import org.tensorflow.op.core.StringSplitV2;
import org.tensorflow.op.core.StringStrip;
import org.tensorflow.op.core.StringToHashBucket;
import org.tensorflow.op.core.StringToHashBucketFast;
import org.tensorflow.op.core.StringToHashBucketStrong;
import org.tensorflow.op.core.StringToNumber;
import org.tensorflow.op.core.Sub;
import org.tensorflow.op.core.Substr;
import org.tensorflow.op.core.Subtract;
import org.tensorflow.op.core.Sum;
import org.tensorflow.op.core.Svd;
import org.tensorflow.op.core.TFRecordReader;
import org.tensorflow.op.core.TakeManySparseFromTensorsMap;
import org.tensorflow.op.core.Tan;
import org.tensorflow.op.core.Tanh;
import org.tensorflow.op.core.TemporaryVariable;
import org.tensorflow.op.core.TensorArray;
import org.tensorflow.op.core.TensorArrayClose;
import org.tensorflow.op.core.TensorArrayConcat;
import org.tensorflow.op.core.TensorArrayGather;
import org.tensorflow.op.core.TensorArrayGrad;
import org.tensorflow.op.core.TensorArrayGradWithShape;
import org.tensorflow.op.core.TensorArrayPack;
import org.tensorflow.op.core.TensorArrayRead;
import org.tensorflow.op.core.TensorArrayScatter;
import org.tensorflow.op.core.TensorArraySize;
import org.tensorflow.op.core.TensorArraySplit;
import org.tensorflow.op.core.TensorArrayUnpack;
import org.tensorflow.op.core.TensorArrayWrite;
import org.tensorflow.op.core.TensorListConcat;
import org.tensorflow.op.core.TensorListConcatLists;
import org.tensorflow.op.core.TensorListElementShape;
import org.tensorflow.op.core.TensorListFromTensor;
import org.tensorflow.op.core.TensorListGather;
import org.tensorflow.op.core.TensorListGetItem;
import org.tensorflow.op.core.TensorListLength;
import org.tensorflow.op.core.TensorListPopBack;
import org.tensorflow.op.core.TensorListPushBack;
import org.tensorflow.op.core.TensorListPushBackBatch;
import org.tensorflow.op.core.TensorListReserve;
import org.tensorflow.op.core.TensorListScatter;
import org.tensorflow.op.core.TensorListSetItem;
import org.tensorflow.op.core.TensorListSplit;
import org.tensorflow.op.core.TensorListStack;
import org.tensorflow.op.core.TensorScatterAdd;
import org.tensorflow.op.core.TensorScatterSub;
import org.tensorflow.op.core.TensorScatterUpdate;
import org.tensorflow.op.core.TensorSummary;
import org.tensorflow.op.core.TensorSummaryV2;
import org.tensorflow.op.core.TextLineReader;
import org.tensorflow.op.core.Tile;
import org.tensorflow.op.core.TileGrad;
import org.tensorflow.op.core.Timestamp;
import org.tensorflow.op.core.TopK;
import org.tensorflow.op.core.Transpose;
import org.tensorflow.op.core.TruncateDiv;
import org.tensorflow.op.core.TruncateMod;
import org.tensorflow.op.core.TruncatedNormal;
import org.tensorflow.op.core.TryRpc;
import org.tensorflow.op.core.Unbatch;
import org.tensorflow.op.core.UnbatchGrad;
import org.tensorflow.op.core.UnicodeScript;
import org.tensorflow.op.core.UnicodeTranscode;
import org.tensorflow.op.core.UniformCandidateSampler;
import org.tensorflow.op.core.Unique;
import org.tensorflow.op.core.UniqueV2;
import org.tensorflow.op.core.UniqueWithCounts;
import org.tensorflow.op.core.UniqueWithCountsV2;
import org.tensorflow.op.core.UnravelIndex;
import org.tensorflow.op.core.UnsortedSegmentMax;
import org.tensorflow.op.core.UnsortedSegmentMin;
import org.tensorflow.op.core.UnsortedSegmentProd;
import org.tensorflow.op.core.UnsortedSegmentSum;
import org.tensorflow.op.core.Unstack;
import org.tensorflow.op.core.Unstage;
import org.tensorflow.op.core.VarHandleOp;
import org.tensorflow.op.core.VarIsInitializedOp;
import org.tensorflow.op.core.Variable;
import org.tensorflow.op.core.VariableShape;
import org.tensorflow.op.core.Where;
import org.tensorflow.op.core.Where3;
import org.tensorflow.op.core.WholeFileReader;
import org.tensorflow.op.core.WriteFile;
import org.tensorflow.op.core.Xdivy;
import org.tensorflow.op.core.Xlogy;
import org.tensorflow.op.core.Zeros;
import org.tensorflow.op.core.ZerosLike;
import org.tensorflow.op.core.Zeta;
import org.tensorflow.types.UInt8;

/**
 * An API for building a {@link Graph} with operation wrappers
 * <p>
 * Any operation wrapper found in the classpath properly annotated as an{@link org.tensorflow.op.annotation.Operator @Operator} is exposed
 * by this API or one of its subgroup.
 * <p>Example usage:
 * <pre>{@code
 * try (Graph g = new Graph()) {
 *   Ops ops = new Ops(g);
 *   // Operations are typed classes with convenience
 *   // builders in Ops.
 *   Constant three = ops.constant(3);
 *   // Single-result operations implement the Operand
 *   // interface, so this works too.
 *   Operand four = ops.constant(4);
 *   // Most builders are found within a group, and accept
 *   // Operand types as operands
 *   Operand nine = ops.math().add(four, ops.constant(5));
 *   // Multi-result operations however offer methods to
 *   // select a particular result for use.
 *   Operand result = 
 *       ops.math().add(ops.array().unique(s, a).y(), b);
 *   // Optional attributes
 *   ops.math().matMul(a, b, MatMul.transposeA(true));
 *   // Naming operators
 *   ops.withName(“foo”).constant(5); // name “foo”
 *   // Names can exist in a hierarchy
 *   Ops sub = ops.withSubScope(“sub”);
 *   sub.withName(“bar”).constant(4); // “sub/bar”
 * }
 * }</pre>
 */
public final class Ops {
  private final Scope scope;

  private Ops(Scope scope) {
    this.scope = scope;
  }

  /**
   * Adds an {@link GatherV2} operation to the graph
   *
   * @param params The tensor from which to gather values. Must be at least rank
   * @param indices Index tensor. Must be in range `[0, params.shape[axis])`.
   * @param axis The axis in `params` to gather `indices` from. Defaults to the first
   * @return a new instance of GatherV2
   * @see org.tensorflow.op.core.GatherV2
   */
  public <T, U extends Number, V extends Number> GatherV2<T> gatherV2(Operand<T> params,
      Operand<U> indices, Operand<V> axis) {
    return GatherV2.create(scope, params, indices, axis);
  }

  /**
   * Adds an {@link SparseSegmentSumWithNumSegments} operation to the graph
   *
   * @param data 
   * @param indices A 1-D tensor. Has same rank as `segment_ids`.
   * @param segmentIds A 1-D tensor. Values should be sorted and can be repeated.
   * @param numSegments Should equal the number of distinct segment IDs.
   * @return a new instance of SparseSegmentSumWithNumSegments
   * @see org.tensorflow.op.core.SparseSegmentSumWithNumSegments
   */
  public <T extends Number, U extends Number, V extends Number> SparseSegmentSumWithNumSegments<T> sparseSegmentSumWithNumSegments(Operand<T> data,
      Operand<U> indices, Operand<Integer> segmentIds, Operand<V> numSegments) {
    return SparseSegmentSumWithNumSegments.create(scope, data, indices, segmentIds, numSegments);
  }

  /**
   * Adds an {@link Assign} operation to the graph
   *
   * @param ref Should be from a `Variable` node. May be uninitialized.
   * @param value The value to be assigned to the variable.
   * @param options carries optional attributes values
   * @return a new instance of Assign
   * @see org.tensorflow.op.core.Assign
   */
  public <T> Assign<T> assign(Operand<T> ref, Operand<T> value, Assign.Options... options) {
    return Assign.create(scope, ref, value, options);
  }

  /**
   * Adds an {@link IsFinite} operation to the graph
   *
   * @param x 
   * @return a new instance of IsFinite
   * @see org.tensorflow.op.core.IsFinite
   */
  public <T extends Number> IsFinite isFinite(Operand<T> x) {
    return IsFinite.create(scope, x);
  }

  /**
   * Adds an {@link Conv2DBackpropInput} operation to the graph
   *
   * @param inputSizes An integer vector representing the shape of `input`,
   * @param filter 4-D with shape
   * @param outBackprop 4-D with shape `[batch, out_height, out_width, out_channels]`.
   * @param strides The stride of the sliding window for each dimension of the input
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of Conv2DBackpropInput
   * @see org.tensorflow.op.core.Conv2DBackpropInput
   */
  public <T extends Number> Conv2DBackpropInput<T> conv2DBackpropInput(Operand<Integer> inputSizes,
      Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding,
      Conv2DBackpropInput.Options... options) {
    return Conv2DBackpropInput.create(scope, inputSizes, filter, outBackprop, strides, padding, options);
  }

  /**
   * Adds an {@link Split} operation to the graph
   *
   * @param axis 0-D.  The dimension along which to split.  Must be in the range
   * @param value The tensor to split.
   * @param numSplit The number of ways to split.  Must evenly divide
   * @return a new instance of Split
   * @see org.tensorflow.op.core.Split
   */
  public <T> Split<T> split(Operand<Integer> axis, Operand<T> value, Long numSplit) {
    return Split.create(scope, axis, value, numSplit);
  }

  /**
   * Adds an {@link CTCLoss} operation to the graph
   *
   * @param inputs 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
   * @param labelsIndices The indices of a `SparseTensor<int32, 2>`.
   * @param labelsValues The values (labels) associated with the given batch and time.
   * @param sequenceLength A vector containing sequence lengths (batch).
   * @param options carries optional attributes values
   * @return a new instance of CTCLoss
   * @see org.tensorflow.op.core.CTCLoss
   */
  public CTCLoss cTCLoss(Operand<Float> inputs, Operand<Long> labelsIndices,
      Operand<Integer> labelsValues, Operand<Integer> sequenceLength, CTCLoss.Options... options) {
    return CTCLoss.create(scope, inputs, labelsIndices, labelsValues, sequenceLength, options);
  }

  /**
   * Adds an {@link Sigmoid} operation to the graph
   *
   * @param x 
   * @return a new instance of Sigmoid
   * @see org.tensorflow.op.core.Sigmoid
   */
  public <T> Sigmoid<T> sigmoid(Operand<T> x) {
    return Sigmoid.create(scope, x);
  }

  /**
   * Adds an {@link ResourceStridedSliceAssign} operation to the graph
   *
   * @param ref 
   * @param begin 
   * @param end 
   * @param strides 
   * @param value 
   * @param options carries optional attributes values
   * @return a new instance of ResourceStridedSliceAssign
   * @see org.tensorflow.op.core.ResourceStridedSliceAssign
   */
  public <T extends Number, U> ResourceStridedSliceAssign resourceStridedSliceAssign(Operand<?> ref,
      Operand<T> begin, Operand<T> end, Operand<T> strides, Operand<U> value,
      ResourceStridedSliceAssign.Options... options) {
    return ResourceStridedSliceAssign.create(scope, ref, begin, end, strides, value, options);
  }

  /**
   * Adds an {@link BatchCholeskyGrad} operation to the graph
   *
   * @param l 
   * @param grad 
   * @return a new instance of BatchCholeskyGrad
   * @see org.tensorflow.op.core.BatchCholeskyGrad
   */
  public <T extends Number> BatchCholeskyGrad<T> batchCholeskyGrad(Operand<T> l, Operand<T> grad) {
    return BatchCholeskyGrad.create(scope, l, grad);
  }

  /**
   * Adds an {@link PriorityQueue} operation to the graph
   *
   * @param componentTypes The type of each component in a value.
   * @param shapes The shape of each component in a value. The length of this attr must
   * @param options carries optional attributes values
   * @return a new instance of PriorityQueue
   * @see org.tensorflow.op.core.PriorityQueue
   */
  public PriorityQueue priorityQueue(List<Class<?>> componentTypes, List<Shape> shapes,
      PriorityQueue.Options... options) {
    return PriorityQueue.create(scope, componentTypes, shapes, options);
  }

  /**
   * Adds an {@link Pad} operation to the graph
   *
   * @param input 
   * @param paddings 
   * @return a new instance of Pad
   * @see org.tensorflow.op.core.Pad
   */
  public <T, U extends Number> Pad<T> pad(Operand<T> input, Operand<U> paddings) {
    return Pad.create(scope, input, paddings);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Float> constant(float[][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link FloorDiv} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of FloorDiv
   * @see org.tensorflow.op.core.FloorDiv
   */
  public <T> FloorDiv<T> floorDiv(Operand<T> x, Operand<T> y) {
    return FloorDiv.create(scope, x, y);
  }

  /**
   * Adds an {@link QuantizedReluX} operation to the graph
   *
   * @param features 
   * @param maxValue 
   * @param minFeatures The float value that the lowest quantized value represents.
   * @param maxFeatures The float value that the highest quantized value represents.
   * @param outType 
   * @return a new instance of QuantizedReluX
   * @see org.tensorflow.op.core.QuantizedReluX
   */
  public <U, T> QuantizedReluX<U> quantizedReluX(Operand<T> features, Operand<Float> maxValue,
      Operand<Float> minFeatures, Operand<Float> maxFeatures, Class<U> outType) {
    return QuantizedReluX.create(scope, features, maxValue, minFeatures, maxFeatures, outType);
  }

  /**
   * Adds an {@link UnravelIndex} operation to the graph
   *
   * @param indices An 0-D or 1-D `int` Tensor whose elements are indices into the
   * @param dims An 1-D `int` Tensor. The shape of the array to use for unraveling
   * @return a new instance of UnravelIndex
   * @see org.tensorflow.op.core.UnravelIndex
   */
  public <T extends Number> UnravelIndex<T> unravelIndex(Operand<T> indices, Operand<T> dims) {
    return UnravelIndex.create(scope, indices, dims);
  }

  /**
   * Adds an {@link ResourceScatterAdd} operation to the graph
   *
   * @param resource Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to add to `ref`.
   * @return a new instance of ResourceScatterAdd
   * @see org.tensorflow.op.core.ResourceScatterAdd
   */
  public <T extends Number, U> ResourceScatterAdd resourceScatterAdd(Operand<?> resource,
      Operand<T> indices, Operand<U> updates) {
    return ResourceScatterAdd.create(scope, resource, indices, updates);
  }

  /**
   * Adds an {@link RestoreSlice} operation to the graph
   *
   * @param filePattern Must have a single element. The pattern of the files from
   * @param tensorName Must have a single element. The name of the tensor to be
   * @param shapeAndSlice Scalar. The shapes and slice specifications to use when
   * @param dt The type of the tensor to be restored.
   * @param options carries optional attributes values
   * @return a new instance of RestoreSlice
   * @see org.tensorflow.op.core.RestoreSlice
   */
  public <T> RestoreSlice<T> restoreSlice(Operand<String> filePattern, Operand<String> tensorName,
      Operand<String> shapeAndSlice, Class<T> dt, RestoreSlice.Options... options) {
    return RestoreSlice.create(scope, filePattern, tensorName, shapeAndSlice, dt, options);
  }

  /**
   * Adds an {@link AccumulateNV2} operation to the graph
   *
   * @param inputs A list of `Tensor` objects, each with same shape and type.
   * @param shape Shape of elements of `inputs`.
   * @return a new instance of AccumulateNV2
   * @see org.tensorflow.op.core.AccumulateNV2
   */
  public <T> AccumulateNV2<T> accumulateNV2(Operand<T> inputs, Shape shape) {
    return AccumulateNV2.create(scope, inputs, shape);
  }

  /**
   * Adds an {@link ScatterNdAdd} operation to the graph
   *
   * @param ref A mutable Tensor. Should be from a Variable node.
   * @param indices A Tensor. Must be one of the following types: int32, int64.
   * @param updates A Tensor. Must have the same type as ref. A tensor of updated values
   * @param options carries optional attributes values
   * @return a new instance of ScatterNdAdd
   * @see org.tensorflow.op.core.ScatterNdAdd
   */
  public <T, U extends Number> ScatterNdAdd<T> scatterNdAdd(Operand<T> ref, Operand<U> indices,
      Operand<T> updates, ScatterNdAdd.Options... options) {
    return ScatterNdAdd.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Integer> constant(int[][][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link AddN} operation to the graph
   *
   * @param inputs Must all be the same size and shape.
   * @return a new instance of AddN
   * @see org.tensorflow.op.core.AddN
   */
  public <T> AddN<T> addN(Operand<T> inputs) {
    return AddN.create(scope, inputs);
  }

  /**
   * Adds an {@link Sum} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of Sum
   * @see org.tensorflow.op.core.Sum
   */
  public <T, U extends Number> Sum<T> sum(Operand<T> input, Operand<U> axis,
      Sum.Options... options) {
    return Sum.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link PlaceholderWithDefault} operation to the graph
   *
   * @param input The default value to produce when `output` is not fed.
   * @param shape The (possibly partial) shape of the tensor.
   * @return a new instance of PlaceholderWithDefault
   * @see org.tensorflow.op.core.PlaceholderWithDefault
   */
  public <T> PlaceholderWithDefault<T> placeholderWithDefault(Operand<T> input, Shape shape) {
    return PlaceholderWithDefault.create(scope, input, shape);
  }

  /**
   * Adds an {@link Abort} operation to the graph
   *
   * @param options carries optional attributes values
   * @return a new instance of Abort
   * @see org.tensorflow.op.core.Abort
   */
  public Abort abort(Abort.Options... options) {
    return Abort.create(scope, options);
  }

  /**
   * Adds an {@link AvgPool} operation to the graph
   *
   * @param value 4-D with shape `[batch, height, width, channels]`.
   * @param ksize The size of the sliding window for each dimension of `value`.
   * @param strides The stride of the sliding window for each dimension of `value`.
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of AvgPool
   * @see org.tensorflow.op.core.AvgPool
   */
  public <T extends Number> AvgPool<T> avgPool(Operand<T> value, List<Long> ksize,
      List<Long> strides, String padding, AvgPool.Options... options) {
    return AvgPool.create(scope, value, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link BatchIFFT} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchIFFT
   * @see org.tensorflow.op.core.BatchIFFT
   */
  public BatchIFFT batchIFFT(Operand<?> input) {
    return BatchIFFT.create(scope, input);
  }

  /**
   * Adds an {@link NthElement} operation to the graph
   *
   * @param input 1-D or higher with last dimension at least `n+1`.
   * @param n 0-D. Position of sorted vector to select along the last dimension (along
   * @param options carries optional attributes values
   * @return a new instance of NthElement
   * @see org.tensorflow.op.core.NthElement
   */
  public <T extends Number> NthElement<T> nthElement(Operand<T> input, Operand<Integer> n,
      NthElement.Options... options) {
    return NthElement.create(scope, input, n, options);
  }

  /**
   * Adds an {@link EncodeJpeg} operation to the graph
   *
   * @param image 3-D with shape `[height, width, channels]`.
   * @param options carries optional attributes values
   * @return a new instance of EncodeJpeg
   * @see org.tensorflow.op.core.EncodeJpeg
   */
  public EncodeJpeg encodeJpeg(Operand<UInt8> image, EncodeJpeg.Options... options) {
    return EncodeJpeg.create(scope, image, options);
  }

  /**
   * Adds an {@link SegmentSum} operation to the graph
   *
   * @param data 
   * @param segmentIds A 1-D tensor whose size is equal to the size of `data`'s
   * @return a new instance of SegmentSum
   * @see org.tensorflow.op.core.SegmentSum
   */
  public <T, U extends Number> SegmentSum<T> segmentSum(Operand<T> data, Operand<U> segmentIds) {
    return SegmentSum.create(scope, data, segmentIds);
  }

  /**
   * Adds an {@link MaxPoolV2} operation to the graph
   *
   * @param input 4-D input to pool over.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of MaxPoolV2
   * @see org.tensorflow.op.core.MaxPoolV2
   */
  public <T> MaxPoolV2<T> maxPoolV2(Operand<T> input, Operand<Integer> ksize,
      Operand<Integer> strides, String padding, MaxPoolV2.Options... options) {
    return MaxPoolV2.create(scope, input, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link MatMul} operation to the graph
   *
   * @param a 
   * @param b 
   * @param options carries optional attributes values
   * @return a new instance of MatMul
   * @see org.tensorflow.op.core.MatMul
   */
  public <T> MatMul<T> matMul(Operand<T> a, Operand<T> b, MatMul.Options... options) {
    return MatMul.create(scope, a, b, options);
  }

  /**
   * Adds an {@link Acos} operation to the graph
   *
   * @param x 
   * @return a new instance of Acos
   * @see org.tensorflow.op.core.Acos
   */
  public <T> Acos<T> acos(Operand<T> x) {
    return Acos.create(scope, x);
  }

  /**
   * Adds an {@link TensorListScatter} operation to the graph
   *
   * @param tensor 
   * @param indices 
   * @param elementShape 
   * @return a new instance of TensorListScatter
   * @see org.tensorflow.op.core.TensorListScatter
   */
  public <T, U extends Number> TensorListScatter tensorListScatter(Operand<T> tensor,
      Operand<Integer> indices, Operand<U> elementShape) {
    return TensorListScatter.create(scope, tensor, indices, elementShape);
  }

  /**
   * Adds an {@link BatchFFT2D} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchFFT2D
   * @see org.tensorflow.op.core.BatchFFT2D
   */
  public BatchFFT2D batchFFT2D(Operand<?> input) {
    return BatchFFT2D.create(scope, input);
  }

  /**
   * Adds an {@link Requantize} operation to the graph
   *
   * @param input 
   * @param inputMin The float value that the minimum quantized input value represents.
   * @param inputMax The float value that the maximum quantized input value represents.
   * @param requestedOutputMin The float value that the minimum quantized output value represents.
   * @param requestedOutputMax The float value that the maximum quantized output value represents.
   * @param outType The type of the output. Should be a lower bit depth than Tinput.
   * @return a new instance of Requantize
   * @see org.tensorflow.op.core.Requantize
   */
  public <U, T> Requantize<U> requantize(Operand<T> input, Operand<Float> inputMin,
      Operand<Float> inputMax, Operand<Float> requestedOutputMin, Operand<Float> requestedOutputMax,
      Class<U> outType) {
    return Requantize.create(scope, input, inputMin, inputMax, requestedOutputMin, requestedOutputMax, outType);
  }

  /**
   * Adds an {@link All} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of All
   * @see org.tensorflow.op.core.All
   */
  public <T extends Number> All all(Operand<Boolean> input, Operand<T> axis,
      All.Options... options) {
    return All.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link StridedSliceAssign} operation to the graph
   *
   * @param ref 
   * @param begin 
   * @param end 
   * @param strides 
   * @param value 
   * @param options carries optional attributes values
   * @return a new instance of StridedSliceAssign
   * @see org.tensorflow.op.core.StridedSliceAssign
   */
  public <T, U extends Number> StridedSliceAssign<T> stridedSliceAssign(Operand<T> ref,
      Operand<U> begin, Operand<U> end, Operand<U> strides, Operand<T> value,
      StridedSliceAssign.Options... options) {
    return StridedSliceAssign.create(scope, ref, begin, end, strides, value, options);
  }

  /**
   * Adds an {@link OrderedMapUnstage} operation to the graph
   *
   * @param key 
   * @param indices 
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of OrderedMapUnstage
   * @see org.tensorflow.op.core.OrderedMapUnstage
   */
  public OrderedMapUnstage orderedMapUnstage(Operand<Long> key, Operand<Integer> indices,
      List<Class<?>> dtypes, OrderedMapUnstage.Options... options) {
    return OrderedMapUnstage.create(scope, key, indices, dtypes, options);
  }

  /**
   * Adds an {@link SparseReshape} operation to the graph
   *
   * @param inputIndices 2-D.  `N x R_in` matrix with the indices of non-empty values in a
   * @param inputShape 1-D.  `R_in` vector with the input SparseTensor's dense shape.
   * @param newShape 1-D.  `R_out` vector with the requested new dense shape.
   * @return a new instance of SparseReshape
   * @see org.tensorflow.op.core.SparseReshape
   */
  public SparseReshape sparseReshape(Operand<Long> inputIndices, Operand<Long> inputShape,
      Operand<Long> newShape) {
    return SparseReshape.create(scope, inputIndices, inputShape, newShape);
  }

  /**
   * Adds an {@link AssignAddVariableOp} operation to the graph
   *
   * @param resource handle to the resource in which to store the variable.
   * @param value the value by which the variable will be incremented.
   * @return a new instance of AssignAddVariableOp
   * @see org.tensorflow.op.core.AssignAddVariableOp
   */
  public <T> AssignAddVariableOp assignAddVariableOp(Operand<?> resource, Operand<T> value) {
    return AssignAddVariableOp.create(scope, resource, value);
  }

  /**
   * Adds an {@link DataFormatDimMap} operation to the graph
   *
   * @param x A Tensor with each element as a dimension index in source data format.
   * @param options carries optional attributes values
   * @return a new instance of DataFormatDimMap
   * @see org.tensorflow.op.core.DataFormatDimMap
   */
  public <T extends Number> DataFormatDimMap<T> dataFormatDimMap(Operand<T> x,
      DataFormatDimMap.Options... options) {
    return DataFormatDimMap.create(scope, x, options);
  }

  /**
   * Adds an {@link ScatterNdSub} operation to the graph
   *
   * @param ref A mutable Tensor. Should be from a Variable node.
   * @param indices A Tensor. Must be one of the following types: int32, int64.
   * @param updates A Tensor. Must have the same type as ref. A tensor of updated values
   * @param options carries optional attributes values
   * @return a new instance of ScatterNdSub
   * @see org.tensorflow.op.core.ScatterNdSub
   */
  public <T, U extends Number> ScatterNdSub<T> scatterNdSub(Operand<T> ref, Operand<U> indices,
      Operand<T> updates, ScatterNdSub.Options... options) {
    return ScatterNdSub.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link StringToHashBucketStrong} operation to the graph
   *
   * @param input The strings to assign a hash bucket.
   * @param numBuckets The number of buckets.
   * @param key The key for the keyed hash function passed as a list of two uint64
   * @return a new instance of StringToHashBucketStrong
   * @see org.tensorflow.op.core.StringToHashBucketStrong
   */
  public StringToHashBucketStrong stringToHashBucketStrong(Operand<String> input, Long numBuckets,
      List<Long> key) {
    return StringToHashBucketStrong.create(scope, input, numBuckets, key);
  }

  /**
   * Adds an {@link Polygamma} operation to the graph
   *
   * @param a 
   * @param x 
   * @return a new instance of Polygamma
   * @see org.tensorflow.op.core.Polygamma
   */
  public <T extends Number> Polygamma<T> polygamma(Operand<T> a, Operand<T> x) {
    return Polygamma.create(scope, a, x);
  }

  /**
   * Adds an {@link BigQueryReader} operation to the graph
   *
   * @param projectId GCP project ID.
   * @param datasetId BigQuery Dataset ID.
   * @param tableId Table to read.
   * @param columns List of columns to read. Leave empty to read all columns.
   * @param timestampMillis Table snapshot timestamp in millis since epoch. Relative
   * @param options carries optional attributes values
   * @return a new instance of BigQueryReader
   * @see org.tensorflow.op.core.BigQueryReader
   */
  public BigQueryReader bigQueryReader(String projectId, String datasetId, String tableId,
      List<String> columns, Long timestampMillis, BigQueryReader.Options... options) {
    return BigQueryReader.create(scope, projectId, datasetId, tableId, columns, timestampMillis, options);
  }

  /**
   * Adds an {@link SparseApplyFtrl} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param linear Should be from a Variable().
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param lrPower Scaling factor. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyFtrl
   * @see org.tensorflow.op.core.SparseApplyFtrl
   */
  public <T, U extends Number> SparseApplyFtrl<T> sparseApplyFtrl(Operand<T> var, Operand<T> accum,
      Operand<T> linear, Operand<T> grad, Operand<U> indices, Operand<T> lr, Operand<T> l1,
      Operand<T> l2, Operand<T> lrPower, SparseApplyFtrl.Options... options) {
    return SparseApplyFtrl.create(scope, var, accum, linear, grad, indices, lr, l1, l2, lrPower, options);
  }

  /**
   * Adds an {@link SparseSegmentSqrtN} operation to the graph
   *
   * @param data 
   * @param indices A 1-D tensor. Has same rank as `segment_ids`.
   * @param segmentIds A 1-D tensor. Values should be sorted and can be repeated.
   * @return a new instance of SparseSegmentSqrtN
   * @see org.tensorflow.op.core.SparseSegmentSqrtN
   */
  public <T extends Number, U extends Number> SparseSegmentSqrtN<T> sparseSegmentSqrtN(Operand<T> data,
      Operand<U> indices, Operand<Integer> segmentIds) {
    return SparseSegmentSqrtN.create(scope, data, indices, segmentIds);
  }

  /**
   * Adds an {@link AssignVariableOp} operation to the graph
   *
   * @param resource handle to the resource in which to store the variable.
   * @param value the value to set the new tensor to use.
   * @return a new instance of AssignVariableOp
   * @see org.tensorflow.op.core.AssignVariableOp
   */
  public <T> AssignVariableOp assignVariableOp(Operand<?> resource, Operand<T> value) {
    return AssignVariableOp.create(scope, resource, value);
  }

  /**
   * Adds an {@link PreventGradient} operation to the graph
   *
   * @param input any tensor.
   * @param options carries optional attributes values
   * @return a new instance of PreventGradient
   * @see org.tensorflow.op.core.PreventGradient
   */
  public <T> PreventGradient<T> preventGradient(Operand<T> input,
      PreventGradient.Options... options) {
    return PreventGradient.create(scope, input, options);
  }

  /**
   * Adds an {@link FakeQuantWithMinMaxVars} operation to the graph
   *
   * @param inputs 
   * @param min 
   * @param max 
   * @param options carries optional attributes values
   * @return a new instance of FakeQuantWithMinMaxVars
   * @see org.tensorflow.op.core.FakeQuantWithMinMaxVars
   */
  public FakeQuantWithMinMaxVars fakeQuantWithMinMaxVars(Operand<Float> inputs, Operand<Float> min,
      Operand<Float> max, FakeQuantWithMinMaxVars.Options... options) {
    return FakeQuantWithMinMaxVars.create(scope, inputs, min, max, options);
  }

  /**
   * Adds an {@link TensorListPushBackBatch} operation to the graph
   *
   * @param inputHandles 
   * @param tensor 
   * @return a new instance of TensorListPushBackBatch
   * @see org.tensorflow.op.core.TensorListPushBackBatch
   */
  public <T> TensorListPushBackBatch tensorListPushBackBatch(Operand<?> inputHandles,
      Operand<T> tensor) {
    return TensorListPushBackBatch.create(scope, inputHandles, tensor);
  }

  /**
   * Adds an {@link BesselI0e} operation to the graph
   *
   * @param x 
   * @return a new instance of BesselI0e
   * @see org.tensorflow.op.core.BesselI0e
   */
  public <T extends Number> BesselI0e<T> besselI0e(Operand<T> x) {
    return BesselI0e.create(scope, x);
  }

  /**
   * Adds an {@link Rpc} operation to the graph
   *
   * @param address `0-D` or `1-D`.  The address (i.e. host_name:port) of the RPC server.
   * @param method `0-D` or `1-D`.  The method address on the RPC server.
   * @param request `0-D` or `1-D`.  Serialized proto strings: the rpc request argument.
   * @param options carries optional attributes values
   * @return a new instance of Rpc
   * @see org.tensorflow.op.core.Rpc
   */
  public Rpc rpc(Operand<String> address, Operand<String> method, Operand<String> request,
      Rpc.Options... options) {
    return Rpc.create(scope, address, method, request, options);
  }

  /**
   * Adds an {@link ResizeArea} operation to the graph
   *
   * @param images 4-D with shape `[batch, height, width, channels]`.
   * @param size = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
   * @param options carries optional attributes values
   * @return a new instance of ResizeArea
   * @see org.tensorflow.op.core.ResizeArea
   */
  public <T extends Number> ResizeArea resizeArea(Operand<T> images, Operand<Integer> size,
      ResizeArea.Options... options) {
    return ResizeArea.create(scope, images, size, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Integer> constant(int[][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link Asin} operation to the graph
   *
   * @param x 
   * @return a new instance of Asin
   * @see org.tensorflow.op.core.Asin
   */
  public <T> Asin<T> asin(Operand<T> x) {
    return Asin.create(scope, x);
  }

  /**
   * Adds an {@link SparseSoftmax} operation to the graph
   *
   * @param spIndices 2-D.  `NNZ x R` matrix with the indices of non-empty values in a
   * @param spValues 1-D.  `NNZ` non-empty values corresponding to `sp_indices`.
   * @param spShape 1-D.  Shape of the input SparseTensor.
   * @return a new instance of SparseSoftmax
   * @see org.tensorflow.op.core.SparseSoftmax
   */
  public <T extends Number> SparseSoftmax<T> sparseSoftmax(Operand<Long> spIndices,
      Operand<T> spValues, Operand<Long> spShape) {
    return SparseSoftmax.create(scope, spIndices, spValues, spShape);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data The value to put into the new constant.
   * @return a boolean constant
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Boolean> constant(boolean data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link VariableShape} operation to the graph
   *
   * @param input 
   * @return a new instance of VariableShape
   * @see org.tensorflow.op.core.VariableShape
   */
  public VariableShape<Integer> variableShape(Operand<?> input) {
    return VariableShape.create(scope, input);
  }

  /**
   * Adds an {@link TensorArrayGradWithShape} operation to the graph
   *
   * @param handle The handle to the forward TensorArray.
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @param shapeToPrepend An int32 vector representing a shape. Elements in the gradient accumulator will
   * @param source The gradient source string, used to decide which gradient TensorArray
   * @return a new instance of TensorArrayGradWithShape
   * @see org.tensorflow.op.core.TensorArrayGradWithShape
   */
  public TensorArrayGradWithShape tensorArrayGradWithShape(Operand<?> handle, Operand<Float> flowIn,
      Operand<Integer> shapeToPrepend, String source) {
    return TensorArrayGradWithShape.create(scope, handle, flowIn, shapeToPrepend, source);
  }

  /**
   * Adds an {@link ApplyAdagradDA} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param gradientAccumulator Should be from a Variable().
   * @param gradientSquaredAccumulator Should be from a Variable().
   * @param grad The gradient.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param globalStep Training step number. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ApplyAdagradDA
   * @see org.tensorflow.op.core.ApplyAdagradDA
   */
  public <T> ApplyAdagradDA<T> applyAdagradDA(Operand<T> var, Operand<T> gradientAccumulator,
      Operand<T> gradientSquaredAccumulator, Operand<T> grad, Operand<T> lr, Operand<T> l1,
      Operand<T> l2, Operand<Long> globalStep, ApplyAdagradDA.Options... options) {
    return ApplyAdagradDA.create(scope, var, gradientAccumulator, gradientSquaredAccumulator, grad, lr, l1, l2, globalStep, options);
  }

  /**
   * Adds an {@link Angle} operation to the graph
   *
   * @param input 
   * @param Tout 
   * @return a new instance of Angle
   * @see org.tensorflow.op.core.Angle
   */
  public <U extends Number, T> Angle<U> angle(Operand<T> input, Class<U> Tout) {
    return Angle.create(scope, input, Tout);
  }

  /**
   * Adds an {@link Betainc} operation to the graph
   *
   * @param a 
   * @param b 
   * @param x 
   * @return a new instance of Betainc
   * @see org.tensorflow.op.core.Betainc
   */
  public <T extends Number> Betainc<T> betainc(Operand<T> a, Operand<T> b, Operand<T> x) {
    return Betainc.create(scope, a, b, x);
  }

  /**
   * Adds an {@link MutableHashTable} operation to the graph
   *
   * @param keyDtype Type of the table keys.
   * @param valueDtype Type of the table values.
   * @param options carries optional attributes values
   * @return a new instance of MutableHashTable
   * @see org.tensorflow.op.core.MutableHashTable
   */
  public <T, U> MutableHashTable mutableHashTable(Class<T> keyDtype, Class<U> valueDtype,
      MutableHashTable.Options... options) {
    return MutableHashTable.create(scope, keyDtype, valueDtype, options);
  }

  /**
   * Adds an {@link IFFT3D} operation to the graph
   *
   * @param input A complex64 tensor.
   * @return a new instance of IFFT3D
   * @see org.tensorflow.op.core.IFFT3D
   */
  public <T> IFFT3D<T> iFFT3D(Operand<T> input) {
    return IFFT3D.create(scope, input);
  }

  /**
   * Adds an {@link Erfc} operation to the graph
   *
   * @param x 
   * @return a new instance of Erfc
   * @see org.tensorflow.op.core.Erfc
   */
  public <T extends Number> Erfc<T> erfc(Operand<T> x) {
    return Erfc.create(scope, x);
  }

  /**
   * Adds an {@link ApplyRMSProp} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param ms Should be from a Variable().
   * @param mom Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay rate. Must be a scalar.
   * @param momentum 
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ApplyRMSProp
   * @see org.tensorflow.op.core.ApplyRMSProp
   */
  public <T> ApplyRMSProp<T> applyRMSProp(Operand<T> var, Operand<T> ms, Operand<T> mom,
      Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad,
      ApplyRMSProp.Options... options) {
    return ApplyRMSProp.create(scope, var, ms, mom, lr, rho, momentum, epsilon, grad, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Long> constant(long[][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ApplyGradientDescent} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param alpha Scaling factor. Must be a scalar.
   * @param delta The change.
   * @param options carries optional attributes values
   * @return a new instance of ApplyGradientDescent
   * @see org.tensorflow.op.core.ApplyGradientDescent
   */
  public <T> ApplyGradientDescent<T> applyGradientDescent(Operand<T> var, Operand<T> alpha,
      Operand<T> delta, ApplyGradientDescent.Options... options) {
    return ApplyGradientDescent.create(scope, var, alpha, delta, options);
  }

  /**
   * Adds an {@link Atanh} operation to the graph
   *
   * @param x 
   * @return a new instance of Atanh
   * @see org.tensorflow.op.core.Atanh
   */
  public <T> Atanh<T> atanh(Operand<T> x) {
    return Atanh.create(scope, x);
  }

  /**
   * Adds an {@link SpaceToBatchND} operation to the graph
   *
   * @param input N-D with shape `input_shape = [batch] + spatial_shape + remaining_shape`,
   * @param blockShape 1-D with shape `[M]`, all values must be >= 1.
   * @param paddings 2-D with shape `[M, 2]`, all values must be >= 0.
   * @return a new instance of SpaceToBatchND
   * @see org.tensorflow.op.core.SpaceToBatchND
   */
  public <T, U extends Number, V extends Number> SpaceToBatchND<T> spaceToBatchND(Operand<T> input,
      Operand<U> blockShape, Operand<V> paddings) {
    return SpaceToBatchND.create(scope, input, blockShape, paddings);
  }

  /**
   * Adds an {@link Tanh} operation to the graph
   *
   * @param x 
   * @return a new instance of Tanh
   * @see org.tensorflow.op.core.Tanh
   */
  public <T> Tanh<T> tanh(Operand<T> x) {
    return Tanh.create(scope, x);
  }

  /**
   * Adds an {@link TensorArrayUnpack} operation to the graph
   *
   * @param handle 
   * @param value 
   * @param flowIn 
   * @return a new instance of TensorArrayUnpack
   * @see org.tensorflow.op.core.TensorArrayUnpack
   */
  public <T> TensorArrayUnpack tensorArrayUnpack(Operand<String> handle, Operand<T> value,
      Operand<Float> flowIn) {
    return TensorArrayUnpack.create(scope, handle, value, flowIn);
  }

  /**
   * Adds an {@link BarrierInsertMany} operation to the graph
   *
   * @param handle The handle to a barrier.
   * @param keys A one-dimensional tensor of keys, with length n.
   * @param values An any-dimensional tensor of values, which are associated with the
   * @param componentIndex The component of the barrier elements that is being assigned.
   * @return a new instance of BarrierInsertMany
   * @see org.tensorflow.op.core.BarrierInsertMany
   */
  public <T> BarrierInsertMany barrierInsertMany(Operand<String> handle, Operand<String> keys,
      Operand<T> values, Long componentIndex) {
    return BarrierInsertMany.create(scope, handle, keys, values, componentIndex);
  }

  /**
   * Adds an {@link BitwiseXor} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of BitwiseXor
   * @see org.tensorflow.op.core.BitwiseXor
   */
  public <T extends Number> BitwiseXor<T> bitwiseXor(Operand<T> x, Operand<T> y) {
    return BitwiseXor.create(scope, x, y);
  }

  /**
   * Adds an {@link ScalarSummary} operation to the graph
   *
   * @param tags Tags for the summary.
   * @param values Same shape as `tags.  Values for the summary.
   * @return a new instance of ScalarSummary
   * @see org.tensorflow.op.core.ScalarSummary
   */
  public <T extends Number> ScalarSummary scalarSummary(Operand<String> tags, Operand<T> values) {
    return ScalarSummary.create(scope, tags, values);
  }

  /**
   * Adds an {@link ApplyCenteredRMSProp} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param mg Should be from a Variable().
   * @param ms Should be from a Variable().
   * @param mom Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay rate. Must be a scalar.
   * @param momentum 
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ApplyCenteredRMSProp
   * @see org.tensorflow.op.core.ApplyCenteredRMSProp
   */
  public <T> ApplyCenteredRMSProp<T> applyCenteredRMSProp(Operand<T> var, Operand<T> mg,
      Operand<T> ms, Operand<T> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum,
      Operand<T> epsilon, Operand<T> grad, ApplyCenteredRMSProp.Options... options) {
    return ApplyCenteredRMSProp.create(scope, var, mg, ms, mom, lr, rho, momentum, epsilon, grad, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param object a Java object representing the constant.
   * @return a constant of type `type`
   * @see org.tensorflow.Tensor#create(Object) Tensor.create
   * @see org.tensorflow.op.core.Constant
   */
  public <T> Constant<T> constant(Object object, Class<T> type) {
    return Constant.create(scope, object, type);
  }

  /**
   * Adds an {@link MaxPoolWithArgmax} operation to the graph
   *
   * @param input 4-D with shape `[batch, height, width, channels]`.  Input to pool over.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * @param padding The type of padding algorithm to use.
   * @return a new instance of MaxPoolWithArgmax
   * @see org.tensorflow.op.core.MaxPoolWithArgmax
   */
  public <T extends Number> MaxPoolWithArgmax<T, Long> maxPoolWithArgmax(Operand<T> input,
      List<Long> ksize, List<Long> strides, String padding) {
    return MaxPoolWithArgmax.create(scope, input, ksize, strides, padding);
  }

  /**
   * Adds an {@link SparseToDense} operation to the graph
   *
   * @param sparseIndices 0-D, 1-D, or 2-D.  `sparse_indices[i]` contains the complete
   * @param outputShape 1-D.  Shape of the dense output tensor.
   * @param sparseValues 1-D.  Values corresponding to each row of `sparse_indices`,
   * @param defaultValue Scalar value to set for indices not specified in
   * @param options carries optional attributes values
   * @return a new instance of SparseToDense
   * @see org.tensorflow.op.core.SparseToDense
   */
  public <U, T extends Number> SparseToDense<U> sparseToDense(Operand<T> sparseIndices,
      Operand<T> outputShape, Operand<U> sparseValues, Operand<U> defaultValue,
      SparseToDense.Options... options) {
    return SparseToDense.create(scope, sparseIndices, outputShape, sparseValues, defaultValue, options);
  }

  /**
   * Adds an {@link StringStrip} operation to the graph
   *
   * @param input A string `Tensor` of any shape.
   * @return a new instance of StringStrip
   * @see org.tensorflow.op.core.StringStrip
   */
  public StringStrip stringStrip(Operand<String> input) {
    return StringStrip.create(scope, input);
  }

  /**
   * Adds an {@link DeserializeSparse} operation to the graph
   *
   * @param serializedSparse The serialized `SparseTensor` objects. The last dimension
   * @param dtype The `dtype` of the serialized `SparseTensor` objects.
   * @return a new instance of DeserializeSparse
   * @see org.tensorflow.op.core.DeserializeSparse
   */
  public <U, T> DeserializeSparse<U> deserializeSparse(Operand<T> serializedSparse,
      Class<U> dtype) {
    return DeserializeSparse.create(scope, serializedSparse, dtype);
  }

  /**
   * Adds an {@link SparseConditionalAccumulator} operation to the graph
   *
   * @param dtype The type of the value being accumulated.
   * @param shape The shape of the values.
   * @param options carries optional attributes values
   * @return a new instance of SparseConditionalAccumulator
   * @see org.tensorflow.op.core.SparseConditionalAccumulator
   */
  public <T> SparseConditionalAccumulator sparseConditionalAccumulator(Class<T> dtype, Shape shape,
      SparseConditionalAccumulator.Options... options) {
    return SparseConditionalAccumulator.create(scope, dtype, shape, options);
  }

  /**
   * Adds an {@link TextLineReader} operation to the graph
   *
   * @param options carries optional attributes values
   * @return a new instance of TextLineReader
   * @see org.tensorflow.op.core.TextLineReader
   */
  public TextLineReader textLineReader(TextLineReader.Options... options) {
    return TextLineReader.create(scope, options);
  }

  /**
   * Adds an {@link Unique} operation to the graph
   *
   * @param x 1-D.
   * @return a new instance of Unique
   * @see org.tensorflow.op.core.Unique
   */
  public <T> Unique<T, Integer> unique(Operand<T> x) {
    return Unique.create(scope, x);
  }

  /**
   * Adds an {@link DivNoNan} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of DivNoNan
   * @see org.tensorflow.op.core.DivNoNan
   */
  public <T extends Number> DivNoNan<T> divNoNan(Operand<T> x, Operand<T> y) {
    return DivNoNan.create(scope, x, y);
  }

  /**
   * Adds an {@link Diag} operation to the graph
   *
   * @param diagonal Rank k tensor where k is at most 1.
   * @return a new instance of Diag
   * @see org.tensorflow.op.core.Diag
   */
  public <T> Diag<T> diag(Operand<T> diagonal) {
    return Diag.create(scope, diagonal);
  }

  /**
   * Adds an {@link ResourceScatterMax} operation to the graph
   *
   * @param resource Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to add to `ref`.
   * @return a new instance of ResourceScatterMax
   * @see org.tensorflow.op.core.ResourceScatterMax
   */
  public <T extends Number, U> ResourceScatterMax resourceScatterMax(Operand<?> resource,
      Operand<T> indices, Operand<U> updates) {
    return ResourceScatterMax.create(scope, resource, indices, updates);
  }

  /**
   * Adds an {@link LMDBReader} operation to the graph
   *
   * @param options carries optional attributes values
   * @return a new instance of LMDBReader
   * @see org.tensorflow.op.core.LMDBReader
   */
  public LMDBReader lMDBReader(LMDBReader.Options... options) {
    return LMDBReader.create(scope, options);
  }

  /**
   * Adds an {@link DecodeCompressed} operation to the graph
   *
   * @param bytes A Tensor of string which is compressed.
   * @param options carries optional attributes values
   * @return a new instance of DecodeCompressed
   * @see org.tensorflow.op.core.DecodeCompressed
   */
  public DecodeCompressed decodeCompressed(Operand<String> bytes,
      DecodeCompressed.Options... options) {
    return DecodeCompressed.create(scope, bytes, options);
  }

  /**
   * Adds an {@link QueueDequeueUpTo} operation to the graph
   *
   * @param handle The handle to a queue.
   * @param n The number of tuples to dequeue.
   * @param componentTypes The type of each component in a tuple.
   * @param options carries optional attributes values
   * @return a new instance of QueueDequeueUpTo
   * @see org.tensorflow.op.core.QueueDequeueUpTo
   */
  public QueueDequeueUpTo queueDequeueUpTo(Operand<?> handle, Operand<Integer> n,
      List<Class<?>> componentTypes, QueueDequeueUpTo.Options... options) {
    return QueueDequeueUpTo.create(scope, handle, n, componentTypes, options);
  }

  /**
   * Adds an {@link TopK} operation to the graph
   *
   * @param input 1-D or higher with last dimension at least `k`.
   * @param k 0-D.  Number of top elements to look for along the last dimension (along each
   * @param options carries optional attributes values
   * @return a new instance of TopK
   * @see org.tensorflow.op.core.TopK
   */
  public <T extends Number> TopK<T> topK(Operand<T> input, Operand<Integer> k,
      TopK.Options... options) {
    return TopK.create(scope, input, k, options);
  }

  /**
   * Adds an {@link ResourceApplyProximalGradientDescent} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param alpha Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param delta The change.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyProximalGradientDescent
   * @see org.tensorflow.op.core.ResourceApplyProximalGradientDescent
   */
  public <T> ResourceApplyProximalGradientDescent resourceApplyProximalGradientDescent(Operand<?> var,
      Operand<T> alpha, Operand<T> l1, Operand<T> l2, Operand<T> delta,
      ResourceApplyProximalGradientDescent.Options... options) {
    return ResourceApplyProximalGradientDescent.create(scope, var, alpha, l1, l2, delta, options);
  }

  /**
   * Adds an {@link TFRecordReader} operation to the graph
   *
   * @param options carries optional attributes values
   * @return a new instance of TFRecordReader
   * @see org.tensorflow.op.core.TFRecordReader
   */
  public TFRecordReader tFRecordReader(TFRecordReader.Options... options) {
    return TFRecordReader.create(scope, options);
  }

  /**
   * Adds an {@link Stage} operation to the graph
   *
   * @param values a list of tensors
   * @param options carries optional attributes values
   * @return a new instance of Stage
   * @see org.tensorflow.op.core.Stage
   */
  public Stage stage(Iterable<Operand<?>> values, Stage.Options... options) {
    return Stage.create(scope, values, options);
  }

  /**
   * Adds an {@link TensorArrayClose} operation to the graph
   *
   * @param handle The handle to a TensorArray (output of TensorArray or TensorArrayGrad).
   * @return a new instance of TensorArrayClose
   * @see org.tensorflow.op.core.TensorArrayClose
   */
  public TensorArrayClose tensorArrayClose(Operand<?> handle) {
    return TensorArrayClose.create(scope, handle);
  }

  /**
   * Adds an {@link BatchSelfAdjointEigV2} operation to the graph
   *
   * @param input 
   * @param options carries optional attributes values
   * @return a new instance of BatchSelfAdjointEigV2
   * @see org.tensorflow.op.core.BatchSelfAdjointEigV2
   */
  public <T extends Number> BatchSelfAdjointEigV2<T> batchSelfAdjointEigV2(Operand<T> input,
      BatchSelfAdjointEigV2.Options... options) {
    return BatchSelfAdjointEigV2.create(scope, input, options);
  }

  /**
   * Adds an {@link HistogramFixedWidth} operation to the graph
   *
   * @param values Numeric `Tensor`.
   * @param valueRange Shape [2] `Tensor` of same `dtype` as `values`.
   * @param nbins Scalar `int32 Tensor`.  Number of histogram bins.
   * @return a new instance of HistogramFixedWidth
   * @see org.tensorflow.op.core.HistogramFixedWidth
   */
  public <T extends Number> HistogramFixedWidth<Integer> histogramFixedWidth(Operand<T> values,
      Operand<T> valueRange, Operand<Integer> nbins) {
    return HistogramFixedWidth.create(scope, values, valueRange, nbins);
  }

  /**
   * Adds an {@link NegTrain} operation to the graph
   *
   * @param wIn input word embedding.
   * @param wOut output word embedding.
   * @param examples A vector of word ids.
   * @param labels A vector of word ids.
   * @param lr 
   * @param vocabCount Count of words in the vocabulary.
   * @param numNegativeSamples Number of negative samples per example.
   * @return a new instance of NegTrain
   * @see org.tensorflow.op.core.NegTrain
   */
  public NegTrain negTrain(Operand<Float> wIn, Operand<Float> wOut, Operand<Integer> examples,
      Operand<Integer> labels, Operand<Float> lr, List<Long> vocabCount, Long numNegativeSamples) {
    return NegTrain.create(scope, wIn, wOut, examples, labels, lr, vocabCount, numNegativeSamples);
  }

  /**
   * Adds an {@link SetSize} operation to the graph
   *
   * @param setIndices 2D `Tensor`, indices of a `SparseTensor`.
   * @param setValues 1D `Tensor`, values of a `SparseTensor`.
   * @param setShape 1D `Tensor`, shape of a `SparseTensor`.
   * @param options carries optional attributes values
   * @return a new instance of SetSize
   * @see org.tensorflow.op.core.SetSize
   */
  public <T> SetSize setSize(Operand<Long> setIndices, Operand<T> setValues, Operand<Long> setShape,
      SetSize.Options... options) {
    return SetSize.create(scope, setIndices, setValues, setShape, options);
  }

  /**
   * Adds an {@link InitializeTable} operation to the graph
   *
   * @param tableHandle Handle to a table which will be initialized.
   * @param keys Keys of type Tkey.
   * @param values Values of type Tval.
   * @return a new instance of InitializeTable
   * @see org.tensorflow.op.core.InitializeTable
   */
  public <T, U> InitializeTable initializeTable(Operand<?> tableHandle, Operand<T> keys,
      Operand<U> values) {
    return InitializeTable.create(scope, tableHandle, keys, values);
  }

  /**
   * Adds an {@link ParameterizedTruncatedNormal} operation to the graph
   *
   * @param shape The shape of the output tensor. Batches are indexed by the 0th dimension.
   * @param means The mean parameter of each batch.
   * @param stdevs The standard deviation parameter of each batch. Must be greater than 0.
   * @param minvals The minimum cutoff. May be -infinity.
   * @param maxvals The maximum cutoff. May be +infinity, and must be more than the minval
   * @param options carries optional attributes values
   * @return a new instance of ParameterizedTruncatedNormal
   * @see org.tensorflow.op.core.ParameterizedTruncatedNormal
   */
  public <U extends Number, T extends Number> ParameterizedTruncatedNormal<U> parameterizedTruncatedNormal(Operand<T> shape,
      Operand<U> means, Operand<U> stdevs, Operand<U> minvals, Operand<U> maxvals,
      ParameterizedTruncatedNormal.Options... options) {
    return ParameterizedTruncatedNormal.create(scope, shape, means, stdevs, minvals, maxvals, options);
  }

  /**
   * Adds an {@link ScatterMul} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to multiply to `ref`.
   * @param options carries optional attributes values
   * @return a new instance of ScatterMul
   * @see org.tensorflow.op.core.ScatterMul
   */
  public <T, U extends Number> ScatterMul<T> scatterMul(Operand<T> ref, Operand<U> indices,
      Operand<T> updates, ScatterMul.Options... options) {
    return ScatterMul.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link ScatterUpdate} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to store in `ref`.
   * @param options carries optional attributes values
   * @return a new instance of ScatterUpdate
   * @see org.tensorflow.op.core.ScatterUpdate
   */
  public <T, U extends Number> ScatterUpdate<T> scatterUpdate(Operand<T> ref, Operand<U> indices,
      Operand<T> updates, ScatterUpdate.Options... options) {
    return ScatterUpdate.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link StageSize} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of StageSize
   * @see org.tensorflow.op.core.StageSize
   */
  public StageSize stageSize(List<Class<?>> dtypes, StageSize.Options... options) {
    return StageSize.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link StringLength} operation to the graph
   *
   * @param input The string for which to compute the length.
   * @param options carries optional attributes values
   * @return a new instance of StringLength
   * @see org.tensorflow.op.core.StringLength
   */
  public StringLength stringLength(Operand<String> input, StringLength.Options... options) {
    return StringLength.create(scope, input, options);
  }

  /**
   * Adds an {@link QuantizedInstanceNorm} operation to the graph
   *
   * @param x A 4D input Tensor.
   * @param xMin The value represented by the lowest quantized input.
   * @param xMax The value represented by the highest quantized input.
   * @param options carries optional attributes values
   * @return a new instance of QuantizedInstanceNorm
   * @see org.tensorflow.op.core.QuantizedInstanceNorm
   */
  public <T> QuantizedInstanceNorm<T> quantizedInstanceNorm(Operand<T> x, Operand<Float> xMin,
      Operand<Float> xMax, QuantizedInstanceNorm.Options... options) {
    return QuantizedInstanceNorm.create(scope, x, xMin, xMax, options);
  }

  /**
   * Adds an {@link MatchingFiles} operation to the graph
   *
   * @param pattern Shell wildcard pattern(s). Scalar or vector of type string.
   * @return a new instance of MatchingFiles
   * @see org.tensorflow.op.core.MatchingFiles
   */
  public MatchingFiles matchingFiles(Operand<String> pattern) {
    return MatchingFiles.create(scope, pattern);
  }

  /**
   * Adds an {@link ResourceSparseApplyKerasMomentum} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param momentum Momentum. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyKerasMomentum
   * @see org.tensorflow.op.core.ResourceSparseApplyKerasMomentum
   */
  public <T, U extends Number> ResourceSparseApplyKerasMomentum resourceSparseApplyKerasMomentum(Operand<?> var,
      Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum,
      ResourceSparseApplyKerasMomentum.Options... options) {
    return ResourceSparseApplyKerasMomentum.create(scope, var, accum, lr, grad, indices, momentum, options);
  }

  /**
   * Adds an {@link QueueDequeueMany} operation to the graph
   *
   * @param handle The handle to a queue.
   * @param n The number of tuples to dequeue.
   * @param componentTypes The type of each component in a tuple.
   * @param options carries optional attributes values
   * @return a new instance of QueueDequeueMany
   * @see org.tensorflow.op.core.QueueDequeueMany
   */
  public QueueDequeueMany queueDequeueMany(Operand<?> handle, Operand<Integer> n,
      List<Class<?>> componentTypes, QueueDequeueMany.Options... options) {
    return QueueDequeueMany.create(scope, handle, n, componentTypes, options);
  }

  /**
   * Adds an {@link AssignAdd} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param value The value to be added to the variable.
   * @param options carries optional attributes values
   * @return a new instance of AssignAdd
   * @see org.tensorflow.op.core.AssignAdd
   */
  public <T> AssignAdd<T> assignAdd(Operand<T> ref, Operand<T> value,
      AssignAdd.Options... options) {
    return AssignAdd.create(scope, ref, value, options);
  }

  /**
   * Adds an {@link StringToHashBucket} operation to the graph
   *
   * @param stringTensor 
   * @param numBuckets The number of buckets.
   * @return a new instance of StringToHashBucket
   * @see org.tensorflow.op.core.StringToHashBucket
   */
  public StringToHashBucket stringToHashBucket(Operand<String> stringTensor, Long numBuckets) {
    return StringToHashBucket.create(scope, stringTensor, numBuckets);
  }

  /**
   * Adds an {@link RefSelect} operation to the graph
   *
   * @param index A scalar that determines the input that gets selected.
   * @param inputs A list of ref tensors, one of which will be forwarded to `output`.
   * @return a new instance of RefSelect
   * @see org.tensorflow.op.core.RefSelect
   */
  public <T> RefSelect<T> refSelect(Operand<Integer> index, Operand<T> inputs) {
    return RefSelect.create(scope, index, inputs);
  }

  /**
   * Adds an {@link DestroyTemporaryVariable} operation to the graph
   *
   * @param ref A reference to the temporary variable tensor.
   * @param varName Name of the temporary variable, usually the name of the matching
   * @return a new instance of DestroyTemporaryVariable
   * @see org.tensorflow.op.core.DestroyTemporaryVariable
   */
  public <T> DestroyTemporaryVariable<T> destroyTemporaryVariable(Operand<T> ref, String varName) {
    return DestroyTemporaryVariable.create(scope, ref, varName);
  }

  /**
   * Adds an {@link SparseSparseMinimum} operation to the graph
   *
   * @param aIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param aValues 1-D.  `N` non-empty values corresponding to `a_indices`.
   * @param aShape 1-D.  Shape of the input SparseTensor.
   * @param bIndices counterpart to `a_indices` for the other operand.
   * @param bValues counterpart to `a_values` for the other operand; must be of the same dtype.
   * @param bShape counterpart to `a_shape` for the other operand; the two shapes must be equal.
   * @return a new instance of SparseSparseMinimum
   * @see org.tensorflow.op.core.SparseSparseMinimum
   */
  public <T> SparseSparseMinimum<T> sparseSparseMinimum(Operand<Long> aIndices, Operand<T> aValues,
      Operand<Long> aShape, Operand<Long> bIndices, Operand<T> bValues, Operand<Long> bShape) {
    return SparseSparseMinimum.create(scope, aIndices, aValues, aShape, bIndices, bValues, bShape);
  }

  /**
   * Adds an {@link BatchMatrixTriangularSolve} operation to the graph
   *
   * @param matrix 
   * @param rhs 
   * @param options carries optional attributes values
   * @return a new instance of BatchMatrixTriangularSolve
   * @see org.tensorflow.op.core.BatchMatrixTriangularSolve
   */
  public <T extends Number> BatchMatrixTriangularSolve<T> batchMatrixTriangularSolve(Operand<T> matrix,
      Operand<T> rhs, BatchMatrixTriangularSolve.Options... options) {
    return BatchMatrixTriangularSolve.create(scope, matrix, rhs, options);
  }

  /**
   * Adds an {@link Erf} operation to the graph
   *
   * @param x 
   * @return a new instance of Erf
   * @see org.tensorflow.op.core.Erf
   */
  public <T extends Number> Erf<T> erf(Operand<T> x) {
    return Erf.create(scope, x);
  }

  /**
   * Adds an {@link GcsConfigureCredentials} operation to the graph
   *
   * @param json 
   * @return a new instance of GcsConfigureCredentials
   * @see org.tensorflow.op.core.GcsConfigureCredentials
   */
  public GcsConfigureCredentials gcsConfigureCredentials(Operand<String> json) {
    return GcsConfigureCredentials.create(scope, json);
  }

  /**
   * Adds an {@link StatelessMultinomial} operation to the graph
   *
   * @param logits 2-D Tensor with shape `[batch_size, num_classes]`.  Each slice `[i, :]`
   * @param numSamples 0-D.  Number of independent samples to draw for each row slice.
   * @param seed 2 seeds (shape [2]).
   * @param outputDtype 
   * @return a new instance of StatelessMultinomial
   * @see org.tensorflow.op.core.StatelessMultinomial
   */
  public <V extends Number, T extends Number, U extends Number> StatelessMultinomial<V> statelessMultinomial(Operand<T> logits,
      Operand<Integer> numSamples, Operand<U> seed, Class<V> outputDtype) {
    return StatelessMultinomial.create(scope, logits, numSamples, seed, outputDtype);
  }

  /**
   * Adds an {@link Fact} operation to the graph
   *
   * @return a new instance of Fact
   * @see org.tensorflow.op.core.Fact
   */
  public Fact fact() {
    return Fact.create(scope);
  }

  /**
   * Adds an {@link ResourceApplyAdagrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyAdagrad
   * @see org.tensorflow.op.core.ResourceApplyAdagrad
   */
  public <T> ResourceApplyAdagrad resourceApplyAdagrad(Operand<?> var, Operand<?> accum,
      Operand<T> lr, Operand<T> grad, ResourceApplyAdagrad.Options... options) {
    return ResourceApplyAdagrad.create(scope, var, accum, lr, grad, options);
  }

  /**
   * Adds an {@link TryRpc} operation to the graph
   *
   * @param address `0-D` or `1-D`.  The address (i.e. host_name:port) of the RPC server.
   * @param method `0-D` or `1-D`.  The method address on the RPC server.
   * @param request `0-D` or `1-D`.  Serialized proto strings: the rpc request argument.
   * @param options carries optional attributes values
   * @return a new instance of TryRpc
   * @see org.tensorflow.op.core.TryRpc
   */
  public TryRpc tryRpc(Operand<String> address, Operand<String> method, Operand<String> request,
      TryRpc.Options... options) {
    return TryRpc.create(scope, address, method, request, options);
  }

  /**
   * Adds an {@link ResourceApplyFtrl} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param linear Should be from a Variable().
   * @param grad The gradient.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regulariation. Must be a scalar.
   * @param l2 L2 regulariation. Must be a scalar.
   * @param lrPower Scaling factor. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyFtrl
   * @see org.tensorflow.op.core.ResourceApplyFtrl
   */
  public <T> ResourceApplyFtrl resourceApplyFtrl(Operand<?> var, Operand<?> accum,
      Operand<?> linear, Operand<T> grad, Operand<T> lr, Operand<T> l1, Operand<T> l2,
      Operand<T> lrPower, ResourceApplyFtrl.Options... options) {
    return ResourceApplyFtrl.create(scope, var, accum, linear, grad, lr, l1, l2, lrPower, options);
  }

  /**
   * Adds an {@link ApplyProximalAdagrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ApplyProximalAdagrad
   * @see org.tensorflow.op.core.ApplyProximalAdagrad
   */
  public <T> ApplyProximalAdagrad<T> applyProximalAdagrad(Operand<T> var, Operand<T> accum,
      Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> grad,
      ApplyProximalAdagrad.Options... options) {
    return ApplyProximalAdagrad.create(scope, var, accum, lr, l1, l2, grad, options);
  }

  /**
   * Adds an {@link BroadcastDynamicShape} operation to the graph
   *
   * @param s0 
   * @param s1 
   * @return a new instance of BroadcastDynamicShape
   * @see org.tensorflow.op.core.BroadcastDynamicShape
   */
  public <T extends Number> BroadcastDynamicShape<T> broadcastDynamicShape(Operand<T> s0,
      Operand<T> s1) {
    return BroadcastDynamicShape.create(scope, s0, s1);
  }

  /**
   * Adds an {@link SparseSegmentMeanWithNumSegments} operation to the graph
   *
   * @param data 
   * @param indices A 1-D tensor. Has same rank as `segment_ids`.
   * @param segmentIds A 1-D tensor. Values should be sorted and can be repeated.
   * @param numSegments Should equal the number of distinct segment IDs.
   * @return a new instance of SparseSegmentMeanWithNumSegments
   * @see org.tensorflow.op.core.SparseSegmentMeanWithNumSegments
   */
  public <T extends Number, U extends Number, V extends Number> SparseSegmentMeanWithNumSegments<T> sparseSegmentMeanWithNumSegments(Operand<T> data,
      Operand<U> indices, Operand<Integer> segmentIds, Operand<V> numSegments) {
    return SparseSegmentMeanWithNumSegments.create(scope, data, indices, segmentIds, numSegments);
  }

  /**
   * Adds an {@link ShardedFilespec} operation to the graph
   *
   * @param basename 
   * @param numShards 
   * @return a new instance of ShardedFilespec
   * @see org.tensorflow.op.core.ShardedFilespec
   */
  public ShardedFilespec shardedFilespec(Operand<String> basename, Operand<Integer> numShards) {
    return ShardedFilespec.create(scope, basename, numShards);
  }

  /**
   * Adds an {@link IteratorGetNextAsOptional} operation to the graph
   *
   * @param iterator 
   * @param outputTypes 
   * @param outputShapes 
   * @return a new instance of IteratorGetNextAsOptional
   * @see org.tensorflow.op.core.IteratorGetNextAsOptional
   */
  public IteratorGetNextAsOptional iteratorGetNextAsOptional(Operand<?> iterator,
      List<Class<?>> outputTypes, List<Shape> outputShapes) {
    return IteratorGetNextAsOptional.create(scope, iterator, outputTypes, outputShapes);
  }

  /**
   * Adds an {@link SerializeSparse} operation to the graph
   *
   * @param sparseIndices 2-D.  The `indices` of the `SparseTensor`.
   * @param sparseValues 1-D.  The `values` of the `SparseTensor`.
   * @param sparseShape 1-D.  The `shape` of the `SparseTensor`.
   * @return a new instance of SerializeSparse
   * @see org.tensorflow.op.core.SerializeSparse
   */
  public <T> SerializeSparse<String> serializeSparse(Operand<Long> sparseIndices,
      Operand<T> sparseValues, Operand<Long> sparseShape) {
    return SerializeSparse.create(scope, sparseIndices, sparseValues, sparseShape);
  }

  /**
   * Adds an {@link MaxPoolGradGrad} operation to the graph
   *
   * @param origInput The original input tensor.
   * @param origOutput The original output tensor.
   * @param grad 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of MaxPoolGradGrad
   * @see org.tensorflow.op.core.MaxPoolGradGrad
   */
  public <T extends Number> MaxPoolGradGrad<T> maxPoolGradGrad(Operand<T> origInput,
      Operand<T> origOutput, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding,
      MaxPoolGradGrad.Options... options) {
    return MaxPoolGradGrad.create(scope, origInput, origOutput, grad, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link QuantizeAndDequantizeV2} operation to the graph
   *
   * @param input Tensor to quantize and then dequantize.
   * @param inputMin If `range_given == True`, this specifies the minimum input value that needs to
   * @param inputMax If `range_given == True`, this specifies the maximum input value that needs to
   * @param options carries optional attributes values
   * @return a new instance of QuantizeAndDequantizeV2
   * @see org.tensorflow.op.core.QuantizeAndDequantizeV2
   */
  public <T extends Number> QuantizeAndDequantizeV2<T> quantizeAndDequantizeV2(Operand<T> input,
      Operand<T> inputMin, Operand<T> inputMax, QuantizeAndDequantizeV2.Options... options) {
    return QuantizeAndDequantizeV2.create(scope, input, inputMin, inputMax, options);
  }

  /**
   * Adds an {@link GreaterEqual} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of GreaterEqual
   * @see org.tensorflow.op.core.GreaterEqual
   */
  public <T extends Number> GreaterEqual greaterEqual(Operand<T> x, Operand<T> y) {
    return GreaterEqual.create(scope, x, y);
  }

  /**
   * Adds an {@link Sqrt} operation to the graph
   *
   * @param x 
   * @return a new instance of Sqrt
   * @see org.tensorflow.op.core.Sqrt
   */
  public <T> Sqrt<T> sqrt(Operand<T> x) {
    return Sqrt.create(scope, x);
  }

  /**
   * Adds an {@link DecodeWav} operation to the graph
   *
   * @param contents The WAV-encoded audio, usually from a file.
   * @param options carries optional attributes values
   * @return a new instance of DecodeWav
   * @see org.tensorflow.op.core.DecodeWav
   */
  public DecodeWav decodeWav(Operand<String> contents, DecodeWav.Options... options) {
    return DecodeWav.create(scope, contents, options);
  }

  /**
   * Adds an {@link SparseSlice} operation to the graph
   *
   * @param indices 2-D tensor represents the indices of the sparse tensor.
   * @param values 1-D tensor represents the values of the sparse tensor.
   * @param shape 1-D. tensor represents the shape of the sparse tensor.
   * @param start 1-D. tensor represents the start of the slice.
   * @param size 1-D. tensor represents the size of the slice.
   * @return a new instance of SparseSlice
   * @see org.tensorflow.op.core.SparseSlice
   */
  public <T> SparseSlice<T> sparseSlice(Operand<Long> indices, Operand<T> values,
      Operand<Long> shape, Operand<Long> start, Operand<Long> size) {
    return SparseSlice.create(scope, indices, values, shape, start, size);
  }

  /**
   * Adds an {@link DecodeProtoV2} operation to the graph
   *
   * @param bytes Tensor of serialized protos with shape `batch_shape`.
   * @param messageType Name of the proto message type to decode.
   * @param fieldNames List of strings containing proto field names.
   * @param outputTypes List of TF types to use for the respective field in field_names.
   * @param options carries optional attributes values
   * @return a new instance of DecodeProtoV2
   * @see org.tensorflow.op.core.DecodeProtoV2
   */
  public DecodeProtoV2 decodeProtoV2(Operand<String> bytes, String messageType,
      List<String> fieldNames, List<Class<?>> outputTypes, DecodeProtoV2.Options... options) {
    return DecodeProtoV2.create(scope, bytes, messageType, fieldNames, outputTypes, options);
  }

  /**
   * Adds an {@link IteratorGetNext} operation to the graph
   *
   * @param iterator 
   * @param outputTypes 
   * @param outputShapes 
   * @return a new instance of IteratorGetNext
   * @see org.tensorflow.op.core.IteratorGetNext
   */
  public IteratorGetNext iteratorGetNext(Operand<?> iterator, List<Class<?>> outputTypes,
      List<Shape> outputShapes) {
    return IteratorGetNext.create(scope, iterator, outputTypes, outputShapes);
  }

  /**
   * Adds an {@link BatchCholesky} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchCholesky
   * @see org.tensorflow.op.core.BatchCholesky
   */
  public <T extends Number> BatchCholesky<T> batchCholesky(Operand<T> input) {
    return BatchCholesky.create(scope, input);
  }

  /**
   * Adds an {@link MergeV2Checkpoints} operation to the graph
   *
   * @param checkpointPrefixes prefixes of V2 checkpoints to merge.
   * @param destinationPrefix scalar.  The desired final prefix.  Allowed to be the same
   * @param options carries optional attributes values
   * @return a new instance of MergeV2Checkpoints
   * @see org.tensorflow.op.core.MergeV2Checkpoints
   */
  public MergeV2Checkpoints mergeV2Checkpoints(Operand<String> checkpointPrefixes,
      Operand<String> destinationPrefix, MergeV2Checkpoints.Options... options) {
    return MergeV2Checkpoints.create(scope, checkpointPrefixes, destinationPrefix, options);
  }

  /**
   * Adds an {@link TemporaryVariable} operation to the graph
   *
   * @param shape The shape of the variable tensor.
   * @param dtype The type of elements in the variable tensor.
   * @param options carries optional attributes values
   * @return a new instance of TemporaryVariable
   * @see org.tensorflow.op.core.TemporaryVariable
   */
  public <T> TemporaryVariable<T> temporaryVariable(Shape shape, Class<T> dtype,
      TemporaryVariable.Options... options) {
    return TemporaryVariable.create(scope, shape, dtype, options);
  }

  /**
   * Adds an {@link ApplyFtrlV2} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param linear Should be from a Variable().
   * @param grad The gradient.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regulariation. Must be a scalar.
   * @param l2 L2 shrinkage regulariation. Must be a scalar.
   * @param l2Shrinkage 
   * @param lrPower Scaling factor. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ApplyFtrlV2
   * @see org.tensorflow.op.core.ApplyFtrlV2
   */
  public <T> ApplyFtrlV2<T> applyFtrlV2(Operand<T> var, Operand<T> accum, Operand<T> linear,
      Operand<T> grad, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> l2Shrinkage,
      Operand<T> lrPower, ApplyFtrlV2.Options... options) {
    return ApplyFtrlV2.create(scope, var, accum, linear, grad, lr, l1, l2, l2Shrinkage, lrPower, options);
  }

  /**
   * Adds an {@link MaxPool3D} operation to the graph
   *
   * @param input Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
   * @param ksize 1-D tensor of length 5. The size of the window for each dimension of
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of MaxPool3D
   * @see org.tensorflow.op.core.MaxPool3D
   */
  public <T extends Number> MaxPool3D<T> maxPool3D(Operand<T> input, List<Long> ksize,
      List<Long> strides, String padding, MaxPool3D.Options... options) {
    return MaxPool3D.create(scope, input, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link FusedBatchNorm} operation to the graph
   *
   * @param x A 4D Tensor for input data.
   * @param scale A 1D Tensor for scaling factor, to scale the normalized x.
   * @param offset A 1D Tensor for offset, to shift to the normalized x.
   * @param mean A 1D Tensor for population mean. Used for inference only;
   * @param variance A 1D Tensor for population variance. Used for inference only;
   * @param options carries optional attributes values
   * @return a new instance of FusedBatchNorm
   * @see org.tensorflow.op.core.FusedBatchNorm
   */
  public <T extends Number> FusedBatchNorm<T> fusedBatchNorm(Operand<T> x, Operand<T> scale,
      Operand<T> offset, Operand<T> mean, Operand<T> variance, FusedBatchNorm.Options... options) {
    return FusedBatchNorm.create(scope, x, scale, offset, mean, variance, options);
  }

  /**
   * Adds an {@link SegmentMin} operation to the graph
   *
   * @param data 
   * @param segmentIds A 1-D tensor whose size is equal to the size of `data`'s
   * @return a new instance of SegmentMin
   * @see org.tensorflow.op.core.SegmentMin
   */
  public <T extends Number, U extends Number> SegmentMin<T> segmentMin(Operand<T> data,
      Operand<U> segmentIds) {
    return SegmentMin.create(scope, data, segmentIds);
  }

  /**
   * Adds an {@link PrintV2} operation to the graph
   *
   * @param input The string scalar to print.
   * @param options carries optional attributes values
   * @return a new instance of PrintV2
   * @see org.tensorflow.op.core.PrintV2
   */
  public PrintV2 printV2(Operand<String> input, PrintV2.Options... options) {
    return PrintV2.create(scope, input, options);
  }

  /**
   * Adds an {@link GcsConfigureBlockCache} operation to the graph
   *
   * @param maxCacheSize 
   * @param blockSize 
   * @param maxStaleness 
   * @return a new instance of GcsConfigureBlockCache
   * @see org.tensorflow.op.core.GcsConfigureBlockCache
   */
  public GcsConfigureBlockCache gcsConfigureBlockCache(Operand<?> maxCacheSize,
      Operand<?> blockSize, Operand<?> maxStaleness) {
    return GcsConfigureBlockCache.create(scope, maxCacheSize, blockSize, maxStaleness);
  }

  /**
   * Adds an {@link BiasAdd} operation to the graph
   *
   * @param value Any number of dimensions.
   * @param bias 1-D with size the last dimension of `value`.
   * @param options carries optional attributes values
   * @return a new instance of BiasAdd
   * @see org.tensorflow.op.core.BiasAdd
   */
  public <T> BiasAdd<T> biasAdd(Operand<T> value, Operand<T> bias, BiasAdd.Options... options) {
    return BiasAdd.create(scope, value, bias, options);
  }

  /**
   * Adds an {@link MatrixSquareRoot} operation to the graph
   *
   * @param input Shape is `[..., M, M]`.
   * @return a new instance of MatrixSquareRoot
   * @see org.tensorflow.op.core.MatrixSquareRoot
   */
  public <T> MatrixSquareRoot<T> matrixSquareRoot(Operand<T> input) {
    return MatrixSquareRoot.create(scope, input);
  }

  /**
   * Adds an {@link Abs} operation to the graph
   *
   * @param x 
   * @return a new instance of Abs
   * @see org.tensorflow.op.core.Abs
   */
  public <T extends Number> Abs<T> abs(Operand<T> x) {
    return Abs.create(scope, x);
  }

  /**
   * Adds an {@link DynamicStitch} operation to the graph
   *
   * @param indices 
   * @param data 
   * @return a new instance of DynamicStitch
   * @see org.tensorflow.op.core.DynamicStitch
   */
  public <T> DynamicStitch<T> dynamicStitch(Iterable<Operand<Integer>> indices, Operand<T> data) {
    return DynamicStitch.create(scope, indices, data);
  }

  /**
   * Adds an {@link Substr} operation to the graph
   *
   * @param input Tensor of strings
   * @param pos Scalar defining the position of first character in each substring
   * @param len Scalar defining the number of characters to include in each substring
   * @param options carries optional attributes values
   * @return a new instance of Substr
   * @see org.tensorflow.op.core.Substr
   */
  public <T extends Number> Substr substr(Operand<String> input, Operand<T> pos, Operand<T> len,
      Substr.Options... options) {
    return Substr.create(scope, input, pos, len, options);
  }

  /**
   * Adds an {@link ResizeBilinear} operation to the graph
   *
   * @param images 4-D with shape `[batch, height, width, channels]`.
   * @param size = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
   * @param options carries optional attributes values
   * @return a new instance of ResizeBilinear
   * @see org.tensorflow.op.core.ResizeBilinear
   */
  public <T extends Number> ResizeBilinear resizeBilinear(Operand<T> images, Operand<Integer> size,
      ResizeBilinear.Options... options) {
    return ResizeBilinear.create(scope, images, size, options);
  }

  /**
   * Adds an {@link Acosh} operation to the graph
   *
   * @param x 
   * @return a new instance of Acosh
   * @see org.tensorflow.op.core.Acosh
   */
  public <T> Acosh<T> acosh(Operand<T> x) {
    return Acosh.create(scope, x);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Long> constant(long[][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link EmptyTensorList} operation to the graph
   *
   * @param elementShape 
   * @param maxNumElements 
   * @param elementDtype 
   * @return a new instance of EmptyTensorList
   * @see org.tensorflow.op.core.EmptyTensorList
   */
  public <T extends Number, U> EmptyTensorList emptyTensorList(Operand<T> elementShape,
      Operand<Integer> maxNumElements, Class<U> elementDtype) {
    return EmptyTensorList.create(scope, elementShape, maxNumElements, elementDtype);
  }

  /**
   * Adds an {@link QueueIsClosedV2} operation to the graph
   *
   * @param handle The handle to a queue.
   * @return a new instance of QueueIsClosedV2
   * @see org.tensorflow.op.core.QueueIsClosedV2
   */
  public QueueIsClosedV2 queueIsClosedV2(Operand<?> handle) {
    return QueueIsClosedV2.create(scope, handle);
  }

  /**
   * Adds an {@link Selu} operation to the graph
   *
   * @param features 
   * @return a new instance of Selu
   * @see org.tensorflow.op.core.Selu
   */
  public <T extends Number> Selu<T> selu(Operand<T> features) {
    return Selu.create(scope, features);
  }

  /**
   * Adds an {@link QuantizeAndDequantizeV3} operation to the graph
   *
   * @param input 
   * @param inputMin 
   * @param inputMax 
   * @param numBits 
   * @param options carries optional attributes values
   * @return a new instance of QuantizeAndDequantizeV3
   * @see org.tensorflow.op.core.QuantizeAndDequantizeV3
   */
  public <T extends Number> QuantizeAndDequantizeV3<T> quantizeAndDequantizeV3(Operand<T> input,
      Operand<T> inputMin, Operand<T> inputMax, Operand<Integer> numBits,
      QuantizeAndDequantizeV3.Options... options) {
    return QuantizeAndDequantizeV3.create(scope, input, inputMin, inputMax, numBits, options);
  }

  /**
   * Adds an {@link SparseCross} operation to the graph
   *
   * @param indices 2-D.  Indices of each input `SparseTensor`.
   * @param values 1-D.   values of each `SparseTensor`.
   * @param shapes 1-D.   Shapes of each `SparseTensor`.
   * @param denseInputs 2-D.    Columns represented by dense `Tensor`.
   * @param hashedOutput If true, returns the hash of the cross instead of the string.
   * @param numBuckets It is used if hashed_output is true.
   * @param hashKey Specify the hash_key that will be used by the `FingerprintCat64`
   * @param outType 
   * @param internalType 
   * @return a new instance of SparseCross
   * @see org.tensorflow.op.core.SparseCross
   */
  public <T, U> SparseCross<T> sparseCross(Iterable<Operand<Long>> indices,
      Iterable<Operand<?>> values, Iterable<Operand<Long>> shapes, Iterable<Operand<?>> denseInputs,
      Boolean hashedOutput, Long numBuckets, Long hashKey, Class<T> outType,
      Class<U> internalType) {
    return SparseCross.create(scope, indices, values, shapes, denseInputs, hashedOutput, numBuckets, hashKey, outType, internalType);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Boolean> constant(boolean[] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ResourceSparseApplyMomentum} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param momentum Momentum. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyMomentum
   * @see org.tensorflow.op.core.ResourceSparseApplyMomentum
   */
  public <T, U extends Number> ResourceSparseApplyMomentum resourceSparseApplyMomentum(Operand<?> var,
      Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum,
      ResourceSparseApplyMomentum.Options... options) {
    return ResourceSparseApplyMomentum.create(scope, var, accum, lr, grad, indices, momentum, options);
  }

  /**
   * Adds an {@link IRFFT} operation to the graph
   *
   * @param input A complex64 tensor.
   * @param fftLength An int32 tensor of shape [1]. The FFT length.
   * @return a new instance of IRFFT
   * @see org.tensorflow.op.core.IRFFT
   */
  public IRFFT iRFFT(Operand<?> input, Operand<Integer> fftLength) {
    return IRFFT.create(scope, input, fftLength);
  }

  /**
   * Adds an {@link GetSessionTensor} operation to the graph
   *
   * @param handle The handle for a tensor stored in the session state.
   * @param dtype The type of the output value.
   * @return a new instance of GetSessionTensor
   * @see org.tensorflow.op.core.GetSessionTensor
   */
  public <T> GetSessionTensor<T> getSessionTensor(Operand<String> handle, Class<T> dtype) {
    return GetSessionTensor.create(scope, handle, dtype);
  }

  /**
   * Adds an {@link Zeros} operation to the graph
   *
   * @param dims a 1-D operand that represents the shape of the output tensor
   * @param type the output tensor datatype
   * @return a constant tensor initialized with zeros
   * @throws IllegalArgumentException if the tensor type or shape cannot be initialized with zeros.
   * @see org.tensorflow.op.core.Zeros
   */
  public <T, U extends Number> Zeros<T> zeros(Operand<U> dims, Class<T> type) {
    return Zeros.create(scope, dims, type);
  }

  /**
   * Adds an {@link Exp} operation to the graph
   *
   * @param x 
   * @return a new instance of Exp
   * @see org.tensorflow.op.core.Exp
   */
  public <T> Exp<T> exp(Operand<T> x) {
    return Exp.create(scope, x);
  }

  /**
   * Adds an {@link PadV2} operation to the graph
   *
   * @param input 
   * @param paddings 
   * @param constantValues 
   * @return a new instance of PadV2
   * @see org.tensorflow.op.core.PadV2
   */
  public <T, U extends Number> PadV2<T> padV2(Operand<T> input, Operand<U> paddings,
      Operand<T> constantValues) {
    return PadV2.create(scope, input, paddings, constantValues);
  }

  /**
   * Adds an {@link Mul} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Mul
   * @see org.tensorflow.op.core.Mul
   */
  public <T> Mul<T> mul(Operand<T> x, Operand<T> y) {
    return Mul.create(scope, x, y);
  }

  /**
   * Adds an {@link ResourceSparseApplyProximalGradientDescent} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param alpha Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyProximalGradientDescent
   * @see org.tensorflow.op.core.ResourceSparseApplyProximalGradientDescent
   */
  public <T, U extends Number> ResourceSparseApplyProximalGradientDescent resourceSparseApplyProximalGradientDescent(Operand<?> var,
      Operand<T> alpha, Operand<T> l1, Operand<T> l2, Operand<T> grad, Operand<U> indices,
      ResourceSparseApplyProximalGradientDescent.Options... options) {
    return ResourceSparseApplyProximalGradientDescent.create(scope, var, alpha, l1, l2, grad, indices, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Boolean> constant(boolean[][][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link IFFT} operation to the graph
   *
   * @param input A complex tensor.
   * @return a new instance of IFFT
   * @see org.tensorflow.op.core.IFFT
   */
  public <T> IFFT<T> iFFT(Operand<T> input) {
    return IFFT.create(scope, input);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Float> constant(float[] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link IRFFT3D} operation to the graph
   *
   * @param input A complex64 tensor.
   * @param fftLength An int32 tensor of shape [3]. The FFT length for each dimension.
   * @return a new instance of IRFFT3D
   * @see org.tensorflow.op.core.IRFFT3D
   */
  public IRFFT3D iRFFT3D(Operand<?> input, Operand<Integer> fftLength) {
    return IRFFT3D.create(scope, input, fftLength);
  }

  /**
   * Adds an {@link RandomUniformInt} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param minval 0-D.  Inclusive lower bound on the generated integers.
   * @param maxval 0-D.  Exclusive upper bound on the generated integers.
   * @param options carries optional attributes values
   * @return a new instance of RandomUniformInt
   * @see org.tensorflow.op.core.RandomUniformInt
   */
  public <U extends Number, T extends Number> RandomUniformInt<U> randomUniformInt(Operand<T> shape,
      Operand<U> minval, Operand<U> maxval, RandomUniformInt.Options... options) {
    return RandomUniformInt.create(scope, shape, minval, maxval, options);
  }

  /**
   * Adds an {@link ReduceJoin} operation to the graph
   *
   * @param inputs The input to be joined.  All reduced indices must have non-zero size.
   * @param reductionIndices The dimensions to reduce over.  Dimensions are reduced in the
   * @param options carries optional attributes values
   * @return a new instance of ReduceJoin
   * @see org.tensorflow.op.core.ReduceJoin
   */
  public ReduceJoin reduceJoin(Operand<String> inputs, Operand<Integer> reductionIndices,
      ReduceJoin.Options... options) {
    return ReduceJoin.create(scope, inputs, reductionIndices, options);
  }

  /**
   * Adds an {@link UniformCandidateSampler} operation to the graph
   *
   * @param trueClasses A batch_size * num_true matrix, in which each row contains the
   * @param numTrue Number of true labels per context.
   * @param numSampled Number of candidates to randomly sample.
   * @param unique If unique is true, we sample with rejection, so that all sampled
   * @param rangeMax The sampler will sample integers from the interval [0, range_max).
   * @param options carries optional attributes values
   * @return a new instance of UniformCandidateSampler
   * @see org.tensorflow.op.core.UniformCandidateSampler
   */
  public UniformCandidateSampler uniformCandidateSampler(Operand<Long> trueClasses, Long numTrue,
      Long numSampled, Boolean unique, Long rangeMax, UniformCandidateSampler.Options... options) {
    return UniformCandidateSampler.create(scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
  }

  /**
   * Adds an {@link DebugGradientRefIdentity} operation to the graph
   *
   * @param input 
   * @return a new instance of DebugGradientRefIdentity
   * @see org.tensorflow.op.core.DebugGradientRefIdentity
   */
  public <T> DebugGradientRefIdentity<T> debugGradientRefIdentity(Operand<T> input) {
    return DebugGradientRefIdentity.create(scope, input);
  }

  /**
   * Adds an {@link Dilation2DBackpropInput} operation to the graph
   *
   * @param input 4-D with shape `[batch, in_height, in_width, depth]`.
   * @param filter 3-D with shape `[filter_height, filter_width, depth]`.
   * @param outBackprop 4-D with shape `[batch, out_height, out_width, depth]`.
   * @param strides 1-D of length 4. The stride of the sliding window for each dimension of
   * @param rates 1-D of length 4. The input stride for atrous morphological dilation.
   * @param padding The type of padding algorithm to use.
   * @return a new instance of Dilation2DBackpropInput
   * @see org.tensorflow.op.core.Dilation2DBackpropInput
   */
  public <T extends Number> Dilation2DBackpropInput<T> dilation2DBackpropInput(Operand<T> input,
      Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates,
      String padding) {
    return Dilation2DBackpropInput.create(scope, input, filter, outBackprop, strides, rates, padding);
  }

  /**
   * Adds an {@link GetSessionHandle} operation to the graph
   *
   * @param value The tensor to be stored.
   * @return a new instance of GetSessionHandle
   * @see org.tensorflow.op.core.GetSessionHandle
   */
  public <T> GetSessionHandle getSessionHandle(Operand<T> value) {
    return GetSessionHandle.create(scope, value);
  }

  /**
   * Adds an {@link ApplyAddSign} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param m Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param alpha Must be a scalar.
   * @param signDecay Must be a scalar.
   * @param beta Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ApplyAddSign
   * @see org.tensorflow.op.core.ApplyAddSign
   */
  public <T> ApplyAddSign<T> applyAddSign(Operand<T> var, Operand<T> m, Operand<T> lr,
      Operand<T> alpha, Operand<T> signDecay, Operand<T> beta, Operand<T> grad,
      ApplyAddSign.Options... options) {
    return ApplyAddSign.create(scope, var, m, lr, alpha, signDecay, beta, grad, options);
  }

  /**
   * Adds an {@link ReaderRead} operation to the graph
   *
   * @param readerHandle Handle to a Reader.
   * @param queueHandle Handle to a Queue, with string work items.
   * @return a new instance of ReaderRead
   * @see org.tensorflow.op.core.ReaderRead
   */
  public ReaderRead readerRead(Operand<?> readerHandle, Operand<?> queueHandle) {
    return ReaderRead.create(scope, readerHandle, queueHandle);
  }

  /**
   * Adds an {@link IteratorFromStringHandle} operation to the graph
   *
   * @param stringHandle A string representation of the given handle.
   * @param outputTypes If specified, defines the type of each tuple component in an
   * @param options carries optional attributes values
   * @return a new instance of IteratorFromStringHandle
   * @see org.tensorflow.op.core.IteratorFromStringHandle
   */
  public IteratorFromStringHandle iteratorFromStringHandle(Operand<String> stringHandle,
      List<Class<?>> outputTypes, IteratorFromStringHandle.Options... options) {
    return IteratorFromStringHandle.create(scope, stringHandle, outputTypes, options);
  }

  /**
   * Adds an {@link ScatterMax} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to reduce into `ref`.
   * @param options carries optional attributes values
   * @return a new instance of ScatterMax
   * @see org.tensorflow.op.core.ScatterMax
   */
  public <T extends Number, U extends Number> ScatterMax<T> scatterMax(Operand<T> ref,
      Operand<U> indices, Operand<T> updates, ScatterMax.Options... options) {
    return ScatterMax.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link FixedUnigramCandidateSampler} operation to the graph
   *
   * @param trueClasses A batch_size * num_true matrix, in which each row contains the
   * @param numTrue Number of true labels per context.
   * @param numSampled Number of candidates to randomly sample.
   * @param unique If unique is true, we sample with rejection, so that all sampled
   * @param rangeMax The sampler will sample integers from the interval [0, range_max).
   * @param options carries optional attributes values
   * @return a new instance of FixedUnigramCandidateSampler
   * @see org.tensorflow.op.core.FixedUnigramCandidateSampler
   */
  public FixedUnigramCandidateSampler fixedUnigramCandidateSampler(Operand<Long> trueClasses,
      Long numTrue, Long numSampled, Boolean unique, Long rangeMax,
      FixedUnigramCandidateSampler.Options... options) {
    return FixedUnigramCandidateSampler.create(scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
  }

  /**
   * Adds an {@link MapUnstageNoKey} operation to the graph
   *
   * @param indices 
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of MapUnstageNoKey
   * @see org.tensorflow.op.core.MapUnstageNoKey
   */
  public MapUnstageNoKey mapUnstageNoKey(Operand<Integer> indices, List<Class<?>> dtypes,
      MapUnstageNoKey.Options... options) {
    return MapUnstageNoKey.create(scope, indices, dtypes, options);
  }

  /**
   * Adds an {@link AddSparseToTensorsMap} operation to the graph
   *
   * @param sparseIndices 2-D.  The `indices` of the `SparseTensor`.
   * @param sparseValues 1-D.  The `values` of the `SparseTensor`.
   * @param sparseShape 1-D.  The `shape` of the `SparseTensor`.
   * @param options carries optional attributes values
   * @return a new instance of AddSparseToTensorsMap
   * @see org.tensorflow.op.core.AddSparseToTensorsMap
   */
  public <T> AddSparseToTensorsMap addSparseToTensorsMap(Operand<Long> sparseIndices,
      Operand<T> sparseValues, Operand<Long> sparseShape,
      AddSparseToTensorsMap.Options... options) {
    return AddSparseToTensorsMap.create(scope, sparseIndices, sparseValues, sparseShape, options);
  }

  /**
   * Adds an {@link LoadAndRemapMatrix} operation to the graph
   *
   * @param ckptPath Path to the TensorFlow checkpoint (version 2, `TensorBundle`) from
   * @param oldTensorName Name of the 2-D `Tensor` to load from checkpoint.
   * @param rowRemapping An int `Tensor` of row remappings (generally created by
   * @param colRemapping An int `Tensor` of column remappings (generally created by
   * @param initializingValues A float `Tensor` containing  values to fill in for cells
   * @param numRows Number of rows (length of the 1st dimension) in the output matrix.
   * @param numCols Number of columns (length of the 2nd dimension) in the output matrix.
   * @param options carries optional attributes values
   * @return a new instance of LoadAndRemapMatrix
   * @see org.tensorflow.op.core.LoadAndRemapMatrix
   */
  public LoadAndRemapMatrix loadAndRemapMatrix(Operand<String> ckptPath,
      Operand<String> oldTensorName, Operand<Long> rowRemapping, Operand<Long> colRemapping,
      Operand<Float> initializingValues, Long numRows, Long numCols,
      LoadAndRemapMatrix.Options... options) {
    return LoadAndRemapMatrix.create(scope, ckptPath, oldTensorName, rowRemapping, colRemapping, initializingValues, numRows, numCols, options);
  }

  /**
   * Adds an {@link ScatterNd} operation to the graph
   *
   * @param indices Index tensor.
   * @param updates Updates to scatter into output.
   * @param shape 1-D. The shape of the resulting tensor.
   * @return a new instance of ScatterNd
   * @see org.tensorflow.op.core.ScatterNd
   */
  public <U, T extends Number> ScatterNd<U> scatterNd(Operand<T> indices, Operand<U> updates,
      Operand<T> shape) {
    return ScatterNd.create(scope, indices, updates, shape);
  }

  /**
   * Adds an {@link TensorListSetItem} operation to the graph
   *
   * @param inputHandle 
   * @param index 
   * @param item 
   * @return a new instance of TensorListSetItem
   * @see org.tensorflow.op.core.TensorListSetItem
   */
  public <T> TensorListSetItem tensorListSetItem(Operand<?> inputHandle, Operand<Integer> index,
      Operand<T> item) {
    return TensorListSetItem.create(scope, inputHandle, index, item);
  }

  /**
   * Adds an {@link RefSwitch} operation to the graph
   *
   * @param data The ref tensor to be forwarded to the appropriate output.
   * @param pred A scalar that specifies which output port will receive data.
   * @return a new instance of RefSwitch
   * @see org.tensorflow.op.core.RefSwitch
   */
  public <T> RefSwitch<T> refSwitch(Operand<T> data, Operand<Boolean> pred) {
    return RefSwitch.create(scope, data, pred);
  }

  /**
   * Adds an {@link SdcaOptimizer} operation to the graph
   *
   * @param sparseExampleIndices a list of vectors which contain example indices.
   * @param sparseFeatureIndices a list of vectors which contain feature indices.
   * @param sparseFeatureValues a list of vectors which contains feature value
   * @param denseFeatures a list of matrices which contains the dense feature values.
   * @param exampleWeights a vector which contains the weight associated with each
   * @param exampleLabels a vector which contains the label/target associated with each
   * @param sparseIndices a list of vectors where each value is the indices which has
   * @param sparseWeights a list of vectors where each value is the weight associated with
   * @param denseWeights a list of vectors where the values are the weights associated
   * @param exampleStateData a list of vectors containing the example state data.
   * @param lossType Type of the primal loss. Currently SdcaSolver supports logistic,
   * @param l1 Symmetric l1 regularization strength.
   * @param l2 Symmetric l2 regularization strength.
   * @param numLossPartitions Number of partitions of the global loss function.
   * @param numInnerIterations Number of iterations per mini-batch.
   * @param options carries optional attributes values
   * @return a new instance of SdcaOptimizer
   * @see org.tensorflow.op.core.SdcaOptimizer
   */
  public SdcaOptimizer sdcaOptimizer(Iterable<Operand<Long>> sparseExampleIndices,
      Iterable<Operand<Long>> sparseFeatureIndices, Iterable<Operand<Float>> sparseFeatureValues,
      Iterable<Operand<Float>> denseFeatures, Operand<Float> exampleWeights,
      Operand<Float> exampleLabels, Iterable<Operand<Long>> sparseIndices,
      Iterable<Operand<Float>> sparseWeights, Iterable<Operand<Float>> denseWeights,
      Operand<Float> exampleStateData, String lossType, Float l1, Float l2, Long numLossPartitions,
      Long numInnerIterations, SdcaOptimizer.Options... options) {
    return SdcaOptimizer.create(scope, sparseExampleIndices, sparseFeatureIndices, sparseFeatureValues, denseFeatures, exampleWeights, exampleLabels, sparseIndices, sparseWeights, denseWeights, exampleStateData, lossType, l1, l2, numLossPartitions, numInnerIterations, options);
  }

  /**
   * Adds an {@link SparseFillEmptyRowsGrad} operation to the graph
   *
   * @param reverseIndexMap 1-D.  The reverse index map from SparseFillEmptyRows.
   * @param gradValues 1-D.  The gradients from backprop.
   * @return a new instance of SparseFillEmptyRowsGrad
   * @see org.tensorflow.op.core.SparseFillEmptyRowsGrad
   */
  public <T> SparseFillEmptyRowsGrad<T> sparseFillEmptyRowsGrad(Operand<Long> reverseIndexMap,
      Operand<T> gradValues) {
    return SparseFillEmptyRowsGrad.create(scope, reverseIndexMap, gradValues);
  }

  /**
   * Adds an {@link Identity} operation to the graph
   *
   * @param input 
   * @return a new instance of Identity
   * @see org.tensorflow.op.core.Identity
   */
  public <T> Identity<T> identity(Operand<T> input) {
    return Identity.create(scope, input);
  }

  /**
   * Adds an {@link Where3} operation to the graph
   *
   * @param condition 
   * @param x = A `Tensor` which may have the same shape as `condition`.
   * @param y = A `Tensor` with the same type and shape as `x`.
   * @return a new instance of Where3
   * @see org.tensorflow.op.core.Where3
   */
  public <T> Where3<T> where3(Operand<Boolean> condition, Operand<T> x, Operand<T> y) {
    return Where3.create(scope, condition, x, y);
  }

  /**
   * Adds an {@link ReaderReadUpTo} operation to the graph
   *
   * @param readerHandle Handle to a `Reader`.
   * @param queueHandle Handle to a `Queue`, with string work items.
   * @param numRecords number of records to read from `Reader`.
   * @return a new instance of ReaderReadUpTo
   * @see org.tensorflow.op.core.ReaderReadUpTo
   */
  public ReaderReadUpTo readerReadUpTo(Operand<?> readerHandle, Operand<?> queueHandle,
      Operand<Long> numRecords) {
    return ReaderReadUpTo.create(scope, readerHandle, queueHandle, numRecords);
  }

  /**
   * Adds an {@link LRN} operation to the graph
   *
   * @param input 4-D.
   * @param options carries optional attributes values
   * @return a new instance of LRN
   * @see org.tensorflow.op.core.LRN
   */
  public <T extends Number> LRN<T> lRN(Operand<T> input, LRN.Options... options) {
    return LRN.create(scope, input, options);
  }

  /**
   * Adds an {@link SerializeManySparse} operation to the graph
   *
   * @param sparseIndices 2-D.  The `indices` of the minibatch `SparseTensor`.
   * @param sparseValues 1-D.  The `values` of the minibatch `SparseTensor`.
   * @param sparseShape 1-D.  The `shape` of the minibatch `SparseTensor`.
   * @param outType The `dtype` to use for serialization; the supported types are `string`
   * @return a new instance of SerializeManySparse
   * @see org.tensorflow.op.core.SerializeManySparse
   */
  public <U, T> SerializeManySparse<U> serializeManySparse(Operand<Long> sparseIndices,
      Operand<T> sparseValues, Operand<Long> sparseShape, Class<U> outType) {
    return SerializeManySparse.create(scope, sparseIndices, sparseValues, sparseShape, outType);
  }

  /**
   * Adds an {@link AudioSpectrogram} operation to the graph
   *
   * @param input Float representation of audio data.
   * @param windowSize How wide the input window is in samples. For the highest efficiency
   * @param stride How widely apart the center of adjacent sample windows should be.
   * @param options carries optional attributes values
   * @return a new instance of AudioSpectrogram
   * @see org.tensorflow.op.core.AudioSpectrogram
   */
  public AudioSpectrogram audioSpectrogram(Operand<Float> input, Long windowSize, Long stride,
      AudioSpectrogram.Options... options) {
    return AudioSpectrogram.create(scope, input, windowSize, stride, options);
  }

  /**
   * Adds an {@link SparseApplyProximalAdagrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyProximalAdagrad
   * @see org.tensorflow.op.core.SparseApplyProximalAdagrad
   */
  public <T, U extends Number> SparseApplyProximalAdagrad<T> sparseApplyProximalAdagrad(Operand<T> var,
      Operand<T> accum, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> grad,
      Operand<U> indices, SparseApplyProximalAdagrad.Options... options) {
    return SparseApplyProximalAdagrad.create(scope, var, accum, lr, l1, l2, grad, indices, options);
  }

  /**
   * Adds an {@link QuantizedRelu6} operation to the graph
   *
   * @param features 
   * @param minFeatures The float value that the lowest quantized value represents.
   * @param maxFeatures The float value that the highest quantized value represents.
   * @param outType 
   * @return a new instance of QuantizedRelu6
   * @see org.tensorflow.op.core.QuantizedRelu6
   */
  public <U, T> QuantizedRelu6<U> quantizedRelu6(Operand<T> features, Operand<Float> minFeatures,
      Operand<Float> maxFeatures, Class<U> outType) {
    return QuantizedRelu6.create(scope, features, minFeatures, maxFeatures, outType);
  }

  /**
   * Adds an {@link Greater} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Greater
   * @see org.tensorflow.op.core.Greater
   */
  public <T extends Number> Greater greater(Operand<T> x, Operand<T> y) {
    return Greater.create(scope, x, y);
  }

  /**
   * Adds an {@link EncodeBase64} operation to the graph
   *
   * @param input Strings to be encoded.
   * @param options carries optional attributes values
   * @return a new instance of EncodeBase64
   * @see org.tensorflow.op.core.EncodeBase64
   */
  public EncodeBase64 encodeBase64(Operand<String> input, EncodeBase64.Options... options) {
    return EncodeBase64.create(scope, input, options);
  }

  /**
   * Adds an {@link Square} operation to the graph
   *
   * @param x 
   * @return a new instance of Square
   * @see org.tensorflow.op.core.Square
   */
  public <T> Square<T> square(Operand<T> x) {
    return Square.create(scope, x);
  }

  /**
   * Adds an {@link EncodeWav} operation to the graph
   *
   * @param audio 2-D with shape `[length, channels]`.
   * @param sampleRate Scalar containing the sample frequency.
   * @return a new instance of EncodeWav
   * @see org.tensorflow.op.core.EncodeWav
   */
  public EncodeWav encodeWav(Operand<Float> audio, Operand<Integer> sampleRate) {
    return EncodeWav.create(scope, audio, sampleRate);
  }

  /**
   * Adds an {@link ResourceApplyFtrlV2} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param linear Should be from a Variable().
   * @param grad The gradient.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regulariation. Must be a scalar.
   * @param l2 L2 shrinkage regulariation. Must be a scalar.
   * @param l2Shrinkage 
   * @param lrPower Scaling factor. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyFtrlV2
   * @see org.tensorflow.op.core.ResourceApplyFtrlV2
   */
  public <T> ResourceApplyFtrlV2 resourceApplyFtrlV2(Operand<?> var, Operand<?> accum,
      Operand<?> linear, Operand<T> grad, Operand<T> lr, Operand<T> l1, Operand<T> l2,
      Operand<T> l2Shrinkage, Operand<T> lrPower, ResourceApplyFtrlV2.Options... options) {
    return ResourceApplyFtrlV2.create(scope, var, accum, linear, grad, lr, l1, l2, l2Shrinkage, lrPower, options);
  }

  /**
   * Adds an {@link SparseToSparseSetOperation} operation to the graph
   *
   * @param set1Indices 2D `Tensor`, indices of a `SparseTensor`. Must be in row-major
   * @param set1Values 1D `Tensor`, values of a `SparseTensor`. Must be in row-major
   * @param set1Shape 1D `Tensor`, shape of a `SparseTensor`. `set1_shape[0...n-1]` must
   * @param set2Indices 2D `Tensor`, indices of a `SparseTensor`. Must be in row-major
   * @param set2Values 1D `Tensor`, values of a `SparseTensor`. Must be in row-major
   * @param set2Shape 1D `Tensor`, shape of a `SparseTensor`. `set2_shape[0...n-1]` must
   * @param setOperation 
   * @param options carries optional attributes values
   * @return a new instance of SparseToSparseSetOperation
   * @see org.tensorflow.op.core.SparseToSparseSetOperation
   */
  public <T> SparseToSparseSetOperation<T> sparseToSparseSetOperation(Operand<Long> set1Indices,
      Operand<T> set1Values, Operand<Long> set1Shape, Operand<Long> set2Indices,
      Operand<T> set2Values, Operand<Long> set2Shape, String setOperation,
      SparseToSparseSetOperation.Options... options) {
    return SparseToSparseSetOperation.create(scope, set1Indices, set1Values, set1Shape, set2Indices, set2Values, set2Shape, setOperation, options);
  }

  /**
   * Adds an {@link Timestamp} operation to the graph
   *
   * @return a new instance of Timestamp
   * @see org.tensorflow.op.core.Timestamp
   */
  public Timestamp timestamp() {
    return Timestamp.create(scope);
  }

  /**
   * Adds an {@link BatchMatrixSolveLs} operation to the graph
   *
   * @param matrix 
   * @param rhs 
   * @param l2Regularizer 
   * @param options carries optional attributes values
   * @return a new instance of BatchMatrixSolveLs
   * @see org.tensorflow.op.core.BatchMatrixSolveLs
   */
  public <T extends Number> BatchMatrixSolveLs<T> batchMatrixSolveLs(Operand<T> matrix,
      Operand<T> rhs, Operand<Double> l2Regularizer, BatchMatrixSolveLs.Options... options) {
    return BatchMatrixSolveLs.create(scope, matrix, rhs, l2Regularizer, options);
  }

  /**
   * Adds an {@link StatelessRandomUniform} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param seed 2 seeds (shape [2]).
   * @return a new instance of StatelessRandomUniform
   * @see org.tensorflow.op.core.StatelessRandomUniform
   */
  public <T extends Number, U extends Number> StatelessRandomUniform<Float> statelessRandomUniform(Operand<T> shape,
      Operand<U> seed) {
    return StatelessRandomUniform.create(scope, shape, seed);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Boolean> constant(boolean[][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link SparseAdd} operation to the graph
   *
   * @param aIndices 2-D.  The `indices` of the first `SparseTensor`, size `[nnz, ndims]` Matrix.
   * @param aValues 1-D.  The `values` of the first `SparseTensor`, size `[nnz]` Vector.
   * @param aShape 1-D.  The `shape` of the first `SparseTensor`, size `[ndims]` Vector.
   * @param bIndices 2-D.  The `indices` of the second `SparseTensor`, size `[nnz, ndims]` Matrix.
   * @param bValues 1-D.  The `values` of the second `SparseTensor`, size `[nnz]` Vector.
   * @param bShape 1-D.  The `shape` of the second `SparseTensor`, size `[ndims]` Vector.
   * @param thresh 0-D.  The magnitude threshold that determines if an output value/index
   * @return a new instance of SparseAdd
   * @see org.tensorflow.op.core.SparseAdd
   */
  public <T, U extends Number> SparseAdd<T> sparseAdd(Operand<Long> aIndices, Operand<T> aValues,
      Operand<Long> aShape, Operand<Long> bIndices, Operand<T> bValues, Operand<Long> bShape,
      Operand<U> thresh) {
    return SparseAdd.create(scope, aIndices, aValues, aShape, bIndices, bValues, bShape, thresh);
  }

  /**
   * Adds an {@link LinSpace} operation to the graph
   *
   * @param start 0-D tensor. First entry in the range.
   * @param stop 0-D tensor. Last entry in the range.
   * @param num 0-D tensor. Number of values to generate.
   * @return a new instance of LinSpace
   * @see org.tensorflow.op.core.LinSpace
   */
  public <T extends Number, U extends Number> LinSpace<T> linSpace(Operand<T> start,
      Operand<T> stop, Operand<U> num) {
    return LinSpace.create(scope, start, stop, num);
  }

  /**
   * Adds an {@link AddManySparseToTensorsMap} operation to the graph
   *
   * @param sparseIndices 2-D.  The `indices` of the minibatch `SparseTensor`.
   * @param sparseValues 1-D.  The `values` of the minibatch `SparseTensor`.
   * @param sparseShape 1-D.  The `shape` of the minibatch `SparseTensor`.
   * @param options carries optional attributes values
   * @return a new instance of AddManySparseToTensorsMap
   * @see org.tensorflow.op.core.AddManySparseToTensorsMap
   */
  public <T> AddManySparseToTensorsMap addManySparseToTensorsMap(Operand<Long> sparseIndices,
      Operand<T> sparseValues, Operand<Long> sparseShape,
      AddManySparseToTensorsMap.Options... options) {
    return AddManySparseToTensorsMap.create(scope, sparseIndices, sparseValues, sparseShape, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data The string to put into the new constant.
   * @return a string constant
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<String> constant(String data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link InplaceSub} operation to the graph
   *
   * @param x A `Tensor` of type T.
   * @param i A vector. Indices into the left-most dimension of `x`.
   * @param v A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
   * @return a new instance of InplaceSub
   * @see org.tensorflow.op.core.InplaceSub
   */
  public <T> InplaceSub<T> inplaceSub(Operand<T> x, Operand<Integer> i, Operand<T> v) {
    return InplaceSub.create(scope, x, i, v);
  }

  /**
   * Adds an {@link Cumsum} operation to the graph
   *
   * @param x A `Tensor`. Must be one of the following types: `float32`, `float64`,
   * @param axis A `Tensor` of type `int32` (default: 0). Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of Cumsum
   * @see org.tensorflow.op.core.Cumsum
   */
  public <T, U extends Number> Cumsum<T> cumsum(Operand<T> x, Operand<U> axis,
      Cumsum.Options... options) {
    return Cumsum.create(scope, x, axis, options);
  }

  /**
   * Adds an {@link StringToNumber} operation to the graph
   *
   * @param stringTensor 
   * @return a new instance of StringToNumber
   * @see org.tensorflow.op.core.StringToNumber
   */
  public StringToNumber<Float> stringToNumber(Operand<String> stringTensor) {
    return StringToNumber.create(scope, stringTensor);
  }

  /**
   * Adds an {@link DebugGradientIdentity} operation to the graph
   *
   * @param input 
   * @return a new instance of DebugGradientIdentity
   * @see org.tensorflow.op.core.DebugGradientIdentity
   */
  public <T> DebugGradientIdentity<T> debugGradientIdentity(Operand<T> input) {
    return DebugGradientIdentity.create(scope, input);
  }

  /**
   * Adds an {@link ApplyProximalGradientDescent} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param alpha Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param delta The change.
   * @param options carries optional attributes values
   * @return a new instance of ApplyProximalGradientDescent
   * @see org.tensorflow.op.core.ApplyProximalGradientDescent
   */
  public <T> ApplyProximalGradientDescent<T> applyProximalGradientDescent(Operand<T> var,
      Operand<T> alpha, Operand<T> l1, Operand<T> l2, Operand<T> delta,
      ApplyProximalGradientDescent.Options... options) {
    return ApplyProximalGradientDescent.create(scope, var, alpha, l1, l2, delta, options);
  }

  /**
   * Adds an {@link SdcaFprint} operation to the graph
   *
   * @param input vector of strings to compute fingerprints on.
   * @return a new instance of SdcaFprint
   * @see org.tensorflow.op.core.SdcaFprint
   */
  public SdcaFprint sdcaFprint(Operand<String> input) {
    return SdcaFprint.create(scope, input);
  }

  /**
   * Adds an {@link FFT} operation to the graph
   *
   * @param input A complex tensor.
   * @return a new instance of FFT
   * @see org.tensorflow.op.core.FFT
   */
  public <T> FFT<T> fFT(Operand<T> input) {
    return FFT.create(scope, input);
  }

  /**
   * Adds an {@link OptionalNone} operation to the graph
   *
   * @return a new instance of OptionalNone
   * @see org.tensorflow.op.core.OptionalNone
   */
  public OptionalNone optionalNone() {
    return OptionalNone.create(scope);
  }

  /**
   * Adds an {@link MapStage} operation to the graph
   *
   * @param key int64
   * @param indices 
   * @param values a list of tensors
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of MapStage
   * @see org.tensorflow.op.core.MapStage
   */
  public MapStage mapStage(Operand<Long> key, Operand<Integer> indices, Iterable<Operand<?>> values,
      List<Class<?>> dtypes, MapStage.Options... options) {
    return MapStage.create(scope, key, indices, values, dtypes, options);
  }

  /**
   * Adds an {@link SparseApplyProximalGradientDescent} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param alpha Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyProximalGradientDescent
   * @see org.tensorflow.op.core.SparseApplyProximalGradientDescent
   */
  public <T, U extends Number> SparseApplyProximalGradientDescent<T> sparseApplyProximalGradientDescent(Operand<T> var,
      Operand<T> alpha, Operand<T> l1, Operand<T> l2, Operand<T> grad, Operand<U> indices,
      SparseApplyProximalGradientDescent.Options... options) {
    return SparseApplyProximalGradientDescent.create(scope, var, alpha, l1, l2, grad, indices, options);
  }

  /**
   * Adds an {@link ImmutableConst} operation to the graph
   *
   * @param dtype Type of the returned tensor.
   * @param shape Shape of the returned tensor.
   * @param memoryRegionName Name of readonly memory region used by the tensor, see
   * @return a new instance of ImmutableConst
   * @see org.tensorflow.op.core.ImmutableConst
   */
  public <T> ImmutableConst<T> immutableConst(Class<T> dtype, Shape shape,
      String memoryRegionName) {
    return ImmutableConst.create(scope, dtype, shape, memoryRegionName);
  }

  /**
   * Adds an {@link ResizeNearestNeighbor} operation to the graph
   *
   * @param images 4-D with shape `[batch, height, width, channels]`.
   * @param size = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
   * @param options carries optional attributes values
   * @return a new instance of ResizeNearestNeighbor
   * @see org.tensorflow.op.core.ResizeNearestNeighbor
   */
  public <T extends Number> ResizeNearestNeighbor<T> resizeNearestNeighbor(Operand<T> images,
      Operand<Integer> size, ResizeNearestNeighbor.Options... options) {
    return ResizeNearestNeighbor.create(scope, images, size, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. String elements are
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<String> constant(byte[] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link Max} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of Max
   * @see org.tensorflow.op.core.Max
   */
  public <T, U extends Number> Max<T> max(Operand<T> input, Operand<U> axis,
      Max.Options... options) {
    return Max.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link SparseReduceMaxSparse} operation to the graph
   *
   * @param inputIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param inputValues 1-D.  `N` non-empty values corresponding to `input_indices`.
   * @param inputShape 1-D.  Shape of the input SparseTensor.
   * @param reductionAxes 1-D.  Length-`K` vector containing the reduction axes.
   * @param options carries optional attributes values
   * @return a new instance of SparseReduceMaxSparse
   * @see org.tensorflow.op.core.SparseReduceMaxSparse
   */
  public <T extends Number> SparseReduceMaxSparse<T> sparseReduceMaxSparse(Operand<Long> inputIndices,
      Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes,
      SparseReduceMaxSparse.Options... options) {
    return SparseReduceMaxSparse.create(scope, inputIndices, inputValues, inputShape, reductionAxes, options);
  }

  /**
   * Adds an {@link Size} operation to the graph
   *
   * @param input 
   * @param outType 
   * @return a new instance of Size
   * @see org.tensorflow.op.core.Size
   */
  public <U extends Number, T> Size<U> size(Operand<T> input, Class<U> outType) {
    return Size.create(scope, input, outType);
  }

  /**
   * Adds an {@link TensorArraySize} operation to the graph
   *
   * @param handle The handle to a TensorArray (output of TensorArray or TensorArrayGrad).
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @return a new instance of TensorArraySize
   * @see org.tensorflow.op.core.TensorArraySize
   */
  public TensorArraySize tensorArraySize(Operand<?> handle, Operand<Float> flowIn) {
    return TensorArraySize.create(scope, handle, flowIn);
  }

  /**
   * Adds an {@link TensorArrayWrite} operation to the graph
   *
   * @param handle The handle to a TensorArray.
   * @param index The position to write to inside the TensorArray.
   * @param value The tensor to write to the TensorArray.
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @return a new instance of TensorArrayWrite
   * @see org.tensorflow.op.core.TensorArrayWrite
   */
  public <T> TensorArrayWrite tensorArrayWrite(Operand<?> handle, Operand<Integer> index,
      Operand<T> value, Operand<Float> flowIn) {
    return TensorArrayWrite.create(scope, handle, index, value, flowIn);
  }

  /**
   * Adds an {@link Where} operation to the graph
   *
   * @param condition 
   * @return a new instance of Where
   * @see org.tensorflow.op.core.Where
   */
  public <T> Where where(Operand<T> condition) {
    return Where.create(scope, condition);
  }

  /**
   * Adds an {@link SparseSegmentSqrtNWithNumSegments} operation to the graph
   *
   * @param data 
   * @param indices A 1-D tensor. Has same rank as `segment_ids`.
   * @param segmentIds A 1-D tensor. Values should be sorted and can be repeated.
   * @param numSegments Should equal the number of distinct segment IDs.
   * @return a new instance of SparseSegmentSqrtNWithNumSegments
   * @see org.tensorflow.op.core.SparseSegmentSqrtNWithNumSegments
   */
  public <T extends Number, U extends Number, V extends Number> SparseSegmentSqrtNWithNumSegments<T> sparseSegmentSqrtNWithNumSegments(Operand<T> data,
      Operand<U> indices, Operand<Integer> segmentIds, Operand<V> numSegments) {
    return SparseSegmentSqrtNWithNumSegments.create(scope, data, indices, segmentIds, numSegments);
  }

  /**
   * Adds an {@link SplitV} operation to the graph
   *
   * @param value The tensor to split.
   * @param sizeSplits list containing the sizes of each output tensor along the split
   * @param axis 0-D.  The dimension along which to split.  Must be in the range
   * @param numSplit 
   * @return a new instance of SplitV
   * @see org.tensorflow.op.core.SplitV
   */
  public <T, U extends Number> SplitV<T> splitV(Operand<T> value, Operand<U> sizeSplits,
      Operand<Integer> axis, Long numSplit) {
    return SplitV.create(scope, value, sizeSplits, axis, numSplit);
  }

  /**
   * Adds an {@link TensorScatterUpdate} operation to the graph
   *
   * @param tensor Tensor to copy/update.
   * @param indices Index tensor.
   * @param updates Updates to scatter into output.
   * @return a new instance of TensorScatterUpdate
   * @see org.tensorflow.op.core.TensorScatterUpdate
   */
  public <T, U extends Number> TensorScatterUpdate<T> tensorScatterUpdate(Operand<T> tensor,
      Operand<U> indices, Operand<T> updates) {
    return TensorScatterUpdate.create(scope, tensor, indices, updates);
  }

  /**
   * Adds an {@link OrderedMapSize} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of OrderedMapSize
   * @see org.tensorflow.op.core.OrderedMapSize
   */
  public OrderedMapSize orderedMapSize(List<Class<?>> dtypes, OrderedMapSize.Options... options) {
    return OrderedMapSize.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link QueueSize} operation to the graph
   *
   * @param handle The handle to a queue.
   * @return a new instance of QueueSize
   * @see org.tensorflow.op.core.QueueSize
   */
  public QueueSize queueSize(Operand<?> handle) {
    return QueueSize.create(scope, handle);
  }

  /**
   * Adds an {@link DepthToSpace} operation to the graph
   *
   * @param input 
   * @param blockSize The size of the spatial block, same as in Space2Depth.
   * @param options carries optional attributes values
   * @return a new instance of DepthToSpace
   * @see org.tensorflow.op.core.DepthToSpace
   */
  public <T> DepthToSpace<T> depthToSpace(Operand<T> input, Long blockSize,
      DepthToSpace.Options... options) {
    return DepthToSpace.create(scope, input, blockSize, options);
  }

  /**
   * Adds an {@link DecodeBmp} operation to the graph
   *
   * @param contents 0-D.  The BMP-encoded image.
   * @param options carries optional attributes values
   * @return a new instance of DecodeBmp
   * @see org.tensorflow.op.core.DecodeBmp
   */
  public DecodeBmp decodeBmp(Operand<String> contents, DecodeBmp.Options... options) {
    return DecodeBmp.create(scope, contents, options);
  }

  /**
   * Adds an {@link Less} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Less
   * @see org.tensorflow.op.core.Less
   */
  public <T extends Number> Less less(Operand<T> x, Operand<T> y) {
    return Less.create(scope, x, y);
  }

  /**
   * Adds an {@link ResourceApplyAdam} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param m Should be from a Variable().
   * @param v Should be from a Variable().
   * @param beta1Power Must be a scalar.
   * @param beta2Power Must be a scalar.
   * @param lr Scaling factor. Must be a scalar.
   * @param beta1 Momentum factor. Must be a scalar.
   * @param beta2 Momentum factor. Must be a scalar.
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyAdam
   * @see org.tensorflow.op.core.ResourceApplyAdam
   */
  public <T> ResourceApplyAdam resourceApplyAdam(Operand<?> var, Operand<?> m, Operand<?> v,
      Operand<T> beta1Power, Operand<T> beta2Power, Operand<T> lr, Operand<T> beta1,
      Operand<T> beta2, Operand<T> epsilon, Operand<T> grad, ResourceApplyAdam.Options... options) {
    return ResourceApplyAdam.create(scope, var, m, v, beta1Power, beta2Power, lr, beta1, beta2, epsilon, grad, options);
  }

  /**
   * Adds an {@link Floor} operation to the graph
   *
   * @param x 
   * @return a new instance of Floor
   * @see org.tensorflow.op.core.Floor
   */
  public <T extends Number> Floor<T> floor(Operand<T> x) {
    return Floor.create(scope, x);
  }

  /**
   * Adds an {@link ResourceApplyMomentum} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param grad The gradient.
   * @param momentum Momentum. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyMomentum
   * @see org.tensorflow.op.core.ResourceApplyMomentum
   */
  public <T> ResourceApplyMomentum resourceApplyMomentum(Operand<?> var, Operand<?> accum,
      Operand<T> lr, Operand<T> grad, Operand<T> momentum,
      ResourceApplyMomentum.Options... options) {
    return ResourceApplyMomentum.create(scope, var, accum, lr, grad, momentum, options);
  }

  /**
   * Adds an {@link SparseReduceMax} operation to the graph
   *
   * @param inputIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param inputValues 1-D.  `N` non-empty values corresponding to `input_indices`.
   * @param inputShape 1-D.  Shape of the input SparseTensor.
   * @param reductionAxes 1-D.  Length-`K` vector containing the reduction axes.
   * @param options carries optional attributes values
   * @return a new instance of SparseReduceMax
   * @see org.tensorflow.op.core.SparseReduceMax
   */
  public <T extends Number> SparseReduceMax<T> sparseReduceMax(Operand<Long> inputIndices,
      Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes,
      SparseReduceMax.Options... options) {
    return SparseReduceMax.create(scope, inputIndices, inputValues, inputShape, reductionAxes, options);
  }

  /**
   * Adds an {@link Placeholder} operation to the graph
   *
   * @param dtype The type of elements in the tensor.
   * @param options carries optional attributes values
   * @return a new instance of Placeholder
   * @see org.tensorflow.op.core.Placeholder
   */
  public <T> Placeholder<T> placeholder(Class<T> dtype, Placeholder.Options... options) {
    return Placeholder.create(scope, dtype, options);
  }

  /**
   * Adds an {@link ReverseSequence} operation to the graph
   *
   * @param input The input to reverse.
   * @param seqLengths 1-D with length `input.dims(batch_dim)` and
   * @param seqDim The dimension which is partially reversed.
   * @param options carries optional attributes values
   * @return a new instance of ReverseSequence
   * @see org.tensorflow.op.core.ReverseSequence
   */
  public <T, U extends Number> ReverseSequence<T> reverseSequence(Operand<T> input,
      Operand<U> seqLengths, Long seqDim, ReverseSequence.Options... options) {
    return ReverseSequence.create(scope, input, seqLengths, seqDim, options);
  }

  /**
   * Adds an {@link FusedBatchNormV2} operation to the graph
   *
   * @param x A 4D Tensor for input data.
   * @param scale A 1D Tensor for scaling factor, to scale the normalized x.
   * @param offset A 1D Tensor for offset, to shift to the normalized x.
   * @param mean A 1D Tensor for population mean. Used for inference only;
   * @param variance A 1D Tensor for population variance. Used for inference only;
   * @param options carries optional attributes values
   * @return a new instance of FusedBatchNormV2
   * @see org.tensorflow.op.core.FusedBatchNormV2
   */
  public <T extends Number, U extends Number> FusedBatchNormV2<T, U> fusedBatchNormV2(Operand<T> x,
      Operand<U> scale, Operand<U> offset, Operand<U> mean, Operand<U> variance,
      FusedBatchNormV2.Options... options) {
    return FusedBatchNormV2.create(scope, x, scale, offset, mean, variance, options);
  }

  /**
   * Adds an {@link TensorListGather} operation to the graph
   *
   * @param inputHandle 
   * @param indices 
   * @param elementDtype 
   * @return a new instance of TensorListGather
   * @see org.tensorflow.op.core.TensorListGather
   */
  public <T> TensorListGather<T> tensorListGather(Operand<?> inputHandle, Operand<Integer> indices,
      Class<T> elementDtype) {
    return TensorListGather.create(scope, inputHandle, indices, elementDtype);
  }

  /**
   * Adds an {@link MaxPool3DGrad} operation to the graph
   *
   * @param origInput The original input tensor.
   * @param origOutput The original output tensor.
   * @param grad Output backprop of shape `[batch, depth, rows, cols, channels]`.
   * @param ksize 1-D tensor of length 5. The size of the window for each dimension of
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of MaxPool3DGrad
   * @see org.tensorflow.op.core.MaxPool3DGrad
   */
  public <U extends Number, T extends Number> MaxPool3DGrad<U> maxPool3DGrad(Operand<T> origInput,
      Operand<T> origOutput, Operand<U> grad, List<Long> ksize, List<Long> strides, String padding,
      MaxPool3DGrad.Options... options) {
    return MaxPool3DGrad.create(scope, origInput, origOutput, grad, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link DecodeCSV} operation to the graph
   *
   * @param records Each string is a record/row in the csv and all records should have
   * @param recordDefaults One tensor per column of the input record, with either a
   * @param options carries optional attributes values
   * @return a new instance of DecodeCSV
   * @see org.tensorflow.op.core.DecodeCSV
   */
  public DecodeCSV decodeCSV(Operand<String> records, Iterable<Operand<?>> recordDefaults,
      DecodeCSV.Options... options) {
    return DecodeCSV.create(scope, records, recordDefaults, options);
  }

  /**
   * Adds an {@link ResourceCountUpTo} operation to the graph
   *
   * @param resource Should be from a scalar `Variable` node.
   * @param limit If incrementing ref would bring it above limit, instead generates an
   * @param T 
   * @return a new instance of ResourceCountUpTo
   * @see org.tensorflow.op.core.ResourceCountUpTo
   */
  public <T extends Number> ResourceCountUpTo<T> resourceCountUpTo(Operand<?> resource, Long limit,
      Class<T> T) {
    return ResourceCountUpTo.create(scope, resource, limit, T);
  }

  /**
   * Adds an {@link Tile} operation to the graph
   *
   * @param input 1-D or higher.
   * @param multiples 1-D. Length must be the same as the number of dimensions in `input`
   * @return a new instance of Tile
   * @see org.tensorflow.op.core.Tile
   */
  public <T, U extends Number> Tile<T> tile(Operand<T> input, Operand<U> multiples) {
    return Tile.create(scope, input, multiples);
  }

  /**
   * Adds an {@link Cholesky} operation to the graph
   *
   * @param input Shape is `[..., M, M]`.
   * @return a new instance of Cholesky
   * @see org.tensorflow.op.core.Cholesky
   */
  public <T> Cholesky<T> cholesky(Operand<T> input) {
    return Cholesky.create(scope, input);
  }

  /**
   * Adds an {@link Conv3DBackpropInputV2} operation to the graph
   *
   * @param inputSizes An integer vector representing the tensor shape of `input`,
   * @param filter Shape `[depth, rows, cols, in_channels, out_channels]`.
   * @param outBackprop Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of Conv3DBackpropInputV2
   * @see org.tensorflow.op.core.Conv3DBackpropInputV2
   */
  public <U extends Number, T extends Number> Conv3DBackpropInputV2<U> conv3DBackpropInputV2(Operand<T> inputSizes,
      Operand<U> filter, Operand<U> outBackprop, List<Long> strides, String padding,
      Conv3DBackpropInputV2.Options... options) {
    return Conv3DBackpropInputV2.create(scope, inputSizes, filter, outBackprop, strides, padding, options);
  }

  /**
   * Adds an {@link SparseAddGrad} operation to the graph
   *
   * @param backpropValGrad 1-D with shape `[nnz(sum)]`.  The gradient with respect to
   * @param aIndices 2-D.  The `indices` of the `SparseTensor` A, size `[nnz(A), ndims]`.
   * @param bIndices 2-D.  The `indices` of the `SparseTensor` B, size `[nnz(B), ndims]`.
   * @param sumIndices 2-D.  The `indices` of the sum `SparseTensor`, size
   * @return a new instance of SparseAddGrad
   * @see org.tensorflow.op.core.SparseAddGrad
   */
  public <T> SparseAddGrad<T> sparseAddGrad(Operand<T> backpropValGrad, Operand<Long> aIndices,
      Operand<Long> bIndices, Operand<Long> sumIndices) {
    return SparseAddGrad.create(scope, backpropValGrad, aIndices, bIndices, sumIndices);
  }

  /**
   * Adds an {@link Rank} operation to the graph
   *
   * @param input 
   * @return a new instance of Rank
   * @see org.tensorflow.op.core.Rank
   */
  public <T> Rank rank(Operand<T> input) {
    return Rank.create(scope, input);
  }

  /**
   * Adds an {@link Negate} operation to the graph
   *
   * @param x 
   * @return a new instance of Negate
   * @see org.tensorflow.op.core.Negate
   */
  public <T> Negate<T> negate(Operand<T> x) {
    return Negate.create(scope, x);
  }

  /**
   * Adds an {@link QueueEnqueueMany} operation to the graph
   *
   * @param handle The handle to a queue.
   * @param components One or more tensors from which the enqueued tensors should
   * @param options carries optional attributes values
   * @return a new instance of QueueEnqueueMany
   * @see org.tensorflow.op.core.QueueEnqueueMany
   */
  public QueueEnqueueMany queueEnqueueMany(Operand<?> handle, Iterable<Operand<?>> components,
      QueueEnqueueMany.Options... options) {
    return QueueEnqueueMany.create(scope, handle, components, options);
  }

  /**
   * Adds an {@link Multinomial} operation to the graph
   *
   * @param logits 2-D Tensor with shape `[batch_size, num_classes]`.  Each slice `[i, :]`
   * @param numSamples 0-D.  Number of independent samples to draw for each row slice.
   * @param options carries optional attributes values
   * @return a new instance of Multinomial
   * @see org.tensorflow.op.core.Multinomial
   */
  public <T extends Number> Multinomial<Long> multinomial(Operand<T> logits,
      Operand<Integer> numSamples, Multinomial.Options... options) {
    return Multinomial.create(scope, logits, numSamples, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param charset The encoding from String to bytes.
   * @param data The string to put into the new constant.
   * @return a string constant
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<String> constant(String data, Charset charset) {
    return Constant.create(scope, data, charset);
  }

  /**
   * Adds an {@link SpaceToDepth} operation to the graph
   *
   * @param input 
   * @param blockSize The size of the spatial block.
   * @param options carries optional attributes values
   * @return a new instance of SpaceToDepth
   * @see org.tensorflow.op.core.SpaceToDepth
   */
  public <T> SpaceToDepth<T> spaceToDepth(Operand<T> input, Long blockSize,
      SpaceToDepth.Options... options) {
    return SpaceToDepth.create(scope, input, blockSize, options);
  }

  /**
   * Adds an {@link MapSize} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of MapSize
   * @see org.tensorflow.op.core.MapSize
   */
  public MapSize mapSize(List<Class<?>> dtypes, MapSize.Options... options) {
    return MapSize.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Integer> constant(int[][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link OrderedMapIncompleteSize} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of OrderedMapIncompleteSize
   * @see org.tensorflow.op.core.OrderedMapIncompleteSize
   */
  public OrderedMapIncompleteSize orderedMapIncompleteSize(List<Class<?>> dtypes,
      OrderedMapIncompleteSize.Options... options) {
    return OrderedMapIncompleteSize.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link SparseApplyCenteredRMSProp} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param mg Should be from a Variable().
   * @param ms Should be from a Variable().
   * @param mom Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay rate. Must be a scalar.
   * @param momentum 
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var, ms and mom.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyCenteredRMSProp
   * @see org.tensorflow.op.core.SparseApplyCenteredRMSProp
   */
  public <T, U extends Number> SparseApplyCenteredRMSProp<T> sparseApplyCenteredRMSProp(Operand<T> var,
      Operand<T> mg, Operand<T> ms, Operand<T> mom, Operand<T> lr, Operand<T> rho,
      Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, Operand<U> indices,
      SparseApplyCenteredRMSProp.Options... options) {
    return SparseApplyCenteredRMSProp.create(scope, var, mg, ms, mom, lr, rho, momentum, epsilon, grad, indices, options);
  }

  /**
   * Adds an {@link RandomUniform} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param dtype The type of the output.
   * @param options carries optional attributes values
   * @return a new instance of RandomUniform
   * @see org.tensorflow.op.core.RandomUniform
   */
  public <U extends Number, T extends Number> RandomUniform<U> randomUniform(Operand<T> shape,
      Class<U> dtype, RandomUniform.Options... options) {
    return RandomUniform.create(scope, shape, dtype, options);
  }

  /**
   * Adds an {@link ResourceSparseApplyRMSProp} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param ms Should be from a Variable().
   * @param mom Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay rate. Must be a scalar.
   * @param momentum 
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var, ms and mom.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyRMSProp
   * @see org.tensorflow.op.core.ResourceSparseApplyRMSProp
   */
  public <T, U extends Number> ResourceSparseApplyRMSProp resourceSparseApplyRMSProp(Operand<?> var,
      Operand<?> ms, Operand<?> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum,
      Operand<T> epsilon, Operand<T> grad, Operand<U> indices,
      ResourceSparseApplyRMSProp.Options... options) {
    return ResourceSparseApplyRMSProp.create(scope, var, ms, mom, lr, rho, momentum, epsilon, grad, indices, options);
  }

  /**
   * Adds an {@link IsVariableInitialized} operation to the graph
   *
   * @param ref Should be from a `Variable` node. May be uninitialized.
   * @return a new instance of IsVariableInitialized
   * @see org.tensorflow.op.core.IsVariableInitialized
   */
  public <T> IsVariableInitialized isVariableInitialized(Operand<T> ref) {
    return IsVariableInitialized.create(scope, ref);
  }

  /**
   * Adds an {@link UnsortedSegmentMin} operation to the graph
   *
   * @param data 
   * @param segmentIds A tensor whose shape is a prefix of `data.shape`.
   * @param numSegments 
   * @return a new instance of UnsortedSegmentMin
   * @see org.tensorflow.op.core.UnsortedSegmentMin
   */
  public <T extends Number, U extends Number, V extends Number> UnsortedSegmentMin<T> unsortedSegmentMin(Operand<T> data,
      Operand<U> segmentIds, Operand<V> numSegments) {
    return UnsortedSegmentMin.create(scope, data, segmentIds, numSegments);
  }

  /**
   * Adds an {@link Igamma} operation to the graph
   *
   * @param a 
   * @param x 
   * @return a new instance of Igamma
   * @see org.tensorflow.op.core.Igamma
   */
  public <T extends Number> Igamma<T> igamma(Operand<T> a, Operand<T> x) {
    return Igamma.create(scope, a, x);
  }

  /**
   * Adds an {@link RFFT} operation to the graph
   *
   * @param input A float32 tensor.
   * @param fftLength An int32 tensor of shape [1]. The FFT length.
   * @return a new instance of RFFT
   * @see org.tensorflow.op.core.RFFT
   */
  public RFFT rFFT(Operand<Float> input, Operand<Integer> fftLength) {
    return RFFT.create(scope, input, fftLength);
  }

  /**
   * Adds an {@link VarHandleOp} operation to the graph
   *
   * @param dtype the type of this variable. Must agree with the dtypes
   * @param shape The (possibly partially specified) shape of this variable.
   * @param options carries optional attributes values
   * @return a new instance of VarHandleOp
   * @see org.tensorflow.op.core.VarHandleOp
   */
  public <T> VarHandleOp varHandleOp(Class<T> dtype, Shape shape, VarHandleOp.Options... options) {
    return VarHandleOp.create(scope, dtype, shape, options);
  }

  /**
   * Adds an {@link QueueDequeue} operation to the graph
   *
   * @param handle The handle to a queue.
   * @param componentTypes The type of each component in a tuple.
   * @param options carries optional attributes values
   * @return a new instance of QueueDequeue
   * @see org.tensorflow.op.core.QueueDequeue
   */
  public QueueDequeue queueDequeue(Operand<?> handle, List<Class<?>> componentTypes,
      QueueDequeue.Options... options) {
    return QueueDequeue.create(scope, handle, componentTypes, options);
  }

  /**
   * Adds an {@link PopulationCount} operation to the graph
   *
   * @param x 
   * @return a new instance of PopulationCount
   * @see org.tensorflow.op.core.PopulationCount
   */
  public <T extends Number> PopulationCount populationCount(Operand<T> x) {
    return PopulationCount.create(scope, x);
  }

  /**
   * Adds an {@link ResourceApplyAdamWithAmsgrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param m Should be from a Variable().
   * @param v Should be from a Variable().
   * @param vhat Should be from a Variable().
   * @param beta1Power Must be a scalar.
   * @param beta2Power Must be a scalar.
   * @param lr Scaling factor. Must be a scalar.
   * @param beta1 Momentum factor. Must be a scalar.
   * @param beta2 Momentum factor. Must be a scalar.
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyAdamWithAmsgrad
   * @see org.tensorflow.op.core.ResourceApplyAdamWithAmsgrad
   */
  public <T> ResourceApplyAdamWithAmsgrad resourceApplyAdamWithAmsgrad(Operand<?> var, Operand<?> m,
      Operand<?> v, Operand<?> vhat, Operand<T> beta1Power, Operand<T> beta2Power, Operand<T> lr,
      Operand<T> beta1, Operand<T> beta2, Operand<T> epsilon, Operand<T> grad,
      ResourceApplyAdamWithAmsgrad.Options... options) {
    return ResourceApplyAdamWithAmsgrad.create(scope, var, m, v, vhat, beta1Power, beta2Power, lr, beta1, beta2, epsilon, grad, options);
  }

  /**
   * Adds an {@link ParseSequenceExample} operation to the graph
   *
   * @param serialized A vector containing binary serialized SequenceExample protos.
   * @param debugName A vector containing the names of the serialized protos.
   * @param contextDenseDefaults A list of Ncontext_dense Tensors (some may be empty).
   * @param featureListDenseMissingAssumedEmpty A vector listing the
   * @param contextSparseKeys A list of Ncontext_sparse string Tensors (scalars).
   * @param contextDenseKeys A list of Ncontext_dense string Tensors (scalars).
   * @param featureListSparseKeys A list of Nfeature_list_sparse string Tensors
   * @param featureListDenseKeys A list of Nfeature_list_dense string Tensors (scalars).
   * @param contextSparseTypes A list of Ncontext_sparse types; the data types of data in
   * @param featureListDenseTypes 
   * @param featureListSparseTypes A list of Nfeature_list_sparse types; the data types
   * @param options carries optional attributes values
   * @return a new instance of ParseSequenceExample
   * @see org.tensorflow.op.core.ParseSequenceExample
   */
  public ParseSequenceExample parseSequenceExample(Operand<String> serialized,
      Operand<String> debugName, Iterable<Operand<?>> contextDenseDefaults,
      List<String> featureListDenseMissingAssumedEmpty, List<String> contextSparseKeys,
      List<String> contextDenseKeys, List<String> featureListSparseKeys,
      List<String> featureListDenseKeys, List<Class<?>> contextSparseTypes,
      List<Class<?>> featureListDenseTypes, List<Class<?>> featureListSparseTypes,
      ParseSequenceExample.Options... options) {
    return ParseSequenceExample.create(scope, serialized, debugName, contextDenseDefaults, featureListDenseMissingAssumedEmpty, contextSparseKeys, contextDenseKeys, featureListSparseKeys, featureListDenseKeys, contextSparseTypes, featureListDenseTypes, featureListSparseTypes, options);
  }

  /**
   * Adds an {@link Multinomial} operation to the graph
   *
   * @param logits 2-D Tensor with shape `[batch_size, num_classes]`.  Each slice `[i, :]`
   * @param numSamples 0-D.  Number of independent samples to draw for each row slice.
   * @param outputDtype 
   * @param options carries optional attributes values
   * @return a new instance of Multinomial
   * @see org.tensorflow.op.core.Multinomial
   */
  public <U extends Number, T extends Number> Multinomial<U> multinomial(Operand<T> logits,
      Operand<Integer> numSamples, Class<U> outputDtype, Multinomial.Options... options) {
    return Multinomial.create(scope, logits, numSamples, outputDtype, options);
  }

  /**
   * Adds an {@link TensorListStack} operation to the graph
   *
   * @param inputHandle 
   * @param elementDtype 
   * @param options carries optional attributes values
   * @return a new instance of TensorListStack
   * @see org.tensorflow.op.core.TensorListStack
   */
  public <T> TensorListStack<T> tensorListStack(Operand<?> inputHandle, Class<T> elementDtype,
      TensorListStack.Options... options) {
    return TensorListStack.create(scope, inputHandle, elementDtype, options);
  }

  /**
   * Adds an {@link TensorListFromTensor} operation to the graph
   *
   * @param tensor 
   * @param elementShape 
   * @return a new instance of TensorListFromTensor
   * @see org.tensorflow.op.core.TensorListFromTensor
   */
  public <T, U extends Number> TensorListFromTensor tensorListFromTensor(Operand<T> tensor,
      Operand<U> elementShape) {
    return TensorListFromTensor.create(scope, tensor, elementShape);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Long> constant(long[][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ScatterSub} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to subtract from `ref`.
   * @param options carries optional attributes values
   * @return a new instance of ScatterSub
   * @see org.tensorflow.op.core.ScatterSub
   */
  public <T, U extends Number> ScatterSub<T> scatterSub(Operand<T> ref, Operand<U> indices,
      Operand<T> updates, ScatterSub.Options... options) {
    return ScatterSub.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link Rint} operation to the graph
   *
   * @param x 
   * @return a new instance of Rint
   * @see org.tensorflow.op.core.Rint
   */
  public <T extends Number> Rint<T> rint(Operand<T> x) {
    return Rint.create(scope, x);
  }

  /**
   * Adds an {@link QuantizedAdd} operation to the graph
   *
   * @param x 
   * @param y 
   * @param minX The float value that the lowest quantized `x` value represents.
   * @param maxX The float value that the highest quantized `x` value represents.
   * @param minY The float value that the lowest quantized `y` value represents.
   * @param maxY The float value that the highest quantized `y` value represents.
   * @param Toutput 
   * @return a new instance of QuantizedAdd
   * @see org.tensorflow.op.core.QuantizedAdd
   */
  public <V, T, U> QuantizedAdd<V> quantizedAdd(Operand<T> x, Operand<U> y, Operand<Float> minX,
      Operand<Float> maxX, Operand<Float> minY, Operand<Float> maxY, Class<V> Toutput) {
    return QuantizedAdd.create(scope, x, y, minX, maxX, minY, maxY, Toutput);
  }

  /**
   * Adds an {@link StopGradient} operation to the graph
   *
   * @param input 
   * @return a new instance of StopGradient
   * @see org.tensorflow.op.core.StopGradient
   */
  public <T> StopGradient<T> stopGradient(Operand<T> input) {
    return StopGradient.create(scope, input);
  }

  /**
   * Adds an {@link AssignSub} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param value The value to be subtracted to the variable.
   * @param options carries optional attributes values
   * @return a new instance of AssignSub
   * @see org.tensorflow.op.core.AssignSub
   */
  public <T> AssignSub<T> assignSub(Operand<T> ref, Operand<T> value,
      AssignSub.Options... options) {
    return AssignSub.create(scope, ref, value, options);
  }

  /**
   * Adds an {@link AvgPool3D} operation to the graph
   *
   * @param input Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
   * @param ksize 1-D tensor of length 5. The size of the window for each dimension of
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of AvgPool3D
   * @see org.tensorflow.op.core.AvgPool3D
   */
  public <T extends Number> AvgPool3D<T> avgPool3D(Operand<T> input, List<Long> ksize,
      List<Long> strides, String padding, AvgPool3D.Options... options) {
    return AvgPool3D.create(scope, input, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link InTopK} operation to the graph
   *
   * @param predictions A `batch_size` x `classes` tensor.
   * @param targets A `batch_size` vector of class ids.
   * @param k Number of top elements to look at for computing precision.
   * @return a new instance of InTopK
   * @see org.tensorflow.op.core.InTopK
   */
  public <T extends Number> InTopK inTopK(Operand<Float> predictions, Operand<T> targets, Long k) {
    return InTopK.create(scope, predictions, targets, k);
  }

  /**
   * Adds an {@link Restore} operation to the graph
   *
   * @param filePattern Must have a single element. The pattern of the files from
   * @param tensorName Must have a single element. The name of the tensor to be
   * @param dt The type of the tensor to be restored.
   * @param options carries optional attributes values
   * @return a new instance of Restore
   * @see org.tensorflow.op.core.Restore
   */
  public <T> Restore<T> restore(Operand<String> filePattern, Operand<String> tensorName,
      Class<T> dt, Restore.Options... options) {
    return Restore.create(scope, filePattern, tensorName, dt, options);
  }

  /**
   * Adds an {@link MatrixTriangularSolve} operation to the graph
   *
   * @param matrix Shape is `[..., M, M]`.
   * @param rhs Shape is `[..., M, K]`.
   * @param options carries optional attributes values
   * @return a new instance of MatrixTriangularSolve
   * @see org.tensorflow.op.core.MatrixTriangularSolve
   */
  public <T> MatrixTriangularSolve<T> matrixTriangularSolve(Operand<T> matrix, Operand<T> rhs,
      MatrixTriangularSolve.Options... options) {
    return MatrixTriangularSolve.create(scope, matrix, rhs, options);
  }

  /**
   * Adds an {@link BatchSelfAdjointEig} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchSelfAdjointEig
   * @see org.tensorflow.op.core.BatchSelfAdjointEig
   */
  public <T extends Number> BatchSelfAdjointEig<T> batchSelfAdjointEig(Operand<T> input) {
    return BatchSelfAdjointEig.create(scope, input);
  }

  /**
   * Adds an {@link MatrixDiag} operation to the graph
   *
   * @param diagonal Rank `k`, where `k >= 1`.
   * @return a new instance of MatrixDiag
   * @see org.tensorflow.op.core.MatrixDiag
   */
  public <T> MatrixDiag<T> matrixDiag(Operand<T> diagonal) {
    return MatrixDiag.create(scope, diagonal);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Boolean> constant(boolean[][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link AudioSummary} operation to the graph
   *
   * @param tag Scalar. Used to build the `tag` attribute of the summary values.
   * @param tensor 2-D of shape `[batch_size, frames]`.
   * @param sampleRate The sample rate of the signal in hertz.
   * @param options carries optional attributes values
   * @return a new instance of AudioSummary
   * @see org.tensorflow.op.core.AudioSummary
   */
  public AudioSummary audioSummary(Operand<String> tag, Operand<Float> tensor,
      Operand<Float> sampleRate, AudioSummary.Options... options) {
    return AudioSummary.create(scope, tag, tensor, sampleRate, options);
  }

  /**
   * Adds an {@link AllCandidateSampler} operation to the graph
   *
   * @param trueClasses A batch_size * num_true matrix, in which each row contains the
   * @param numTrue Number of true labels per context.
   * @param numSampled Number of candidates to produce.
   * @param unique If unique is true, we sample with rejection, so that all sampled
   * @param options carries optional attributes values
   * @return a new instance of AllCandidateSampler
   * @see org.tensorflow.op.core.AllCandidateSampler
   */
  public AllCandidateSampler allCandidateSampler(Operand<Long> trueClasses, Long numTrue,
      Long numSampled, Boolean unique, AllCandidateSampler.Options... options) {
    return AllCandidateSampler.create(scope, trueClasses, numTrue, numSampled, unique, options);
  }

  /**
   * Adds an {@link ExtractVolumePatches} operation to the graph
   *
   * @param input 5-D Tensor with shape `[batch, in_planes, in_rows, in_cols, depth]`.
   * @param ksizes The size of the sliding window for each dimension of `input`.
   * @param strides 1-D of length 5. How far the centers of two consecutive patches are in
   * @param padding The type of padding algorithm to use.
   * @return a new instance of ExtractVolumePatches
   * @see org.tensorflow.op.core.ExtractVolumePatches
   */
  public <T extends Number> ExtractVolumePatches<T> extractVolumePatches(Operand<T> input,
      List<Long> ksizes, List<Long> strides, String padding) {
    return ExtractVolumePatches.create(scope, input, ksizes, strides, padding);
  }

  /**
   * Adds an {@link DecodePng} operation to the graph
   *
   * @param contents 0-D.  The PNG-encoded image.
   * @param dtype 
   * @param options carries optional attributes values
   * @return a new instance of DecodePng
   * @see org.tensorflow.op.core.DecodePng
   */
  public <T extends Number> DecodePng<T> decodePng(Operand<String> contents, Class<T> dtype,
      DecodePng.Options... options) {
    return DecodePng.create(scope, contents, dtype, options);
  }

  /**
   * Adds an {@link ApplyPowerSign} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param m Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param logbase Must be a scalar.
   * @param signDecay Must be a scalar.
   * @param beta Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ApplyPowerSign
   * @see org.tensorflow.op.core.ApplyPowerSign
   */
  public <T> ApplyPowerSign<T> applyPowerSign(Operand<T> var, Operand<T> m, Operand<T> lr,
      Operand<T> logbase, Operand<T> signDecay, Operand<T> beta, Operand<T> grad,
      ApplyPowerSign.Options... options) {
    return ApplyPowerSign.create(scope, var, m, lr, logbase, signDecay, beta, grad, options);
  }

  /**
   * Adds an {@link DecodePng} operation to the graph
   *
   * @param contents 0-D.  The PNG-encoded image.
   * @param options carries optional attributes values
   * @return a new instance of DecodePng
   * @see org.tensorflow.op.core.DecodePng
   */
  public DecodePng<UInt8> decodePng(Operand<String> contents, DecodePng.Options... options) {
    return DecodePng.create(scope, contents, options);
  }

  /**
   * Adds an {@link VariableShape} operation to the graph
   *
   * @param input 
   * @param outType 
   * @return a new instance of VariableShape
   * @see org.tensorflow.op.core.VariableShape
   */
  public <T extends Number> VariableShape<T> variableShape(Operand<?> input, Class<T> outType) {
    return VariableShape.create(scope, input, outType);
  }

  /**
   * Adds an {@link ExtractImagePatches} operation to the graph
   *
   * @param images 4-D Tensor with shape `[batch, in_rows, in_cols, depth]`.
   * @param ksizes The size of the sliding window for each dimension of `images`.
   * @param strides 1-D of length 4. How far the centers of two consecutive patches are in
   * @param rates 1-D of length 4. Must be: `[1, rate_rows, rate_cols, 1]`. This is the
   * @param padding The type of padding algorithm to use.
   * @return a new instance of ExtractImagePatches
   * @see org.tensorflow.op.core.ExtractImagePatches
   */
  public <T extends Number> ExtractImagePatches<T> extractImagePatches(Operand<T> images,
      List<Long> ksizes, List<Long> strides, List<Long> rates, String padding) {
    return ExtractImagePatches.create(scope, images, ksizes, strides, rates, padding);
  }

  /**
   * Adds an {@link QuantizeDownAndShrinkRange} operation to the graph
   *
   * @param input 
   * @param inputMin The float value that the minimum quantized input value represents.
   * @param inputMax The float value that the maximum quantized input value represents.
   * @param outType The type of the output. Should be a lower bit depth than Tinput.
   * @return a new instance of QuantizeDownAndShrinkRange
   * @see org.tensorflow.op.core.QuantizeDownAndShrinkRange
   */
  public <U, T> QuantizeDownAndShrinkRange<U> quantizeDownAndShrinkRange(Operand<T> input,
      Operand<Float> inputMin, Operand<Float> inputMax, Class<U> outType) {
    return QuantizeDownAndShrinkRange.create(scope, input, inputMin, inputMax, outType);
  }

  /**
   * Adds an {@link DecodeJSONExample} operation to the graph
   *
   * @param jsonExamples Each string is a JSON object serialized according to the JSON
   * @return a new instance of DecodeJSONExample
   * @see org.tensorflow.op.core.DecodeJSONExample
   */
  public DecodeJSONExample decodeJSONExample(Operand<String> jsonExamples) {
    return DecodeJSONExample.create(scope, jsonExamples);
  }

  /**
   * Adds an {@link Bincount} operation to the graph
   *
   * @param arr int32 `Tensor`.
   * @param size non-negative int32 scalar `Tensor`.
   * @param weights is an int32, int64, float32, or float64 `Tensor` with the same
   * @return a new instance of Bincount
   * @see org.tensorflow.op.core.Bincount
   */
  public <T extends Number> Bincount<T> bincount(Operand<Integer> arr, Operand<Integer> size,
      Operand<T> weights) {
    return Bincount.create(scope, arr, size, weights);
  }

  /**
   * Adds an {@link MatrixBandPart} operation to the graph
   *
   * @param input Rank `k` tensor.
   * @param numLower 0-D tensor. Number of subdiagonals to keep. If negative, keep entire
   * @param numUpper 0-D tensor. Number of superdiagonals to keep. If negative, keep
   * @return a new instance of MatrixBandPart
   * @see org.tensorflow.op.core.MatrixBandPart
   */
  public <T, U extends Number> MatrixBandPart<T> matrixBandPart(Operand<T> input,
      Operand<U> numLower, Operand<U> numUpper) {
    return MatrixBandPart.create(scope, input, numLower, numUpper);
  }

  /**
   * Adds an {@link QuantizedBatchNormWithGlobalNormalization} operation to the graph
   *
   * @param t A 4D input Tensor.
   * @param tMin The value represented by the lowest quantized input.
   * @param tMax The value represented by the highest quantized input.
   * @param m A 1D mean Tensor with size matching the last dimension of t.
   * @param mMin The value represented by the lowest quantized mean.
   * @param mMax The value represented by the highest quantized mean.
   * @param v A 1D variance Tensor with size matching the last dimension of t.
   * @param vMin The value represented by the lowest quantized variance.
   * @param vMax The value represented by the highest quantized variance.
   * @param beta A 1D beta Tensor with size matching the last dimension of t.
   * @param betaMin The value represented by the lowest quantized offset.
   * @param betaMax The value represented by the highest quantized offset.
   * @param gamma A 1D gamma Tensor with size matching the last dimension of t.
   * @param gammaMin The value represented by the lowest quantized gamma.
   * @param gammaMax The value represented by the highest quantized gamma.
   * @param outType 
   * @param varianceEpsilon A small float number to avoid dividing by 0.
   * @param scaleAfterNormalization A bool indicating whether the resulted tensor
   * @return a new instance of QuantizedBatchNormWithGlobalNormalization
   * @see org.tensorflow.op.core.QuantizedBatchNormWithGlobalNormalization
   */
  public <U, T> QuantizedBatchNormWithGlobalNormalization<U> quantizedBatchNormWithGlobalNormalization(Operand<T> t,
      Operand<Float> tMin, Operand<Float> tMax, Operand<T> m, Operand<Float> mMin,
      Operand<Float> mMax, Operand<T> v, Operand<Float> vMin, Operand<Float> vMax, Operand<T> beta,
      Operand<Float> betaMin, Operand<Float> betaMax, Operand<T> gamma, Operand<Float> gammaMin,
      Operand<Float> gammaMax, Class<U> outType, Float varianceEpsilon,
      Boolean scaleAfterNormalization) {
    return QuantizedBatchNormWithGlobalNormalization.create(scope, t, tMin, tMax, m, mMin, mMax, v, vMin, vMax, beta, betaMin, betaMax, gamma, gammaMin, gammaMax, outType, varianceEpsilon, scaleAfterNormalization);
  }

  /**
   * Adds an {@link ResourceSparseApplyAdagradDA} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param gradientAccumulator Should be from a Variable().
   * @param gradientSquaredAccumulator Should be from a Variable().
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param lr Learning rate. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param globalStep Training step number. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyAdagradDA
   * @see org.tensorflow.op.core.ResourceSparseApplyAdagradDA
   */
  public <T, U extends Number> ResourceSparseApplyAdagradDA resourceSparseApplyAdagradDA(Operand<?> var,
      Operand<?> gradientAccumulator, Operand<?> gradientSquaredAccumulator, Operand<T> grad,
      Operand<U> indices, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<Long> globalStep,
      ResourceSparseApplyAdagradDA.Options... options) {
    return ResourceSparseApplyAdagradDA.create(scope, var, gradientAccumulator, gradientSquaredAccumulator, grad, indices, lr, l1, l2, globalStep, options);
  }

  /**
   * Adds an {@link MapIncompleteSize} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of MapIncompleteSize
   * @see org.tensorflow.op.core.MapIncompleteSize
   */
  public MapIncompleteSize mapIncompleteSize(List<Class<?>> dtypes,
      MapIncompleteSize.Options... options) {
    return MapIncompleteSize.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link StridedSliceGrad} operation to the graph
   *
   * @param shape 
   * @param begin 
   * @param end 
   * @param strides 
   * @param dy 
   * @param options carries optional attributes values
   * @return a new instance of StridedSliceGrad
   * @see org.tensorflow.op.core.StridedSliceGrad
   */
  public <U, T extends Number> StridedSliceGrad<U> stridedSliceGrad(Operand<T> shape,
      Operand<T> begin, Operand<T> end, Operand<T> strides, Operand<U> dy,
      StridedSliceGrad.Options... options) {
    return StridedSliceGrad.create(scope, shape, begin, end, strides, dy, options);
  }

  /**
   * Adds an {@link MaxPoolGradV2} operation to the graph
   *
   * @param origInput The original input tensor.
   * @param origOutput The original output tensor.
   * @param grad 4-D.  Gradients w.r.t. the output of `max_pool`.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of MaxPoolGradV2
   * @see org.tensorflow.op.core.MaxPoolGradV2
   */
  public <T extends Number> MaxPoolGradV2<T> maxPoolGradV2(Operand<T> origInput,
      Operand<T> origOutput, Operand<T> grad, Operand<Integer> ksize, Operand<Integer> strides,
      String padding, MaxPoolGradV2.Options... options) {
    return MaxPoolGradV2.create(scope, origInput, origOutput, grad, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link StridedSlice} operation to the graph
   *
   * @param input 
   * @param begin `begin[k]` specifies the offset into the `k`th range specification.
   * @param end `end[i]` is like `begin` with the exception that `end_mask` is
   * @param strides `strides[i]` specifies the increment in the `i`th specification
   * @param options carries optional attributes values
   * @return a new instance of StridedSlice
   * @see org.tensorflow.op.core.StridedSlice
   */
  public <T, U extends Number> StridedSlice<T> stridedSlice(Operand<T> input, Operand<U> begin,
      Operand<U> end, Operand<U> strides, StridedSlice.Options... options) {
    return StridedSlice.create(scope, input, begin, end, strides, options);
  }

  /**
   * Adds an {@link DepthwiseConv2dNative} operation to the graph
   *
   * @param input 
   * @param filter 
   * @param strides 1-D of length 4.  The stride of the sliding window for each dimension
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of DepthwiseConv2dNative
   * @see org.tensorflow.op.core.DepthwiseConv2dNative
   */
  public <T extends Number> DepthwiseConv2dNative<T> depthwiseConv2dNative(Operand<T> input,
      Operand<T> filter, List<Long> strides, String padding,
      DepthwiseConv2dNative.Options... options) {
    return DepthwiseConv2dNative.create(scope, input, filter, strides, padding, options);
  }

  /**
   * Adds an {@link ResourceScatterMul} operation to the graph
   *
   * @param resource Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to add to `ref`.
   * @return a new instance of ResourceScatterMul
   * @see org.tensorflow.op.core.ResourceScatterMul
   */
  public <T extends Number, U> ResourceScatterMul resourceScatterMul(Operand<?> resource,
      Operand<T> indices, Operand<U> updates) {
    return ResourceScatterMul.create(scope, resource, indices, updates);
  }

  /**
   * Adds an {@link ControlTrigger} operation to the graph
   *
   * @return a new instance of ControlTrigger
   * @see org.tensorflow.op.core.ControlTrigger
   */
  public ControlTrigger controlTrigger() {
    return ControlTrigger.create(scope);
  }

  /**
   * Adds an {@link CudnnRNNBackprop} operation to the graph
   *
   * @param input 
   * @param inputH 
   * @param inputC 
   * @param params 
   * @param output 
   * @param outputH 
   * @param outputC 
   * @param outputBackprop 
   * @param outputHBackprop 
   * @param outputCBackprop 
   * @param reserveSpace 
   * @param options carries optional attributes values
   * @return a new instance of CudnnRNNBackprop
   * @see org.tensorflow.op.core.CudnnRNNBackprop
   */
  public <T extends Number> CudnnRNNBackprop<T> cudnnRNNBackprop(Operand<T> input,
      Operand<T> inputH, Operand<T> inputC, Operand<T> params, Operand<T> output,
      Operand<T> outputH, Operand<T> outputC, Operand<T> outputBackprop, Operand<T> outputHBackprop,
      Operand<T> outputCBackprop, Operand<T> reserveSpace, CudnnRNNBackprop.Options... options) {
    return CudnnRNNBackprop.create(scope, input, inputH, inputC, params, output, outputH, outputC, outputBackprop, outputHBackprop, outputCBackprop, reserveSpace, options);
  }

  /**
   * Adds an {@link Shape} operation to the graph
   *
   * @param input 
   * @param outType 
   * @return a new instance of Shape
   * @see org.tensorflow.op.core.Shape
   */
  public <U extends Number, T> org.tensorflow.op.core.Shape<U> shape(Operand<T> input,
      Class<U> outType) {
    return org.tensorflow.op.core.Shape.create(scope, input, outType);
  }

  /**
   * Adds an {@link TensorListPushBack} operation to the graph
   *
   * @param inputHandle 
   * @param tensor 
   * @return a new instance of TensorListPushBack
   * @see org.tensorflow.op.core.TensorListPushBack
   */
  public <T> TensorListPushBack tensorListPushBack(Operand<?> inputHandle, Operand<T> tensor) {
    return TensorListPushBack.create(scope, inputHandle, tensor);
  }

  /**
   * Adds an {@link IdentityN} operation to the graph
   *
   * @param input 
   * @return a new instance of IdentityN
   * @see org.tensorflow.op.core.IdentityN
   */
  public IdentityN identityN(Iterable<Operand<?>> input) {
    return IdentityN.create(scope, input);
  }

  /**
   * Adds an {@link Reciprocal} operation to the graph
   *
   * @param x 
   * @return a new instance of Reciprocal
   * @see org.tensorflow.op.core.Reciprocal
   */
  public <T> Reciprocal<T> reciprocal(Operand<T> x) {
    return Reciprocal.create(scope, x);
  }

  /**
   * Adds an {@link DenseToDenseSetOperation} operation to the graph
   *
   * @param set1 `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set2`.
   * @param set2 `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set1`.
   * @param setOperation 
   * @param options carries optional attributes values
   * @return a new instance of DenseToDenseSetOperation
   * @see org.tensorflow.op.core.DenseToDenseSetOperation
   */
  public <T> DenseToDenseSetOperation<T> denseToDenseSetOperation(Operand<T> set1, Operand<T> set2,
      String setOperation, DenseToDenseSetOperation.Options... options) {
    return DenseToDenseSetOperation.create(scope, set1, set2, setOperation, options);
  }

  /**
   * Adds an {@link Reshape} operation to the graph
   *
   * @param tensor 
   * @param shape Defines the shape of the output tensor.
   * @return a new instance of Reshape
   * @see org.tensorflow.op.core.Reshape
   */
  public <T, U extends Number> Reshape<T> reshape(Operand<T> tensor, Operand<U> shape) {
    return Reshape.create(scope, tensor, shape);
  }

  /**
   * Adds an {@link SparseSparseMaximum} operation to the graph
   *
   * @param aIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param aValues 1-D.  `N` non-empty values corresponding to `a_indices`.
   * @param aShape 1-D.  Shape of the input SparseTensor.
   * @param bIndices counterpart to `a_indices` for the other operand.
   * @param bValues counterpart to `a_values` for the other operand; must be of the same dtype.
   * @param bShape counterpart to `a_shape` for the other operand; the two shapes must be equal.
   * @return a new instance of SparseSparseMaximum
   * @see org.tensorflow.op.core.SparseSparseMaximum
   */
  public <T extends Number> SparseSparseMaximum<T> sparseSparseMaximum(Operand<Long> aIndices,
      Operand<T> aValues, Operand<Long> aShape, Operand<Long> bIndices, Operand<T> bValues,
      Operand<Long> bShape) {
    return SparseSparseMaximum.create(scope, aIndices, aValues, aShape, bIndices, bValues, bShape);
  }

  /**
   * Adds an {@link ResourceApplyRMSProp} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param ms Should be from a Variable().
   * @param mom Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay rate. Must be a scalar.
   * @param momentum 
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyRMSProp
   * @see org.tensorflow.op.core.ResourceApplyRMSProp
   */
  public <T> ResourceApplyRMSProp resourceApplyRMSProp(Operand<?> var, Operand<?> ms,
      Operand<?> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon,
      Operand<T> grad, ResourceApplyRMSProp.Options... options) {
    return ResourceApplyRMSProp.create(scope, var, ms, mom, lr, rho, momentum, epsilon, grad, options);
  }

  /**
   * Adds an {@link DestroyResourceOp} operation to the graph
   *
   * @param resource handle to the resource to delete.
   * @param options carries optional attributes values
   * @return a new instance of DestroyResourceOp
   * @see org.tensorflow.op.core.DestroyResourceOp
   */
  public DestroyResourceOp destroyResourceOp(Operand<?> resource,
      DestroyResourceOp.Options... options) {
    return DestroyResourceOp.create(scope, resource, options);
  }

  /**
   * Adds an {@link DrawBoundingBoxes} operation to the graph
   *
   * @param images 4-D with shape `[batch, height, width, depth]`. A batch of images.
   * @param boxes 3-D with shape `[batch, num_bounding_boxes, 4]` containing bounding
   * @return a new instance of DrawBoundingBoxes
   * @see org.tensorflow.op.core.DrawBoundingBoxes
   */
  public <T extends Number> DrawBoundingBoxes<T> drawBoundingBoxes(Operand<T> images,
      Operand<Float> boxes) {
    return DrawBoundingBoxes.create(scope, images, boxes);
  }

  /**
   * Adds an {@link LookupTableExport} operation to the graph
   *
   * @param tableHandle Handle to the table.
   * @param Tkeys 
   * @param Tvalues 
   * @return a new instance of LookupTableExport
   * @see org.tensorflow.op.core.LookupTableExport
   */
  public <T, U> LookupTableExport<T, U> lookupTableExport(Operand<?> tableHandle, Class<T> Tkeys,
      Class<U> Tvalues) {
    return LookupTableExport.create(scope, tableHandle, Tkeys, Tvalues);
  }

  /**
   * Adds an {@link SparseTensorDenseAdd} operation to the graph
   *
   * @param aIndices 2-D.  The `indices` of the `SparseTensor`, with shape `[nnz, ndims]`.
   * @param aValues 1-D.  The `values` of the `SparseTensor`, with shape `[nnz]`.
   * @param aShape 1-D.  The `shape` of the `SparseTensor`, with shape `[ndims]`.
   * @param b `ndims`-D Tensor.  With shape `a_shape`.
   * @return a new instance of SparseTensorDenseAdd
   * @see org.tensorflow.op.core.SparseTensorDenseAdd
   */
  public <U, T extends Number> SparseTensorDenseAdd<U> sparseTensorDenseAdd(Operand<T> aIndices,
      Operand<U> aValues, Operand<T> aShape, Operand<U> b) {
    return SparseTensorDenseAdd.create(scope, aIndices, aValues, aShape, b);
  }

  /**
   * Adds an {@link UnsortedSegmentMax} operation to the graph
   *
   * @param data 
   * @param segmentIds A tensor whose shape is a prefix of `data.shape`.END
   * @param numSegments 
   * @return a new instance of UnsortedSegmentMax
   * @see org.tensorflow.op.core.UnsortedSegmentMax
   */
  public <T extends Number, U extends Number, V extends Number> UnsortedSegmentMax<T> unsortedSegmentMax(Operand<T> data,
      Operand<U> segmentIds, Operand<V> numSegments) {
    return UnsortedSegmentMax.create(scope, data, segmentIds, numSegments);
  }

  /**
   * Adds an {@link StringToNumber} operation to the graph
   *
   * @param stringTensor 
   * @param outType The numeric type to interpret each string in `string_tensor` as.
   * @return a new instance of StringToNumber
   * @see org.tensorflow.op.core.StringToNumber
   */
  public <T extends Number> StringToNumber<T> stringToNumber(Operand<String> stringTensor,
      Class<T> outType) {
    return StringToNumber.create(scope, stringTensor, outType);
  }

  /**
   * Adds an {@link TensorArrayRead} operation to the graph
   *
   * @param handle The handle to a TensorArray.
   * @param index 
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @param dtype The type of the elem that is returned.
   * @return a new instance of TensorArrayRead
   * @see org.tensorflow.op.core.TensorArrayRead
   */
  public <T> TensorArrayRead<T> tensorArrayRead(Operand<?> handle, Operand<Integer> index,
      Operand<Float> flowIn, Class<T> dtype) {
    return TensorArrayRead.create(scope, handle, index, flowIn, dtype);
  }

  /**
   * Adds an {@link QuantizedMaxPool} operation to the graph
   *
   * @param input The 4D (batch x rows x cols x depth) Tensor to MaxReduce over.
   * @param minInput The float value that the lowest quantized input value represents.
   * @param maxInput The float value that the highest quantized input value represents.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the input
   * @param padding The type of padding algorithm to use.
   * @return a new instance of QuantizedMaxPool
   * @see org.tensorflow.op.core.QuantizedMaxPool
   */
  public <T> QuantizedMaxPool<T> quantizedMaxPool(Operand<T> input, Operand<Float> minInput,
      Operand<Float> maxInput, List<Long> ksize, List<Long> strides, String padding) {
    return QuantizedMaxPool.create(scope, input, minInput, maxInput, ksize, strides, padding);
  }

  /**
   * Adds an {@link SerializeIterator} operation to the graph
   *
   * @param resourceHandle A handle to an iterator resource.
   * @return a new instance of SerializeIterator
   * @see org.tensorflow.op.core.SerializeIterator
   */
  public SerializeIterator serializeIterator(Operand<?> resourceHandle) {
    return SerializeIterator.create(scope, resourceHandle);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param shape the tensor shape.
   * @param data a buffer containing the tensor data.
   * @return a float constant
   * @throws IllegalArgumentException If the tensor shape is not compatible with the buffer
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Float> constant(long[] shape, FloatBuffer data) {
    return Constant.create(scope, shape, data);
  }

  /**
   * Adds an {@link CropAndResizeGradImage} operation to the graph
   *
   * @param grads A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
   * @param boxes A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
   * @param boxInd A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
   * @param imageSize A 1-D tensor with value `[batch, image_height, image_width, depth]`
   * @param T 
   * @param options carries optional attributes values
   * @return a new instance of CropAndResizeGradImage
   * @see org.tensorflow.op.core.CropAndResizeGradImage
   */
  public <T extends Number> CropAndResizeGradImage<T> cropAndResizeGradImage(Operand<Float> grads,
      Operand<Float> boxes, Operand<Integer> boxInd, Operand<Integer> imageSize, Class<T> T,
      CropAndResizeGradImage.Options... options) {
    return CropAndResizeGradImage.create(scope, grads, boxes, boxInd, imageSize, T, options);
  }

  /**
   * Adds an {@link SparseAccumulatorApplyGradient} operation to the graph
   *
   * @param handle The handle to a accumulator.
   * @param localStep The local_step value at which the sparse gradient was computed.
   * @param gradientIndices Indices of the sparse gradient to be accumulated. Must be a
   * @param gradientValues Values are the non-zero slices of the gradient, and must have
   * @param gradientShape Shape of the sparse gradient to be accumulated.
   * @param hasKnownShape Boolean indicating whether gradient_shape is unknown, in which
   * @return a new instance of SparseAccumulatorApplyGradient
   * @see org.tensorflow.op.core.SparseAccumulatorApplyGradient
   */
  public <T> SparseAccumulatorApplyGradient sparseAccumulatorApplyGradient(Operand<String> handle,
      Operand<Long> localStep, Operand<Long> gradientIndices, Operand<T> gradientValues,
      Operand<Long> gradientShape, Boolean hasKnownShape) {
    return SparseAccumulatorApplyGradient.create(scope, handle, localStep, gradientIndices, gradientValues, gradientShape, hasKnownShape);
  }

  /**
   * Adds an {@link SparseSegmentSum} operation to the graph
   *
   * @param data 
   * @param indices A 1-D tensor. Has same rank as `segment_ids`.
   * @param segmentIds A 1-D tensor. Values should be sorted and can be repeated.
   * @return a new instance of SparseSegmentSum
   * @see org.tensorflow.op.core.SparseSegmentSum
   */
  public <T extends Number, U extends Number> SparseSegmentSum<T> sparseSegmentSum(Operand<T> data,
      Operand<U> indices, Operand<Integer> segmentIds) {
    return SparseSegmentSum.create(scope, data, indices, segmentIds);
  }

  /**
   * Adds an {@link QueueIsClosed} operation to the graph
   *
   * @param handle The handle to a queue.
   * @return a new instance of QueueIsClosed
   * @see org.tensorflow.op.core.QueueIsClosed
   */
  public QueueIsClosed queueIsClosed(Operand<String> handle) {
    return QueueIsClosed.create(scope, handle);
  }

  /**
   * Adds an {@link Lu} operation to the graph
   *
   * @param input A tensor of shape `[..., M, M]` whose inner-most 2 dimensions form matrices of
   * @param outputIdxType 
   * @return a new instance of Lu
   * @see org.tensorflow.op.core.Lu
   */
  public <T, U extends Number> Lu<T, U> lu(Operand<T> input, Class<U> outputIdxType) {
    return Lu.create(scope, input, outputIdxType);
  }

  /**
   * Adds an {@link SegmentProd} operation to the graph
   *
   * @param data 
   * @param segmentIds A 1-D tensor whose size is equal to the size of `data`'s
   * @return a new instance of SegmentProd
   * @see org.tensorflow.op.core.SegmentProd
   */
  public <T, U extends Number> SegmentProd<T> segmentProd(Operand<T> data, Operand<U> segmentIds) {
    return SegmentProd.create(scope, data, segmentIds);
  }

  /**
   * Adds an {@link IteratorToStringHandle} operation to the graph
   *
   * @param resourceHandle A handle to an iterator resource.
   * @return a new instance of IteratorToStringHandle
   * @see org.tensorflow.op.core.IteratorToStringHandle
   */
  public IteratorToStringHandle iteratorToStringHandle(Operand<?> resourceHandle) {
    return IteratorToStringHandle.create(scope, resourceHandle);
  }

  /**
   * Adds an {@link SdcaShrinkL1} operation to the graph
   *
   * @param weights a list of vectors where each value is the weight associated with a
   * @param l1 Symmetric l1 regularization strength.
   * @param l2 Symmetric l2 regularization strength. Should be a positive float.
   * @return a new instance of SdcaShrinkL1
   * @see org.tensorflow.op.core.SdcaShrinkL1
   */
  public SdcaShrinkL1 sdcaShrinkL1(Iterable<Operand<Float>> weights, Float l1, Float l2) {
    return SdcaShrinkL1.create(scope, weights, l1, l2);
  }

  /**
   * Adds an {@link BatchMatrixDiagPart} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchMatrixDiagPart
   * @see org.tensorflow.op.core.BatchMatrixDiagPart
   */
  public <T> BatchMatrixDiagPart<T> batchMatrixDiagPart(Operand<T> input) {
    return BatchMatrixDiagPart.create(scope, input);
  }

  /**
   * Adds an {@link Prod} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of Prod
   * @see org.tensorflow.op.core.Prod
   */
  public <T, U extends Number> Prod<T> prod(Operand<T> input, Operand<U> axis,
      Prod.Options... options) {
    return Prod.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link Conv3D} operation to the graph
   *
   * @param input Shape `[batch, in_depth, in_height, in_width, in_channels]`.
   * @param filter Shape `[filter_depth, filter_height, filter_width, in_channels,
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of Conv3D
   * @see org.tensorflow.op.core.Conv3D
   */
  public <T extends Number> Conv3D<T> conv3D(Operand<T> input, Operand<T> filter,
      List<Long> strides, String padding, Conv3D.Options... options) {
    return Conv3D.create(scope, input, filter, strides, padding, options);
  }

  /**
   * Adds an {@link AdjustSaturation} operation to the graph
   *
   * @param images Images to adjust.  At least 3-D.
   * @param scale A float scale to add to the saturation.
   * @return a new instance of AdjustSaturation
   * @see org.tensorflow.op.core.AdjustSaturation
   */
  public AdjustSaturation adjustSaturation(Operand<Float> images, Operand<Float> scale) {
    return AdjustSaturation.create(scope, images, scale);
  }

  /**
   * Adds an {@link LogMatrixDeterminant} operation to the graph
   *
   * @param input Shape is `[N, M, M]`.
   * @return a new instance of LogMatrixDeterminant
   * @see org.tensorflow.op.core.LogMatrixDeterminant
   */
  public <T> LogMatrixDeterminant<T> logMatrixDeterminant(Operand<T> input) {
    return LogMatrixDeterminant.create(scope, input);
  }

  /**
   * Adds an {@link ResourceScatterSub} operation to the graph
   *
   * @param resource Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to add to `ref`.
   * @return a new instance of ResourceScatterSub
   * @see org.tensorflow.op.core.ResourceScatterSub
   */
  public <T extends Number, U> ResourceScatterSub resourceScatterSub(Operand<?> resource,
      Operand<T> indices, Operand<U> updates) {
    return ResourceScatterSub.create(scope, resource, indices, updates);
  }

  /**
   * Adds an {@link ReaderReset} operation to the graph
   *
   * @param readerHandle Handle to a Reader.
   * @return a new instance of ReaderReset
   * @see org.tensorflow.op.core.ReaderReset
   */
  public ReaderReset readerReset(Operand<?> readerHandle) {
    return ReaderReset.create(scope, readerHandle);
  }

  /**
   * Adds an {@link Relu} operation to the graph
   *
   * @param features 
   * @return a new instance of Relu
   * @see org.tensorflow.op.core.Relu
   */
  public <T> Relu<T> relu(Operand<T> features) {
    return Relu.create(scope, features);
  }

  /**
   * Adds an {@link HSVToRGB} operation to the graph
   *
   * @param images 1-D or higher rank. HSV data to convert. Last dimension must be size 3.
   * @return a new instance of HSVToRGB
   * @see org.tensorflow.op.core.HSVToRGB
   */
  public <T extends Number> HSVToRGB<T> hSVToRGB(Operand<T> images) {
    return HSVToRGB.create(scope, images);
  }

  /**
   * Adds an {@link ScatterMin} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to reduce into `ref`.
   * @param options carries optional attributes values
   * @return a new instance of ScatterMin
   * @see org.tensorflow.op.core.ScatterMin
   */
  public <T extends Number, U extends Number> ScatterMin<T> scatterMin(Operand<T> ref,
      Operand<U> indices, Operand<T> updates, ScatterMin.Options... options) {
    return ScatterMin.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link MatrixInverse} operation to the graph
   *
   * @param input Shape is `[..., M, M]`.
   * @param options carries optional attributes values
   * @return a new instance of MatrixInverse
   * @see org.tensorflow.op.core.MatrixInverse
   */
  public <T> MatrixInverse<T> matrixInverse(Operand<T> input, MatrixInverse.Options... options) {
    return MatrixInverse.create(scope, input, options);
  }

  /**
   * Adds an {@link Stack} operation to the graph
   *
   * @param values Must be of same shape and type.
   * @param options carries optional attributes values
   * @return a new instance of Stack
   * @see org.tensorflow.op.core.Stack
   */
  public <T> Stack<T> stack(Operand<T> values, Stack.Options... options) {
    return Stack.create(scope, values, options);
  }

  /**
   * Adds an {@link Add} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Add
   * @see org.tensorflow.op.core.Add
   */
  public <T> Add<T> add(Operand<T> x, Operand<T> y) {
    return Add.create(scope, x, y);
  }

  /**
   * Adds an {@link CTCGreedyDecoder} operation to the graph
   *
   * @param inputs 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
   * @param sequenceLength A vector containing sequence lengths, size `(batch_size)`.
   * @param options carries optional attributes values
   * @return a new instance of CTCGreedyDecoder
   * @see org.tensorflow.op.core.CTCGreedyDecoder
   */
  public CTCGreedyDecoder cTCGreedyDecoder(Operand<Float> inputs, Operand<Integer> sequenceLength,
      CTCGreedyDecoder.Options... options) {
    return CTCGreedyDecoder.create(scope, inputs, sequenceLength, options);
  }

  /**
   * Adds an {@link LookupTableImport} operation to the graph
   *
   * @param tableHandle Handle to the table.
   * @param keys Any shape.  Keys to look up.
   * @param values Values to associate with keys.
   * @return a new instance of LookupTableImport
   * @see org.tensorflow.op.core.LookupTableImport
   */
  public <T, U> LookupTableImport lookupTableImport(Operand<?> tableHandle, Operand<T> keys,
      Operand<U> values) {
    return LookupTableImport.create(scope, tableHandle, keys, values);
  }

  /**
   * Adds an {@link IsInf} operation to the graph
   *
   * @param x 
   * @return a new instance of IsInf
   * @see org.tensorflow.op.core.IsInf
   */
  public <T extends Number> IsInf isInf(Operand<T> x) {
    return IsInf.create(scope, x);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Double> constant(double[][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link TensorArraySplit} operation to the graph
   *
   * @param handle The handle to a TensorArray.
   * @param value The concatenated tensor to write to the TensorArray.
   * @param lengths The vector of lengths, how to split the rows of value into the
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @return a new instance of TensorArraySplit
   * @see org.tensorflow.op.core.TensorArraySplit
   */
  public <T> TensorArraySplit tensorArraySplit(Operand<?> handle, Operand<T> value,
      Operand<Long> lengths, Operand<Float> flowIn) {
    return TensorArraySplit.create(scope, handle, value, lengths, flowIn);
  }

  /**
   * Adds an {@link ExtractJpegShape} operation to the graph
   *
   * @param contents 0-D. The JPEG-encoded image.
   * @return a new instance of ExtractJpegShape
   * @see org.tensorflow.op.core.ExtractJpegShape
   */
  public ExtractJpegShape<Integer> extractJpegShape(Operand<String> contents) {
    return ExtractJpegShape.create(scope, contents);
  }

  /**
   * Adds an {@link TruncatedNormal} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param dtype The type of the output.
   * @param options carries optional attributes values
   * @return a new instance of TruncatedNormal
   * @see org.tensorflow.op.core.TruncatedNormal
   */
  public <U extends Number, T extends Number> TruncatedNormal<U> truncatedNormal(Operand<T> shape,
      Class<U> dtype, TruncatedNormal.Options... options) {
    return TruncatedNormal.create(scope, shape, dtype, options);
  }

  /**
   * Adds an {@link MergeSummary} operation to the graph
   *
   * @param inputs Can be of any shape.  Each must contain serialized `Summary` protocol
   * @return a new instance of MergeSummary
   * @see org.tensorflow.op.core.MergeSummary
   */
  public MergeSummary mergeSummary(Iterable<Operand<String>> inputs) {
    return MergeSummary.create(scope, inputs);
  }

  /**
   * Adds an {@link Conv2DBackpropFilter} operation to the graph
   *
   * @param input 4-D with shape `[batch, in_height, in_width, in_channels]`.
   * @param filterSizes An integer vector representing the tensor shape of `filter`,
   * @param outBackprop 4-D with shape `[batch, out_height, out_width, out_channels]`.
   * @param strides The stride of the sliding window for each dimension of the input
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of Conv2DBackpropFilter
   * @see org.tensorflow.op.core.Conv2DBackpropFilter
   */
  public <T extends Number> Conv2DBackpropFilter<T> conv2DBackpropFilter(Operand<T> input,
      Operand<Integer> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding,
      Conv2DBackpropFilter.Options... options) {
    return Conv2DBackpropFilter.create(scope, input, filterSizes, outBackprop, strides, padding, options);
  }

  /**
   * Adds an {@link MaxPoolWithArgmax} operation to the graph
   *
   * @param input 4-D with shape `[batch, height, width, channels]`.  Input to pool over.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * @param Targmax 
   * @param padding The type of padding algorithm to use.
   * @return a new instance of MaxPoolWithArgmax
   * @see org.tensorflow.op.core.MaxPoolWithArgmax
   */
  public <T extends Number, U extends Number> MaxPoolWithArgmax<T, U> maxPoolWithArgmax(Operand<T> input,
      List<Long> ksize, List<Long> strides, Class<U> Targmax, String padding) {
    return MaxPoolWithArgmax.create(scope, input, ksize, strides, Targmax, padding);
  }

  /**
   * Adds an {@link RegexFullMatch} operation to the graph
   *
   * @param input A string tensor of the text to be processed.
   * @param pattern A scalar string tensor containing the regular expression to match the input.
   * @return a new instance of RegexFullMatch
   * @see org.tensorflow.op.core.RegexFullMatch
   */
  public RegexFullMatch regexFullMatch(Operand<String> input, Operand<String> pattern) {
    return RegexFullMatch.create(scope, input, pattern);
  }

  /**
   * Adds an {@link CropAndResize} operation to the graph
   *
   * @param image A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
   * @param boxes A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
   * @param boxInd A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
   * @param cropSize A 1-D tensor of 2 elements, `size = [crop_height, crop_width]`. All
   * @param options carries optional attributes values
   * @return a new instance of CropAndResize
   * @see org.tensorflow.op.core.CropAndResize
   */
  public <T extends Number> CropAndResize cropAndResize(Operand<T> image, Operand<Float> boxes,
      Operand<Integer> boxInd, Operand<Integer> cropSize, CropAndResize.Options... options) {
    return CropAndResize.create(scope, image, boxes, boxInd, cropSize, options);
  }

  /**
   * Adds an {@link QuantizedConv2D} operation to the graph
   *
   * @param input 
   * @param filter filter's input_depth dimension must match input's depth dimensions.
   * @param minInput The float value that the lowest quantized input value represents.
   * @param maxInput The float value that the highest quantized input value represents.
   * @param minFilter The float value that the lowest quantized filter value represents.
   * @param maxFilter The float value that the highest quantized filter value represents.
   * @param outType 
   * @param strides The stride of the sliding window for each dimension of the input
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of QuantizedConv2D
   * @see org.tensorflow.op.core.QuantizedConv2D
   */
  public <V, T, U> QuantizedConv2D<V> quantizedConv2D(Operand<T> input, Operand<U> filter,
      Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minFilter,
      Operand<Float> maxFilter, Class<V> outType, List<Long> strides, String padding,
      QuantizedConv2D.Options... options) {
    return QuantizedConv2D.create(scope, input, filter, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
  }

  /**
   * Adds an {@link BarrierClose} operation to the graph
   *
   * @param handle The handle to a barrier.
   * @param options carries optional attributes values
   * @return a new instance of BarrierClose
   * @see org.tensorflow.op.core.BarrierClose
   */
  public BarrierClose barrierClose(Operand<String> handle, BarrierClose.Options... options) {
    return BarrierClose.create(scope, handle, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Double> constant(double[] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link SpaceToBatch} operation to the graph
   *
   * @param input 4-D with shape `[batch, height, width, depth]`.
   * @param paddings 2-D tensor of non-negative integers with shape `[2, 2]`. It specifies
   * @param blockSize 
   * @return a new instance of SpaceToBatch
   * @see org.tensorflow.op.core.SpaceToBatch
   */
  public <T, U extends Number> SpaceToBatch<T> spaceToBatch(Operand<T> input, Operand<U> paddings,
      Long blockSize) {
    return SpaceToBatch.create(scope, input, paddings, blockSize);
  }

  /**
   * Adds an {@link QuantizedAvgPool} operation to the graph
   *
   * @param input 4-D with shape `[batch, height, width, channels]`.
   * @param minInput The float value that the lowest quantized input value represents.
   * @param maxInput The float value that the highest quantized input value represents.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the input
   * @param padding The type of padding algorithm to use.
   * @return a new instance of QuantizedAvgPool
   * @see org.tensorflow.op.core.QuantizedAvgPool
   */
  public <T> QuantizedAvgPool<T> quantizedAvgPool(Operand<T> input, Operand<Float> minInput,
      Operand<Float> maxInput, List<Long> ksize, List<Long> strides, String padding) {
    return QuantizedAvgPool.create(scope, input, minInput, maxInput, ksize, strides, padding);
  }

  /**
   * Adds an {@link DecodeAndCropJpeg} operation to the graph
   *
   * @param contents 0-D.  The JPEG-encoded image.
   * @param cropWindow 1-D.  The crop window: [crop_y, crop_x, crop_height, crop_width].
   * @param options carries optional attributes values
   * @return a new instance of DecodeAndCropJpeg
   * @see org.tensorflow.op.core.DecodeAndCropJpeg
   */
  public DecodeAndCropJpeg decodeAndCropJpeg(Operand<String> contents, Operand<Integer> cropWindow,
      DecodeAndCropJpeg.Options... options) {
    return DecodeAndCropJpeg.create(scope, contents, cropWindow, options);
  }

  /**
   * Adds an {@link HistogramFixedWidth} operation to the graph
   *
   * @param values Numeric `Tensor`.
   * @param valueRange Shape [2] `Tensor` of same `dtype` as `values`.
   * @param nbins Scalar `int32 Tensor`.  Number of histogram bins.
   * @param dtype 
   * @return a new instance of HistogramFixedWidth
   * @see org.tensorflow.op.core.HistogramFixedWidth
   */
  public <U extends Number, T extends Number> HistogramFixedWidth<U> histogramFixedWidth(Operand<T> values,
      Operand<T> valueRange, Operand<Integer> nbins, Class<U> dtype) {
    return HistogramFixedWidth.create(scope, values, valueRange, nbins, dtype);
  }

  /**
   * Adds an {@link SampleDistortedBoundingBoxV2} operation to the graph
   *
   * @param imageSize 1-D, containing `[height, width, channels]`.
   * @param boundingBoxes 3-D with shape `[batch, N, 4]` describing the N bounding boxes
   * @param minObjectCovered The cropped area of the image must contain at least this
   * @param options carries optional attributes values
   * @return a new instance of SampleDistortedBoundingBoxV2
   * @see org.tensorflow.op.core.SampleDistortedBoundingBoxV2
   */
  public <T extends Number> SampleDistortedBoundingBoxV2<T> sampleDistortedBoundingBoxV2(Operand<T> imageSize,
      Operand<Float> boundingBoxes, Operand<Float> minObjectCovered,
      SampleDistortedBoundingBoxV2.Options... options) {
    return SampleDistortedBoundingBoxV2.create(scope, imageSize, boundingBoxes, minObjectCovered, options);
  }

  /**
   * Adds an {@link Mfcc} operation to the graph
   *
   * @param spectrogram Typically produced by the Spectrogram op, with magnitude_squared
   * @param sampleRate How many samples per second the source audio used.
   * @param options carries optional attributes values
   * @return a new instance of Mfcc
   * @see org.tensorflow.op.core.Mfcc
   */
  public Mfcc mfcc(Operand<Float> spectrogram, Operand<Integer> sampleRate,
      Mfcc.Options... options) {
    return Mfcc.create(scope, spectrogram, sampleRate, options);
  }

  /**
   * Adds an {@link InplaceUpdate} operation to the graph
   *
   * @param x A tensor of type `T`.
   * @param i A vector. Indices into the left-most dimension of `x`.
   * @param v A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
   * @return a new instance of InplaceUpdate
   * @see org.tensorflow.op.core.InplaceUpdate
   */
  public <T> InplaceUpdate<T> inplaceUpdate(Operand<T> x, Operand<Integer> i, Operand<T> v) {
    return InplaceUpdate.create(scope, x, i, v);
  }

  /**
   * Adds an {@link InplaceAdd} operation to the graph
   *
   * @param x A `Tensor` of type T.
   * @param i A vector. Indices into the left-most dimension of `x`.
   * @param v A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
   * @return a new instance of InplaceAdd
   * @see org.tensorflow.op.core.InplaceAdd
   */
  public <T> InplaceAdd<T> inplaceAdd(Operand<T> x, Operand<Integer> i, Operand<T> v) {
    return InplaceAdd.create(scope, x, i, v);
  }

  /**
   * Adds an {@link ArgMin} operation to the graph
   *
   * @param input 
   * @param dimension int32 or int64, must be in the range `[-rank(input), rank(input))`.
   * @return a new instance of ArgMin
   * @see org.tensorflow.op.core.ArgMin
   */
  public <T, U extends Number> ArgMin<Long> argMin(Operand<T> input, Operand<U> dimension) {
    return ArgMin.create(scope, input, dimension);
  }

  /**
   * Adds an {@link ScatterNdUpdate} operation to the graph
   *
   * @param ref A mutable Tensor. Should be from a Variable node.
   * @param indices A Tensor. Must be one of the following types: int32, int64.
   * @param updates A Tensor. Must have the same type as ref. A tensor of updated
   * @param options carries optional attributes values
   * @return a new instance of ScatterNdUpdate
   * @see org.tensorflow.op.core.ScatterNdUpdate
   */
  public <T, U extends Number> ScatterNdUpdate<T> scatterNdUpdate(Operand<T> ref,
      Operand<U> indices, Operand<T> updates, ScatterNdUpdate.Options... options) {
    return ScatterNdUpdate.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link SparseConcat} operation to the graph
   *
   * @param indices 2-D.  Indices of each input `SparseTensor`.
   * @param values 1-D.  Non-empty values of each `SparseTensor`.
   * @param shapes 1-D.  Shapes of each `SparseTensor`.
   * @param concatDim Dimension to concatenate along. Must be in range [-rank, rank),
   * @return a new instance of SparseConcat
   * @see org.tensorflow.op.core.SparseConcat
   */
  public <T> SparseConcat<T> sparseConcat(Iterable<Operand<Long>> indices, Operand<T> values,
      Iterable<Operand<Long>> shapes, Long concatDim) {
    return SparseConcat.create(scope, indices, values, shapes, concatDim);
  }

  /**
   * Adds an {@link Gather} operation to the graph
   *
   * @param params 
   * @param indices 
   * @param options carries optional attributes values
   * @return a new instance of Gather
   * @see org.tensorflow.op.core.Gather
   */
  public <T, U extends Number> Gather<T> gather(Operand<T> params, Operand<U> indices,
      Gather.Options... options) {
    return Gather.create(scope, params, indices, options);
  }

  /**
   * Adds an {@link SegmentMax} operation to the graph
   *
   * @param data 
   * @param segmentIds A 1-D tensor whose size is equal to the size of `data`'s
   * @return a new instance of SegmentMax
   * @see org.tensorflow.op.core.SegmentMax
   */
  public <T extends Number, U extends Number> SegmentMax<T> segmentMax(Operand<T> data,
      Operand<U> segmentIds) {
    return SegmentMax.create(scope, data, segmentIds);
  }

  /**
   * Adds an {@link BatchMatrixInverse} operation to the graph
   *
   * @param input 
   * @param options carries optional attributes values
   * @return a new instance of BatchMatrixInverse
   * @see org.tensorflow.op.core.BatchMatrixInverse
   */
  public <T extends Number> BatchMatrixInverse<T> batchMatrixInverse(Operand<T> input,
      BatchMatrixInverse.Options... options) {
    return BatchMatrixInverse.create(scope, input, options);
  }

  /**
   * Adds an {@link Bucketize} operation to the graph
   *
   * @param input Any shape of Tensor contains with int or float type.
   * @param boundaries A sorted list of floats gives the boundary of the buckets.
   * @return a new instance of Bucketize
   * @see org.tensorflow.op.core.Bucketize
   */
  public <T extends Number> Bucketize bucketize(Operand<T> input, List<Float> boundaries) {
    return Bucketize.create(scope, input, boundaries);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Integer> constant(int[][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link IRFFT2D} operation to the graph
   *
   * @param input A complex64 tensor.
   * @param fftLength An int32 tensor of shape [2]. The FFT length for each dimension.
   * @return a new instance of IRFFT2D
   * @see org.tensorflow.op.core.IRFFT2D
   */
  public IRFFT2D iRFFT2D(Operand<?> input, Operand<Integer> fftLength) {
    return IRFFT2D.create(scope, input, fftLength);
  }

  /**
   * Adds an {@link ReaderRestoreState} operation to the graph
   *
   * @param readerHandle Handle to a Reader.
   * @param state Result of a ReaderSerializeState of a Reader with type
   * @return a new instance of ReaderRestoreState
   * @see org.tensorflow.op.core.ReaderRestoreState
   */
  public ReaderRestoreState readerRestoreState(Operand<?> readerHandle, Operand<String> state) {
    return ReaderRestoreState.create(scope, readerHandle, state);
  }

  /**
   * Adds an {@link NoOp} operation to the graph
   *
   * @return a new instance of NoOp
   * @see org.tensorflow.op.core.NoOp
   */
  public NoOp noOp() {
    return NoOp.create(scope);
  }

  /**
   * Adds an {@link ConjugateTranspose} operation to the graph
   *
   * @param x 
   * @param perm 
   * @return a new instance of ConjugateTranspose
   * @see org.tensorflow.op.core.ConjugateTranspose
   */
  public <T, U extends Number> ConjugateTranspose<T> conjugateTranspose(Operand<T> x,
      Operand<U> perm) {
    return ConjugateTranspose.create(scope, x, perm);
  }

  /**
   * Adds an {@link SerializeSparse} operation to the graph
   *
   * @param sparseIndices 2-D.  The `indices` of the `SparseTensor`.
   * @param sparseValues 1-D.  The `values` of the `SparseTensor`.
   * @param sparseShape 1-D.  The `shape` of the `SparseTensor`.
   * @param outType The `dtype` to use for serialization; the supported types are `string`
   * @return a new instance of SerializeSparse
   * @see org.tensorflow.op.core.SerializeSparse
   */
  public <U, T> SerializeSparse<U> serializeSparse(Operand<Long> sparseIndices,
      Operand<T> sparseValues, Operand<Long> sparseShape, Class<U> outType) {
    return SerializeSparse.create(scope, sparseIndices, sparseValues, sparseShape, outType);
  }

  /**
   * Adds an {@link Round} operation to the graph
   *
   * @param x 
   * @return a new instance of Round
   * @see org.tensorflow.op.core.Round
   */
  public <T> Round<T> round(Operand<T> x) {
    return Round.create(scope, x);
  }

  /**
   * Adds an {@link WriteFile} operation to the graph
   *
   * @param filename scalar. The name of the file to which we write the contents.
   * @param contents scalar. The content to be written to the output file.
   * @return a new instance of WriteFile
   * @see org.tensorflow.op.core.WriteFile
   */
  public WriteFile writeFile(Operand<String> filename, Operand<String> contents) {
    return WriteFile.create(scope, filename, contents);
  }

  /**
   * Adds an {@link MatrixSolve} operation to the graph
   *
   * @param matrix Shape is `[..., M, M]`.
   * @param rhs Shape is `[..., M, K]`.
   * @param options carries optional attributes values
   * @return a new instance of MatrixSolve
   * @see org.tensorflow.op.core.MatrixSolve
   */
  public <T> MatrixSolve<T> matrixSolve(Operand<T> matrix, Operand<T> rhs,
      MatrixSolve.Options... options) {
    return MatrixSolve.create(scope, matrix, rhs, options);
  }

  /**
   * Adds an {@link NonMaxSuppression} operation to the graph
   *
   * @param boxes A 2-D float tensor of shape `[num_boxes, 4]`.
   * @param scores A 1-D float tensor of shape `[num_boxes]` representing a single
   * @param maxOutputSize A scalar integer tensor representing the maximum number of
   * @param options carries optional attributes values
   * @return a new instance of NonMaxSuppression
   * @see org.tensorflow.op.core.NonMaxSuppression
   */
  public NonMaxSuppression nonMaxSuppression(Operand<Float> boxes, Operand<Float> scores,
      Operand<Integer> maxOutputSize, NonMaxSuppression.Options... options) {
    return NonMaxSuppression.create(scope, boxes, scores, maxOutputSize, options);
  }

  /**
   * Adds an {@link MaxPool3DGradGrad} operation to the graph
   *
   * @param origInput The original input tensor.
   * @param origOutput The original output tensor.
   * @param grad Output backprop of shape `[batch, depth, rows, cols, channels]`.
   * @param ksize 1-D tensor of length 5. The size of the window for each dimension of
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of MaxPool3DGradGrad
   * @see org.tensorflow.op.core.MaxPool3DGradGrad
   */
  public <T extends Number> MaxPool3DGradGrad<T> maxPool3DGradGrad(Operand<T> origInput,
      Operand<T> origOutput, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding,
      MaxPool3DGradGrad.Options... options) {
    return MaxPool3DGradGrad.create(scope, origInput, origOutput, grad, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link BatchMatrixDeterminant} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchMatrixDeterminant
   * @see org.tensorflow.op.core.BatchMatrixDeterminant
   */
  public <T> BatchMatrixDeterminant<T> batchMatrixDeterminant(Operand<T> input) {
    return BatchMatrixDeterminant.create(scope, input);
  }

  /**
   * Adds an {@link Cross} operation to the graph
   *
   * @param a A tensor containing 3-element vectors.
   * @param b Another tensor, of same type and shape as `a`.
   * @return a new instance of Cross
   * @see org.tensorflow.op.core.Cross
   */
  public <T extends Number> Cross<T> cross(Operand<T> a, Operand<T> b) {
    return Cross.create(scope, a, b);
  }

  /**
   * Adds an {@link AnonymousIterator} operation to the graph
   *
   * @param outputTypes 
   * @param outputShapes 
   * @return a new instance of AnonymousIterator
   * @see org.tensorflow.op.core.AnonymousIterator
   */
  public AnonymousIterator anonymousIterator(List<Class<?>> outputTypes, List<Shape> outputShapes) {
    return AnonymousIterator.create(scope, outputTypes, outputShapes);
  }

  /**
   * Adds an {@link QuantizedBiasAdd} operation to the graph
   *
   * @param input 
   * @param bias A 1D bias Tensor with size matching the last dimension of 'input'.
   * @param minInput The float value that the lowest quantized input value represents.
   * @param maxInput The float value that the highest quantized input value represents.
   * @param minBias The float value that the lowest quantized bias value represents.
   * @param maxBias The float value that the highest quantized bias value represents.
   * @param outType 
   * @return a new instance of QuantizedBiasAdd
   * @see org.tensorflow.op.core.QuantizedBiasAdd
   */
  public <V, T, U> QuantizedBiasAdd<V> quantizedBiasAdd(Operand<T> input, Operand<U> bias,
      Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minBias,
      Operand<Float> maxBias, Class<V> outType) {
    return QuantizedBiasAdd.create(scope, input, bias, minInput, maxInput, minBias, maxBias, outType);
  }

  /**
   * Adds an {@link CudnnRNN} operation to the graph
   *
   * @param input 
   * @param inputH 
   * @param inputC 
   * @param params 
   * @param options carries optional attributes values
   * @return a new instance of CudnnRNN
   * @see org.tensorflow.op.core.CudnnRNN
   */
  public <T extends Number> CudnnRNN<T> cudnnRNN(Operand<T> input, Operand<T> inputH,
      Operand<T> inputC, Operand<T> params, CudnnRNN.Options... options) {
    return CudnnRNN.create(scope, input, inputH, inputC, params, options);
  }

  /**
   * Adds an {@link DecodeRaw} operation to the graph
   *
   * @param bytes All the elements must have the same length.
   * @param outType 
   * @param options carries optional attributes values
   * @return a new instance of DecodeRaw
   * @see org.tensorflow.op.core.DecodeRaw
   */
  public <T extends Number> DecodeRaw<T> decodeRaw(Operand<String> bytes, Class<T> outType,
      DecodeRaw.Options... options) {
    return DecodeRaw.create(scope, bytes, outType, options);
  }

  /**
   * Adds an {@link SparseAccumulatorTakeGradient} operation to the graph
   *
   * @param handle The handle to a SparseConditionalAccumulator.
   * @param numRequired Number of gradients required before we return an aggregate.
   * @param dtype The data type of accumulated gradients. Needs to correspond to the type
   * @return a new instance of SparseAccumulatorTakeGradient
   * @see org.tensorflow.op.core.SparseAccumulatorTakeGradient
   */
  public <T> SparseAccumulatorTakeGradient<T> sparseAccumulatorTakeGradient(Operand<String> handle,
      Operand<Integer> numRequired, Class<T> dtype) {
    return SparseAccumulatorTakeGradient.create(scope, handle, numRequired, dtype);
  }

  /**
   * Adds an {@link Imag} operation to the graph
   *
   * @param input 
   * @param Tout 
   * @return a new instance of Imag
   * @see org.tensorflow.op.core.Imag
   */
  public <U extends Number, T> Imag<U> imag(Operand<T> input, Class<U> Tout) {
    return Imag.create(scope, input, Tout);
  }

  /**
   * Adds an {@link RealDiv} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of RealDiv
   * @see org.tensorflow.op.core.RealDiv
   */
  public <T> RealDiv<T> realDiv(Operand<T> x, Operand<T> y) {
    return RealDiv.create(scope, x, y);
  }

  /**
   * Adds an {@link DepthwiseConv2dNativeBackpropInput} operation to the graph
   *
   * @param inputSizes An integer vector representing the shape of `input`, based
   * @param filter 4-D with shape
   * @param outBackprop 4-D with shape  based on `data_format`.
   * @param strides The stride of the sliding window for each dimension of the input
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of DepthwiseConv2dNativeBackpropInput
   * @see org.tensorflow.op.core.DepthwiseConv2dNativeBackpropInput
   */
  public <T extends Number> DepthwiseConv2dNativeBackpropInput<T> depthwiseConv2dNativeBackpropInput(Operand<Integer> inputSizes,
      Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding,
      DepthwiseConv2dNativeBackpropInput.Options... options) {
    return DepthwiseConv2dNativeBackpropInput.create(scope, inputSizes, filter, outBackprop, strides, padding, options);
  }

  /**
   * Adds an {@link Conj} operation to the graph
   *
   * @param input 
   * @return a new instance of Conj
   * @see org.tensorflow.op.core.Conj
   */
  public <T> Conj<T> conj(Operand<T> input) {
    return Conj.create(scope, input);
  }

  /**
   * Adds an {@link NonMaxSuppressionV3} operation to the graph
   *
   * @param boxes A 2-D float tensor of shape `[num_boxes, 4]`.
   * @param scores A 1-D float tensor of shape `[num_boxes]` representing a single
   * @param maxOutputSize A scalar integer tensor representing the maximum number of
   * @param iouThreshold A 0-D float tensor representing the threshold for deciding whether
   * @param scoreThreshold A 0-D float tensor representing the threshold for deciding when to remove
   * @return a new instance of NonMaxSuppressionV3
   * @see org.tensorflow.op.core.NonMaxSuppressionV3
   */
  public <T extends Number> NonMaxSuppressionV3 nonMaxSuppressionV3(Operand<T> boxes,
      Operand<T> scores, Operand<Integer> maxOutputSize, Operand<Float> iouThreshold,
      Operand<Float> scoreThreshold) {
    return NonMaxSuppressionV3.create(scope, boxes, scores, maxOutputSize, iouThreshold, scoreThreshold);
  }

  /**
   * Adds an {@link TensorListReserve} operation to the graph
   *
   * @param elementShape 
   * @param numElements 
   * @param elementDtype 
   * @return a new instance of TensorListReserve
   * @see org.tensorflow.op.core.TensorListReserve
   */
  public <T extends Number, U> TensorListReserve tensorListReserve(Operand<T> elementShape,
      Operand<Integer> numElements, Class<U> elementDtype) {
    return TensorListReserve.create(scope, elementShape, numElements, elementDtype);
  }

  /**
   * Adds an {@link BarrierIncompleteSize} operation to the graph
   *
   * @param handle The handle to a barrier.
   * @return a new instance of BarrierIncompleteSize
   * @see org.tensorflow.op.core.BarrierIncompleteSize
   */
  public BarrierIncompleteSize barrierIncompleteSize(Operand<String> handle) {
    return BarrierIncompleteSize.create(scope, handle);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Double> constant(double[][][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. String elements are
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<String> constant(byte[][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ParseTensor} operation to the graph
   *
   * @param serialized A scalar string containing a serialized TensorProto proto.
   * @param outType The type of the serialized tensor.  The provided type must match the
   * @return a new instance of ParseTensor
   * @see org.tensorflow.op.core.ParseTensor
   */
  public <T> ParseTensor<T> parseTensor(Operand<String> serialized, Class<T> outType) {
    return ParseTensor.create(scope, serialized, outType);
  }

  /**
   * Adds an {@link CountUpTo} operation to the graph
   *
   * @param ref Should be from a scalar `Variable` node.
   * @param limit If incrementing ref would bring it above limit, instead generates an
   * @return a new instance of CountUpTo
   * @see org.tensorflow.op.core.CountUpTo
   */
  public <T extends Number> CountUpTo<T> countUpTo(Operand<T> ref, Long limit) {
    return CountUpTo.create(scope, ref, limit);
  }

  /**
   * Adds an {@link Mod} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Mod
   * @see org.tensorflow.op.core.Mod
   */
  public <T extends Number> Mod<T> mod(Operand<T> x, Operand<T> y) {
    return Mod.create(scope, x, y);
  }

  /**
   * Adds an {@link SparseApplyMomentum} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param momentum Momentum. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyMomentum
   * @see org.tensorflow.op.core.SparseApplyMomentum
   */
  public <T, U extends Number> SparseApplyMomentum<T> sparseApplyMomentum(Operand<T> var,
      Operand<T> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum,
      SparseApplyMomentum.Options... options) {
    return SparseApplyMomentum.create(scope, var, accum, lr, grad, indices, momentum, options);
  }

  /**
   * Adds an {@link FractionalAvgPool} operation to the graph
   *
   * @param value 4-D with shape `[batch, height, width, channels]`.
   * @param poolingRatio Pooling ratio for each dimension of `value`, currently only
   * @param options carries optional attributes values
   * @return a new instance of FractionalAvgPool
   * @see org.tensorflow.op.core.FractionalAvgPool
   */
  public <T extends Number> FractionalAvgPool<T> fractionalAvgPool(Operand<T> value,
      List<Float> poolingRatio, FractionalAvgPool.Options... options) {
    return FractionalAvgPool.create(scope, value, poolingRatio, options);
  }

  /**
   * Adds an {@link UniqueWithCountsV2} operation to the graph
   *
   * @param x A `Tensor`.
   * @param axis A `Tensor` of type `int32` (default: None). The axis of the Tensor to
   * @return a new instance of UniqueWithCountsV2
   * @see org.tensorflow.op.core.UniqueWithCountsV2
   */
  public <T, U extends Number> UniqueWithCountsV2<T, Integer> uniqueWithCountsV2(Operand<T> x,
      Operand<U> axis) {
    return UniqueWithCountsV2.create(scope, x, axis);
  }

  /**
   * Adds an {@link StageClear} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of StageClear
   * @see org.tensorflow.op.core.StageClear
   */
  public StageClear stageClear(List<Class<?>> dtypes, StageClear.Options... options) {
    return StageClear.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link Fill} operation to the graph
   *
   * @param dims 1-D. Represents the shape of the output tensor.
   * @param value 0-D (scalar). Value to fill the returned tensor.
   * @return a new instance of Fill
   * @see org.tensorflow.op.core.Fill
   */
  public <U, T extends Number> Fill<U> fill(Operand<T> dims, Operand<U> value) {
    return Fill.create(scope, dims, value);
  }

  /**
   * Adds an {@link IsNan} operation to the graph
   *
   * @param x 
   * @return a new instance of IsNan
   * @see org.tensorflow.op.core.IsNan
   */
  public <T extends Number> IsNan isNan(Operand<T> x) {
    return IsNan.create(scope, x);
  }

  /**
   * Adds an {@link VarIsInitializedOp} operation to the graph
   *
   * @param resource the input resource handle.
   * @return a new instance of VarIsInitializedOp
   * @see org.tensorflow.op.core.VarIsInitializedOp
   */
  public VarIsInitializedOp varIsInitializedOp(Operand<?> resource) {
    return VarIsInitializedOp.create(scope, resource);
  }

  /**
   * Adds an {@link Merge} operation to the graph
   *
   * @param inputs The input tensors, exactly one of which will become available.
   * @return a new instance of Merge
   * @see org.tensorflow.op.core.Merge
   */
  public <T> Merge<T> merge(Operand<T> inputs) {
    return Merge.create(scope, inputs);
  }

  /**
   * Adds an {@link DepthwiseConv2dNativeBackpropFilter} operation to the graph
   *
   * @param input 4-D with shape based on `data_format`.  For example, if
   * @param filterSizes An integer vector representing the tensor shape of `filter`,
   * @param outBackprop 4-D with shape  based on `data_format`.
   * @param strides The stride of the sliding window for each dimension of the input
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of DepthwiseConv2dNativeBackpropFilter
   * @see org.tensorflow.op.core.DepthwiseConv2dNativeBackpropFilter
   */
  public <T extends Number> DepthwiseConv2dNativeBackpropFilter<T> depthwiseConv2dNativeBackpropFilter(Operand<T> input,
      Operand<Integer> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding,
      DepthwiseConv2dNativeBackpropFilter.Options... options) {
    return DepthwiseConv2dNativeBackpropFilter.create(scope, input, filterSizes, outBackprop, strides, padding, options);
  }

  /**
   * Adds an {@link BatchNormWithGlobalNormalizationGrad} operation to the graph
   *
   * @param t A 4D input Tensor.
   * @param m A 1D mean Tensor with size matching the last dimension of t.
   * @param v A 1D variance Tensor with size matching the last dimension of t.
   * @param gamma A 1D gamma Tensor with size matching the last dimension of t.
   * @param backprop 4D backprop Tensor.
   * @param varianceEpsilon A small float number to avoid dividing by 0.
   * @param scaleAfterNormalization A bool indicating whether the resulted tensor
   * @return a new instance of BatchNormWithGlobalNormalizationGrad
   * @see org.tensorflow.op.core.BatchNormWithGlobalNormalizationGrad
   */
  public <T> BatchNormWithGlobalNormalizationGrad<T> batchNormWithGlobalNormalizationGrad(Operand<T> t,
      Operand<T> m, Operand<T> v, Operand<T> gamma, Operand<T> backprop, Float varianceEpsilon,
      Boolean scaleAfterNormalization) {
    return BatchNormWithGlobalNormalizationGrad.create(scope, t, m, v, gamma, backprop, varianceEpsilon, scaleAfterNormalization);
  }

  /**
   * Adds an {@link CudnnRNNCanonicalToParams} operation to the graph
   *
   * @param numLayers 
   * @param numUnits 
   * @param inputSize 
   * @param weights 
   * @param biases 
   * @param options carries optional attributes values
   * @return a new instance of CudnnRNNCanonicalToParams
   * @see org.tensorflow.op.core.CudnnRNNCanonicalToParams
   */
  public <T extends Number> CudnnRNNCanonicalToParams<T> cudnnRNNCanonicalToParams(Operand<Integer> numLayers,
      Operand<Integer> numUnits, Operand<Integer> inputSize, Operand<T> weights,
      Iterable<Operand<T>> biases, CudnnRNNCanonicalToParams.Options... options) {
    return CudnnRNNCanonicalToParams.create(scope, numLayers, numUnits, inputSize, weights, biases, options);
  }

  /**
   * Adds an {@link DynamicPartition} operation to the graph
   *
   * @param data 
   * @param partitions Any shape.  Indices in the range `[0, num_partitions)`.
   * @param numPartitions The number of partitions to output.
   * @return a new instance of DynamicPartition
   * @see org.tensorflow.op.core.DynamicPartition
   */
  public <T> DynamicPartition<T> dynamicPartition(Operand<T> data, Operand<Integer> partitions,
      Long numPartitions) {
    return DynamicPartition.create(scope, data, partitions, numPartitions);
  }

  /**
   * Adds an {@link MaxPool} operation to the graph
   *
   * @param input 4-D input to pool over.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of MaxPool
   * @see org.tensorflow.op.core.MaxPool
   */
  public <T> MaxPool<T> maxPool(Operand<T> input, List<Long> ksize, List<Long> strides,
      String padding, MaxPool.Options... options) {
    return MaxPool.create(scope, input, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link SetDiff1D} operation to the graph
   *
   * @param x 1-D. Values to keep.
   * @param y 1-D. Values to remove.
   * @return a new instance of SetDiff1D
   * @see org.tensorflow.op.core.SetDiff1D
   */
  public <T> SetDiff1D<T, Integer> setDiff1D(Operand<T> x, Operand<T> y) {
    return SetDiff1D.create(scope, x, y);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param shape the tensor shape.
   * @param data a buffer containing the tensor data.
   * @return a double constant
   * @throws IllegalArgumentException If the tensor shape is not compatible with the buffer
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Double> constant(long[] shape, DoubleBuffer data) {
    return Constant.create(scope, shape, data);
  }

  /**
   * Adds an {@link Neg} operation to the graph
   *
   * @param x 
   * @return a new instance of Neg
   * @see org.tensorflow.op.core.Neg
   */
  public <T> Neg<T> neg(Operand<T> x) {
    return Neg.create(scope, x);
  }

  /**
   * Adds an {@link BroadcastTo} operation to the graph
   *
   * @param input A Tensor to broadcast.
   * @param shape An 1-D `int` Tensor. The shape of the desired output.
   * @return a new instance of BroadcastTo
   * @see org.tensorflow.op.core.BroadcastTo
   */
  public <T, U extends Number> BroadcastTo<T> broadcastTo(Operand<T> input, Operand<U> shape) {
    return BroadcastTo.create(scope, input, shape);
  }

  /**
   * Adds an {@link Maximum} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Maximum
   * @see org.tensorflow.op.core.Maximum
   */
  public <T extends Number> Maximum<T> maximum(Operand<T> x, Operand<T> y) {
    return Maximum.create(scope, x, y);
  }

  /**
   * Adds an {@link GetSessionHandleV2} operation to the graph
   *
   * @param value The tensor to be stored.
   * @return a new instance of GetSessionHandleV2
   * @see org.tensorflow.op.core.GetSessionHandleV2
   */
  public <T> GetSessionHandleV2 getSessionHandleV2(Operand<T> value) {
    return GetSessionHandleV2.create(scope, value);
  }

  /**
   * Adds an {@link ResourceApplyCenteredRMSProp} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param mg Should be from a Variable().
   * @param ms Should be from a Variable().
   * @param mom Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay rate. Must be a scalar.
   * @param momentum 
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyCenteredRMSProp
   * @see org.tensorflow.op.core.ResourceApplyCenteredRMSProp
   */
  public <T> ResourceApplyCenteredRMSProp resourceApplyCenteredRMSProp(Operand<?> var,
      Operand<?> mg, Operand<?> ms, Operand<?> mom, Operand<T> lr, Operand<T> rho,
      Operand<T> momentum, Operand<T> epsilon, Operand<T> grad,
      ResourceApplyCenteredRMSProp.Options... options) {
    return ResourceApplyCenteredRMSProp.create(scope, var, mg, ms, mom, lr, rho, momentum, epsilon, grad, options);
  }

  /**
   * Adds an {@link UnsortedSegmentSum} operation to the graph
   *
   * @param data 
   * @param segmentIds A tensor whose shape is a prefix of `data.shape`.
   * @param numSegments 
   * @return a new instance of UnsortedSegmentSum
   * @see org.tensorflow.op.core.UnsortedSegmentSum
   */
  public <T, U extends Number, V extends Number> UnsortedSegmentSum<T> unsortedSegmentSum(Operand<T> data,
      Operand<U> segmentIds, Operand<V> numSegments) {
    return UnsortedSegmentSum.create(scope, data, segmentIds, numSegments);
  }

  /**
   * Adds an {@link FixedLengthRecordReader} operation to the graph
   *
   * @param recordBytes Number of bytes in the record.
   * @param options carries optional attributes values
   * @return a new instance of FixedLengthRecordReader
   * @see org.tensorflow.op.core.FixedLengthRecordReader
   */
  public FixedLengthRecordReader fixedLengthRecordReader(Long recordBytes,
      FixedLengthRecordReader.Options... options) {
    return FixedLengthRecordReader.create(scope, recordBytes, options);
  }

  /**
   * Adds an {@link AccumulatorApplyGradient} operation to the graph
   *
   * @param handle The handle to a accumulator.
   * @param localStep The local_step value at which the gradient was computed.
   * @param gradient A tensor of the gradient to be accumulated.
   * @return a new instance of AccumulatorApplyGradient
   * @see org.tensorflow.op.core.AccumulatorApplyGradient
   */
  public <T> AccumulatorApplyGradient accumulatorApplyGradient(Operand<String> handle,
      Operand<Long> localStep, Operand<T> gradient) {
    return AccumulatorApplyGradient.create(scope, handle, localStep, gradient);
  }

  /**
   * Adds an {@link TensorArray} operation to the graph
   *
   * @param size The size of the array.
   * @param dtype The type of the elements on the tensor_array.
   * @param options carries optional attributes values
   * @return a new instance of TensorArray
   * @see org.tensorflow.op.core.TensorArray
   */
  public <T> TensorArray tensorArray(Operand<Integer> size, Class<T> dtype,
      TensorArray.Options... options) {
    return TensorArray.create(scope, size, dtype, options);
  }

  /**
   * Adds an {@link Gradients} operation to the graph
   *
   * @param y outputs of the function to derive
   * @param x inputs of the function for which partial derivatives are computed
   * @param options carries optional attributes values
   * @return a new instance of {@code Gradients}
   * @see org.tensorflow.op.core.Gradients
   */
  public Gradients gradients(Iterable<? extends Operand<?>> y, Iterable<? extends Operand<?>> x,
      Gradients.Options... options) {
    return Gradients.create(scope, y, x, options);
  }

  /**
   * Adds an {@link Snapshot} operation to the graph
   *
   * @param input 
   * @return a new instance of Snapshot
   * @see org.tensorflow.op.core.Snapshot
   */
  public <T> Snapshot<T> snapshot(Operand<T> input) {
    return Snapshot.create(scope, input);
  }

  /**
   * Adds an {@link FractionalMaxPool} operation to the graph
   *
   * @param value 4-D with shape `[batch, height, width, channels]`.
   * @param poolingRatio Pooling ratio for each dimension of `value`, currently only
   * @param options carries optional attributes values
   * @return a new instance of FractionalMaxPool
   * @see org.tensorflow.op.core.FractionalMaxPool
   */
  public <T extends Number> FractionalMaxPool<T> fractionalMaxPool(Operand<T> value,
      List<Float> poolingRatio, FractionalMaxPool.Options... options) {
    return FractionalMaxPool.create(scope, value, poolingRatio, options);
  }

  /**
   * Adds an {@link ComputeAccidentalHits} operation to the graph
   *
   * @param trueClasses The true_classes output of UnpackSparseLabels.
   * @param sampledCandidates The sampled_candidates output of CandidateSampler.
   * @param numTrue Number of true labels per context.
   * @param options carries optional attributes values
   * @return a new instance of ComputeAccidentalHits
   * @see org.tensorflow.op.core.ComputeAccidentalHits
   */
  public ComputeAccidentalHits computeAccidentalHits(Operand<Long> trueClasses,
      Operand<Long> sampledCandidates, Long numTrue, ComputeAccidentalHits.Options... options) {
    return ComputeAccidentalHits.create(scope, trueClasses, sampledCandidates, numTrue, options);
  }

  /**
   * Adds an {@link CheckNumerics} operation to the graph
   *
   * @param tensor 
   * @param message Prefix of the error message.
   * @return a new instance of CheckNumerics
   * @see org.tensorflow.op.core.CheckNumerics
   */
  public <T extends Number> CheckNumerics<T> checkNumerics(Operand<T> tensor, String message) {
    return CheckNumerics.create(scope, tensor, message);
  }

  /**
   * Adds an {@link CholeskyGrad} operation to the graph
   *
   * @param l Output of batch Cholesky algorithm l = cholesky(A). Shape is `[..., M, M]`.
   * @param grad df/dl where f is some scalar function. Shape is `[..., M, M]`.
   * @return a new instance of CholeskyGrad
   * @see org.tensorflow.op.core.CholeskyGrad
   */
  public <T extends Number> CholeskyGrad<T> choleskyGrad(Operand<T> l, Operand<T> grad) {
    return CholeskyGrad.create(scope, l, grad);
  }

  /**
   * Adds an {@link LogSoftmax} operation to the graph
   *
   * @param logits 2-D with shape `[batch_size, num_classes]`.
   * @return a new instance of LogSoftmax
   * @see org.tensorflow.op.core.LogSoftmax
   */
  public <T extends Number> LogSoftmax<T> logSoftmax(Operand<T> logits) {
    return LogSoftmax.create(scope, logits);
  }

  /**
   * Adds an {@link Gradients} operation to the graph
   *
   * @param y output of the function to derive
   * @param x inputs of the function for which partial derivatives are computed
   * @param options carries optional attributes values
   * @return a new instance of {@code Gradients}
   * @see org.tensorflow.op.core.Gradients
   */
  public Gradients gradients(Operand<?> y, Iterable<? extends Operand<?>> x,
      Gradients.Options... options) {
    return Gradients.create(scope, y, x, options);
  }

  /**
   * Adds an {@link TensorScatterAdd} operation to the graph
   *
   * @param tensor Tensor to copy/update.
   * @param indices Index tensor.
   * @param updates Updates to scatter into output.
   * @return a new instance of TensorScatterAdd
   * @see org.tensorflow.op.core.TensorScatterAdd
   */
  public <T, U extends Number> TensorScatterAdd<T> tensorScatterAdd(Operand<T> tensor,
      Operand<U> indices, Operand<T> updates) {
    return TensorScatterAdd.create(scope, tensor, indices, updates);
  }

  /**
   * Adds an {@link SaveSlices} operation to the graph
   *
   * @param filename Must have a single element. The name of the file to which we write the
   * @param tensorNames Shape `[N]`. The names of the tensors to be saved.
   * @param shapesAndSlices Shape `[N]`.  The shapes and slice specifications to use when
   * @param data `N` tensors to save.
   * @return a new instance of SaveSlices
   * @see org.tensorflow.op.core.SaveSlices
   */
  public SaveSlices saveSlices(Operand<String> filename, Operand<String> tensorNames,
      Operand<String> shapesAndSlices, Iterable<Operand<?>> data) {
    return SaveSlices.create(scope, filename, tensorNames, shapesAndSlices, data);
  }

  /**
   * Adds an {@link SparseTensorDenseMatMul} operation to the graph
   *
   * @param aIndices 2-D.  The `indices` of the `SparseTensor`, size `[nnz, 2]` Matrix.
   * @param aValues 1-D.  The `values` of the `SparseTensor`, size `[nnz]` Vector.
   * @param aShape 1-D.  The `shape` of the `SparseTensor`, size `[2]` Vector.
   * @param b 2-D.  A dense Matrix.
   * @param options carries optional attributes values
   * @return a new instance of SparseTensorDenseMatMul
   * @see org.tensorflow.op.core.SparseTensorDenseMatMul
   */
  public <U, T extends Number> SparseTensorDenseMatMul<U> sparseTensorDenseMatMul(Operand<T> aIndices,
      Operand<U> aValues, Operand<Long> aShape, Operand<U> b,
      SparseTensorDenseMatMul.Options... options) {
    return SparseTensorDenseMatMul.create(scope, aIndices, aValues, aShape, b, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data The value to put into the new constant. 
   * @return a float constant
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Float> constant(float data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link SparseDenseCwiseAdd} operation to the graph
   *
   * @param spIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param spValues 1-D.  `N` non-empty values corresponding to `sp_indices`.
   * @param spShape 1-D.  Shape of the input SparseTensor.
   * @param dense `R`-D.  The dense Tensor operand.
   * @return a new instance of SparseDenseCwiseAdd
   * @see org.tensorflow.op.core.SparseDenseCwiseAdd
   */
  public <T> SparseDenseCwiseAdd<T> sparseDenseCwiseAdd(Operand<Long> spIndices,
      Operand<T> spValues, Operand<Long> spShape, Operand<T> dense) {
    return SparseDenseCwiseAdd.create(scope, spIndices, spValues, spShape, dense);
  }

  /**
   * Adds an {@link ResourceSparseApplyFtrl} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param linear Should be from a Variable().
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param lrPower Scaling factor. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyFtrl
   * @see org.tensorflow.op.core.ResourceSparseApplyFtrl
   */
  public <T, U extends Number> ResourceSparseApplyFtrl resourceSparseApplyFtrl(Operand<?> var,
      Operand<?> accum, Operand<?> linear, Operand<T> grad, Operand<U> indices, Operand<T> lr,
      Operand<T> l1, Operand<T> l2, Operand<T> lrPower,
      ResourceSparseApplyFtrl.Options... options) {
    return ResourceSparseApplyFtrl.create(scope, var, accum, linear, grad, indices, lr, l1, l2, lrPower, options);
  }

  /**
   * Adds an {@link TensorListPopBack} operation to the graph
   *
   * @param inputHandle 
   * @param elementDtype 
   * @return a new instance of TensorListPopBack
   * @see org.tensorflow.op.core.TensorListPopBack
   */
  public <T> TensorListPopBack<T> tensorListPopBack(Operand<?> inputHandle, Class<T> elementDtype) {
    return TensorListPopBack.create(scope, inputHandle, elementDtype);
  }

  /**
   * Adds an {@link NonMaxSuppressionV2} operation to the graph
   *
   * @param boxes A 2-D float tensor of shape `[num_boxes, 4]`.
   * @param scores A 1-D float tensor of shape `[num_boxes]` representing a single
   * @param maxOutputSize A scalar integer tensor representing the maximum number of
   * @param iouThreshold A 0-D float tensor representing the threshold for deciding whether
   * @return a new instance of NonMaxSuppressionV2
   * @see org.tensorflow.op.core.NonMaxSuppressionV2
   */
  public <T extends Number> NonMaxSuppressionV2 nonMaxSuppressionV2(Operand<T> boxes,
      Operand<T> scores, Operand<Integer> maxOutputSize, Operand<Float> iouThreshold) {
    return NonMaxSuppressionV2.create(scope, boxes, scores, maxOutputSize, iouThreshold);
  }

  /**
   * Adds an {@link Variable} operation to the graph
   *
   * @param shape The shape of the variable tensor.
   * @param dtype The type of elements in the variable tensor.
   * @param options carries optional attributes values
   * @return a new instance of Variable
   * @see org.tensorflow.op.core.Variable
   */
  public <T> Variable<T> variable(Shape shape, Class<T> dtype, Variable.Options... options) {
    return Variable.create(scope, shape, dtype, options);
  }

  /**
   * Adds an {@link TensorArrayConcat} operation to the graph
   *
   * @param handle The handle to a TensorArray.
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @param dtype The type of the elem that is returned.
   * @param options carries optional attributes values
   * @return a new instance of TensorArrayConcat
   * @see org.tensorflow.op.core.TensorArrayConcat
   */
  public <T> TensorArrayConcat<T> tensorArrayConcat(Operand<?> handle, Operand<Float> flowIn,
      Class<T> dtype, TensorArrayConcat.Options... options) {
    return TensorArrayConcat.create(scope, handle, flowIn, dtype, options);
  }

  /**
   * Adds an {@link RandomGamma} operation to the graph
   *
   * @param shape 1-D integer tensor. Shape of independent samples to draw from each
   * @param alpha A tensor in which each scalar is a "shape" parameter describing the
   * @param options carries optional attributes values
   * @return a new instance of RandomGamma
   * @see org.tensorflow.op.core.RandomGamma
   */
  public <U extends Number, T extends Number> RandomGamma<U> randomGamma(Operand<T> shape,
      Operand<U> alpha, RandomGamma.Options... options) {
    return RandomGamma.create(scope, shape, alpha, options);
  }

  /**
   * Adds an {@link Reverse} operation to the graph
   *
   * @param tensor Up to 8-D.
   * @param axis 1-D. The indices of the dimensions to reverse. Must be in the range
   * @return a new instance of Reverse
   * @see org.tensorflow.op.core.Reverse
   */
  public <T, U extends Number> Reverse<T> reverse(Operand<T> tensor, Operand<U> axis) {
    return Reverse.create(scope, tensor, axis);
  }

  /**
   * Adds an {@link BatchToSpaceND} operation to the graph
   *
   * @param input N-D with shape `input_shape = [batch] + spatial_shape + remaining_shape`,
   * @param blockShape 1-D with shape `[M]`, all values must be >= 1.
   * @param crops 2-D with shape `[M, 2]`, all values must be >= 0.
   * @return a new instance of BatchToSpaceND
   * @see org.tensorflow.op.core.BatchToSpaceND
   */
  public <T, U extends Number, V extends Number> BatchToSpaceND<T> batchToSpaceND(Operand<T> input,
      Operand<U> blockShape, Operand<V> crops) {
    return BatchToSpaceND.create(scope, input, blockShape, crops);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. String elements are
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<String> constant(byte[][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link TakeManySparseFromTensorsMap} operation to the graph
   *
   * @param sparseHandles 1-D, The `N` serialized `SparseTensor` objects.
   * @param dtype The `dtype` of the `SparseTensor` objects stored in the
   * @param options carries optional attributes values
   * @return a new instance of TakeManySparseFromTensorsMap
   * @see org.tensorflow.op.core.TakeManySparseFromTensorsMap
   */
  public <T> TakeManySparseFromTensorsMap<T> takeManySparseFromTensorsMap(Operand<Long> sparseHandles,
      Class<T> dtype, TakeManySparseFromTensorsMap.Options... options) {
    return TakeManySparseFromTensorsMap.create(scope, sparseHandles, dtype, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. String elements are
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<String> constant(byte[][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ConsumeMutexLock} operation to the graph
   *
   * @param mutexLock A tensor returned by `MutexLock`.
   * @return a new instance of ConsumeMutexLock
   * @see org.tensorflow.op.core.ConsumeMutexLock
   */
  public ConsumeMutexLock consumeMutexLock(Operand<?> mutexLock) {
    return ConsumeMutexLock.create(scope, mutexLock);
  }

  /**
   * Adds an {@link Softplus} operation to the graph
   *
   * @param features 
   * @return a new instance of Softplus
   * @see org.tensorflow.op.core.Softplus
   */
  public <T extends Number> Softplus<T> softplus(Operand<T> features) {
    return Softplus.create(scope, features);
  }

  /**
   * Adds an {@link CTCBeamSearchDecoder} operation to the graph
   *
   * @param inputs 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
   * @param sequenceLength A vector containing sequence lengths, size `(batch)`.
   * @param beamWidth A scalar >= 0 (beam search beam width).
   * @param topPaths A scalar >= 0, <= beam_width (controls output size).
   * @param options carries optional attributes values
   * @return a new instance of CTCBeamSearchDecoder
   * @see org.tensorflow.op.core.CTCBeamSearchDecoder
   */
  public CTCBeamSearchDecoder cTCBeamSearchDecoder(Operand<Float> inputs,
      Operand<Integer> sequenceLength, Long beamWidth, Long topPaths,
      CTCBeamSearchDecoder.Options... options) {
    return CTCBeamSearchDecoder.create(scope, inputs, sequenceLength, beamWidth, topPaths, options);
  }

  /**
   * Adds an {@link ApplyAdagrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ApplyAdagrad
   * @see org.tensorflow.op.core.ApplyAdagrad
   */
  public <T> ApplyAdagrad<T> applyAdagrad(Operand<T> var, Operand<T> accum, Operand<T> lr,
      Operand<T> grad, ApplyAdagrad.Options... options) {
    return ApplyAdagrad.create(scope, var, accum, lr, grad, options);
  }

  /**
   * Adds an {@link SparseApplyAdagradDA} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param gradientAccumulator Should be from a Variable().
   * @param gradientSquaredAccumulator Should be from a Variable().
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param lr Learning rate. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param globalStep Training step number. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyAdagradDA
   * @see org.tensorflow.op.core.SparseApplyAdagradDA
   */
  public <T, U extends Number> SparseApplyAdagradDA<T> sparseApplyAdagradDA(Operand<T> var,
      Operand<T> gradientAccumulator, Operand<T> gradientSquaredAccumulator, Operand<T> grad,
      Operand<U> indices, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<Long> globalStep,
      SparseApplyAdagradDA.Options... options) {
    return SparseApplyAdagradDA.create(scope, var, gradientAccumulator, gradientSquaredAccumulator, grad, indices, lr, l1, l2, globalStep, options);
  }

  /**
   * Adds an {@link ComplexAbs} operation to the graph
   *
   * @param x 
   * @param Tout 
   * @return a new instance of ComplexAbs
   * @see org.tensorflow.op.core.ComplexAbs
   */
  public <U extends Number, T> ComplexAbs<U> complexAbs(Operand<T> x, Class<U> Tout) {
    return ComplexAbs.create(scope, x, Tout);
  }

  /**
   * Adds an {@link MakeIterator} operation to the graph
   *
   * @param dataset 
   * @param iterator 
   * @return a new instance of MakeIterator
   * @see org.tensorflow.op.core.MakeIterator
   */
  public MakeIterator makeIterator(Operand<?> dataset, Operand<?> iterator) {
    return MakeIterator.create(scope, dataset, iterator);
  }

  /**
   * Adds an {@link SparseSplit} operation to the graph
   *
   * @param splitDim 0-D.  The dimension along which to split.  Must be in the range
   * @param indices 2-D tensor represents the indices of the sparse tensor.
   * @param values 1-D tensor represents the values of the sparse tensor.
   * @param shape 1-D. tensor represents the shape of the sparse tensor.
   * @param numSplit The number of ways to split.
   * @return a new instance of SparseSplit
   * @see org.tensorflow.op.core.SparseSplit
   */
  public <T> SparseSplit<T> sparseSplit(Operand<Long> splitDim, Operand<Long> indices,
      Operand<T> values, Operand<Long> shape, Long numSplit) {
    return SparseSplit.create(scope, splitDim, indices, values, shape, numSplit);
  }

  /**
   * Adds an {@link ReaderNumWorkUnitsCompleted} operation to the graph
   *
   * @param readerHandle Handle to a Reader.
   * @return a new instance of ReaderNumWorkUnitsCompleted
   * @see org.tensorflow.op.core.ReaderNumWorkUnitsCompleted
   */
  public ReaderNumWorkUnitsCompleted readerNumWorkUnitsCompleted(Operand<?> readerHandle) {
    return ReaderNumWorkUnitsCompleted.create(scope, readerHandle);
  }

  /**
   * Adds an {@link BatchMatrixBandPart} operation to the graph
   *
   * @param input 
   * @param numLower 
   * @param numUpper 
   * @return a new instance of BatchMatrixBandPart
   * @see org.tensorflow.op.core.BatchMatrixBandPart
   */
  public <T> BatchMatrixBandPart<T> batchMatrixBandPart(Operand<T> input, Operand<Long> numLower,
      Operand<Long> numUpper) {
    return BatchMatrixBandPart.create(scope, input, numLower, numUpper);
  }

  /**
   * Adds an {@link OptionalFromValue} operation to the graph
   *
   * @param components 
   * @return a new instance of OptionalFromValue
   * @see org.tensorflow.op.core.OptionalFromValue
   */
  public OptionalFromValue optionalFromValue(Iterable<Operand<?>> components) {
    return OptionalFromValue.create(scope, components);
  }

  /**
   * Adds an {@link ReduceAll} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of ReduceAll
   * @see org.tensorflow.op.core.ReduceAll
   */
  public <T extends Number> ReduceAll reduceAll(Operand<Boolean> input, Operand<T> axis,
      ReduceAll.Options... options) {
    return ReduceAll.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link Div} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Div
   * @see org.tensorflow.op.core.Div
   */
  public <T> Div<T> div(Operand<T> x, Operand<T> y) {
    return Div.create(scope, x, y);
  }

  /**
   * Adds an {@link Concat} operation to the graph
   *
   * @param values List of `N` Tensors to concatenate. Their ranks and types must match,
   * @param axis 0-D.  The dimension along which to concatenate.  Must be in the
   * @return a new instance of Concat
   * @see org.tensorflow.op.core.Concat
   */
  public <T, U extends Number> Concat<T> concat(Operand<T> values, Operand<U> axis) {
    return Concat.create(scope, values, axis);
  }

  /**
   * Adds an {@link ResourceApplyAdadelta} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param accumUpdate Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay factor. Must be a scalar.
   * @param epsilon Constant factor. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyAdadelta
   * @see org.tensorflow.op.core.ResourceApplyAdadelta
   */
  public <T> ResourceApplyAdadelta resourceApplyAdadelta(Operand<?> var, Operand<?> accum,
      Operand<?> accumUpdate, Operand<T> lr, Operand<T> rho, Operand<T> epsilon, Operand<T> grad,
      ResourceApplyAdadelta.Options... options) {
    return ResourceApplyAdadelta.create(scope, var, accum, accumUpdate, lr, rho, epsilon, grad, options);
  }

  /**
   * Adds an {@link RandomShuffle} operation to the graph
   *
   * @param value The tensor to be shuffled.
   * @param options carries optional attributes values
   * @return a new instance of RandomShuffle
   * @see org.tensorflow.op.core.RandomShuffle
   */
  public <T> RandomShuffle<T> randomShuffle(Operand<T> value, RandomShuffle.Options... options) {
    return RandomShuffle.create(scope, value, options);
  }

  /**
   * Adds an {@link MutableHashTableOfTensors} operation to the graph
   *
   * @param keyDtype Type of the table keys.
   * @param valueDtype Type of the table values.
   * @param options carries optional attributes values
   * @return a new instance of MutableHashTableOfTensors
   * @see org.tensorflow.op.core.MutableHashTableOfTensors
   */
  public <T, U> MutableHashTableOfTensors mutableHashTableOfTensors(Class<T> keyDtype,
      Class<U> valueDtype, MutableHashTableOfTensors.Options... options) {
    return MutableHashTableOfTensors.create(scope, keyDtype, valueDtype, options);
  }

  /**
   * Adds an {@link SparseDenseCwiseDiv} operation to the graph
   *
   * @param spIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param spValues 1-D.  `N` non-empty values corresponding to `sp_indices`.
   * @param spShape 1-D.  Shape of the input SparseTensor.
   * @param dense `R`-D.  The dense Tensor operand.
   * @return a new instance of SparseDenseCwiseDiv
   * @see org.tensorflow.op.core.SparseDenseCwiseDiv
   */
  public <T> SparseDenseCwiseDiv<T> sparseDenseCwiseDiv(Operand<Long> spIndices,
      Operand<T> spValues, Operand<Long> spShape, Operand<T> dense) {
    return SparseDenseCwiseDiv.create(scope, spIndices, spValues, spShape, dense);
  }

  /**
   * Adds an {@link EncodeProto} operation to the graph
   *
   * @param sizes Tensor of int32 with shape `[batch_shape, len(field_names)]`.
   * @param values List of tensors containing values for the corresponding field.
   * @param fieldNames List of strings containing proto field names.
   * @param messageType Name of the proto message type to decode.
   * @param options carries optional attributes values
   * @return a new instance of EncodeProto
   * @see org.tensorflow.op.core.EncodeProto
   */
  public EncodeProto encodeProto(Operand<Integer> sizes, Iterable<Operand<?>> values,
      List<String> fieldNames, String messageType, EncodeProto.Options... options) {
    return EncodeProto.create(scope, sizes, values, fieldNames, messageType, options);
  }

  /**
   * Adds an {@link SparseReorder} operation to the graph
   *
   * @param inputIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param inputValues 1-D.  `N` non-empty values corresponding to `input_indices`.
   * @param inputShape 1-D.  Shape of the input SparseTensor.
   * @return a new instance of SparseReorder
   * @see org.tensorflow.op.core.SparseReorder
   */
  public <T> SparseReorder<T> sparseReorder(Operand<Long> inputIndices, Operand<T> inputValues,
      Operand<Long> inputShape) {
    return SparseReorder.create(scope, inputIndices, inputValues, inputShape);
  }

  /**
   * Adds an {@link UniqueWithCountsV2} operation to the graph
   *
   * @param x A `Tensor`.
   * @param axis A `Tensor` of type `int32` (default: None). The axis of the Tensor to
   * @param outIdx 
   * @return a new instance of UniqueWithCountsV2
   * @see org.tensorflow.op.core.UniqueWithCountsV2
   */
  public <T, V extends Number, U extends Number> UniqueWithCountsV2<T, V> uniqueWithCountsV2(Operand<T> x,
      Operand<U> axis, Class<V> outIdx) {
    return UniqueWithCountsV2.create(scope, x, axis, outIdx);
  }

  /**
   * Adds an {@link BatchMatMul} operation to the graph
   *
   * @param x 2-D or higher with shape `[..., r_x, c_x]`.
   * @param y 2-D or higher with shape `[..., r_y, c_y]`.
   * @param options carries optional attributes values
   * @return a new instance of BatchMatMul
   * @see org.tensorflow.op.core.BatchMatMul
   */
  public <T> BatchMatMul<T> batchMatMul(Operand<T> x, Operand<T> y,
      BatchMatMul.Options... options) {
    return BatchMatMul.create(scope, x, y, options);
  }

  /**
   * Adds an {@link UnicodeTranscode} operation to the graph
   *
   * @param input The text to be processed. Can have any shape.
   * @param inputEncoding Text encoding of the input strings. This is any of the encodings supported
   * @param outputEncoding The unicode encoding to use in the output. Must be one of
   * @param options carries optional attributes values
   * @return a new instance of UnicodeTranscode
   * @see org.tensorflow.op.core.UnicodeTranscode
   */
  public UnicodeTranscode unicodeTranscode(Operand<String> input, String inputEncoding,
      String outputEncoding, UnicodeTranscode.Options... options) {
    return UnicodeTranscode.create(scope, input, inputEncoding, outputEncoding, options);
  }

  /**
   * Adds an {@link ResourceSparseApplyAdagrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyAdagrad
   * @see org.tensorflow.op.core.ResourceSparseApplyAdagrad
   */
  public <T, U extends Number> ResourceSparseApplyAdagrad resourceSparseApplyAdagrad(Operand<?> var,
      Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices,
      ResourceSparseApplyAdagrad.Options... options) {
    return ResourceSparseApplyAdagrad.create(scope, var, accum, lr, grad, indices, options);
  }

  /**
   * Adds an {@link Squeeze} operation to the graph
   *
   * @param input The `input` to squeeze.
   * @param options carries optional attributes values
   * @return a new instance of Squeeze
   * @see org.tensorflow.op.core.Squeeze
   */
  public <T> Squeeze<T> squeeze(Operand<T> input, Squeeze.Options... options) {
    return Squeeze.create(scope, input, options);
  }

  /**
   * Adds an {@link DeepCopy} operation to the graph
   *
   * @param x The source tensor of type `T`.
   * @return a new instance of DeepCopy
   * @see org.tensorflow.op.core.DeepCopy
   */
  public <T> DeepCopy<T> deepCopy(Operand<T> x) {
    return DeepCopy.create(scope, x);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data The value to put into the new constant.
   * @return an integer constant
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Integer> constant(int data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link Conv3DBackpropFilterV2} operation to the graph
   *
   * @param input Shape `[batch, depth, rows, cols, in_channels]`.
   * @param filterSizes An integer vector representing the tensor shape of `filter`,
   * @param outBackprop Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of Conv3DBackpropFilterV2
   * @see org.tensorflow.op.core.Conv3DBackpropFilterV2
   */
  public <T extends Number> Conv3DBackpropFilterV2<T> conv3DBackpropFilterV2(Operand<T> input,
      Operand<Integer> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding,
      Conv3DBackpropFilterV2.Options... options) {
    return Conv3DBackpropFilterV2.create(scope, input, filterSizes, outBackprop, strides, padding, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Long> constant(long[] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. String elements are
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<String> constant(byte[][][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ReduceMin} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of ReduceMin
   * @see org.tensorflow.op.core.ReduceMin
   */
  public <T, U extends Number> ReduceMin<T> reduceMin(Operand<T> input, Operand<U> axis,
      ReduceMin.Options... options) {
    return ReduceMin.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link RegexReplace} operation to the graph
   *
   * @param input The text to be processed.
   * @param pattern The regular expression to match the input.
   * @param rewrite The rewrite to be applied to the matched expresion.
   * @param options carries optional attributes values
   * @return a new instance of RegexReplace
   * @see org.tensorflow.op.core.RegexReplace
   */
  public RegexReplace regexReplace(Operand<String> input, Operand<String> pattern,
      Operand<String> rewrite, RegexReplace.Options... options) {
    return RegexReplace.create(scope, input, pattern, rewrite, options);
  }

  /**
   * Adds an {@link QuantizedMatMul} operation to the graph
   *
   * @param a Must be a two-dimensional tensor.
   * @param b Must be a two-dimensional tensor.
   * @param minA The float value that the lowest quantized `a` value represents.
   * @param maxA The float value that the highest quantized `a` value represents.
   * @param minB The float value that the lowest quantized `b` value represents.
   * @param maxB The float value that the highest quantized `b` value represents.
   * @param Toutput 
   * @param Tactivation The type of output produced by activation function
   * @param options carries optional attributes values
   * @return a new instance of QuantizedMatMul
   * @see org.tensorflow.op.core.QuantizedMatMul
   */
  public <V, T, U, W> QuantizedMatMul<V> quantizedMatMul(Operand<T> a, Operand<U> b,
      Operand<Float> minA, Operand<Float> maxA, Operand<Float> minB, Operand<Float> maxB,
      Class<V> Toutput, Class<W> Tactivation, QuantizedMatMul.Options... options) {
    return QuantizedMatMul.create(scope, a, b, minA, maxA, minB, maxB, Toutput, Tactivation, options);
  }

  /**
   * Adds an {@link DeleteSessionTensor} operation to the graph
   *
   * @param handle The handle for a tensor stored in the session state.
   * @return a new instance of DeleteSessionTensor
   * @see org.tensorflow.op.core.DeleteSessionTensor
   */
  public DeleteSessionTensor deleteSessionTensor(Operand<String> handle) {
    return DeleteSessionTensor.create(scope, handle);
  }

  /**
   * Adds an {@link ResourceSparseApplyCenteredRMSProp} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param mg Should be from a Variable().
   * @param ms Should be from a Variable().
   * @param mom Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay rate. Must be a scalar.
   * @param momentum 
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var, ms and mom.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyCenteredRMSProp
   * @see org.tensorflow.op.core.ResourceSparseApplyCenteredRMSProp
   */
  public <T, U extends Number> ResourceSparseApplyCenteredRMSProp resourceSparseApplyCenteredRMSProp(Operand<?> var,
      Operand<?> mg, Operand<?> ms, Operand<?> mom, Operand<T> lr, Operand<T> rho,
      Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, Operand<U> indices,
      ResourceSparseApplyCenteredRMSProp.Options... options) {
    return ResourceSparseApplyCenteredRMSProp.create(scope, var, mg, ms, mom, lr, rho, momentum, epsilon, grad, indices, options);
  }

  /**
   * Adds an {@link MatrixDeterminant} operation to the graph
   *
   * @param input Shape is `[..., M, M]`.
   * @return a new instance of MatrixDeterminant
   * @see org.tensorflow.op.core.MatrixDeterminant
   */
  public <T> MatrixDeterminant<T> matrixDeterminant(Operand<T> input) {
    return MatrixDeterminant.create(scope, input);
  }

  /**
   * Adds an {@link TileGrad} operation to the graph
   *
   * @param input 
   * @param multiples 
   * @return a new instance of TileGrad
   * @see org.tensorflow.op.core.TileGrad
   */
  public <T> TileGrad<T> tileGrad(Operand<T> input, Operand<Integer> multiples) {
    return TileGrad.create(scope, input, multiples);
  }

  /**
   * Adds an {@link RightShift} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of RightShift
   * @see org.tensorflow.op.core.RightShift
   */
  public <T extends Number> RightShift<T> rightShift(Operand<T> x, Operand<T> y) {
    return RightShift.create(scope, x, y);
  }

  /**
   * Adds an {@link ReaderSerializeState} operation to the graph
   *
   * @param readerHandle Handle to a Reader.
   * @return a new instance of ReaderSerializeState
   * @see org.tensorflow.op.core.ReaderSerializeState
   */
  public ReaderSerializeState readerSerializeState(Operand<?> readerHandle) {
    return ReaderSerializeState.create(scope, readerHandle);
  }

  /**
   * Adds an {@link Save} operation to the graph
   *
   * @param filename Must have a single element. The name of the file to which we write
   * @param tensorNames Shape `[N]`. The names of the tensors to be saved.
   * @param data `N` tensors to save.
   * @return a new instance of Save
   * @see org.tensorflow.op.core.Save
   */
  public Save save(Operand<String> filename, Operand<String> tensorNames,
      Iterable<Operand<?>> data) {
    return Save.create(scope, filename, tensorNames, data);
  }

  /**
   * Adds an {@link Xlogy} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Xlogy
   * @see org.tensorflow.op.core.Xlogy
   */
  public <T> Xlogy<T> xlogy(Operand<T> x, Operand<T> y) {
    return Xlogy.create(scope, x, y);
  }

  /**
   * Adds an {@link TensorListConcat} operation to the graph
   *
   * @param inputHandle 
   * @param elementDtype 
   * @return a new instance of TensorListConcat
   * @see org.tensorflow.op.core.TensorListConcat
   */
  public <T> TensorListConcat<T> tensorListConcat(Operand<?> inputHandle, Class<T> elementDtype) {
    return TensorListConcat.create(scope, inputHandle, elementDtype);
  }

  /**
   * Adds an {@link ImageSummary} operation to the graph
   *
   * @param tag Scalar. Used to build the `tag` attribute of the summary values.
   * @param tensor 4-D of shape `[batch_size, height, width, channels]` where
   * @param options carries optional attributes values
   * @return a new instance of ImageSummary
   * @see org.tensorflow.op.core.ImageSummary
   */
  public <T extends Number> ImageSummary imageSummary(Operand<String> tag, Operand<T> tensor,
      ImageSummary.Options... options) {
    return ImageSummary.create(scope, tag, tensor, options);
  }

  /**
   * Adds an {@link TensorListSplit} operation to the graph
   *
   * @param tensor 
   * @param elementShape 
   * @param lengths 
   * @return a new instance of TensorListSplit
   * @see org.tensorflow.op.core.TensorListSplit
   */
  public <T, U extends Number> TensorListSplit tensorListSplit(Operand<T> tensor,
      Operand<U> elementShape, Operand<Long> lengths) {
    return TensorListSplit.create(scope, tensor, elementShape, lengths);
  }

  /**
   * Adds an {@link NextIteration} operation to the graph
   *
   * @param data The tensor to be made available to the next iteration.
   * @return a new instance of NextIteration
   * @see org.tensorflow.op.core.NextIteration
   */
  public <T> NextIteration<T> nextIteration(Operand<T> data) {
    return NextIteration.create(scope, data);
  }

  /**
   * Adds an {@link MutableDenseHashTable} operation to the graph
   *
   * @param emptyKey The key used to represent empty key buckets internally. Must not
   * @param deletedKey 
   * @param valueDtype Type of the table values.
   * @param options carries optional attributes values
   * @return a new instance of MutableDenseHashTable
   * @see org.tensorflow.op.core.MutableDenseHashTable
   */
  public <T, U> MutableDenseHashTable mutableDenseHashTable(Operand<T> emptyKey,
      Operand<T> deletedKey, Class<U> valueDtype, MutableDenseHashTable.Options... options) {
    return MutableDenseHashTable.create(scope, emptyKey, deletedKey, valueDtype, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param shape the tensor shape.
   * @param data a buffer containing the tensor data.
   * @return an integer constant
   * @throws IllegalArgumentException If the tensor shape is not compatible with the buffer
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Integer> constant(long[] shape, IntBuffer data) {
    return Constant.create(scope, shape, data);
  }

  /**
   * Adds an {@link QuantizedResizeBilinear} operation to the graph
   *
   * @param images 4-D with shape `[batch, height, width, channels]`.
   * @param size = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
   * @param min 
   * @param max 
   * @param options carries optional attributes values
   * @return a new instance of QuantizedResizeBilinear
   * @see org.tensorflow.op.core.QuantizedResizeBilinear
   */
  public <T> QuantizedResizeBilinear<T> quantizedResizeBilinear(Operand<T> images,
      Operand<Integer> size, Operand<Float> min, Operand<Float> max,
      QuantizedResizeBilinear.Options... options) {
    return QuantizedResizeBilinear.create(scope, images, size, min, max, options);
  }

  /**
   * Adds an {@link RandomCrop} operation to the graph
   *
   * @param image 3-D of shape `[height, width, channels]`.
   * @param size 1-D of length 2 containing: `crop_height`, `crop_width`..
   * @param options carries optional attributes values
   * @return a new instance of RandomCrop
   * @see org.tensorflow.op.core.RandomCrop
   */
  public <T extends Number> RandomCrop<T> randomCrop(Operand<T> image, Operand<Long> size,
      RandomCrop.Options... options) {
    return RandomCrop.create(scope, image, size, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Double> constant(double[][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link SelfAdjointEig} operation to the graph
   *
   * @param input `Tensor` input of shape `[N, N]`.
   * @param options carries optional attributes values
   * @return a new instance of SelfAdjointEig
   * @see org.tensorflow.op.core.SelfAdjointEig
   */
  public <T> SelfAdjointEig<T> selfAdjointEig(Operand<T> input, SelfAdjointEig.Options... options) {
    return SelfAdjointEig.create(scope, input, options);
  }

  /**
   * Adds an {@link MaxPoolGradGradWithArgmax} operation to the graph
   *
   * @param input The original input.
   * @param grad 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t. the
   * @param argmax The indices of the maximum values chosen for each output of `max_pool`.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * @param padding The type of padding algorithm to use.
   * @return a new instance of MaxPoolGradGradWithArgmax
   * @see org.tensorflow.op.core.MaxPoolGradGradWithArgmax
   */
  public <T extends Number, U extends Number> MaxPoolGradGradWithArgmax<T> maxPoolGradGradWithArgmax(Operand<T> input,
      Operand<T> grad, Operand<U> argmax, List<Long> ksize, List<Long> strides, String padding) {
    return MaxPoolGradGradWithArgmax.create(scope, input, grad, argmax, ksize, strides, padding);
  }

  /**
   * Adds an {@link Minimum} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Minimum
   * @see org.tensorflow.op.core.Minimum
   */
  public <T extends Number> Minimum<T> minimum(Operand<T> x, Operand<T> y) {
    return Minimum.create(scope, x, y);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Integer> constant(int[][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link Atan2} operation to the graph
   *
   * @param y 
   * @param x 
   * @return a new instance of Atan2
   * @see org.tensorflow.op.core.Atan2
   */
  public <T extends Number> Atan2<T> atan2(Operand<T> y, Operand<T> x) {
    return Atan2.create(scope, y, x);
  }

  /**
   * Adds an {@link Empty} operation to the graph
   *
   * @param shape 1-D. Represents the shape of the output tensor.
   * @param dtype 
   * @param options carries optional attributes values
   * @return a new instance of Empty
   * @see org.tensorflow.op.core.Empty
   */
  public <T> Empty<T> empty(Operand<Integer> shape, Class<T> dtype, Empty.Options... options) {
    return Empty.create(scope, shape, dtype, options);
  }

  /**
   * Adds an {@link ResourceSparseApplyFtrlV2} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param linear Should be from a Variable().
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 shrinkage regulariation. Must be a scalar.
   * @param l2Shrinkage 
   * @param lrPower Scaling factor. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyFtrlV2
   * @see org.tensorflow.op.core.ResourceSparseApplyFtrlV2
   */
  public <T, U extends Number> ResourceSparseApplyFtrlV2 resourceSparseApplyFtrlV2(Operand<?> var,
      Operand<?> accum, Operand<?> linear, Operand<T> grad, Operand<U> indices, Operand<T> lr,
      Operand<T> l1, Operand<T> l2, Operand<T> l2Shrinkage, Operand<T> lrPower,
      ResourceSparseApplyFtrlV2.Options... options) {
    return ResourceSparseApplyFtrlV2.create(scope, var, accum, linear, grad, indices, lr, l1, l2, l2Shrinkage, lrPower, options);
  }

  /**
   * Adds an {@link FFT2D} operation to the graph
   *
   * @param input A complex tensor.
   * @return a new instance of FFT2D
   * @see org.tensorflow.op.core.FFT2D
   */
  public <T> FFT2D<T> fFT2D(Operand<T> input) {
    return FFT2D.create(scope, input);
  }

  /**
   * Adds an {@link StatelessRandomNormal} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param seed 2 seeds (shape [2]).
   * @return a new instance of StatelessRandomNormal
   * @see org.tensorflow.op.core.StatelessRandomNormal
   */
  public <T extends Number, U extends Number> StatelessRandomNormal<Float> statelessRandomNormal(Operand<T> shape,
      Operand<U> seed) {
    return StatelessRandomNormal.create(scope, shape, seed);
  }

  /**
   * Adds an {@link MapPeek} operation to the graph
   *
   * @param key 
   * @param indices 
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of MapPeek
   * @see org.tensorflow.op.core.MapPeek
   */
  public MapPeek mapPeek(Operand<Long> key, Operand<Integer> indices, List<Class<?>> dtypes,
      MapPeek.Options... options) {
    return MapPeek.create(scope, key, indices, dtypes, options);
  }

  /**
   * Adds an {@link OrderedMapUnstageNoKey} operation to the graph
   *
   * @param indices 
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of OrderedMapUnstageNoKey
   * @see org.tensorflow.op.core.OrderedMapUnstageNoKey
   */
  public OrderedMapUnstageNoKey orderedMapUnstageNoKey(Operand<Integer> indices,
      List<Class<?>> dtypes, OrderedMapUnstageNoKey.Options... options) {
    return OrderedMapUnstageNoKey.create(scope, indices, dtypes, options);
  }

  /**
   * Adds an {@link Dequantize} operation to the graph
   *
   * @param input 
   * @param minRange The minimum scalar value possibly produced for the input.
   * @param maxRange The maximum scalar value possibly produced for the input.
   * @param options carries optional attributes values
   * @return a new instance of Dequantize
   * @see org.tensorflow.op.core.Dequantize
   */
  public <T> Dequantize dequantize(Operand<T> input, Operand<Float> minRange,
      Operand<Float> maxRange, Dequantize.Options... options) {
    return Dequantize.create(scope, input, minRange, maxRange, options);
  }

  /**
   * Adds an {@link SparseSegmentMean} operation to the graph
   *
   * @param data 
   * @param indices A 1-D tensor. Has same rank as `segment_ids`.
   * @param segmentIds A 1-D tensor. Values should be sorted and can be repeated.
   * @return a new instance of SparseSegmentMean
   * @see org.tensorflow.op.core.SparseSegmentMean
   */
  public <T extends Number, U extends Number> SparseSegmentMean<T> sparseSegmentMean(Operand<T> data,
      Operand<U> indices, Operand<Integer> segmentIds) {
    return SparseSegmentMean.create(scope, data, indices, segmentIds);
  }

  /**
   * Adds an {@link AccumulatorTakeGradient} operation to the graph
   *
   * @param handle The handle to an accumulator.
   * @param numRequired Number of gradients required before we return an aggregate.
   * @param dtype The data type of accumulated gradients. Needs to correspond to the type
   * @return a new instance of AccumulatorTakeGradient
   * @see org.tensorflow.op.core.AccumulatorTakeGradient
   */
  public <T> AccumulatorTakeGradient<T> accumulatorTakeGradient(Operand<String> handle,
      Operand<Integer> numRequired, Class<T> dtype) {
    return AccumulatorTakeGradient.create(scope, handle, numRequired, dtype);
  }

  /**
   * Adds an {@link Slice} operation to the graph
   *
   * @param input 
   * @param begin begin[i] specifies the offset into the 'i'th dimension of
   * @param size size[i] specifies the number of elements of the 'i'th dimension
   * @return a new instance of Slice
   * @see org.tensorflow.op.core.Slice
   */
  public <T, U extends Number> Slice<T> slice(Operand<T> input, Operand<U> begin, Operand<U> size) {
    return Slice.create(scope, input, begin, size);
  }

  /**
   * Adds an {@link Skipgram} operation to the graph
   *
   * @param filename The corpus's text file name.
   * @param batchSize The size of produced batch.
   * @param options carries optional attributes values
   * @return a new instance of Skipgram
   * @see org.tensorflow.op.core.Skipgram
   */
  public Skipgram skipgram(String filename, Long batchSize, Skipgram.Options... options) {
    return Skipgram.create(scope, filename, batchSize, options);
  }

  /**
   * Adds an {@link GenerateVocabRemapping} operation to the graph
   *
   * @param newVocabFile Path to the new vocab file.
   * @param oldVocabFile Path to the old vocab file.
   * @param newVocabOffset How many entries into the new vocab file to start reading.
   * @param numNewVocab Number of entries in the new vocab file to remap.
   * @param options carries optional attributes values
   * @return a new instance of GenerateVocabRemapping
   * @see org.tensorflow.op.core.GenerateVocabRemapping
   */
  public GenerateVocabRemapping generateVocabRemapping(Operand<String> newVocabFile,
      Operand<String> oldVocabFile, Long newVocabOffset, Long numNewVocab,
      GenerateVocabRemapping.Options... options) {
    return GenerateVocabRemapping.create(scope, newVocabFile, oldVocabFile, newVocabOffset, numNewVocab, options);
  }

  /**
   * Adds an {@link NotEqual} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of NotEqual
   * @see org.tensorflow.op.core.NotEqual
   */
  public <T> NotEqual notEqual(Operand<T> x, Operand<T> y) {
    return NotEqual.create(scope, x, y);
  }

  /**
   * Adds an {@link UniqueWithCounts} operation to the graph
   *
   * @param x 1-D.
   * @return a new instance of UniqueWithCounts
   * @see org.tensorflow.op.core.UniqueWithCounts
   */
  public <T> UniqueWithCounts<T, Integer> uniqueWithCounts(Operand<T> x) {
    return UniqueWithCounts.create(scope, x);
  }

  /**
   * Adds an {@link FakeQuantWithMinMaxArgsGradient} operation to the graph
   *
   * @param gradients Backpropagated gradients above the FakeQuantWithMinMaxArgs operation.
   * @param inputs Values passed as inputs to the FakeQuantWithMinMaxArgs operation.
   * @param options carries optional attributes values
   * @return a new instance of FakeQuantWithMinMaxArgsGradient
   * @see org.tensorflow.op.core.FakeQuantWithMinMaxArgsGradient
   */
  public FakeQuantWithMinMaxArgsGradient fakeQuantWithMinMaxArgsGradient(Operand<Float> gradients,
      Operand<Float> inputs, FakeQuantWithMinMaxArgsGradient.Options... options) {
    return FakeQuantWithMinMaxArgsGradient.create(scope, gradients, inputs, options);
  }

  /**
   * Adds an {@link ResourceScatterNdAdd} operation to the graph
   *
   * @param ref A resource handle. Must be from a VarHandleOp.
   * @param indices A Tensor. Must be one of the following types: int32, int64.
   * @param updates A Tensor. Must have the same type as ref. A tensor of
   * @param options carries optional attributes values
   * @return a new instance of ResourceScatterNdAdd
   * @see org.tensorflow.op.core.ResourceScatterNdAdd
   */
  public <T extends Number, U> ResourceScatterNdAdd resourceScatterNdAdd(Operand<?> ref,
      Operand<T> indices, Operand<U> updates, ResourceScatterNdAdd.Options... options) {
    return ResourceScatterNdAdd.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link OrderedMapStage} operation to the graph
   *
   * @param key int64
   * @param indices 
   * @param values a list of tensors
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of OrderedMapStage
   * @see org.tensorflow.op.core.OrderedMapStage
   */
  public OrderedMapStage orderedMapStage(Operand<Long> key, Operand<Integer> indices,
      Iterable<Operand<?>> values, List<Class<?>> dtypes, OrderedMapStage.Options... options) {
    return OrderedMapStage.create(scope, key, indices, values, dtypes, options);
  }

  /**
   * Adds an {@link StatelessRandomUniform} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param seed 2 seeds (shape [2]).
   * @param dtype The type of the output.
   * @return a new instance of StatelessRandomUniform
   * @see org.tensorflow.op.core.StatelessRandomUniform
   */
  public <V extends Number, T extends Number, U extends Number> StatelessRandomUniform<V> statelessRandomUniform(Operand<T> shape,
      Operand<U> seed, Class<V> dtype) {
    return StatelessRandomUniform.create(scope, shape, seed, dtype);
  }

  /**
   * Adds an {@link SoftmaxCrossEntropyWithLogits} operation to the graph
   *
   * @param features batch_size x num_classes matrix
   * @param labels batch_size x num_classes matrix
   * @return a new instance of SoftmaxCrossEntropyWithLogits
   * @see org.tensorflow.op.core.SoftmaxCrossEntropyWithLogits
   */
  public <T extends Number> SoftmaxCrossEntropyWithLogits<T> softmaxCrossEntropyWithLogits(Operand<T> features,
      Operand<T> labels) {
    return SoftmaxCrossEntropyWithLogits.create(scope, features, labels);
  }

  /**
   * Adds an {@link ShapeN} operation to the graph
   *
   * @param input 
   * @param outType 
   * @return a new instance of ShapeN
   * @see org.tensorflow.op.core.ShapeN
   */
  public <U extends Number, T> ShapeN<U> shapeN(Operand<T> input, Class<U> outType) {
    return ShapeN.create(scope, input, outType);
  }

  /**
   * Adds an {@link ExtractJpegShape} operation to the graph
   *
   * @param contents 0-D. The JPEG-encoded image.
   * @param outputType (Optional) The output type of the operation (int32 or int64).
   * @return a new instance of ExtractJpegShape
   * @see org.tensorflow.op.core.ExtractJpegShape
   */
  public <T extends Number> ExtractJpegShape<T> extractJpegShape(Operand<String> contents,
      Class<T> outputType) {
    return ExtractJpegShape.create(scope, contents, outputType);
  }

  /**
   * Adds an {@link Print} operation to the graph
   *
   * @param input The tensor passed to `output`
   * @param data A list of tensors to print out when op is evaluated.
   * @param options carries optional attributes values
   * @return a new instance of Print
   * @see org.tensorflow.op.core.Print
   */
  public <T> Print<T> print(Operand<T> input, Iterable<Operand<?>> data, Print.Options... options) {
    return Print.create(scope, input, data, options);
  }

  /**
   * Adds an {@link ResourceApplyProximalAdagrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyProximalAdagrad
   * @see org.tensorflow.op.core.ResourceApplyProximalAdagrad
   */
  public <T> ResourceApplyProximalAdagrad resourceApplyProximalAdagrad(Operand<?> var,
      Operand<?> accum, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> grad,
      ResourceApplyProximalAdagrad.Options... options) {
    return ResourceApplyProximalAdagrad.create(scope, var, accum, lr, l1, l2, grad, options);
  }

  /**
   * Adds an {@link IdentityReader} operation to the graph
   *
   * @param options carries optional attributes values
   * @return a new instance of IdentityReader
   * @see org.tensorflow.op.core.IdentityReader
   */
  public IdentityReader identityReader(IdentityReader.Options... options) {
    return IdentityReader.create(scope, options);
  }

  /**
   * Adds an {@link UnsortedSegmentProd} operation to the graph
   *
   * @param data 
   * @param segmentIds A tensor whose shape is a prefix of `data.shape`.
   * @param numSegments 
   * @return a new instance of UnsortedSegmentProd
   * @see org.tensorflow.op.core.UnsortedSegmentProd
   */
  public <T, U extends Number, V extends Number> UnsortedSegmentProd<T> unsortedSegmentProd(Operand<T> data,
      Operand<U> segmentIds, Operand<V> numSegments) {
    return UnsortedSegmentProd.create(scope, data, segmentIds, numSegments);
  }

  /**
   * Adds an {@link Tan} operation to the graph
   *
   * @param x 
   * @return a new instance of Tan
   * @see org.tensorflow.op.core.Tan
   */
  public <T> Tan<T> tan(Operand<T> x) {
    return Tan.create(scope, x);
  }

  /**
   * Adds an {@link LoopCond} operation to the graph
   *
   * @param input A boolean scalar, representing the branch predicate of the Switch op.
   * @return a new instance of LoopCond
   * @see org.tensorflow.op.core.LoopCond
   */
  public LoopCond loopCond(Operand<Boolean> input) {
    return LoopCond.create(scope, input);
  }

  /**
   * Adds an {@link ArgMin} operation to the graph
   *
   * @param input 
   * @param dimension int32 or int64, must be in the range `[-rank(input), rank(input))`.
   * @param outputType 
   * @return a new instance of ArgMin
   * @see org.tensorflow.op.core.ArgMin
   */
  public <V extends Number, T, U extends Number> ArgMin<V> argMin(Operand<T> input,
      Operand<U> dimension, Class<V> outputType) {
    return ArgMin.create(scope, input, dimension, outputType);
  }

  /**
   * Adds an {@link BatchToSpace} operation to the graph
   *
   * @param input 4-D tensor with shape
   * @param crops 2-D tensor of non-negative integers with shape `[2, 2]`. It specifies
   * @param blockSize 
   * @return a new instance of BatchToSpace
   * @see org.tensorflow.op.core.BatchToSpace
   */
  public <T, U extends Number> BatchToSpace<T> batchToSpace(Operand<T> input, Operand<U> crops,
      Long blockSize) {
    return BatchToSpace.create(scope, input, crops, blockSize);
  }

  /**
   * Adds an {@link QuantizedRelu} operation to the graph
   *
   * @param features 
   * @param minFeatures The float value that the lowest quantized value represents.
   * @param maxFeatures The float value that the highest quantized value represents.
   * @param outType 
   * @return a new instance of QuantizedRelu
   * @see org.tensorflow.op.core.QuantizedRelu
   */
  public <U, T> QuantizedRelu<U> quantizedRelu(Operand<T> features, Operand<Float> minFeatures,
      Operand<Float> maxFeatures, Class<U> outType) {
    return QuantizedRelu.create(scope, features, minFeatures, maxFeatures, outType);
  }

  /**
   * Adds an {@link BarrierReadySize} operation to the graph
   *
   * @param handle The handle to a barrier.
   * @return a new instance of BarrierReadySize
   * @see org.tensorflow.op.core.BarrierReadySize
   */
  public BarrierReadySize barrierReadySize(Operand<String> handle) {
    return BarrierReadySize.create(scope, handle);
  }

  /**
   * Adds an {@link SegmentMean} operation to the graph
   *
   * @param data 
   * @param segmentIds A 1-D tensor whose size is equal to the size of `data`'s
   * @return a new instance of SegmentMean
   * @see org.tensorflow.op.core.SegmentMean
   */
  public <T, U extends Number> SegmentMean<T> segmentMean(Operand<T> data, Operand<U> segmentIds) {
    return SegmentMean.create(scope, data, segmentIds);
  }

  /**
   * Adds an {@link Conv3DBackpropInput} operation to the graph
   *
   * @param input Shape `[batch, depth, rows, cols, in_channels]`.
   * @param filter Shape `[depth, rows, cols, in_channels, out_channels]`.
   * @param outBackprop Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of Conv3DBackpropInput
   * @see org.tensorflow.op.core.Conv3DBackpropInput
   */
  public <T extends Number> Conv3DBackpropInput<T> conv3DBackpropInput(Operand<T> input,
      Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding,
      Conv3DBackpropInput.Options... options) {
    return Conv3DBackpropInput.create(scope, input, filter, outBackprop, strides, padding, options);
  }

  /**
   * Adds an {@link CropAndResizeGradBoxes} operation to the graph
   *
   * @param grads A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
   * @param image A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
   * @param boxes A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
   * @param boxInd A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
   * @param options carries optional attributes values
   * @return a new instance of CropAndResizeGradBoxes
   * @see org.tensorflow.op.core.CropAndResizeGradBoxes
   */
  public <T extends Number> CropAndResizeGradBoxes cropAndResizeGradBoxes(Operand<Float> grads,
      Operand<T> image, Operand<Float> boxes, Operand<Integer> boxInd,
      CropAndResizeGradBoxes.Options... options) {
    return CropAndResizeGradBoxes.create(scope, grads, image, boxes, boxInd, options);
  }

  /**
   * Adds an {@link Igammac} operation to the graph
   *
   * @param a 
   * @param x 
   * @return a new instance of Igammac
   * @see org.tensorflow.op.core.Igammac
   */
  public <T extends Number> Igammac<T> igammac(Operand<T> a, Operand<T> x) {
    return Igammac.create(scope, a, x);
  }

  /**
   * Adds an {@link Barrier} operation to the graph
   *
   * @param componentTypes The type of each component in a value.
   * @param options carries optional attributes values
   * @return a new instance of Barrier
   * @see org.tensorflow.op.core.Barrier
   */
  public Barrier barrier(List<Class<?>> componentTypes, Barrier.Options... options) {
    return Barrier.create(scope, componentTypes, options);
  }

  /**
   * Adds an {@link ScatterAdd} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to add to `ref`.
   * @param options carries optional attributes values
   * @return a new instance of ScatterAdd
   * @see org.tensorflow.op.core.ScatterAdd
   */
  public <T, U extends Number> ScatterAdd<T> scatterAdd(Operand<T> ref, Operand<U> indices,
      Operand<T> updates, ScatterAdd.Options... options) {
    return ScatterAdd.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Float> constant(float[][][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ShardedFilename} operation to the graph
   *
   * @param basename 
   * @param shard 
   * @param numShards 
   * @return a new instance of ShardedFilename
   * @see org.tensorflow.op.core.ShardedFilename
   */
  public ShardedFilename shardedFilename(Operand<String> basename, Operand<Integer> shard,
      Operand<Integer> numShards) {
    return ShardedFilename.create(scope, basename, shard, numShards);
  }

  /**
   * Adds an {@link Mean} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of Mean
   * @see org.tensorflow.op.core.Mean
   */
  public <T, U extends Number> Mean<T> mean(Operand<T> input, Operand<U> axis,
      Mean.Options... options) {
    return Mean.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link AdjustHue} operation to the graph
   *
   * @param images Images to adjust.  At least 3-D.
   * @param delta A float delta to add to the hue.
   * @return a new instance of AdjustHue
   * @see org.tensorflow.op.core.AdjustHue
   */
  public AdjustHue adjustHue(Operand<Float> images, Operand<Float> delta) {
    return AdjustHue.create(scope, images, delta);
  }

  /**
   * Adds an {@link ParallelConcat} operation to the graph
   *
   * @param values Tensors to be concatenated. All must have size 1 in the first dimension
   * @param shape the final shape of the result; should be equal to the shapes of any input
   * @return a new instance of ParallelConcat
   * @see org.tensorflow.op.core.ParallelConcat
   */
  public <T> ParallelConcat<T> parallelConcat(Operand<T> values, Shape shape) {
    return ParallelConcat.create(scope, values, shape);
  }

  /**
   * Adds an {@link ResourceGather} operation to the graph
   *
   * @param resource 
   * @param indices 
   * @param dtype 
   * @param options carries optional attributes values
   * @return a new instance of ResourceGather
   * @see org.tensorflow.op.core.ResourceGather
   */
  public <U, T extends Number> ResourceGather<U> resourceGather(Operand<?> resource,
      Operand<T> indices, Class<U> dtype, ResourceGather.Options... options) {
    return ResourceGather.create(scope, resource, indices, dtype, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Boolean> constant(boolean[][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link LogicalAnd} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of LogicalAnd
   * @see org.tensorflow.op.core.LogicalAnd
   */
  public LogicalAnd logicalAnd(Operand<Boolean> x, Operand<Boolean> y) {
    return LogicalAnd.create(scope, x, y);
  }

  /**
   * Adds an {@link DecodeBase64} operation to the graph
   *
   * @param input Base64 strings to decode.
   * @return a new instance of DecodeBase64
   * @see org.tensorflow.op.core.DecodeBase64
   */
  public DecodeBase64 decodeBase64(Operand<String> input) {
    return DecodeBase64.create(scope, input);
  }

  /**
   * Adds an {@link ShapeN} operation to the graph
   *
   * @param input 
   * @return a new instance of ShapeN
   * @see org.tensorflow.op.core.ShapeN
   */
  public <T> ShapeN<Integer> shapeN(Operand<T> input) {
    return ShapeN.create(scope, input);
  }

  /**
   * Adds an {@link RequantizationRange} operation to the graph
   *
   * @param input 
   * @param inputMin The float value that the minimum quantized input value represents.
   * @param inputMax The float value that the maximum quantized input value represents.
   * @return a new instance of RequantizationRange
   * @see org.tensorflow.op.core.RequantizationRange
   */
  public <T> RequantizationRange requantizationRange(Operand<T> input, Operand<Float> inputMin,
      Operand<Float> inputMax) {
    return RequantizationRange.create(scope, input, inputMin, inputMax);
  }

  /**
   * Adds an {@link ConditionalAccumulator} operation to the graph
   *
   * @param dtype The type of the value being accumulated.
   * @param shape The shape of the values, can be [], in which case shape is unknown.
   * @param options carries optional attributes values
   * @return a new instance of ConditionalAccumulator
   * @see org.tensorflow.op.core.ConditionalAccumulator
   */
  public <T> ConditionalAccumulator conditionalAccumulator(Class<T> dtype, Shape shape,
      ConditionalAccumulator.Options... options) {
    return ConditionalAccumulator.create(scope, dtype, shape, options);
  }

  /**
   * Adds an {@link ApplyFtrl} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param linear Should be from a Variable().
   * @param grad The gradient.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regulariation. Must be a scalar.
   * @param l2 L2 regulariation. Must be a scalar.
   * @param lrPower Scaling factor. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ApplyFtrl
   * @see org.tensorflow.op.core.ApplyFtrl
   */
  public <T> ApplyFtrl<T> applyFtrl(Operand<T> var, Operand<T> accum, Operand<T> linear,
      Operand<T> grad, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> lrPower,
      ApplyFtrl.Options... options) {
    return ApplyFtrl.create(scope, var, accum, linear, grad, lr, l1, l2, lrPower, options);
  }

  /**
   * Adds an {@link TruncateMod} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of TruncateMod
   * @see org.tensorflow.op.core.TruncateMod
   */
  public <T extends Number> TruncateMod<T> truncateMod(Operand<T> x, Operand<T> y) {
    return TruncateMod.create(scope, x, y);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Float> constant(float[][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link SparseMatMul} operation to the graph
   *
   * @param a 
   * @param b 
   * @param options carries optional attributes values
   * @return a new instance of SparseMatMul
   * @see org.tensorflow.op.core.SparseMatMul
   */
  public <T extends Number, U extends Number> SparseMatMul sparseMatMul(Operand<T> a, Operand<U> b,
      SparseMatMul.Options... options) {
    return SparseMatMul.create(scope, a, b, options);
  }

  /**
   * Adds an {@link UnbatchGrad} operation to the graph
   *
   * @param originalInput 
   * @param batchIndex 
   * @param grad 
   * @param id 
   * @param options carries optional attributes values
   * @return a new instance of UnbatchGrad
   * @see org.tensorflow.op.core.UnbatchGrad
   */
  public <T> UnbatchGrad<T> unbatchGrad(Operand<T> originalInput, Operand<Long> batchIndex,
      Operand<T> grad, Operand<Long> id, UnbatchGrad.Options... options) {
    return UnbatchGrad.create(scope, originalInput, batchIndex, grad, id, options);
  }

  /**
   * Adds an {@link CudnnRNNParamsSize} operation to the graph
   *
   * @param numLayers 
   * @param numUnits 
   * @param inputSize 
   * @param T 
   * @param S 
   * @param options carries optional attributes values
   * @return a new instance of CudnnRNNParamsSize
   * @see org.tensorflow.op.core.CudnnRNNParamsSize
   */
  public <U extends Number, T extends Number> CudnnRNNParamsSize<U> cudnnRNNParamsSize(Operand<Integer> numLayers,
      Operand<Integer> numUnits, Operand<Integer> inputSize, Class<T> T, Class<U> S,
      CudnnRNNParamsSize.Options... options) {
    return CudnnRNNParamsSize.create(scope, numLayers, numUnits, inputSize, T, S, options);
  }

  /**
   * Adds an {@link QuantizedConcat} operation to the graph
   *
   * @param concatDim 0-D.  The dimension along which to concatenate.  Must be in the
   * @param values The `N` Tensors to concatenate. Their ranks and types must match,
   * @param inputMins The minimum scalar values for each of the input tensors.
   * @param inputMaxes The maximum scalar values for each of the input tensors.
   * @return a new instance of QuantizedConcat
   * @see org.tensorflow.op.core.QuantizedConcat
   */
  public <T> QuantizedConcat<T> quantizedConcat(Operand<Integer> concatDim, Operand<T> values,
      Iterable<Operand<Float>> inputMins, Iterable<Operand<Float>> inputMaxes) {
    return QuantizedConcat.create(scope, concatDim, values, inputMins, inputMaxes);
  }

  /**
   * Adds an {@link Xdivy} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Xdivy
   * @see org.tensorflow.op.core.Xdivy
   */
  public <T> Xdivy<T> xdivy(Operand<T> x, Operand<T> y) {
    return Xdivy.create(scope, x, y);
  }

  /**
   * Adds an {@link BatchMatrixSetDiag} operation to the graph
   *
   * @param input 
   * @param diagonal 
   * @return a new instance of BatchMatrixSetDiag
   * @see org.tensorflow.op.core.BatchMatrixSetDiag
   */
  public <T> BatchMatrixSetDiag<T> batchMatrixSetDiag(Operand<T> input, Operand<T> diagonal) {
    return BatchMatrixSetDiag.create(scope, input, diagonal);
  }

  /**
   * Adds an {@link Qr} operation to the graph
   *
   * @param input A tensor of shape `[..., M, N]` whose inner-most 2 dimensions
   * @param options carries optional attributes values
   * @return a new instance of Qr
   * @see org.tensorflow.op.core.Qr
   */
  public <T> Qr<T> qr(Operand<T> input, Qr.Options... options) {
    return Qr.create(scope, input, options);
  }

  /**
   * Adds an {@link Log} operation to the graph
   *
   * @param x 
   * @return a new instance of Log
   * @see org.tensorflow.op.core.Log
   */
  public <T> Log<T> log(Operand<T> x) {
    return Log.create(scope, x);
  }

  /**
   * Adds an {@link TensorScatterSub} operation to the graph
   *
   * @param tensor Tensor to copy/update.
   * @param indices Index tensor.
   * @param updates Updates to scatter into output.
   * @return a new instance of TensorScatterSub
   * @see org.tensorflow.op.core.TensorScatterSub
   */
  public <T, U extends Number> TensorScatterSub<T> tensorScatterSub(Operand<T> tensor,
      Operand<U> indices, Operand<T> updates) {
    return TensorScatterSub.create(scope, tensor, indices, updates);
  }

  /**
   * Adds an {@link InvertPermutation} operation to the graph
   *
   * @param x 1-D.
   * @return a new instance of InvertPermutation
   * @see org.tensorflow.op.core.InvertPermutation
   */
  public <T extends Number> InvertPermutation<T> invertPermutation(Operand<T> x) {
    return InvertPermutation.create(scope, x);
  }

  /**
   * Adds an {@link ApplyAdam} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param m Should be from a Variable().
   * @param v Should be from a Variable().
   * @param beta1Power Must be a scalar.
   * @param beta2Power Must be a scalar.
   * @param lr Scaling factor. Must be a scalar.
   * @param beta1 Momentum factor. Must be a scalar.
   * @param beta2 Momentum factor. Must be a scalar.
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ApplyAdam
   * @see org.tensorflow.op.core.ApplyAdam
   */
  public <T> ApplyAdam<T> applyAdam(Operand<T> var, Operand<T> m, Operand<T> v,
      Operand<T> beta1Power, Operand<T> beta2Power, Operand<T> lr, Operand<T> beta1,
      Operand<T> beta2, Operand<T> epsilon, Operand<T> grad, ApplyAdam.Options... options) {
    return ApplyAdam.create(scope, var, m, v, beta1Power, beta2Power, lr, beta1, beta2, epsilon, grad, options);
  }

  /**
   * Adds an {@link FakeQuantWithMinMaxVarsGradient} operation to the graph
   *
   * @param gradients Backpropagated gradients above the FakeQuantWithMinMaxVars operation.
   * @param inputs Values passed as inputs to the FakeQuantWithMinMaxVars operation.
   * @param min 
   * @param max 
   * @param options carries optional attributes values
   * @return a new instance of FakeQuantWithMinMaxVarsGradient
   * @see org.tensorflow.op.core.FakeQuantWithMinMaxVarsGradient
   */
  public FakeQuantWithMinMaxVarsGradient fakeQuantWithMinMaxVarsGradient(Operand<Float> gradients,
      Operand<Float> inputs, Operand<Float> min, Operand<Float> max,
      FakeQuantWithMinMaxVarsGradient.Options... options) {
    return FakeQuantWithMinMaxVarsGradient.create(scope, gradients, inputs, min, max, options);
  }

  /**
   * Adds an {@link SparseFillEmptyRows} operation to the graph
   *
   * @param indices 2-D. the indices of the sparse tensor.
   * @param values 1-D. the values of the sparse tensor.
   * @param denseShape 1-D. the shape of the sparse tensor.
   * @param defaultValue 0-D. default value to insert into location `[row, 0, ..., 0]`
   * @return a new instance of SparseFillEmptyRows
   * @see org.tensorflow.op.core.SparseFillEmptyRows
   */
  public <T> SparseFillEmptyRows<T> sparseFillEmptyRows(Operand<Long> indices, Operand<T> values,
      Operand<Long> denseShape, Operand<T> defaultValue) {
    return SparseFillEmptyRows.create(scope, indices, values, denseShape, defaultValue);
  }

  /**
   * Adds an {@link SampleDistortedBoundingBox} operation to the graph
   *
   * @param imageSize 1-D, containing `[height, width, channels]`.
   * @param boundingBoxes 3-D with shape `[batch, N, 4]` describing the N bounding boxes
   * @param options carries optional attributes values
   * @return a new instance of SampleDistortedBoundingBox
   * @see org.tensorflow.op.core.SampleDistortedBoundingBox
   */
  public <T extends Number> SampleDistortedBoundingBox<T> sampleDistortedBoundingBox(Operand<T> imageSize,
      Operand<Float> boundingBoxes, SampleDistortedBoundingBox.Options... options) {
    return SampleDistortedBoundingBox.create(scope, imageSize, boundingBoxes, options);
  }

  /**
   * Adds an {@link Ceil} operation to the graph
   *
   * @param x 
   * @return a new instance of Ceil
   * @see org.tensorflow.op.core.Ceil
   */
  public <T extends Number> Ceil<T> ceil(Operand<T> x) {
    return Ceil.create(scope, x);
  }

  /**
   * Adds an {@link ComplexAbs} operation to the graph
   *
   * @param x 
   * @return a new instance of ComplexAbs
   * @see org.tensorflow.op.core.ComplexAbs
   */
  public <T> ComplexAbs<Float> complexAbs(Operand<T> x) {
    return ComplexAbs.create(scope, x);
  }

  /**
   * Adds an {@link StringJoin} operation to the graph
   *
   * @param inputs A list of string tensors.  The tensors must all have the same shape,
   * @param options carries optional attributes values
   * @return a new instance of StringJoin
   * @see org.tensorflow.op.core.StringJoin
   */
  public StringJoin stringJoin(Iterable<Operand<String>> inputs, StringJoin.Options... options) {
    return StringJoin.create(scope, inputs, options);
  }

  /**
   * Adds an {@link ReadFile} operation to the graph
   *
   * @param filename 
   * @return a new instance of ReadFile
   * @see org.tensorflow.op.core.ReadFile
   */
  public ReadFile readFile(Operand<String> filename) {
    return ReadFile.create(scope, filename);
  }

  /**
   * Adds an {@link MutexV2} operation to the graph
   *
   * @param options carries optional attributes values
   * @return a new instance of MutexV2
   * @see org.tensorflow.op.core.MutexV2
   */
  public MutexV2 mutexV2(MutexV2.Options... options) {
    return MutexV2.create(scope, options);
  }

  /**
   * Adds an {@link Invert} operation to the graph
   *
   * @param x 
   * @return a new instance of Invert
   * @see org.tensorflow.op.core.Invert
   */
  public <T extends Number> Invert<T> invert(Operand<T> x) {
    return Invert.create(scope, x);
  }

  /**
   * Adds an {@link SparseDenseCwiseMul} operation to the graph
   *
   * @param spIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param spValues 1-D.  `N` non-empty values corresponding to `sp_indices`.
   * @param spShape 1-D.  Shape of the input SparseTensor.
   * @param dense `R`-D.  The dense Tensor operand.
   * @return a new instance of SparseDenseCwiseMul
   * @see org.tensorflow.op.core.SparseDenseCwiseMul
   */
  public <T> SparseDenseCwiseMul<T> sparseDenseCwiseMul(Operand<Long> spIndices,
      Operand<T> spValues, Operand<Long> spShape, Operand<T> dense) {
    return SparseDenseCwiseMul.create(scope, spIndices, spValues, spShape, dense);
  }

  /**
   * Adds an {@link SparseApplyAdagrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyAdagrad
   * @see org.tensorflow.op.core.SparseApplyAdagrad
   */
  public <T, U extends Number> SparseApplyAdagrad<T> sparseApplyAdagrad(Operand<T> var,
      Operand<T> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices,
      SparseApplyAdagrad.Options... options) {
    return SparseApplyAdagrad.create(scope, var, accum, lr, grad, indices, options);
  }

  /**
   * Adds an {@link ReduceProd} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of ReduceProd
   * @see org.tensorflow.op.core.ReduceProd
   */
  public <T, U extends Number> ReduceProd<T> reduceProd(Operand<T> input, Operand<U> axis,
      ReduceProd.Options... options) {
    return ReduceProd.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link ResourceScatterDiv} operation to the graph
   *
   * @param resource Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to add to `ref`.
   * @return a new instance of ResourceScatterDiv
   * @see org.tensorflow.op.core.ResourceScatterDiv
   */
  public <T extends Number, U> ResourceScatterDiv resourceScatterDiv(Operand<?> resource,
      Operand<T> indices, Operand<U> updates) {
    return ResourceScatterDiv.create(scope, resource, indices, updates);
  }

  /**
   * Adds an {@link RandomPoissonV2} operation to the graph
   *
   * @param shape 1-D integer tensor. Shape of independent samples to draw from each
   * @param rate A tensor in which each scalar is a "rate" parameter describing the
   * @param dtype 
   * @param options carries optional attributes values
   * @return a new instance of RandomPoissonV2
   * @see org.tensorflow.op.core.RandomPoissonV2
   */
  public <V extends Number, T extends Number, U extends Number> RandomPoissonV2<V> randomPoissonV2(Operand<T> shape,
      Operand<U> rate, Class<V> dtype, RandomPoissonV2.Options... options) {
    return RandomPoissonV2.create(scope, shape, rate, dtype, options);
  }

  /**
   * Adds an {@link Conv3DBackpropFilter} operation to the graph
   *
   * @param input Shape `[batch, depth, rows, cols, in_channels]`.
   * @param filter Shape `[depth, rows, cols, in_channels, out_channels]`.
   * @param outBackprop Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of Conv3DBackpropFilter
   * @see org.tensorflow.op.core.Conv3DBackpropFilter
   */
  public <T extends Number> Conv3DBackpropFilter<T> conv3DBackpropFilter(Operand<T> input,
      Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding,
      Conv3DBackpropFilter.Options... options) {
    return Conv3DBackpropFilter.create(scope, input, filter, outBackprop, strides, padding, options);
  }

  /**
   * Adds an {@link PaddingFIFOQueue} operation to the graph
   *
   * @param componentTypes The type of each component in a value.
   * @param options carries optional attributes values
   * @return a new instance of PaddingFIFOQueue
   * @see org.tensorflow.op.core.PaddingFIFOQueue
   */
  public PaddingFIFOQueue paddingFIFOQueue(List<Class<?>> componentTypes,
      PaddingFIFOQueue.Options... options) {
    return PaddingFIFOQueue.create(scope, componentTypes, options);
  }

  /**
   * Adds an {@link TensorSummary} operation to the graph
   *
   * @param tensor A tensor to serialize.
   * @param options carries optional attributes values
   * @return a new instance of TensorSummary
   * @see org.tensorflow.op.core.TensorSummary
   */
  public <T> TensorSummary tensorSummary(Operand<T> tensor, TensorSummary.Options... options) {
    return TensorSummary.create(scope, tensor, options);
  }

  /**
   * Adds an {@link ParallelDynamicStitch} operation to the graph
   *
   * @param indices 
   * @param data 
   * @return a new instance of ParallelDynamicStitch
   * @see org.tensorflow.op.core.ParallelDynamicStitch
   */
  public <T> ParallelDynamicStitch<T> parallelDynamicStitch(Iterable<Operand<Integer>> indices,
      Operand<T> data) {
    return ParallelDynamicStitch.create(scope, indices, data);
  }

  /**
   * Adds an {@link Lgamma} operation to the graph
   *
   * @param x 
   * @return a new instance of Lgamma
   * @see org.tensorflow.op.core.Lgamma
   */
  public <T extends Number> Lgamma<T> lgamma(Operand<T> x) {
    return Lgamma.create(scope, x);
  }

  /**
   * Adds an {@link ApplyAdadelta} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param accumUpdate Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay factor. Must be a scalar.
   * @param epsilon Constant factor. Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ApplyAdadelta
   * @see org.tensorflow.op.core.ApplyAdadelta
   */
  public <T> ApplyAdadelta<T> applyAdadelta(Operand<T> var, Operand<T> accum,
      Operand<T> accumUpdate, Operand<T> lr, Operand<T> rho, Operand<T> epsilon, Operand<T> grad,
      ApplyAdadelta.Options... options) {
    return ApplyAdadelta.create(scope, var, accum, accumUpdate, lr, rho, epsilon, grad, options);
  }

  /**
   * Adds an {@link ResourceApplyKerasMomentum} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param grad The gradient.
   * @param momentum Momentum. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyKerasMomentum
   * @see org.tensorflow.op.core.ResourceApplyKerasMomentum
   */
  public <T> ResourceApplyKerasMomentum resourceApplyKerasMomentum(Operand<?> var, Operand<?> accum,
      Operand<T> lr, Operand<T> grad, Operand<T> momentum,
      ResourceApplyKerasMomentum.Options... options) {
    return ResourceApplyKerasMomentum.create(scope, var, accum, lr, grad, momentum, options);
  }

  /**
   * Adds an {@link HashTable} operation to the graph
   *
   * @param keyDtype Type of the table keys.
   * @param valueDtype Type of the table values.
   * @param options carries optional attributes values
   * @return a new instance of HashTable
   * @see org.tensorflow.op.core.HashTable
   */
  public <T, U> HashTable hashTable(Class<T> keyDtype, Class<U> valueDtype,
      HashTable.Options... options) {
    return HashTable.create(scope, keyDtype, valueDtype, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Boolean> constant(boolean[][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link FusedResizeAndPadConv2D} operation to the graph
   *
   * @param input 4-D with shape `[batch, in_height, in_width, in_channels]`.
   * @param size A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
   * @param paddings A two-column matrix specifying the padding sizes. The number of
   * @param filter 4-D with shape
   * @param mode 
   * @param strides 1-D of length 4.  The stride of the sliding window for each dimension
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of FusedResizeAndPadConv2D
   * @see org.tensorflow.op.core.FusedResizeAndPadConv2D
   */
  public <T extends Number> FusedResizeAndPadConv2D<T> fusedResizeAndPadConv2D(Operand<T> input,
      Operand<Integer> size, Operand<Integer> paddings, Operand<T> filter, String mode,
      List<Long> strides, String padding, FusedResizeAndPadConv2D.Options... options) {
    return FusedResizeAndPadConv2D.create(scope, input, size, paddings, filter, mode, strides, padding, options);
  }

  /**
   * Adds an {@link NonMaxSuppressionV4} operation to the graph
   *
   * @param boxes A 2-D float tensor of shape `[num_boxes, 4]`.
   * @param scores A 1-D float tensor of shape `[num_boxes]` representing a single
   * @param maxOutputSize A scalar integer tensor representing the maximum number of
   * @param iouThreshold A 0-D float tensor representing the threshold for deciding whether
   * @param scoreThreshold A 0-D float tensor representing the threshold for deciding when to remove
   * @param options carries optional attributes values
   * @return a new instance of NonMaxSuppressionV4
   * @see org.tensorflow.op.core.NonMaxSuppressionV4
   */
  public <T extends Number> NonMaxSuppressionV4 nonMaxSuppressionV4(Operand<T> boxes,
      Operand<T> scores, Operand<Integer> maxOutputSize, Operand<Float> iouThreshold,
      Operand<Float> scoreThreshold, NonMaxSuppressionV4.Options... options) {
    return NonMaxSuppressionV4.create(scope, boxes, scores, maxOutputSize, iouThreshold, scoreThreshold, options);
  }

  /**
   * Adds an {@link Unstack} operation to the graph
   *
   * @param value 1-D or higher, with `axis` dimension size equal to `num`.
   * @param num 
   * @param options carries optional attributes values
   * @return a new instance of Unstack
   * @see org.tensorflow.op.core.Unstack
   */
  public <T> Unstack<T> unstack(Operand<T> value, Long num, Unstack.Options... options) {
    return Unstack.create(scope, value, num, options);
  }

  /**
   * Adds an {@link Softmax} operation to the graph
   *
   * @param logits 2-D with shape `[batch_size, num_classes]`.
   * @return a new instance of Softmax
   * @see org.tensorflow.op.core.Softmax
   */
  public <T extends Number> Softmax<T> softmax(Operand<T> logits) {
    return Softmax.create(scope, logits);
  }

  /**
   * Adds an {@link BatchIFFT2D} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchIFFT2D
   * @see org.tensorflow.op.core.BatchIFFT2D
   */
  public BatchIFFT2D batchIFFT2D(Operand<?> input) {
    return BatchIFFT2D.create(scope, input);
  }

  /**
   * Adds an {@link ExpandDims} operation to the graph
   *
   * @param input 
   * @param axis 0-D (scalar). Specifies the dimension index at which to
   * @return a new instance of ExpandDims
   * @see org.tensorflow.op.core.ExpandDims
   */
  public <T, U extends Number> ExpandDims<T> expandDims(Operand<T> input, Operand<U> axis) {
    return ExpandDims.create(scope, input, axis);
  }

  /**
   * Adds an {@link ReduceAny} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of ReduceAny
   * @see org.tensorflow.op.core.ReduceAny
   */
  public <T extends Number> ReduceAny reduceAny(Operand<Boolean> input, Operand<T> axis,
      ReduceAny.Options... options) {
    return ReduceAny.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link RFFT3D} operation to the graph
   *
   * @param input A float32 tensor.
   * @param fftLength An int32 tensor of shape [3]. The FFT length for each dimension.
   * @return a new instance of RFFT3D
   * @see org.tensorflow.op.core.RFFT3D
   */
  public RFFT3D rFFT3D(Operand<Float> input, Operand<Integer> fftLength) {
    return RFFT3D.create(scope, input, fftLength);
  }

  /**
   * Adds an {@link QueueEnqueue} operation to the graph
   *
   * @param handle The handle to a queue.
   * @param components One or more tensors from which the enqueued tensors should be taken.
   * @param options carries optional attributes values
   * @return a new instance of QueueEnqueue
   * @see org.tensorflow.op.core.QueueEnqueue
   */
  public QueueEnqueue queueEnqueue(Operand<?> handle, Iterable<Operand<?>> components,
      QueueEnqueue.Options... options) {
    return QueueEnqueue.create(scope, handle, components, options);
  }

  /**
   * Adds an {@link Multiply} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Multiply
   * @see org.tensorflow.op.core.Multiply
   */
  public <T> Multiply<T> multiply(Operand<T> x, Operand<T> y) {
    return Multiply.create(scope, x, y);
  }

  /**
   * Adds an {@link ReduceSum} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of ReduceSum
   * @see org.tensorflow.op.core.ReduceSum
   */
  public <T, U extends Number> ReduceSum<T> reduceSum(Operand<T> input, Operand<U> axis,
      ReduceSum.Options... options) {
    return ReduceSum.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link SparseApplyRMSProp} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param ms Should be from a Variable().
   * @param mom Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param rho Decay rate. Must be a scalar.
   * @param momentum 
   * @param epsilon Ridge term. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var, ms and mom.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyRMSProp
   * @see org.tensorflow.op.core.SparseApplyRMSProp
   */
  public <T, U extends Number> SparseApplyRMSProp<T> sparseApplyRMSProp(Operand<T> var,
      Operand<T> ms, Operand<T> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum,
      Operand<T> epsilon, Operand<T> grad, Operand<U> indices,
      SparseApplyRMSProp.Options... options) {
    return SparseApplyRMSProp.create(scope, var, ms, mom, lr, rho, momentum, epsilon, grad, indices, options);
  }

  /**
   * Adds an {@link LogUniformCandidateSampler} operation to the graph
   *
   * @param trueClasses A batch_size * num_true matrix, in which each row contains the
   * @param numTrue Number of true labels per context.
   * @param numSampled Number of candidates to randomly sample.
   * @param unique If unique is true, we sample with rejection, so that all sampled
   * @param rangeMax The sampler will sample integers from the interval [0, range_max).
   * @param options carries optional attributes values
   * @return a new instance of LogUniformCandidateSampler
   * @see org.tensorflow.op.core.LogUniformCandidateSampler
   */
  public LogUniformCandidateSampler logUniformCandidateSampler(Operand<Long> trueClasses,
      Long numTrue, Long numSampled, Boolean unique, Long rangeMax,
      LogUniformCandidateSampler.Options... options) {
    return LogUniformCandidateSampler.create(scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
  }

  /**
   * Adds an {@link StringFormat} operation to the graph
   *
   * @param inputs The list of tensors to format into the placeholder string.
   * @param options carries optional attributes values
   * @return a new instance of StringFormat
   * @see org.tensorflow.op.core.StringFormat
   */
  public StringFormat stringFormat(Iterable<Operand<?>> inputs, StringFormat.Options... options) {
    return StringFormat.create(scope, inputs, options);
  }

  /**
   * Adds an {@link ReadVariableOp} operation to the graph
   *
   * @param resource handle to the resource in which to store the variable.
   * @param dtype the dtype of the value.
   * @return a new instance of ReadVariableOp
   * @see org.tensorflow.op.core.ReadVariableOp
   */
  public <T> ReadVariableOp<T> readVariableOp(Operand<?> resource, Class<T> dtype) {
    return ReadVariableOp.create(scope, resource, dtype);
  }

  /**
   * Adds an {@link StatelessTruncatedNormal} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param seed 2 seeds (shape [2]).
   * @param dtype The type of the output.
   * @return a new instance of StatelessTruncatedNormal
   * @see org.tensorflow.op.core.StatelessTruncatedNormal
   */
  public <V extends Number, T extends Number, U extends Number> StatelessTruncatedNormal<V> statelessTruncatedNormal(Operand<T> shape,
      Operand<U> seed, Class<V> dtype) {
    return StatelessTruncatedNormal.create(scope, shape, seed, dtype);
  }

  /**
   * Adds an {@link GenerateBigQueryReaderPartitions} operation to the graph
   *
   * @param projectId GCP project ID.
   * @param datasetId BigQuery Dataset ID.
   * @param tableId Table to read.
   * @param columns List of columns to read. Leave empty to read all columns.
   * @param timestampMillis Table snapshot timestamp in millis since epoch. Relative
   * @param numPartitions Number of partitions to split the table into.
   * @param options carries optional attributes values
   * @return a new instance of GenerateBigQueryReaderPartitions
   * @see org.tensorflow.op.core.GenerateBigQueryReaderPartitions
   */
  public GenerateBigQueryReaderPartitions generateBigQueryReaderPartitions(String projectId,
      String datasetId, String tableId, List<String> columns, Long timestampMillis,
      Long numPartitions, GenerateBigQueryReaderPartitions.Options... options) {
    return GenerateBigQueryReaderPartitions.create(scope, projectId, datasetId, tableId, columns, timestampMillis, numPartitions, options);
  }

  /**
   * Adds an {@link FFT3D} operation to the graph
   *
   * @param input A complex64 tensor.
   * @return a new instance of FFT3D
   * @see org.tensorflow.op.core.FFT3D
   */
  public <T> FFT3D<T> fFT3D(Operand<T> input) {
    return FFT3D.create(scope, input);
  }

  /**
   * Adds an {@link MatrixSetDiag} operation to the graph
   *
   * @param input Rank `k+1`, where `k >= 1`.
   * @param diagonal Rank `k`, where `k >= 1`.
   * @return a new instance of MatrixSetDiag
   * @see org.tensorflow.op.core.MatrixSetDiag
   */
  public <T> MatrixSetDiag<T> matrixSetDiag(Operand<T> input, Operand<T> diagonal) {
    return MatrixSetDiag.create(scope, input, diagonal);
  }

  /**
   * Adds an {@link LogicalNot} operation to the graph
   *
   * @param x 
   * @return a new instance of LogicalNot
   * @see org.tensorflow.op.core.LogicalNot
   */
  public LogicalNot logicalNot(Operand<Boolean> x) {
    return LogicalNot.create(scope, x);
  }

  /**
   * Adds an {@link AdjustContrast} operation to the graph
   *
   * @param images Images to adjust.  At least 3-D.
   * @param contrastFactor A float multiplier for adjusting contrast.
   * @return a new instance of AdjustContrast
   * @see org.tensorflow.op.core.AdjustContrast
   */
  public AdjustContrast adjustContrast(Operand<Float> images, Operand<Float> contrastFactor) {
    return AdjustContrast.create(scope, images, contrastFactor);
  }

  /**
   * Adds an {@link ResourceApplyAdagradDA} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param gradientAccumulator Should be from a Variable().
   * @param gradientSquaredAccumulator Should be from a Variable().
   * @param grad The gradient.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param globalStep Training step number. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyAdagradDA
   * @see org.tensorflow.op.core.ResourceApplyAdagradDA
   */
  public <T> ResourceApplyAdagradDA resourceApplyAdagradDA(Operand<?> var,
      Operand<?> gradientAccumulator, Operand<?> gradientSquaredAccumulator, Operand<T> grad,
      Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<Long> globalStep,
      ResourceApplyAdagradDA.Options... options) {
    return ResourceApplyAdagradDA.create(scope, var, gradientAccumulator, gradientSquaredAccumulator, grad, lr, l1, l2, globalStep, options);
  }

  /**
   * Adds an {@link RestoreV2} operation to the graph
   *
   * @param prefix Must have a single element.  The prefix of a V2 checkpoint.
   * @param tensorNames shape {N}.  The names of the tensors to be restored.
   * @param shapeAndSlices shape {N}.  The slice specs of the tensors to be restored.
   * @param dtypes shape {N}.  The list of expected dtype for the tensors.  Must match
   * @return a new instance of RestoreV2
   * @see org.tensorflow.op.core.RestoreV2
   */
  public RestoreV2 restoreV2(Operand<String> prefix, Operand<String> tensorNames,
      Operand<String> shapeAndSlices, List<Class<?>> dtypes) {
    return RestoreV2.create(scope, prefix, tensorNames, shapeAndSlices, dtypes);
  }

  /**
   * Adds an {@link LookupTableSize} operation to the graph
   *
   * @param tableHandle Handle to the table.
   * @return a new instance of LookupTableSize
   * @see org.tensorflow.op.core.LookupTableSize
   */
  public LookupTableSize lookupTableSize(Operand<?> tableHandle) {
    return LookupTableSize.create(scope, tableHandle);
  }

  /**
   * Adds an {@link Zeta} operation to the graph
   *
   * @param x 
   * @param q 
   * @return a new instance of Zeta
   * @see org.tensorflow.op.core.Zeta
   */
  public <T extends Number> Zeta<T> zeta(Operand<T> x, Operand<T> q) {
    return Zeta.create(scope, x, q);
  }

  /**
   * Adds an {@link SparseSegmentMeanGrad} operation to the graph
   *
   * @param grad gradient propagated to the SparseSegmentMean op.
   * @param indices indices passed to the corresponding SparseSegmentMean op.
   * @param segmentIds segment_ids passed to the corresponding SparseSegmentMean op.
   * @param outputDim0 dimension 0 of "data" passed to SparseSegmentMean op.
   * @return a new instance of SparseSegmentMeanGrad
   * @see org.tensorflow.op.core.SparseSegmentMeanGrad
   */
  public <T extends Number, U extends Number> SparseSegmentMeanGrad<T> sparseSegmentMeanGrad(Operand<T> grad,
      Operand<U> indices, Operand<Integer> segmentIds, Operand<Integer> outputDim0) {
    return SparseSegmentMeanGrad.create(scope, grad, indices, segmentIds, outputDim0);
  }

  /**
   * Adds an {@link Digamma} operation to the graph
   *
   * @param x 
   * @return a new instance of Digamma
   * @see org.tensorflow.op.core.Digamma
   */
  public <T extends Number> Digamma<T> digamma(Operand<T> x) {
    return Digamma.create(scope, x);
  }

  /**
   * Adds an {@link StringToHashBucketFast} operation to the graph
   *
   * @param input The strings to assign a hash bucket.
   * @param numBuckets The number of buckets.
   * @return a new instance of StringToHashBucketFast
   * @see org.tensorflow.op.core.StringToHashBucketFast
   */
  public StringToHashBucketFast stringToHashBucketFast(Operand<String> input, Long numBuckets) {
    return StringToHashBucketFast.create(scope, input, numBuckets);
  }

  /**
   * Adds an {@link FloorMod} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of FloorMod
   * @see org.tensorflow.op.core.FloorMod
   */
  public <T extends Number> FloorMod<T> floorMod(Operand<T> x, Operand<T> y) {
    return FloorMod.create(scope, x, y);
  }

  /**
   * Adds an {@link ParseSingleExample} operation to the graph
   *
   * @param serialized A vector containing a batch of binary serialized Example protos.
   * @param denseDefaults A list of Tensors (some may be empty), whose length matches
   * @param numSparse The number of sparse features to be parsed from the example. This
   * @param sparseKeys A list of `num_sparse` strings.
   * @param denseKeys The keys expected in the Examples' features associated with dense
   * @param sparseTypes A list of `num_sparse` types; the data types of data in each
   * @param denseShapes The shapes of data in each Feature given in dense_keys.
   * @return a new instance of ParseSingleExample
   * @see org.tensorflow.op.core.ParseSingleExample
   */
  public ParseSingleExample parseSingleExample(Operand<String> serialized,
      Iterable<Operand<?>> denseDefaults, Long numSparse, List<String> sparseKeys,
      List<String> denseKeys, List<Class<?>> sparseTypes, List<Shape> denseShapes) {
    return ParseSingleExample.create(scope, serialized, denseDefaults, numSparse, sparseKeys, denseKeys, sparseTypes, denseShapes);
  }

  /**
   * Adds an {@link GatherNd} operation to the graph
   *
   * @param params The tensor from which to gather values.
   * @param indices Index tensor.
   * @return a new instance of GatherNd
   * @see org.tensorflow.op.core.GatherNd
   */
  public <T, U extends Number> GatherNd<T> gatherNd(Operand<T> params, Operand<U> indices) {
    return GatherNd.create(scope, params, indices);
  }

  /**
   * Adds an {@link AccumulatorNumAccumulated} operation to the graph
   *
   * @param handle The handle to an accumulator.
   * @return a new instance of AccumulatorNumAccumulated
   * @see org.tensorflow.op.core.AccumulatorNumAccumulated
   */
  public AccumulatorNumAccumulated accumulatorNumAccumulated(Operand<String> handle) {
    return AccumulatorNumAccumulated.create(scope, handle);
  }

  /**
   * Adds an {@link ResizeBicubic} operation to the graph
   *
   * @param images 4-D with shape `[batch, height, width, channels]`.
   * @param size = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
   * @param options carries optional attributes values
   * @return a new instance of ResizeBicubic
   * @see org.tensorflow.op.core.ResizeBicubic
   */
  public <T extends Number> ResizeBicubic resizeBicubic(Operand<T> images, Operand<Integer> size,
      ResizeBicubic.Options... options) {
    return ResizeBicubic.create(scope, images, size, options);
  }

  /**
   * Adds an {@link RefNextIteration} operation to the graph
   *
   * @param data The tensor to be made available to the next iteration.
   * @return a new instance of RefNextIteration
   * @see org.tensorflow.op.core.RefNextIteration
   */
  public <T> RefNextIteration<T> refNextIteration(Operand<T> data) {
    return RefNextIteration.create(scope, data);
  }

  /**
   * Adds an {@link Rsqrt} operation to the graph
   *
   * @param x 
   * @return a new instance of Rsqrt
   * @see org.tensorflow.op.core.Rsqrt
   */
  public <T> Rsqrt<T> rsqrt(Operand<T> x) {
    return Rsqrt.create(scope, x);
  }

  /**
   * Adds an {@link FusedPadConv2D} operation to the graph
   *
   * @param input 4-D with shape `[batch, in_height, in_width, in_channels]`.
   * @param paddings A two-column matrix specifying the padding sizes. The number of
   * @param filter 4-D with shape
   * @param mode 
   * @param strides 1-D of length 4.  The stride of the sliding window for each dimension
   * @param padding The type of padding algorithm to use.
   * @return a new instance of FusedPadConv2D
   * @see org.tensorflow.op.core.FusedPadConv2D
   */
  public <T extends Number> FusedPadConv2D<T> fusedPadConv2D(Operand<T> input,
      Operand<Integer> paddings, Operand<T> filter, String mode, List<Long> strides,
      String padding) {
    return FusedPadConv2D.create(scope, input, paddings, filter, mode, strides, padding);
  }

  /**
   * Adds an {@link Unstage} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of Unstage
   * @see org.tensorflow.op.core.Unstage
   */
  public Unstage unstage(List<Class<?>> dtypes, Unstage.Options... options) {
    return Unstage.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link Cast} operation to the graph
   *
   * @param x 
   * @param DstT 
   * @param options carries optional attributes values
   * @return a new instance of Cast
   * @see org.tensorflow.op.core.Cast
   */
  public <U, T> Cast<U> cast(Operand<T> x, Class<U> DstT, Cast.Options... options) {
    return Cast.create(scope, x, DstT, options);
  }

  /**
   * Adds an {@link EditDistance} operation to the graph
   *
   * @param hypothesisIndices The indices of the hypothesis list SparseTensor.
   * @param hypothesisValues The values of the hypothesis list SparseTensor.
   * @param hypothesisShape The shape of the hypothesis list SparseTensor.
   * @param truthIndices The indices of the truth list SparseTensor.
   * @param truthValues The values of the truth list SparseTensor.
   * @param truthShape truth indices, vector.
   * @param options carries optional attributes values
   * @return a new instance of EditDistance
   * @see org.tensorflow.op.core.EditDistance
   */
  public <T> EditDistance editDistance(Operand<Long> hypothesisIndices, Operand<T> hypothesisValues,
      Operand<Long> hypothesisShape, Operand<Long> truthIndices, Operand<T> truthValues,
      Operand<Long> truthShape, EditDistance.Options... options) {
    return EditDistance.create(scope, hypothesisIndices, hypothesisValues, hypothesisShape, truthIndices, truthValues, truthShape, options);
  }

  /**
   * Adds an {@link Relu6} operation to the graph
   *
   * @param features 
   * @return a new instance of Relu6
   * @see org.tensorflow.op.core.Relu6
   */
  public <T extends Number> Relu6<T> relu6(Operand<T> features) {
    return Relu6.create(scope, features);
  }

  /**
   * Adds an {@link Shape} operation to the graph
   *
   * @param input 
   * @return a new instance of Shape
   * @see org.tensorflow.op.core.Shape
   */
  public <T> org.tensorflow.op.core.Shape<Integer> shape(Operand<T> input) {
    return org.tensorflow.op.core.Shape.create(scope, input);
  }

  /**
   * Adds an {@link MapUnstage} operation to the graph
   *
   * @param key 
   * @param indices 
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of MapUnstage
   * @see org.tensorflow.op.core.MapUnstage
   */
  public MapUnstage mapUnstage(Operand<Long> key, Operand<Integer> indices, List<Class<?>> dtypes,
      MapUnstage.Options... options) {
    return MapUnstage.create(scope, key, indices, dtypes, options);
  }

  /**
   * Adds an {@link OrderedMapClear} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of OrderedMapClear
   * @see org.tensorflow.op.core.OrderedMapClear
   */
  public OrderedMapClear orderedMapClear(List<Class<?>> dtypes,
      OrderedMapClear.Options... options) {
    return OrderedMapClear.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link FakeQuantWithMinMaxVarsPerChannelGradient} operation to the graph
   *
   * @param gradients Backpropagated gradients above the FakeQuantWithMinMaxVars operation,
   * @param inputs Values passed as inputs to the FakeQuantWithMinMaxVars operation, shape
   * @param min 
   * @param max 
   * @param options carries optional attributes values
   * @return a new instance of FakeQuantWithMinMaxVarsPerChannelGradient
   * @see org.tensorflow.op.core.FakeQuantWithMinMaxVarsPerChannelGradient
   */
  public FakeQuantWithMinMaxVarsPerChannelGradient fakeQuantWithMinMaxVarsPerChannelGradient(Operand<Float> gradients,
      Operand<Float> inputs, Operand<Float> min, Operand<Float> max,
      FakeQuantWithMinMaxVarsPerChannelGradient.Options... options) {
    return FakeQuantWithMinMaxVarsPerChannelGradient.create(scope, gradients, inputs, min, max, options);
  }

  /**
   * Adds an {@link BitwiseOr} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of BitwiseOr
   * @see org.tensorflow.op.core.BitwiseOr
   */
  public <T extends Number> BitwiseOr<T> bitwiseOr(Operand<T> x, Operand<T> y) {
    return BitwiseOr.create(scope, x, y);
  }

  /**
   * Adds an {@link ReaderNumRecordsProduced} operation to the graph
   *
   * @param readerHandle Handle to a Reader.
   * @return a new instance of ReaderNumRecordsProduced
   * @see org.tensorflow.op.core.ReaderNumRecordsProduced
   */
  public ReaderNumRecordsProduced readerNumRecordsProduced(Operand<?> readerHandle) {
    return ReaderNumRecordsProduced.create(scope, readerHandle);
  }

  /**
   * Adds an {@link TensorListElementShape} operation to the graph
   *
   * @param inputHandle 
   * @param shapeType 
   * @return a new instance of TensorListElementShape
   * @see org.tensorflow.op.core.TensorListElementShape
   */
  public <T extends Number> TensorListElementShape<T> tensorListElementShape(Operand<?> inputHandle,
      Class<T> shapeType) {
    return TensorListElementShape.create(scope, inputHandle, shapeType);
  }

  /**
   * Adds an {@link Softsign} operation to the graph
   *
   * @param features 
   * @return a new instance of Softsign
   * @see org.tensorflow.op.core.Softsign
   */
  public <T extends Number> Softsign<T> softsign(Operand<T> features) {
    return Softsign.create(scope, features);
  }

  /**
   * Adds an {@link SquaredDifference} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of SquaredDifference
   * @see org.tensorflow.op.core.SquaredDifference
   */
  public <T> SquaredDifference<T> squaredDifference(Operand<T> x, Operand<T> y) {
    return SquaredDifference.create(scope, x, y);
  }

  /**
   * Adds an {@link BatchMatrixDiag} operation to the graph
   *
   * @param diagonal 
   * @return a new instance of BatchMatrixDiag
   * @see org.tensorflow.op.core.BatchMatrixDiag
   */
  public <T> BatchMatrixDiag<T> batchMatrixDiag(Operand<T> diagonal) {
    return BatchMatrixDiag.create(scope, diagonal);
  }

  /**
   * Adds an {@link ScatterDiv} operation to the graph
   *
   * @param ref Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of values that `ref` is divided by.
   * @param options carries optional attributes values
   * @return a new instance of ScatterDiv
   * @see org.tensorflow.op.core.ScatterDiv
   */
  public <T, U extends Number> ScatterDiv<T> scatterDiv(Operand<T> ref, Operand<U> indices,
      Operand<T> updates, ScatterDiv.Options... options) {
    return ScatterDiv.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link QuantizedReshape} operation to the graph
   *
   * @param tensor 
   * @param shape Defines the shape of the output tensor.
   * @param inputMin The minimum value of the input.
   * @param inputMax The maximum value of the input.
   * @return a new instance of QuantizedReshape
   * @see org.tensorflow.op.core.QuantizedReshape
   */
  public <T, U extends Number> QuantizedReshape<T> quantizedReshape(Operand<T> tensor,
      Operand<U> shape, Operand<Float> inputMin, Operand<Float> inputMax) {
    return QuantizedReshape.create(scope, tensor, shape, inputMin, inputMax);
  }

  /**
   * Adds an {@link LogicalOr} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of LogicalOr
   * @see org.tensorflow.op.core.LogicalOr
   */
  public LogicalOr logicalOr(Operand<Boolean> x, Operand<Boolean> y) {
    return LogicalOr.create(scope, x, y);
  }

  /**
   * Adds an {@link BarrierTakeMany} operation to the graph
   *
   * @param handle The handle to a barrier.
   * @param numElements A single-element tensor containing the number of elements to
   * @param componentTypes The type of each component in a value.
   * @param options carries optional attributes values
   * @return a new instance of BarrierTakeMany
   * @see org.tensorflow.op.core.BarrierTakeMany
   */
  public BarrierTakeMany barrierTakeMany(Operand<String> handle, Operand<Integer> numElements,
      List<Class<?>> componentTypes, BarrierTakeMany.Options... options) {
    return BarrierTakeMany.create(scope, handle, numElements, componentTypes, options);
  }

  /**
   * Adds an {@link Real} operation to the graph
   *
   * @param input 
   * @return a new instance of Real
   * @see org.tensorflow.op.core.Real
   */
  public <T> Real<Float> real(Operand<T> input) {
    return Real.create(scope, input);
  }

  /**
   * Adds an {@link Cumprod} operation to the graph
   *
   * @param x A `Tensor`. Must be one of the following types: `float32`, `float64`,
   * @param axis A `Tensor` of type `int32` (default: 0). Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of Cumprod
   * @see org.tensorflow.op.core.Cumprod
   */
  public <T, U extends Number> Cumprod<T> cumprod(Operand<T> x, Operand<U> axis,
      Cumprod.Options... options) {
    return Cumprod.create(scope, x, axis, options);
  }

  /**
   * Adds an {@link Real} operation to the graph
   *
   * @param input 
   * @param Tout 
   * @return a new instance of Real
   * @see org.tensorflow.op.core.Real
   */
  public <U extends Number, T> Real<U> real(Operand<T> input, Class<U> Tout) {
    return Real.create(scope, input, Tout);
  }

  /**
   * Adds an {@link ResourceApplyGradientDescent} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param alpha Scaling factor. Must be a scalar.
   * @param delta The change.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyGradientDescent
   * @see org.tensorflow.op.core.ResourceApplyGradientDescent
   */
  public <T> ResourceApplyGradientDescent resourceApplyGradientDescent(Operand<?> var,
      Operand<T> alpha, Operand<T> delta, ResourceApplyGradientDescent.Options... options) {
    return ResourceApplyGradientDescent.create(scope, var, alpha, delta, options);
  }

  /**
   * Adds an {@link MaxPoolGradGradV2} operation to the graph
   *
   * @param origInput The original input tensor.
   * @param origOutput The original output tensor.
   * @param grad 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
   * @param ksize The size of the window for each dimension of the input tensor.
   * @param strides The stride of the sliding window for each dimension of the
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of MaxPoolGradGradV2
   * @see org.tensorflow.op.core.MaxPoolGradGradV2
   */
  public <T extends Number> MaxPoolGradGradV2<T> maxPoolGradGradV2(Operand<T> origInput,
      Operand<T> origOutput, Operand<T> grad, Operand<Integer> ksize, Operand<Integer> strides,
      String padding, MaxPoolGradGradV2.Options... options) {
    return MaxPoolGradGradV2.create(scope, origInput, origOutput, grad, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link OptionalGetValue} operation to the graph
   *
   * @param optional 
   * @param outputTypes 
   * @param outputShapes 
   * @return a new instance of OptionalGetValue
   * @see org.tensorflow.op.core.OptionalGetValue
   */
  public OptionalGetValue optionalGetValue(Operand<?> optional, List<Class<?>> outputTypes,
      List<Shape> outputShapes) {
    return OptionalGetValue.create(scope, optional, outputTypes, outputShapes);
  }

  /**
   * Adds an {@link TensorListGetItem} operation to the graph
   *
   * @param inputHandle 
   * @param index 
   * @param elementDtype 
   * @return a new instance of TensorListGetItem
   * @see org.tensorflow.op.core.TensorListGetItem
   */
  public <T> TensorListGetItem<T> tensorListGetItem(Operand<?> inputHandle, Operand<Integer> index,
      Class<T> elementDtype) {
    return TensorListGetItem.create(scope, inputHandle, index, elementDtype);
  }

  /**
   * Adds an {@link NonMaxSuppressionWithOverlaps} operation to the graph
   *
   * @param overlaps A 2-D float tensor of shape `[num_boxes, num_boxes]` representing
   * @param scores A 1-D float tensor of shape `[num_boxes]` representing a single
   * @param maxOutputSize A scalar integer tensor representing the maximum number of
   * @param overlapThreshold A 0-D float tensor representing the threshold for deciding whether
   * @param scoreThreshold A 0-D float tensor representing the threshold for deciding when to remove
   * @return a new instance of NonMaxSuppressionWithOverlaps
   * @see org.tensorflow.op.core.NonMaxSuppressionWithOverlaps
   */
  public NonMaxSuppressionWithOverlaps nonMaxSuppressionWithOverlaps(Operand<Float> overlaps,
      Operand<Float> scores, Operand<Integer> maxOutputSize, Operand<Float> overlapThreshold,
      Operand<Float> scoreThreshold) {
    return NonMaxSuppressionWithOverlaps.create(scope, overlaps, scores, maxOutputSize, overlapThreshold, scoreThreshold);
  }

  /**
   * Adds an {@link ResourceApplyPowerSign} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param m Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param logbase Must be a scalar.
   * @param signDecay Must be a scalar.
   * @param beta Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyPowerSign
   * @see org.tensorflow.op.core.ResourceApplyPowerSign
   */
  public <T> ResourceApplyPowerSign resourceApplyPowerSign(Operand<?> var, Operand<?> m,
      Operand<T> lr, Operand<T> logbase, Operand<T> signDecay, Operand<T> beta, Operand<T> grad,
      ResourceApplyPowerSign.Options... options) {
    return ResourceApplyPowerSign.create(scope, var, m, lr, logbase, signDecay, beta, grad, options);
  }

  /**
   * Adds an {@link ApplyMomentum} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param grad The gradient.
   * @param momentum Momentum. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of ApplyMomentum
   * @see org.tensorflow.op.core.ApplyMomentum
   */
  public <T> ApplyMomentum<T> applyMomentum(Operand<T> var, Operand<T> accum, Operand<T> lr,
      Operand<T> grad, Operand<T> momentum, ApplyMomentum.Options... options) {
    return ApplyMomentum.create(scope, var, accum, lr, grad, momentum, options);
  }

  /**
   * Adds an {@link TensorArrayScatter} operation to the graph
   *
   * @param handle The handle to a TensorArray.
   * @param indices The locations at which to write the tensor elements.
   * @param value The concatenated tensor to write to the TensorArray.
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @return a new instance of TensorArrayScatter
   * @see org.tensorflow.op.core.TensorArrayScatter
   */
  public <T> TensorArrayScatter tensorArrayScatter(Operand<?> handle, Operand<Integer> indices,
      Operand<T> value, Operand<Float> flowIn) {
    return TensorArrayScatter.create(scope, handle, indices, value, flowIn);
  }

  /**
   * Adds an {@link BatchIFFT3D} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchIFFT3D
   * @see org.tensorflow.op.core.BatchIFFT3D
   */
  public BatchIFFT3D batchIFFT3D(Operand<?> input) {
    return BatchIFFT3D.create(scope, input);
  }

  /**
   * Adds an {@link SparseSegmentSqrtNGrad} operation to the graph
   *
   * @param grad gradient propagated to the SparseSegmentSqrtN op.
   * @param indices indices passed to the corresponding SparseSegmentSqrtN op.
   * @param segmentIds segment_ids passed to the corresponding SparseSegmentSqrtN op.
   * @param outputDim0 dimension 0 of "data" passed to SparseSegmentSqrtN op.
   * @return a new instance of SparseSegmentSqrtNGrad
   * @see org.tensorflow.op.core.SparseSegmentSqrtNGrad
   */
  public <T extends Number, U extends Number> SparseSegmentSqrtNGrad<T> sparseSegmentSqrtNGrad(Operand<T> grad,
      Operand<U> indices, Operand<Integer> segmentIds, Operand<Integer> outputDim0) {
    return SparseSegmentSqrtNGrad.create(scope, grad, indices, segmentIds, outputDim0);
  }

  /**
   * Adds an {@link QuantizedMul} operation to the graph
   *
   * @param x 
   * @param y 
   * @param minX The float value that the lowest quantized `x` value represents.
   * @param maxX The float value that the highest quantized `x` value represents.
   * @param minY The float value that the lowest quantized `y` value represents.
   * @param maxY The float value that the highest quantized `y` value represents.
   * @param Toutput 
   * @return a new instance of QuantizedMul
   * @see org.tensorflow.op.core.QuantizedMul
   */
  public <V, T, U> QuantizedMul<V> quantizedMul(Operand<T> x, Operand<U> y, Operand<Float> minX,
      Operand<Float> maxX, Operand<Float> minY, Operand<Float> maxY, Class<V> Toutput) {
    return QuantizedMul.create(scope, x, y, minX, maxX, minY, maxY, Toutput);
  }

  /**
   * Adds an {@link IFFT2D} operation to the graph
   *
   * @param input A complex tensor.
   * @return a new instance of IFFT2D
   * @see org.tensorflow.op.core.IFFT2D
   */
  public <T> IFFT2D<T> iFFT2D(Operand<T> input) {
    return IFFT2D.create(scope, input);
  }

  /**
   * Adds an {@link Inv} operation to the graph
   *
   * @param x 
   * @return a new instance of Inv
   * @see org.tensorflow.op.core.Inv
   */
  public <T> Inv<T> inv(Operand<T> x) {
    return Inv.create(scope, x);
  }

  /**
   * Adds an {@link ExtractGlimpse} operation to the graph
   *
   * @param input A 4-D float tensor of shape `[batch_size, height, width, channels]`.
   * @param size A 1-D tensor of 2 elements containing the size of the glimpses
   * @param offsets A 2-D integer tensor of shape `[batch_size, 2]` containing
   * @param options carries optional attributes values
   * @return a new instance of ExtractGlimpse
   * @see org.tensorflow.op.core.ExtractGlimpse
   */
  public ExtractGlimpse extractGlimpse(Operand<Float> input, Operand<Integer> size,
      Operand<Float> offsets, ExtractGlimpse.Options... options) {
    return ExtractGlimpse.create(scope, input, size, offsets, options);
  }

  /**
   * Adds an {@link CudnnRNNParamsToCanonical} operation to the graph
   *
   * @param numLayers 
   * @param numUnits 
   * @param inputSize 
   * @param params 
   * @param numParams 
   * @param options carries optional attributes values
   * @return a new instance of CudnnRNNParamsToCanonical
   * @see org.tensorflow.op.core.CudnnRNNParamsToCanonical
   */
  public <T extends Number> CudnnRNNParamsToCanonical<T> cudnnRNNParamsToCanonical(Operand<Integer> numLayers,
      Operand<Integer> numUnits, Operand<Integer> inputSize, Operand<T> params, Long numParams,
      CudnnRNNParamsToCanonical.Options... options) {
    return CudnnRNNParamsToCanonical.create(scope, numLayers, numUnits, inputSize, params, numParams, options);
  }

  /**
   * Adds an {@link InTopKV2} operation to the graph
   *
   * @param predictions A `batch_size` x `classes` tensor.
   * @param targets A `batch_size` vector of class ids.
   * @param k Number of top elements to look at for computing precision.
   * @return a new instance of InTopKV2
   * @see org.tensorflow.op.core.InTopKV2
   */
  public <T extends Number> InTopKV2 inTopKV2(Operand<Float> predictions, Operand<T> targets,
      Operand<T> k) {
    return InTopKV2.create(scope, predictions, targets, k);
  }

  /**
   * Adds an {@link Bitcast} operation to the graph
   *
   * @param input 
   * @param type 
   * @return a new instance of Bitcast
   * @see org.tensorflow.op.core.Bitcast
   */
  public <U, T> Bitcast<U> bitcast(Operand<T> input, Class<U> type) {
    return Bitcast.create(scope, input, type);
  }

  /**
   * Adds an {@link AssignSubVariableOp} operation to the graph
   *
   * @param resource handle to the resource in which to store the variable.
   * @param value the value by which the variable will be incremented.
   * @return a new instance of AssignSubVariableOp
   * @see org.tensorflow.op.core.AssignSubVariableOp
   */
  public <T> AssignSubVariableOp assignSubVariableOp(Operand<?> resource, Operand<T> value) {
    return AssignSubVariableOp.create(scope, resource, value);
  }

  /**
   * Adds an {@link Roll} operation to the graph
   *
   * @param input 
   * @param shift Dimension must be 0-D or 1-D. `shift[i]` specifies the number of places by which
   * @param axis Dimension must be 0-D or 1-D. `axis[i]` specifies the dimension that the shift
   * @return a new instance of Roll
   * @see org.tensorflow.op.core.Roll
   */
  public <T, U extends Number, V extends Number> Roll<T> roll(Operand<T> input, Operand<U> shift,
      Operand<V> axis) {
    return Roll.create(scope, input, shift, axis);
  }

  /**
   * Adds an {@link HistogramSummary} operation to the graph
   *
   * @param tag Scalar.  Tag to use for the `Summary.Value`.
   * @param values Any shape. Values to use to build the histogram.
   * @return a new instance of HistogramSummary
   * @see org.tensorflow.op.core.HistogramSummary
   */
  public <T extends Number> HistogramSummary histogramSummary(Operand<String> tag,
      Operand<T> values) {
    return HistogramSummary.create(scope, tag, values);
  }

  /**
   * Adds an {@link FusedBatchNormGrad} operation to the graph
   *
   * @param yBackprop A 4D Tensor for the gradient with respect to y.
   * @param x A 4D Tensor for input data.
   * @param scale A 1D Tensor for scaling factor, to scale the normalized x.
   * @param reserveSpace1 When is_training is True, a 1D Tensor for the computed batch
   * @param reserveSpace2 When is_training is True, a 1D Tensor for the computed batch
   * @param options carries optional attributes values
   * @return a new instance of FusedBatchNormGrad
   * @see org.tensorflow.op.core.FusedBatchNormGrad
   */
  public <T extends Number> FusedBatchNormGrad<T> fusedBatchNormGrad(Operand<T> yBackprop,
      Operand<T> x, Operand<T> scale, Operand<T> reserveSpace1, Operand<T> reserveSpace2,
      FusedBatchNormGrad.Options... options) {
    return FusedBatchNormGrad.create(scope, yBackprop, x, scale, reserveSpace1, reserveSpace2, options);
  }

  /**
   * Adds an {@link EncodePng} operation to the graph
   *
   * @param image 3-D with shape `[height, width, channels]`.
   * @param options carries optional attributes values
   * @return a new instance of EncodePng
   * @see org.tensorflow.op.core.EncodePng
   */
  public <T extends Number> EncodePng encodePng(Operand<T> image, EncodePng.Options... options) {
    return EncodePng.create(scope, image, options);
  }

  /**
   * Adds an {@link SparseSoftmaxCrossEntropyWithLogits} operation to the graph
   *
   * @param features batch_size x num_classes matrix
   * @param labels batch_size vector with values in [0, num_classes).
   * @return a new instance of SparseSoftmaxCrossEntropyWithLogits
   * @see org.tensorflow.op.core.SparseSoftmaxCrossEntropyWithLogits
   */
  public <T extends Number, U extends Number> SparseSoftmaxCrossEntropyWithLogits<T> sparseSoftmaxCrossEntropyWithLogits(Operand<T> features,
      Operand<U> labels) {
    return SparseSoftmaxCrossEntropyWithLogits.create(scope, features, labels);
  }

  /**
   * Adds an {@link DeserializeManySparse} operation to the graph
   *
   * @param serializedSparse 2-D, The `N` serialized `SparseTensor` objects.
   * @param dtype The `dtype` of the serialized `SparseTensor` objects.
   * @return a new instance of DeserializeManySparse
   * @see org.tensorflow.op.core.DeserializeManySparse
   */
  public <T> DeserializeManySparse<T> deserializeManySparse(Operand<String> serializedSparse,
      Class<T> dtype) {
    return DeserializeManySparse.create(scope, serializedSparse, dtype);
  }

  /**
   * Adds an {@link MatrixSolveLs} operation to the graph
   *
   * @param matrix Shape is `[..., M, N]`.
   * @param rhs Shape is `[..., M, K]`.
   * @param l2Regularizer Scalar tensor.
   * @param options carries optional attributes values
   * @return a new instance of MatrixSolveLs
   * @see org.tensorflow.op.core.MatrixSolveLs
   */
  public <T> MatrixSolveLs<T> matrixSolveLs(Operand<T> matrix, Operand<T> rhs,
      Operand<Double> l2Regularizer, MatrixSolveLs.Options... options) {
    return MatrixSolveLs.create(scope, matrix, rhs, l2Regularizer, options);
  }

  /**
   * Adds an {@link EagerPyFunc} operation to the graph
   *
   * @param input 
   * @param token 
   * @param Tout 
   * @return a new instance of EagerPyFunc
   * @see org.tensorflow.op.core.EagerPyFunc
   */
  public EagerPyFunc eagerPyFunc(Iterable<Operand<?>> input, String token, List<Class<?>> Tout) {
    return EagerPyFunc.create(scope, input, token, Tout);
  }

  /**
   * Adds an {@link EnsureShape} operation to the graph
   *
   * @param input A tensor, whose shape is to be validated.
   * @param shape The expected (possibly partially specified) shape of the input tensor.
   * @return a new instance of EnsureShape
   * @see org.tensorflow.op.core.EnsureShape
   */
  public <T> EnsureShape<T> ensureShape(Operand<T> input, Shape shape) {
    return EnsureShape.create(scope, input, shape);
  }

  /**
   * Adds an {@link Subtract} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Subtract
   * @see org.tensorflow.op.core.Subtract
   */
  public <T> Subtract<T> subtract(Operand<T> x, Operand<T> y) {
    return Subtract.create(scope, x, y);
  }

  /**
   * Adds an {@link RandomShuffleQueue} operation to the graph
   *
   * @param componentTypes The type of each component in a value.
   * @param options carries optional attributes values
   * @return a new instance of RandomShuffleQueue
   * @see org.tensorflow.op.core.RandomShuffleQueue
   */
  public RandomShuffleQueue randomShuffleQueue(List<Class<?>> componentTypes,
      RandomShuffleQueue.Options... options) {
    return RandomShuffleQueue.create(scope, componentTypes, options);
  }

  /**
   * Adds an {@link StringSplitV2} operation to the graph
   *
   * @param input `1-D` string `Tensor`, the strings to split.
   * @param sep `0-D` string `Tensor`, the delimiter character.
   * @param options carries optional attributes values
   * @return a new instance of StringSplitV2
   * @see org.tensorflow.op.core.StringSplitV2
   */
  public StringSplitV2 stringSplitV2(Operand<String> input, Operand<String> sep,
      StringSplitV2.Options... options) {
    return StringSplitV2.create(scope, input, sep, options);
  }

  /**
   * Adds an {@link SparseReduceSum} operation to the graph
   *
   * @param inputIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param inputValues 1-D.  `N` non-empty values corresponding to `input_indices`.
   * @param inputShape 1-D.  Shape of the input SparseTensor.
   * @param reductionAxes 1-D.  Length-`K` vector containing the reduction axes.
   * @param options carries optional attributes values
   * @return a new instance of SparseReduceSum
   * @see org.tensorflow.op.core.SparseReduceSum
   */
  public <T> SparseReduceSum<T> sparseReduceSum(Operand<Long> inputIndices, Operand<T> inputValues,
      Operand<Long> inputShape, Operand<Integer> reductionAxes,
      SparseReduceSum.Options... options) {
    return SparseReduceSum.create(scope, inputIndices, inputValues, inputShape, reductionAxes, options);
  }

  /**
   * Adds an {@link Equal} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Equal
   * @see org.tensorflow.op.core.Equal
   */
  public <T> Equal equal(Operand<T> x, Operand<T> y) {
    return Equal.create(scope, x, y);
  }

  /**
   * Adds an {@link RemoteFusedGraphExecute} operation to the graph
   *
   * @param inputs Arbitrary number of tensors with arbitrary data types
   * @param Toutputs 
   * @param serializedRemoteFusedGraphExecuteInfo Serialized protocol buffer
   * @return a new instance of RemoteFusedGraphExecute
   * @see org.tensorflow.op.core.RemoteFusedGraphExecute
   */
  public RemoteFusedGraphExecute remoteFusedGraphExecute(Iterable<Operand<?>> inputs,
      List<Class<?>> Toutputs, String serializedRemoteFusedGraphExecuteInfo) {
    return RemoteFusedGraphExecute.create(scope, inputs, Toutputs, serializedRemoteFusedGraphExecuteInfo);
  }

  /**
   * Adds an {@link MirrorPad} operation to the graph
   *
   * @param input The input tensor to be padded.
   * @param paddings A two-column matrix specifying the padding sizes. The number of
   * @param mode Either `REFLECT` or `SYMMETRIC`. In reflect mode the padded regions
   * @return a new instance of MirrorPad
   * @see org.tensorflow.op.core.MirrorPad
   */
  public <T, U extends Number> MirrorPad<T> mirrorPad(Operand<T> input, Operand<U> paddings,
      String mode) {
    return MirrorPad.create(scope, input, paddings, mode);
  }

  /**
   * Adds an {@link ResourceApplyAddSign} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param m Should be from a Variable().
   * @param lr Scaling factor. Must be a scalar.
   * @param alpha Must be a scalar.
   * @param signDecay Must be a scalar.
   * @param beta Must be a scalar.
   * @param grad The gradient.
   * @param options carries optional attributes values
   * @return a new instance of ResourceApplyAddSign
   * @see org.tensorflow.op.core.ResourceApplyAddSign
   */
  public <T> ResourceApplyAddSign resourceApplyAddSign(Operand<?> var, Operand<?> m, Operand<T> lr,
      Operand<T> alpha, Operand<T> signDecay, Operand<T> beta, Operand<T> grad,
      ResourceApplyAddSign.Options... options) {
    return ResourceApplyAddSign.create(scope, var, m, lr, alpha, signDecay, beta, grad, options);
  }

  /**
   * Adds an {@link Complex} operation to the graph
   *
   * @param real 
   * @param imag 
   * @param Tout 
   * @return a new instance of Complex
   * @see org.tensorflow.op.core.Complex
   */
  public <U, T extends Number> Complex<U> complex(Operand<T> real, Operand<T> imag, Class<U> Tout) {
    return Complex.create(scope, real, imag, Tout);
  }

  /**
   * Adds an {@link FakeQuantWithMinMaxVarsPerChannel} operation to the graph
   *
   * @param inputs 
   * @param min 
   * @param max 
   * @param options carries optional attributes values
   * @return a new instance of FakeQuantWithMinMaxVarsPerChannel
   * @see org.tensorflow.op.core.FakeQuantWithMinMaxVarsPerChannel
   */
  public FakeQuantWithMinMaxVarsPerChannel fakeQuantWithMinMaxVarsPerChannel(Operand<Float> inputs,
      Operand<Float> min, Operand<Float> max,
      FakeQuantWithMinMaxVarsPerChannel.Options... options) {
    return FakeQuantWithMinMaxVarsPerChannel.create(scope, inputs, min, max, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param shape the tensor shape.
   * @param data a buffer containing the tensor data.
   * @return a long constant
   * @throws IllegalArgumentException If the tensor shape is not compatible with the buffer
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Long> constant(long[] shape, LongBuffer data) {
    return Constant.create(scope, shape, data);
  }

  /**
   * Adds an {@link OneHot} operation to the graph
   *
   * @param indices A tensor of indices.
   * @param depth A scalar defining the depth of the one hot dimension.
   * @param onValue A scalar defining the value to fill in output when `indices[j] = i`.
   * @param offValue A scalar defining the value to fill in output when `indices[j] != i`.
   * @param options carries optional attributes values
   * @return a new instance of OneHot
   * @see org.tensorflow.op.core.OneHot
   */
  public <U, T extends Number> OneHot<U> oneHot(Operand<T> indices, Operand<Integer> depth,
      Operand<U> onValue, Operand<U> offValue, OneHot.Options... options) {
    return OneHot.create(scope, indices, depth, onValue, offValue, options);
  }

  /**
   * Adds an {@link SparseApplyFtrlV2} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param linear Should be from a Variable().
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param lr Scaling factor. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 shrinkage regulariation. Must be a scalar.
   * @param l2Shrinkage 
   * @param lrPower Scaling factor. Must be a scalar.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyFtrlV2
   * @see org.tensorflow.op.core.SparseApplyFtrlV2
   */
  public <T, U extends Number> SparseApplyFtrlV2<T> sparseApplyFtrlV2(Operand<T> var,
      Operand<T> accum, Operand<T> linear, Operand<T> grad, Operand<U> indices, Operand<T> lr,
      Operand<T> l1, Operand<T> l2, Operand<T> l2Shrinkage, Operand<T> lrPower,
      SparseApplyFtrlV2.Options... options) {
    return SparseApplyFtrlV2.create(scope, var, accum, linear, grad, indices, lr, l1, l2, l2Shrinkage, lrPower, options);
  }

  /**
   * Adds an {@link DecodeJpeg} operation to the graph
   *
   * @param contents 0-D.  The JPEG-encoded image.
   * @param options carries optional attributes values
   * @return a new instance of DecodeJpeg
   * @see org.tensorflow.op.core.DecodeJpeg
   */
  public DecodeJpeg decodeJpeg(Operand<String> contents, DecodeJpeg.Options... options) {
    return DecodeJpeg.create(scope, contents, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Float> constant(float[][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link BiasAddGrad} operation to the graph
   *
   * @param outBackprop Any number of dimensions.
   * @param options carries optional attributes values
   * @return a new instance of BiasAddGrad
   * @see org.tensorflow.op.core.BiasAddGrad
   */
  public <T> BiasAddGrad<T> biasAddGrad(Operand<T> outBackprop, BiasAddGrad.Options... options) {
    return BiasAddGrad.create(scope, outBackprop, options);
  }

  /**
   * Adds an {@link UnicodeScript} operation to the graph
   *
   * @param input A Tensor of int32 Unicode code points.
   * @return a new instance of UnicodeScript
   * @see org.tensorflow.op.core.UnicodeScript
   */
  public UnicodeScript unicodeScript(Operand<Integer> input) {
    return UnicodeScript.create(scope, input);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data The value to put into the new constant.
   * @return a long constant
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Long> constant(long data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link OptionalHasValue} operation to the graph
   *
   * @param optional 
   * @return a new instance of OptionalHasValue
   * @see org.tensorflow.op.core.OptionalHasValue
   */
  public OptionalHasValue optionalHasValue(Operand<?> optional) {
    return OptionalHasValue.create(scope, optional);
  }

  /**
   * Adds an {@link ResourceScatterUpdate} operation to the graph
   *
   * @param resource Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to add to `ref`.
   * @return a new instance of ResourceScatterUpdate
   * @see org.tensorflow.op.core.ResourceScatterUpdate
   */
  public <T extends Number, U> ResourceScatterUpdate resourceScatterUpdate(Operand<?> resource,
      Operand<T> indices, Operand<U> updates) {
    return ResourceScatterUpdate.create(scope, resource, indices, updates);
  }

  /**
   * Adds an {@link Imag} operation to the graph
   *
   * @param input 
   * @return a new instance of Imag
   * @see org.tensorflow.op.core.Imag
   */
  public <T> Imag<Float> imag(Operand<T> input) {
    return Imag.create(scope, input);
  }

  /**
   * Adds an {@link DiagPart} operation to the graph
   *
   * @param input Rank k tensor where k is even and not zero.
   * @return a new instance of DiagPart
   * @see org.tensorflow.op.core.DiagPart
   */
  public <T> DiagPart<T> diagPart(Operand<T> input) {
    return DiagPart.create(scope, input);
  }

  /**
   * Adds an {@link LookupTableInsert} operation to the graph
   *
   * @param tableHandle Handle to the table.
   * @param keys Any shape.  Keys to look up.
   * @param values Values to associate with keys.
   * @return a new instance of LookupTableInsert
   * @see org.tensorflow.op.core.LookupTableInsert
   */
  public <T, U> LookupTableInsert lookupTableInsert(Operand<?> tableHandle, Operand<T> keys,
      Operand<U> values) {
    return LookupTableInsert.create(scope, tableHandle, keys, values);
  }

  /**
   * Adds an {@link UniqueV2} operation to the graph
   *
   * @param x A `Tensor`.
   * @param axis A `Tensor` of type `int32` (default: None). The axis of the Tensor to
   * @param outIdx 
   * @return a new instance of UniqueV2
   * @see org.tensorflow.op.core.UniqueV2
   */
  public <T, V extends Number, U extends Number> UniqueV2<T, V> uniqueV2(Operand<T> x,
      Operand<U> axis, Class<V> outIdx) {
    return UniqueV2.create(scope, x, axis, outIdx);
  }

  /**
   * Adds an {@link QuantizeV2} operation to the graph
   *
   * @param input 
   * @param minRange The minimum scalar value possibly produced for the input.
   * @param maxRange The maximum scalar value possibly produced for the input.
   * @param T 
   * @param options carries optional attributes values
   * @return a new instance of QuantizeV2
   * @see org.tensorflow.op.core.QuantizeV2
   */
  public <T> QuantizeV2<T> quantizeV2(Operand<Float> input, Operand<Float> minRange,
      Operand<Float> maxRange, Class<T> T, QuantizeV2.Options... options) {
    return QuantizeV2.create(scope, input, minRange, maxRange, T, options);
  }

  /**
   * Adds an {@link LearnedUnigramCandidateSampler} operation to the graph
   *
   * @param trueClasses A batch_size * num_true matrix, in which each row contains the
   * @param numTrue Number of true labels per context.
   * @param numSampled Number of candidates to randomly sample.
   * @param unique If unique is true, we sample with rejection, so that all sampled
   * @param rangeMax The sampler will sample integers from the interval [0, range_max).
   * @param options carries optional attributes values
   * @return a new instance of LearnedUnigramCandidateSampler
   * @see org.tensorflow.op.core.LearnedUnigramCandidateSampler
   */
  public LearnedUnigramCandidateSampler learnedUnigramCandidateSampler(Operand<Long> trueClasses,
      Long numTrue, Long numSampled, Boolean unique, Long rangeMax,
      LearnedUnigramCandidateSampler.Options... options) {
    return LearnedUnigramCandidateSampler.create(scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
  }

  /**
   * Adds an {@link TruncateDiv} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of TruncateDiv
   * @see org.tensorflow.op.core.TruncateDiv
   */
  public <T> TruncateDiv<T> truncateDiv(Operand<T> x, Operand<T> y) {
    return TruncateDiv.create(scope, x, y);
  }

  /**
   * Adds an {@link StatelessRandomNormal} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param seed 2 seeds (shape [2]).
   * @param dtype The type of the output.
   * @return a new instance of StatelessRandomNormal
   * @see org.tensorflow.op.core.StatelessRandomNormal
   */
  public <V extends Number, T extends Number, U extends Number> StatelessRandomNormal<V> statelessRandomNormal(Operand<T> shape,
      Operand<U> seed, Class<V> dtype) {
    return StatelessRandomNormal.create(scope, shape, seed, dtype);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Double> constant(double[][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link SparseApplyAdadelta} operation to the graph
   *
   * @param var 
   * @param accum Should be from a Variable().
   * @param accumUpdate : Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param rho Decay factor. Must be a scalar.
   * @param epsilon Constant factor. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param options carries optional attributes values
   * @return a new instance of SparseApplyAdadelta
   * @see org.tensorflow.op.core.SparseApplyAdadelta
   */
  public <T, U extends Number> SparseApplyAdadelta<T> sparseApplyAdadelta(Operand<T> var,
      Operand<T> accum, Operand<T> accumUpdate, Operand<T> lr, Operand<T> rho, Operand<T> epsilon,
      Operand<T> grad, Operand<U> indices, SparseApplyAdadelta.Options... options) {
    return SparseApplyAdadelta.create(scope, var, accum, accumUpdate, lr, rho, epsilon, grad, indices, options);
  }

  /**
   * Adds an {@link AsString} operation to the graph
   *
   * @param input 
   * @param options carries optional attributes values
   * @return a new instance of AsString
   * @see org.tensorflow.op.core.AsString
   */
  public <T> AsString asString(Operand<T> input, AsString.Options... options) {
    return AsString.create(scope, input, options);
  }

  /**
   * Adds an {@link AddV2} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of AddV2
   * @see org.tensorflow.op.core.AddV2
   */
  public <T> AddV2<T> addV2(Operand<T> x, Operand<T> y) {
    return AddV2.create(scope, x, y);
  }

  /**
   * Adds an {@link FIFOQueue} operation to the graph
   *
   * @param componentTypes The type of each component in a value.
   * @param options carries optional attributes values
   * @return a new instance of FIFOQueue
   * @see org.tensorflow.op.core.FIFOQueue
   */
  public FIFOQueue fIFOQueue(List<Class<?>> componentTypes, FIFOQueue.Options... options) {
    return FIFOQueue.create(scope, componentTypes, options);
  }

  /**
   * Adds an {@link BesselI1e} operation to the graph
   *
   * @param x 
   * @return a new instance of BesselI1e
   * @see org.tensorflow.op.core.BesselI1e
   */
  public <T extends Number> BesselI1e<T> besselI1e(Operand<T> x) {
    return BesselI1e.create(scope, x);
  }

  /**
   * Adds an {@link BitwiseAnd} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of BitwiseAnd
   * @see org.tensorflow.op.core.BitwiseAnd
   */
  public <T extends Number> BitwiseAnd<T> bitwiseAnd(Operand<T> x, Operand<T> y) {
    return BitwiseAnd.create(scope, x, y);
  }

  /**
   * Adds an {@link Sub} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Sub
   * @see org.tensorflow.op.core.Sub
   */
  public <T> Sub<T> sub(Operand<T> x, Operand<T> y) {
    return Sub.create(scope, x, y);
  }

  /**
   * Adds an {@link BatchNormWithGlobalNormalization} operation to the graph
   *
   * @param t A 4D input Tensor.
   * @param m A 1D mean Tensor with size matching the last dimension of t.
   * @param v A 1D variance Tensor with size matching the last dimension of t.
   * @param beta A 1D beta Tensor with size matching the last dimension of t.
   * @param gamma A 1D gamma Tensor with size matching the last dimension of t.
   * @param varianceEpsilon A small float number to avoid dividing by 0.
   * @param scaleAfterNormalization A bool indicating whether the resulted tensor
   * @return a new instance of BatchNormWithGlobalNormalization
   * @see org.tensorflow.op.core.BatchNormWithGlobalNormalization
   */
  public <T> BatchNormWithGlobalNormalization<T> batchNormWithGlobalNormalization(Operand<T> t,
      Operand<T> m, Operand<T> v, Operand<T> beta, Operand<T> gamma, Float varianceEpsilon,
      Boolean scaleAfterNormalization) {
    return BatchNormWithGlobalNormalization.create(scope, t, m, v, beta, gamma, varianceEpsilon, scaleAfterNormalization);
  }

  /**
   * Adds an {@link MapClear} operation to the graph
   *
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of MapClear
   * @see org.tensorflow.op.core.MapClear
   */
  public MapClear mapClear(List<Class<?>> dtypes, MapClear.Options... options) {
    return MapClear.create(scope, dtypes, options);
  }

  /**
   * Adds an {@link SerializeTensor} operation to the graph
   *
   * @param tensor A Tensor of type `T`.
   * @return a new instance of SerializeTensor
   * @see org.tensorflow.op.core.SerializeTensor
   */
  public <T> SerializeTensor serializeTensor(Operand<T> tensor) {
    return SerializeTensor.create(scope, tensor);
  }

  /**
   * Adds an {@link Size} operation to the graph
   *
   * @param input 
   * @return a new instance of Size
   * @see org.tensorflow.op.core.Size
   */
  public <T> Size<Integer> size(Operand<T> input) {
    return Size.create(scope, input);
  }

  /**
   * Adds an {@link SerializeManySparse} operation to the graph
   *
   * @param sparseIndices 2-D.  The `indices` of the minibatch `SparseTensor`.
   * @param sparseValues 1-D.  The `values` of the minibatch `SparseTensor`.
   * @param sparseShape 1-D.  The `shape` of the minibatch `SparseTensor`.
   * @return a new instance of SerializeManySparse
   * @see org.tensorflow.op.core.SerializeManySparse
   */
  public <T> SerializeManySparse<String> serializeManySparse(Operand<Long> sparseIndices,
      Operand<T> sparseValues, Operand<Long> sparseShape) {
    return SerializeManySparse.create(scope, sparseIndices, sparseValues, sparseShape);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Float> constant(float[][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link StagePeek} operation to the graph
   *
   * @param index 
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of StagePeek
   * @see org.tensorflow.op.core.StagePeek
   */
  public StagePeek stagePeek(Operand<Integer> index, List<Class<?>> dtypes,
      StagePeek.Options... options) {
    return StagePeek.create(scope, index, dtypes, options);
  }

  /**
   * Adds an {@link IteratorGetNextSync} operation to the graph
   *
   * @param iterator 
   * @param outputTypes 
   * @param outputShapes 
   * @return a new instance of IteratorGetNextSync
   * @see org.tensorflow.op.core.IteratorGetNextSync
   */
  public IteratorGetNextSync iteratorGetNextSync(Operand<?> iterator, List<Class<?>> outputTypes,
      List<Shape> outputShapes) {
    return IteratorGetNextSync.create(scope, iterator, outputTypes, outputShapes);
  }

  /**
   * Adds an {@link Sign} operation to the graph
   *
   * @param x 
   * @return a new instance of Sign
   * @see org.tensorflow.op.core.Sign
   */
  public <T> Sign<T> sign(Operand<T> x) {
    return Sign.create(scope, x);
  }

  /**
   * Adds an {@link ZerosLike} operation to the graph
   *
   * @param x a tensor of type T.
   * @return a new instance of ZerosLike
   * @see org.tensorflow.op.core.ZerosLike
   */
  public <T> ZerosLike<T> zerosLike(Operand<T> x) {
    return ZerosLike.create(scope, x);
  }

  /**
   * Adds an {@link TensorArrayPack} operation to the graph
   *
   * @param handle 
   * @param flowIn 
   * @param dtype 
   * @param options carries optional attributes values
   * @return a new instance of TensorArrayPack
   * @see org.tensorflow.op.core.TensorArrayPack
   */
  public <T> TensorArrayPack<T> tensorArrayPack(Operand<String> handle, Operand<Float> flowIn,
      Class<T> dtype, TensorArrayPack.Options... options) {
    return TensorArrayPack.create(scope, handle, flowIn, dtype, options);
  }

  /**
   * Adds an {@link ReduceMean} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of ReduceMean
   * @see org.tensorflow.op.core.ReduceMean
   */
  public <T, U extends Number> ReduceMean<T> reduceMean(Operand<T> input, Operand<U> axis,
      ReduceMean.Options... options) {
    return ReduceMean.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link BatchFFT} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchFFT
   * @see org.tensorflow.op.core.BatchFFT
   */
  public BatchFFT batchFFT(Operand<?> input) {
    return BatchFFT.create(scope, input);
  }

  /**
   * Adds an {@link BatchFFT3D} operation to the graph
   *
   * @param input 
   * @return a new instance of BatchFFT3D
   * @see org.tensorflow.op.core.BatchFFT3D
   */
  public BatchFFT3D batchFFT3D(Operand<?> input) {
    return BatchFFT3D.create(scope, input);
  }

  /**
   * Adds an {@link Log1p} operation to the graph
   *
   * @param x 
   * @return a new instance of Log1p
   * @see org.tensorflow.op.core.Log1p
   */
  public <T> Log1p<T> log1p(Operand<T> x) {
    return Log1p.create(scope, x);
  }

  /**
   * Adds an {@link ArgMax} operation to the graph
   *
   * @param input 
   * @param dimension int32 or int64, must be in the range `[-rank(input), rank(input))`.
   * @return a new instance of ArgMax
   * @see org.tensorflow.op.core.ArgMax
   */
  public <T, U extends Number> ArgMax<Long> argMax(Operand<T> input, Operand<U> dimension) {
    return ArgMax.create(scope, input, dimension);
  }

  /**
   * Adds an {@link ParseExample} operation to the graph
   *
   * @param serialized A vector containing a batch of binary serialized Example protos.
   * @param names A vector containing the names of the serialized protos.
   * @param sparseKeys A list of Nsparse string Tensors (scalars).
   * @param denseKeys A list of Ndense string Tensors (scalars).
   * @param denseDefaults A list of Ndense Tensors (some may be empty).
   * @param sparseTypes A list of Nsparse types; the data types of data in each Feature
   * @param denseShapes A list of Ndense shapes; the shapes of data in each Feature
   * @return a new instance of ParseExample
   * @see org.tensorflow.op.core.ParseExample
   */
  public ParseExample parseExample(Operand<String> serialized, Operand<String> names,
      Iterable<Operand<String>> sparseKeys, Iterable<Operand<String>> denseKeys,
      Iterable<Operand<?>> denseDefaults, List<Class<?>> sparseTypes, List<Shape> denseShapes) {
    return ParseExample.create(scope, serialized, names, sparseKeys, denseKeys, denseDefaults, sparseTypes, denseShapes);
  }

  /**
   * Adds an {@link Lu} operation to the graph
   *
   * @param input A tensor of shape `[..., M, M]` whose inner-most 2 dimensions form matrices of
   * @return a new instance of Lu
   * @see org.tensorflow.op.core.Lu
   */
  public <T> Lu<T, Integer> lu(Operand<T> input) {
    return Lu.create(scope, input);
  }

  /**
   * Adds an {@link FakeQuantWithMinMaxArgs} operation to the graph
   *
   * @param inputs 
   * @param options carries optional attributes values
   * @return a new instance of FakeQuantWithMinMaxArgs
   * @see org.tensorflow.op.core.FakeQuantWithMinMaxArgs
   */
  public FakeQuantWithMinMaxArgs fakeQuantWithMinMaxArgs(Operand<Float> inputs,
      FakeQuantWithMinMaxArgs.Options... options) {
    return FakeQuantWithMinMaxArgs.create(scope, inputs, options);
  }

  /**
   * Adds an {@link Pow} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of Pow
   * @see org.tensorflow.op.core.Pow
   */
  public <T> Pow<T> pow(Operand<T> x, Operand<T> y) {
    return Pow.create(scope, x, y);
  }

  /**
   * Adds an {@link StatelessMultinomial} operation to the graph
   *
   * @param logits 2-D Tensor with shape `[batch_size, num_classes]`.  Each slice `[i, :]`
   * @param numSamples 0-D.  Number of independent samples to draw for each row slice.
   * @param seed 2 seeds (shape [2]).
   * @return a new instance of StatelessMultinomial
   * @see org.tensorflow.op.core.StatelessMultinomial
   */
  public <T extends Number, U extends Number> StatelessMultinomial<Long> statelessMultinomial(Operand<T> logits,
      Operand<Integer> numSamples, Operand<U> seed) {
    return StatelessMultinomial.create(scope, logits, numSamples, seed);
  }

  /**
   * Adds an {@link BatchSvd} operation to the graph
   *
   * @param input 
   * @param options carries optional attributes values
   * @return a new instance of BatchSvd
   * @see org.tensorflow.op.core.BatchSvd
   */
  public <T> BatchSvd<T> batchSvd(Operand<T> input, BatchSvd.Options... options) {
    return BatchSvd.create(scope, input, options);
  }

  /**
   * Adds an {@link QueueClose} operation to the graph
   *
   * @param handle The handle to a queue.
   * @param options carries optional attributes values
   * @return a new instance of QueueClose
   * @see org.tensorflow.op.core.QueueClose
   */
  public QueueClose queueClose(Operand<?> handle, QueueClose.Options... options) {
    return QueueClose.create(scope, handle, options);
  }

  /**
   * Adds an {@link Atan} operation to the graph
   *
   * @param x 
   * @return a new instance of Atan
   * @see org.tensorflow.op.core.Atan
   */
  public <T> Atan<T> atan(Operand<T> x) {
    return Atan.create(scope, x);
  }

  /**
   * Adds an {@link ReduceMax} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of ReduceMax
   * @see org.tensorflow.op.core.ReduceMax
   */
  public <T, U extends Number> ReduceMax<T> reduceMax(Operand<T> input, Operand<U> axis,
      ReduceMax.Options... options) {
    return ReduceMax.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link TensorListLength} operation to the graph
   *
   * @param inputHandle 
   * @return a new instance of TensorListLength
   * @see org.tensorflow.op.core.TensorListLength
   */
  public TensorListLength tensorListLength(Operand<?> inputHandle) {
    return TensorListLength.create(scope, inputHandle);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Integer> constant(int[] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link OrderedMapPeek} operation to the graph
   *
   * @param key 
   * @param indices 
   * @param dtypes 
   * @param options carries optional attributes values
   * @return a new instance of OrderedMapPeek
   * @see org.tensorflow.op.core.OrderedMapPeek
   */
  public OrderedMapPeek orderedMapPeek(Operand<Long> key, Operand<Integer> indices,
      List<Class<?>> dtypes, OrderedMapPeek.Options... options) {
    return OrderedMapPeek.create(scope, key, indices, dtypes, options);
  }

  /**
   * Adds an {@link InitializeTableFromTextFile} operation to the graph
   *
   * @param tableHandle Handle to a table which will be initialized.
   * @param filename Filename of a vocabulary text file.
   * @param keyIndex Column index in a line to get the table `key` values from.
   * @param valueIndex Column index that represents information of a line to get the table
   * @param options carries optional attributes values
   * @return a new instance of InitializeTableFromTextFile
   * @see org.tensorflow.op.core.InitializeTableFromTextFile
   */
  public InitializeTableFromTextFile initializeTableFromTextFile(Operand<?> tableHandle,
      Operand<String> filename, Long keyIndex, Long valueIndex,
      InitializeTableFromTextFile.Options... options) {
    return InitializeTableFromTextFile.create(scope, tableHandle, filename, keyIndex, valueIndex, options);
  }

  /**
   * Adds an {@link Expm1} operation to the graph
   *
   * @param x 
   * @return a new instance of Expm1
   * @see org.tensorflow.op.core.Expm1
   */
  public <T> Expm1<T> expm1(Operand<T> x) {
    return Expm1.create(scope, x);
  }

  /**
   * Adds an {@link L2Loss} operation to the graph
   *
   * @param t Typically 2-D, but may have any dimensions.
   * @return a new instance of L2Loss
   * @see org.tensorflow.op.core.L2Loss
   */
  public <T extends Number> L2Loss<T> l2Loss(Operand<T> t) {
    return L2Loss.create(scope, t);
  }

  /**
   * Adds an {@link Any} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of Any
   * @see org.tensorflow.op.core.Any
   */
  public <T extends Number> Any any(Operand<Boolean> input, Operand<T> axis,
      Any.Options... options) {
    return Any.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link ResourceScatterNdUpdate} operation to the graph
   *
   * @param ref A resource handle. Must be from a VarHandleOp.
   * @param indices A Tensor. Must be one of the following types: int32, int64.
   * @param updates A Tensor. Must have the same type as ref. A tensor of updated
   * @param options carries optional attributes values
   * @return a new instance of ResourceScatterNdUpdate
   * @see org.tensorflow.op.core.ResourceScatterNdUpdate
   */
  public <T extends Number, U> ResourceScatterNdUpdate resourceScatterNdUpdate(Operand<?> ref,
      Operand<T> indices, Operand<U> updates, ResourceScatterNdUpdate.Options... options) {
    return ResourceScatterNdUpdate.create(scope, ref, indices, updates, options);
  }

  /**
   * Adds an {@link UniqueV2} operation to the graph
   *
   * @param x A `Tensor`.
   * @param axis A `Tensor` of type `int32` (default: None). The axis of the Tensor to
   * @return a new instance of UniqueV2
   * @see org.tensorflow.op.core.UniqueV2
   */
  public <T, U extends Number> UniqueV2<T, Integer> uniqueV2(Operand<T> x, Operand<U> axis) {
    return UniqueV2.create(scope, x, axis);
  }

  /**
   * Adds an {@link RandomNormal} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param dtype The type of the output.
   * @param options carries optional attributes values
   * @return a new instance of RandomNormal
   * @see org.tensorflow.op.core.RandomNormal
   */
  public <U extends Number, T extends Number> RandomNormal<U> randomNormal(Operand<T> shape,
      Class<U> dtype, RandomNormal.Options... options) {
    return RandomNormal.create(scope, shape, dtype, options);
  }

  /**
   * Adds an {@link ClipByValue} operation to the graph
   *
   * @param t A `Tensor`.
   * @param clipValueMin A 0-D (scalar) `Tensor`, or a `Tensor` with the same shape
   * @param clipValueMax A 0-D (scalar) `Tensor`, or a `Tensor` with the same shape
   * @return a new instance of ClipByValue
   * @see org.tensorflow.op.core.ClipByValue
   */
  public <T> ClipByValue<T> clipByValue(Operand<T> t, Operand<T> clipValueMin,
      Operand<T> clipValueMax) {
    return ClipByValue.create(scope, t, clipValueMin, clipValueMax);
  }

  /**
   * Adds an {@link Svd} operation to the graph
   *
   * @param input A tensor of shape `[..., M, N]` whose inner-most 2 dimensions
   * @param options carries optional attributes values
   * @return a new instance of Svd
   * @see org.tensorflow.op.core.Svd
   */
  public <T> Svd<T> svd(Operand<T> input, Svd.Options... options) {
    return Svd.create(scope, input, options);
  }

  /**
   * Adds an {@link SparseReduceSumSparse} operation to the graph
   *
   * @param inputIndices 2-D.  `N x R` matrix with the indices of non-empty values in a
   * @param inputValues 1-D.  `N` non-empty values corresponding to `input_indices`.
   * @param inputShape 1-D.  Shape of the input SparseTensor.
   * @param reductionAxes 1-D.  Length-`K` vector containing the reduction axes.
   * @param options carries optional attributes values
   * @return a new instance of SparseReduceSumSparse
   * @see org.tensorflow.op.core.SparseReduceSumSparse
   */
  public <T> SparseReduceSumSparse<T> sparseReduceSumSparse(Operand<Long> inputIndices,
      Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes,
      SparseReduceSumSparse.Options... options) {
    return SparseReduceSumSparse.create(scope, inputIndices, inputValues, inputShape, reductionAxes, options);
  }

  /**
   * Adds an {@link Asinh} operation to the graph
   *
   * @param x 
   * @return a new instance of Asinh
   * @see org.tensorflow.op.core.Asinh
   */
  public <T> Asinh<T> asinh(Operand<T> x) {
    return Asinh.create(scope, x);
  }

  /**
   * Adds an {@link RGBToHSV} operation to the graph
   *
   * @param images 1-D or higher rank. RGB data to convert. Last dimension must be size 3.
   * @return a new instance of RGBToHSV
   * @see org.tensorflow.op.core.RGBToHSV
   */
  public <T extends Number> RGBToHSV<T> rGBToHSV(Operand<T> images) {
    return RGBToHSV.create(scope, images);
  }

  /**
   * Adds an {@link Elu} operation to the graph
   *
   * @param features 
   * @return a new instance of Elu
   * @see org.tensorflow.op.core.Elu
   */
  public <T extends Number> Elu<T> elu(Operand<T> features) {
    return Elu.create(scope, features);
  }

  /**
   * Adds an {@link Batch} operation to the graph
   *
   * @param inTensors 
   * @param numBatchThreads 
   * @param maxBatchSize 
   * @param batchTimeoutMicros 
   * @param gradTimeoutMicros 
   * @param options carries optional attributes values
   * @return a new instance of Batch
   * @see org.tensorflow.op.core.Batch
   */
  public Batch batch(Iterable<Operand<?>> inTensors, Long numBatchThreads, Long maxBatchSize,
      Long batchTimeoutMicros, Long gradTimeoutMicros, Batch.Options... options) {
    return Batch.create(scope, inTensors, numBatchThreads, maxBatchSize, batchTimeoutMicros, gradTimeoutMicros, options);
  }

  /**
   * Adds an {@link RecordInput} operation to the graph
   *
   * @param filePattern Glob pattern for the data files.
   * @param options carries optional attributes values
   * @return a new instance of RecordInput
   * @see org.tensorflow.op.core.RecordInput
   */
  public RecordInput recordInput(String filePattern, RecordInput.Options... options) {
    return RecordInput.create(scope, filePattern, options);
  }

  /**
   * Adds an {@link Dilation2DBackpropFilter} operation to the graph
   *
   * @param input 4-D with shape `[batch, in_height, in_width, depth]`.
   * @param filter 3-D with shape `[filter_height, filter_width, depth]`.
   * @param outBackprop 4-D with shape `[batch, out_height, out_width, depth]`.
   * @param strides 1-D of length 4. The stride of the sliding window for each dimension of
   * @param rates 1-D of length 4. The input stride for atrous morphological dilation.
   * @param padding The type of padding algorithm to use.
   * @return a new instance of Dilation2DBackpropFilter
   * @see org.tensorflow.op.core.Dilation2DBackpropFilter
   */
  public <T extends Number> Dilation2DBackpropFilter<T> dilation2DBackpropFilter(Operand<T> input,
      Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates,
      String padding) {
    return Dilation2DBackpropFilter.create(scope, input, filter, outBackprop, strides, rates, padding);
  }

  /**
   * Adds an {@link AvgPool3DGrad} operation to the graph
   *
   * @param origInputShape The original input dimensions.
   * @param grad Output backprop of shape `[batch, depth, rows, cols, channels]`.
   * @param ksize 1-D tensor of length 5. The size of the window for each dimension of
   * @param strides 1-D tensor of length 5. The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of AvgPool3DGrad
   * @see org.tensorflow.op.core.AvgPool3DGrad
   */
  public <T extends Number> AvgPool3DGrad<T> avgPool3DGrad(Operand<Integer> origInputShape,
      Operand<T> grad, List<Long> ksize, List<Long> strides, String padding,
      AvgPool3DGrad.Options... options) {
    return AvgPool3DGrad.create(scope, origInputShape, grad, ksize, strides, padding, options);
  }

  /**
   * Adds an {@link Angle} operation to the graph
   *
   * @param input 
   * @return a new instance of Angle
   * @see org.tensorflow.op.core.Angle
   */
  public <T> Angle<Float> angle(Operand<T> input) {
    return Angle.create(scope, input);
  }

  /**
   * Adds an {@link ResourceScatterMin} operation to the graph
   *
   * @param resource Should be from a `Variable` node.
   * @param indices A tensor of indices into the first dimension of `ref`.
   * @param updates A tensor of updated values to add to `ref`.
   * @return a new instance of ResourceScatterMin
   * @see org.tensorflow.op.core.ResourceScatterMin
   */
  public <T extends Number, U> ResourceScatterMin resourceScatterMin(Operand<?> resource,
      Operand<T> indices, Operand<U> updates) {
    return ResourceScatterMin.create(scope, resource, indices, updates);
  }

  /**
   * Adds an {@link Sin} operation to the graph
   *
   * @param x 
   * @return a new instance of Sin
   * @see org.tensorflow.op.core.Sin
   */
  public <T> Sin<T> sin(Operand<T> x) {
    return Sin.create(scope, x);
  }

  /**
   * Adds an {@link SaveV2} operation to the graph
   *
   * @param prefix Must have a single element. The prefix of the V2 checkpoint to which we
   * @param tensorNames shape {N}. The names of the tensors to be saved.
   * @param shapeAndSlices shape {N}.  The slice specs of the tensors to be saved.
   * @param tensors `N` tensors to save.
   * @return a new instance of SaveV2
   * @see org.tensorflow.op.core.SaveV2
   */
  public SaveV2 saveV2(Operand<String> prefix, Operand<String> tensorNames,
      Operand<String> shapeAndSlices, Iterable<Operand<?>> tensors) {
    return SaveV2.create(scope, prefix, tensorNames, shapeAndSlices, tensors);
  }

  /**
   * Adds an {@link ResourceSparseApplyAdadelta} operation to the graph
   *
   * @param var 
   * @param accum Should be from a Variable().
   * @param accumUpdate : Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param rho Decay factor. Must be a scalar.
   * @param epsilon Constant factor. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyAdadelta
   * @see org.tensorflow.op.core.ResourceSparseApplyAdadelta
   */
  public <T, U extends Number> ResourceSparseApplyAdadelta resourceSparseApplyAdadelta(Operand<?> var,
      Operand<?> accum, Operand<?> accumUpdate, Operand<T> lr, Operand<T> rho, Operand<T> epsilon,
      Operand<T> grad, Operand<U> indices, ResourceSparseApplyAdadelta.Options... options) {
    return ResourceSparseApplyAdadelta.create(scope, var, accum, accumUpdate, lr, rho, epsilon, grad, indices, options);
  }

  /**
   * Adds an {@link RandomPoisson} operation to the graph
   *
   * @param shape 
   * @param rate 
   * @param options carries optional attributes values
   * @return a new instance of RandomPoisson
   * @see org.tensorflow.op.core.RandomPoisson
   */
  public <U extends Number, T extends Number> RandomPoisson<U> randomPoisson(Operand<T> shape,
      Operand<U> rate, RandomPoisson.Options... options) {
    return RandomPoisson.create(scope, shape, rate, options);
  }

  /**
   * Adds an {@link ScatterNdNonAliasingAdd} operation to the graph
   *
   * @param input A Tensor.
   * @param indices A Tensor. Must be one of the following types: `int32`, `int64`.
   * @param updates A Tensor. Must have the same type as ref. A tensor of updated values
   * @return a new instance of ScatterNdNonAliasingAdd
   * @see org.tensorflow.op.core.ScatterNdNonAliasingAdd
   */
  public <T, U extends Number> ScatterNdNonAliasingAdd<T> scatterNdNonAliasingAdd(Operand<T> input,
      Operand<U> indices, Operand<T> updates) {
    return ScatterNdNonAliasingAdd.create(scope, input, indices, updates);
  }

  /**
   * Adds an {@link TensorArrayGather} operation to the graph
   *
   * @param handle The handle to a TensorArray.
   * @param indices The locations in the TensorArray from which to read tensor elements.
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @param dtype The type of the elem that is returned.
   * @param options carries optional attributes values
   * @return a new instance of TensorArrayGather
   * @see org.tensorflow.op.core.TensorArrayGather
   */
  public <T> TensorArrayGather<T> tensorArrayGather(Operand<?> handle, Operand<Integer> indices,
      Operand<Float> flowIn, Class<T> dtype, TensorArrayGather.Options... options) {
    return TensorArrayGather.create(scope, handle, indices, flowIn, dtype, options);
  }

  /**
   * Adds an {@link Cosh} operation to the graph
   *
   * @param x 
   * @return a new instance of Cosh
   * @see org.tensorflow.op.core.Cosh
   */
  public <T> Cosh<T> cosh(Operand<T> x) {
    return Cosh.create(scope, x);
  }

  /**
   * Adds an {@link Unique} operation to the graph
   *
   * @param x 1-D.
   * @param outIdx 
   * @return a new instance of Unique
   * @see org.tensorflow.op.core.Unique
   */
  public <T, U extends Number> Unique<T, U> unique(Operand<T> x, Class<U> outIdx) {
    return Unique.create(scope, x, outIdx);
  }

  /**
   * Adds an {@link TensorListConcatLists} operation to the graph
   *
   * @param inputA 
   * @param inputB 
   * @param elementDtype 
   * @return a new instance of TensorListConcatLists
   * @see org.tensorflow.op.core.TensorListConcatLists
   */
  public <T> TensorListConcatLists tensorListConcatLists(Operand<?> inputA, Operand<?> inputB,
      Class<T> elementDtype) {
    return TensorListConcatLists.create(scope, inputA, inputB, elementDtype);
  }

  /**
   * Adds an {@link WholeFileReader} operation to the graph
   *
   * @param options carries optional attributes values
   * @return a new instance of WholeFileReader
   * @see org.tensorflow.op.core.WholeFileReader
   */
  public WholeFileReader wholeFileReader(WholeFileReader.Options... options) {
    return WholeFileReader.create(scope, options);
  }

  /**
   * Adds an {@link DeserializeIterator} operation to the graph
   *
   * @param resourceHandle A handle to an iterator resource.
   * @param serialized A variant tensor storing the state of the iterator contained in the
   * @return a new instance of DeserializeIterator
   * @see org.tensorflow.op.core.DeserializeIterator
   */
  public DeserializeIterator deserializeIterator(Operand<?> resourceHandle, Operand<?> serialized) {
    return DeserializeIterator.create(scope, resourceHandle, serialized);
  }

  /**
   * Adds an {@link AccumulatorSetGlobalStep} operation to the graph
   *
   * @param handle The handle to an accumulator.
   * @param newGlobalStep The new global_step value to set.
   * @return a new instance of AccumulatorSetGlobalStep
   * @see org.tensorflow.op.core.AccumulatorSetGlobalStep
   */
  public AccumulatorSetGlobalStep accumulatorSetGlobalStep(Operand<String> handle,
      Operand<Long> newGlobalStep) {
    return AccumulatorSetGlobalStep.create(scope, handle, newGlobalStep);
  }

  /**
   * Adds an {@link LookupTableFind} operation to the graph
   *
   * @param tableHandle Handle to the table.
   * @param keys Any shape.  Keys to look up.
   * @param defaultValue 
   * @return a new instance of LookupTableFind
   * @see org.tensorflow.op.core.LookupTableFind
   */
  public <U, T> LookupTableFind<U> lookupTableFind(Operand<?> tableHandle, Operand<T> keys,
      Operand<U> defaultValue) {
    return LookupTableFind.create(scope, tableHandle, keys, defaultValue);
  }

  /**
   * Adds an {@link Range} operation to the graph
   *
   * @param start 0-D (scalar). First entry in the sequence.
   * @param limit 0-D (scalar). Upper limit of sequence, exclusive.
   * @param delta 0-D (scalar). Optional. Default is 1. Number that increments `start`.
   * @return a new instance of Range
   * @see org.tensorflow.op.core.Range
   */
  public <T extends Number> Range<T> range(Operand<T> start, Operand<T> limit, Operand<T> delta) {
    return Range.create(scope, start, limit, delta);
  }

  /**
   * Adds an {@link DenseToSparseSetOperation} operation to the graph
   *
   * @param set1 `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set2`.
   * @param set2Indices 2D `Tensor`, indices of a `SparseTensor`. Must be in row-major
   * @param set2Values 1D `Tensor`, values of a `SparseTensor`. Must be in row-major
   * @param set2Shape 1D `Tensor`, shape of a `SparseTensor`. `set2_shape[0...n-1]` must
   * @param setOperation 
   * @param options carries optional attributes values
   * @return a new instance of DenseToSparseSetOperation
   * @see org.tensorflow.op.core.DenseToSparseSetOperation
   */
  public <T> DenseToSparseSetOperation<T> denseToSparseSetOperation(Operand<T> set1,
      Operand<Long> set2Indices, Operand<T> set2Values, Operand<Long> set2Shape,
      String setOperation, DenseToSparseSetOperation.Options... options) {
    return DenseToSparseSetOperation.create(scope, set1, set2Indices, set2Values, set2Shape, setOperation, options);
  }

  /**
   * Adds an {@link StringSplit} operation to the graph
   *
   * @param input 1-D. Strings to split.
   * @param delimiter 0-D. Delimiter characters (bytes), or empty string.
   * @param options carries optional attributes values
   * @return a new instance of StringSplit
   * @see org.tensorflow.op.core.StringSplit
   */
  public StringSplit stringSplit(Operand<String> input, Operand<String> delimiter,
      StringSplit.Options... options) {
    return StringSplit.create(scope, input, delimiter, options);
  }

  /**
   * Adds an {@link TensorArrayGrad} operation to the graph
   *
   * @param handle The handle to the forward TensorArray.
   * @param flowIn A float scalar that enforces proper chaining of operations.
   * @param source The gradient source string, used to decide which gradient TensorArray
   * @return a new instance of TensorArrayGrad
   * @see org.tensorflow.op.core.TensorArrayGrad
   */
  public TensorArrayGrad tensorArrayGrad(Operand<?> handle, Operand<Float> flowIn, String source) {
    return TensorArrayGrad.create(scope, handle, flowIn, source);
  }

  /**
   * Adds an {@link DecodeGif} operation to the graph
   *
   * @param contents 0-D.  The GIF-encoded image.
   * @return a new instance of DecodeGif
   * @see org.tensorflow.op.core.DecodeGif
   */
  public DecodeGif decodeGif(Operand<String> contents) {
    return DecodeGif.create(scope, contents);
  }

  /**
   * Adds an {@link TensorSummaryV2} operation to the graph
   *
   * @param tag A string attached to this summary. Used for organization in TensorBoard.
   * @param tensor A tensor to serialize.
   * @param serializedSummaryMetadata A serialized SummaryMetadata proto. Contains plugin
   * @return a new instance of TensorSummaryV2
   * @see org.tensorflow.op.core.TensorSummaryV2
   */
  public <T> TensorSummaryV2 tensorSummaryV2(Operand<String> tag, Operand<T> tensor,
      Operand<String> serializedSummaryMetadata) {
    return TensorSummaryV2.create(scope, tag, tensor, serializedSummaryMetadata);
  }

  /**
   * Adds an {@link SetDiff1D} operation to the graph
   *
   * @param x 1-D. Values to keep.
   * @param y 1-D. Values to remove.
   * @param outIdx 
   * @return a new instance of SetDiff1D
   * @see org.tensorflow.op.core.SetDiff1D
   */
  public <T, U extends Number> SetDiff1D<T, U> setDiff1D(Operand<T> x, Operand<T> y,
      Class<U> outIdx) {
    return SetDiff1D.create(scope, x, y, outIdx);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param type the tensor datatype.
   * @param shape the tensor shape.
   * @param data a buffer containing the tensor data.
   * @return a constant of type `type`
   * @throws IllegalArgumentException If the tensor datatype or shape is not compatible with the
   * @see org.tensorflow.op.core.Constant
   */
  public <T> Constant<T> constant(Class<T> type, long[] shape, ByteBuffer data) {
    return Constant.create(scope, type, shape, data);
  }

  /**
   * Adds an {@link LeftShift} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of LeftShift
   * @see org.tensorflow.op.core.LeftShift
   */
  public <T extends Number> LeftShift<T> leftShift(Operand<T> x, Operand<T> y) {
    return LeftShift.create(scope, x, y);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. String elements are
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<String> constant(byte[][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ParseSingleSequenceExample} operation to the graph
   *
   * @param serialized A scalar containing a binary serialized SequenceExample proto.
   * @param featureListDenseMissingAssumedEmpty A vector listing the
   * @param contextSparseKeys A list of Ncontext_sparse string Tensors (scalars).
   * @param contextDenseKeys A list of Ncontext_dense string Tensors (scalars).
   * @param featureListSparseKeys A list of Nfeature_list_sparse string Tensors
   * @param featureListDenseKeys A list of Nfeature_list_dense string Tensors (scalars).
   * @param contextDenseDefaults A list of Ncontext_dense Tensors (some may be empty).
   * @param debugName A scalar containing the name of the serialized proto.
   * @param contextSparseTypes A list of Ncontext_sparse types; the data types of data in
   * @param featureListDenseTypes 
   * @param featureListSparseTypes A list of Nfeature_list_sparse types; the data types
   * @param options carries optional attributes values
   * @return a new instance of ParseSingleSequenceExample
   * @see org.tensorflow.op.core.ParseSingleSequenceExample
   */
  public ParseSingleSequenceExample parseSingleSequenceExample(Operand<String> serialized,
      Operand<String> featureListDenseMissingAssumedEmpty,
      Iterable<Operand<String>> contextSparseKeys, Iterable<Operand<String>> contextDenseKeys,
      Iterable<Operand<String>> featureListSparseKeys,
      Iterable<Operand<String>> featureListDenseKeys, Iterable<Operand<?>> contextDenseDefaults,
      Operand<String> debugName, List<Class<?>> contextSparseTypes,
      List<Class<?>> featureListDenseTypes, List<Class<?>> featureListSparseTypes,
      ParseSingleSequenceExample.Options... options) {
    return ParseSingleSequenceExample.create(scope, serialized, featureListDenseMissingAssumedEmpty, contextSparseKeys, contextDenseKeys, featureListSparseKeys, featureListDenseKeys, contextDenseDefaults, debugName, contextSparseTypes, featureListDenseTypes, featureListSparseTypes, options);
  }

  /**
   * Adds an {@link OnesLike} operation to the graph
   *
   * @param x a tensor of type T.
   * @return a new instance of OnesLike
   * @see org.tensorflow.op.core.OnesLike
   */
  public <T> OnesLike<T> onesLike(Operand<T> x) {
    return OnesLike.create(scope, x);
  }

  /**
   * Adds an {@link LessEqual} operation to the graph
   *
   * @param x 
   * @param y 
   * @return a new instance of LessEqual
   * @see org.tensorflow.op.core.LessEqual
   */
  public <T extends Number> LessEqual lessEqual(Operand<T> x, Operand<T> y) {
    return LessEqual.create(scope, x, y);
  }

  /**
   * Adds an {@link Dilation2D} operation to the graph
   *
   * @param input 4-D with shape `[batch, in_height, in_width, depth]`.
   * @param filter 3-D with shape `[filter_height, filter_width, depth]`.
   * @param strides The stride of the sliding window for each dimension of the input
   * @param rates The input stride for atrous morphological dilation. Must be:
   * @param padding The type of padding algorithm to use.
   * @return a new instance of Dilation2D
   * @see org.tensorflow.op.core.Dilation2D
   */
  public <T extends Number> Dilation2D<T> dilation2D(Operand<T> input, Operand<T> filter,
      List<Long> strides, List<Long> rates, String padding) {
    return Dilation2D.create(scope, input, filter, strides, rates, padding);
  }

  /**
   * Adds an {@link Unbatch} operation to the graph
   *
   * @param batchedTensor 
   * @param batchIndex 
   * @param id 
   * @param timeoutMicros 
   * @param options carries optional attributes values
   * @return a new instance of Unbatch
   * @see org.tensorflow.op.core.Unbatch
   */
  public <T> Unbatch<T> unbatch(Operand<T> batchedTensor, Operand<Long> batchIndex,
      Operand<Long> id, Long timeoutMicros, Unbatch.Options... options) {
    return Unbatch.create(scope, batchedTensor, batchIndex, id, timeoutMicros, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Double> constant(double[][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link StatelessTruncatedNormal} operation to the graph
   *
   * @param shape The shape of the output tensor.
   * @param seed 2 seeds (shape [2]).
   * @return a new instance of StatelessTruncatedNormal
   * @see org.tensorflow.op.core.StatelessTruncatedNormal
   */
  public <T extends Number, U extends Number> StatelessTruncatedNormal<Float> statelessTruncatedNormal(Operand<T> shape,
      Operand<U> seed) {
    return StatelessTruncatedNormal.create(scope, shape, seed);
  }

  /**
   * Adds an {@link CompareAndBitpack} operation to the graph
   *
   * @param input Values to compare against `threshold` and bitpack.
   * @param threshold Threshold to compare against.
   * @return a new instance of CompareAndBitpack
   * @see org.tensorflow.op.core.CompareAndBitpack
   */
  public <T> CompareAndBitpack compareAndBitpack(Operand<T> input, Operand<T> threshold) {
    return CompareAndBitpack.create(scope, input, threshold);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Long> constant(long[][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link FusedBatchNormGradV2} operation to the graph
   *
   * @param yBackprop A 4D Tensor for the gradient with respect to y.
   * @param x A 4D Tensor for input data.
   * @param scale A 1D Tensor for scaling factor, to scale the normalized x.
   * @param reserveSpace1 When is_training is True, a 1D Tensor for the computed batch
   * @param reserveSpace2 When is_training is True, a 1D Tensor for the computed batch
   * @param options carries optional attributes values
   * @return a new instance of FusedBatchNormGradV2
   * @see org.tensorflow.op.core.FusedBatchNormGradV2
   */
  public <T extends Number, U extends Number> FusedBatchNormGradV2<T, U> fusedBatchNormGradV2(Operand<T> yBackprop,
      Operand<T> x, Operand<Float> scale, Operand<U> reserveSpace1, Operand<U> reserveSpace2,
      FusedBatchNormGradV2.Options... options) {
    return FusedBatchNormGradV2.create(scope, yBackprop, x, scale, reserveSpace1, reserveSpace2, options);
  }

  /**
   * Adds an {@link QuantizeAndDequantize} operation to the graph
   *
   * @param input 
   * @param options carries optional attributes values
   * @return a new instance of QuantizeAndDequantize
   * @see org.tensorflow.op.core.QuantizeAndDequantize
   */
  public <T extends Number> QuantizeAndDequantize<T> quantizeAndDequantize(Operand<T> input,
      QuantizeAndDequantize.Options... options) {
    return QuantizeAndDequantize.create(scope, input, options);
  }

  /**
   * Adds an {@link RandomPoissonV2} operation to the graph
   *
   * @param shape 1-D integer tensor. Shape of independent samples to draw from each
   * @param rate A tensor in which each scalar is a "rate" parameter describing the
   * @param options carries optional attributes values
   * @return a new instance of RandomPoissonV2
   * @see org.tensorflow.op.core.RandomPoissonV2
   */
  public <T extends Number, U extends Number> RandomPoissonV2<Long> randomPoissonV2(Operand<T> shape,
      Operand<U> rate, RandomPoissonV2.Options... options) {
    return RandomPoissonV2.create(scope, shape, rate, options);
  }

  /**
   * Adds an {@link GuaranteeConst} operation to the graph
   *
   * @param input 
   * @return a new instance of GuaranteeConst
   * @see org.tensorflow.op.core.GuaranteeConst
   */
  public <T> GuaranteeConst<T> guaranteeConst(Operand<T> input) {
    return GuaranteeConst.create(scope, input);
  }

  /**
   * Adds an {@link Sinh} operation to the graph
   *
   * @param x 
   * @return a new instance of Sinh
   * @see org.tensorflow.op.core.Sinh
   */
  public <T> Sinh<T> sinh(Operand<T> x) {
    return Sinh.create(scope, x);
  }

  /**
   * Adds an {@link Cos} operation to the graph
   *
   * @param x 
   * @return a new instance of Cos
   * @see org.tensorflow.op.core.Cos
   */
  public <T> Cos<T> cos(Operand<T> x) {
    return Cos.create(scope, x);
  }

  /**
   * Adds an {@link MutexLock} operation to the graph
   *
   * @param mutex The mutex resource to lock.
   * @return a new instance of MutexLock
   * @see org.tensorflow.op.core.MutexLock
   */
  public MutexLock mutexLock(Operand<?> mutex) {
    return MutexLock.create(scope, mutex);
  }

  /**
   * Adds an {@link PlaceholderV2} operation to the graph
   *
   * @param dtype The type of elements in the tensor.
   * @param shape The shape of the tensor. The shape can be any partially-specified
   * @return a new instance of PlaceholderV2
   * @see org.tensorflow.op.core.PlaceholderV2
   */
  public <T> PlaceholderV2<T> placeholderV2(Class<T> dtype, Shape shape) {
    return PlaceholderV2.create(scope, dtype, shape);
  }

  /**
   * Adds an {@link SparseSliceGrad} operation to the graph
   *
   * @param backpropValGrad 1-D. The gradient with respect to
   * @param inputIndices 2-D.  The `indices` of the input `SparseTensor`.
   * @param inputStart 1-D. tensor represents the start of the slice.
   * @param outputIndices 2-D.  The `indices` of the sliced `SparseTensor`.
   * @return a new instance of SparseSliceGrad
   * @see org.tensorflow.op.core.SparseSliceGrad
   */
  public <T> SparseSliceGrad<T> sparseSliceGrad(Operand<T> backpropValGrad,
      Operand<Long> inputIndices, Operand<Long> inputStart, Operand<Long> outputIndices) {
    return SparseSliceGrad.create(scope, backpropValGrad, inputIndices, inputStart, outputIndices);
  }

  /**
   * Adds an {@link ApproximateEqual} operation to the graph
   *
   * @param x 
   * @param y 
   * @param options carries optional attributes values
   * @return a new instance of ApproximateEqual
   * @see org.tensorflow.op.core.ApproximateEqual
   */
  public <T> ApproximateEqual approximateEqual(Operand<T> x, Operand<T> y,
      ApproximateEqual.Options... options) {
    return ApproximateEqual.create(scope, x, y, options);
  }

  /**
   * Adds an {@link ArgMax} operation to the graph
   *
   * @param input 
   * @param dimension int32 or int64, must be in the range `[-rank(input), rank(input))`.
   * @param outputType 
   * @return a new instance of ArgMax
   * @see org.tensorflow.op.core.ArgMax
   */
  public <V extends Number, T, U extends Number> ArgMax<V> argMax(Operand<T> input,
      Operand<U> dimension, Class<V> outputType) {
    return ArgMax.create(scope, input, dimension, outputType);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data An array containing the values to put into the new constant. The dimensions of the
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Long> constant(long[][][][][][] data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link ResourceSparseApplyProximalAdagrad} operation to the graph
   *
   * @param var Should be from a Variable().
   * @param accum Should be from a Variable().
   * @param lr Learning rate. Must be a scalar.
   * @param l1 L1 regularization. Must be a scalar.
   * @param l2 L2 regularization. Must be a scalar.
   * @param grad The gradient.
   * @param indices A vector of indices into the first dimension of var and accum.
   * @param options carries optional attributes values
   * @return a new instance of ResourceSparseApplyProximalAdagrad
   * @see org.tensorflow.op.core.ResourceSparseApplyProximalAdagrad
   */
  public <T, U extends Number> ResourceSparseApplyProximalAdagrad resourceSparseApplyProximalAdagrad(Operand<?> var,
      Operand<?> accum, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> grad,
      Operand<U> indices, ResourceSparseApplyProximalAdagrad.Options... options) {
    return ResourceSparseApplyProximalAdagrad.create(scope, var, accum, lr, l1, l2, grad, indices, options);
  }

  /**
   * Adds an {@link Constant} operation to the graph
   *
   * @param data The value to put into the new constant.
   * @return a double constant
   * @see org.tensorflow.op.core.Constant
   */
  public Constant<Double> constant(double data) {
    return Constant.create(scope, data);
  }

  /**
   * Adds an {@link UniqueWithCounts} operation to the graph
   *
   * @param x 1-D.
   * @param outIdx 
   * @return a new instance of UniqueWithCounts
   * @see org.tensorflow.op.core.UniqueWithCounts
   */
  public <T, U extends Number> UniqueWithCounts<T, U> uniqueWithCounts(Operand<T> x,
      Class<U> outIdx) {
    return UniqueWithCounts.create(scope, x, outIdx);
  }

  /**
   * Adds an {@link Min} operation to the graph
   *
   * @param input The tensor to reduce.
   * @param axis The dimensions to reduce. Must be in the range
   * @param options carries optional attributes values
   * @return a new instance of Min
   * @see org.tensorflow.op.core.Min
   */
  public <T, U extends Number> Min<T> min(Operand<T> input, Operand<U> axis,
      Min.Options... options) {
    return Min.create(scope, input, axis, options);
  }

  /**
   * Adds an {@link MatrixDiagPart} operation to the graph
   *
   * @param input Rank `k` tensor where `k >= 2`.
   * @return a new instance of MatrixDiagPart
   * @see org.tensorflow.op.core.MatrixDiagPart
   */
  public <T> MatrixDiagPart<T> matrixDiagPart(Operand<T> input) {
    return MatrixDiagPart.create(scope, input);
  }

  /**
   * Adds an {@link DataFormatVecPermute} operation to the graph
   *
   * @param x Vector of size 4 or Tensor of shape (4, 2) in source data format.
   * @param options carries optional attributes values
   * @return a new instance of DataFormatVecPermute
   * @see org.tensorflow.op.core.DataFormatVecPermute
   */
  public <T extends Number> DataFormatVecPermute<T> dataFormatVecPermute(Operand<T> x,
      DataFormatVecPermute.Options... options) {
    return DataFormatVecPermute.create(scope, x, options);
  }

  /**
   * Adds an {@link RFFT2D} operation to the graph
   *
   * @param input A float32 tensor.
   * @param fftLength An int32 tensor of shape [2]. The FFT length for each dimension.
   * @return a new instance of RFFT2D
   * @see org.tensorflow.op.core.RFFT2D
   */
  public RFFT2D rFFT2D(Operand<Float> input, Operand<Integer> fftLength) {
    return RFFT2D.create(scope, input, fftLength);
  }

  /**
   * Adds an {@link BatchMatrixSolve} operation to the graph
   *
   * @param matrix 
   * @param rhs 
   * @param options carries optional attributes values
   * @return a new instance of BatchMatrixSolve
   * @see org.tensorflow.op.core.BatchMatrixSolve
   */
  public <T extends Number> BatchMatrixSolve<T> batchMatrixSolve(Operand<T> matrix, Operand<T> rhs,
      BatchMatrixSolve.Options... options) {
    return BatchMatrixSolve.create(scope, matrix, rhs, options);
  }

  /**
   * Adds an {@link Iterator} operation to the graph
   *
   * @param sharedName 
   * @param container 
   * @param outputTypes 
   * @param outputShapes 
   * @return a new instance of Iterator
   * @see org.tensorflow.op.core.Iterator
   */
  public Iterator iterator(String sharedName, String container, List<Class<?>> outputTypes,
      List<Shape> outputShapes) {
    return Iterator.create(scope, sharedName, container, outputTypes, outputShapes);
  }

  /**
   * Adds an {@link Transpose} operation to the graph
   *
   * @param x 
   * @param perm 
   * @return a new instance of Transpose
   * @see org.tensorflow.op.core.Transpose
   */
  public <T, U extends Number> Transpose<T> transpose(Operand<T> x, Operand<U> perm) {
    return Transpose.create(scope, x, perm);
  }

  /**
   * Adds an {@link Conv2D} operation to the graph
   *
   * @param input A 4-D tensor. The dimension order is interpreted according to the value
   * @param filter A 4-D tensor of shape
   * @param strides 1-D tensor of length 4.  The stride of the sliding window for each
   * @param padding The type of padding algorithm to use.
   * @param options carries optional attributes values
   * @return a new instance of Conv2D
   * @see org.tensorflow.op.core.Conv2D
   */
  public <T extends Number> Conv2D<T> conv2D(Operand<T> input, Operand<T> filter,
      List<Long> strides, String padding, Conv2D.Options... options) {
    return Conv2D.create(scope, input, filter, strides, padding, options);
  }

  /**
   * Returns an API that adds operations to the graph with the provided name prefix.
   *
   * @see {@link Scope#withSubScope(String)}
   */
  public Ops withSubScope(String childScopeName) {
    return new Ops(scope.withSubScope(childScopeName));
  }

  /**
   * Returns an API that uses the provided name for an op.
   *
   * @see {@link Scope#withName(String)}
   */
  public Ops withName(String opName) {
    return new Ops(scope.withName(opName));
  }

  /**
   * Returns the current {@link Scope scope} of this API
   */
  public final Scope scope() {
    return scope;
  }

  /**
   * Creates an API for adding operations to the provided {@code graph}
   */
  public static Ops create(Graph graph) {
    return new Ops(new Scope(graph));
  }
}
