/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.RemoteBlockWriter;
import tachyon.client.netty.ClientHandler;
import tachyon.client.netty.NettyClient;
import tachyon.client.netty.SingleResponseListener;
import tachyon.network.protocol.RPCBlockWriteRequest;
import tachyon.network.protocol.RPCBlockWriteResponse;
import tachyon.network.protocol.RPCErrorResponse;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCResponse;
import tachyon.network.protocol.databuffer.DataByteArrayChannel;

public final class NettyRemoteBlockWriter
implements RemoteBlockWriter {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final Bootstrap mClientBootstrap;
    private final ClientHandler mHandler = new ClientHandler();
    private boolean mOpen = false;
    private InetSocketAddress mAddress;
    private long mBlockId;
    private long mSessionId;
    private long mWrittenBytes;

    public NettyRemoteBlockWriter() {
        this.mClientBootstrap = NettyClient.createClientBootstrap(this.mHandler);
    }

    @Override
    public void open(InetSocketAddress address, long blockId, long sessionId) throws IOException {
        if (this.mOpen) {
            throw new IOException("This writer is already open for address: " + this.mAddress + ", blockId: " + this.mBlockId + ", sessionId: " + this.mSessionId);
        }
        this.mAddress = address;
        this.mBlockId = blockId;
        this.mSessionId = sessionId;
        this.mWrittenBytes = 0L;
        this.mOpen = true;
    }

    @Override
    public void close() {
        if (this.mOpen) {
            this.mOpen = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        SingleResponseListener listener = new SingleResponseListener();
        try {
            ChannelFuture f = this.mClientBootstrap.connect((SocketAddress)this.mAddress).sync();
            LOG.info("Connected to remote machine " + this.mAddress);
            Channel channel = f.channel();
            this.mHandler.addListener(listener);
            channel.writeAndFlush((Object)new RPCBlockWriteRequest(this.mSessionId, this.mBlockId, this.mWrittenBytes, length, new DataByteArrayChannel(bytes, offset, length)));
            RPCResponse response = listener.get(NettyClient.TIMEOUT_MS, TimeUnit.MILLISECONDS);
            channel.close().sync();
            switch (response.getType()) {
                case RPC_BLOCK_WRITE_RESPONSE: {
                    RPCBlockWriteResponse resp = (RPCBlockWriteResponse)response;
                    RPCResponse.Status status = resp.getStatus();
                    LOG.info("status: {} from remote machine {} received", (Object)status, (Object)this.mAddress);
                    if (status != RPCResponse.Status.SUCCESS) {
                        throw new IOException("error writing blockId: " + this.mBlockId + ", sessionId: " + this.mSessionId + ", address: " + this.mAddress + ", message: " + status.getMessage());
                    }
                    this.mWrittenBytes += (long)length;
                    return;
                }
                case RPC_ERROR_RESPONSE: {
                    RPCErrorResponse error = (RPCErrorResponse)response;
                    throw new IOException(error.getStatus().getMessage());
                }
                default: {
                    throw new IOException("Unexpected response message type: " + response.getType() + " (expected: " + RPCMessage.Type.RPC_BLOCK_WRITE_RESPONSE + ")");
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.mHandler.removeListener(listener);
        }
    }
}

