/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import tachyon.TachyonURI;
import tachyon.client.ClientContext;
import tachyon.client.FileSystemMasterClient;
import tachyon.client.file.AbstractTachyonFileSystem;
import tachyon.client.file.FileInStream;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.TachyonFile;
import tachyon.client.file.options.CreateOptions;
import tachyon.client.file.options.DeleteOptions;
import tachyon.client.file.options.FreeOptions;
import tachyon.client.file.options.GetInfoOptions;
import tachyon.client.file.options.InStreamOptions;
import tachyon.client.file.options.ListStatusOptions;
import tachyon.client.file.options.LoadMetadataOptions;
import tachyon.client.file.options.MkdirOptions;
import tachyon.client.file.options.MountOptions;
import tachyon.client.file.options.OpenOptions;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.client.file.options.RenameOptions;
import tachyon.client.file.options.SetStateOptions;
import tachyon.client.file.options.UnmountOptions;
import tachyon.client.lineage.TachyonLineageFileSystem;
import tachyon.exception.FileAlreadyExistsException;
import tachyon.exception.FileDoesNotExistException;
import tachyon.exception.InvalidPathException;
import tachyon.exception.TachyonException;
import tachyon.thrift.FileInfo;

public class TachyonFileSystem
extends AbstractTachyonFileSystem {
    private static TachyonFileSystem sTachyonFileSystem;

    protected TachyonFileSystem() {
    }

    public TachyonFile create(TachyonURI path) throws IOException, TachyonException, FileAlreadyExistsException, InvalidPathException {
        return this.create(path, CreateOptions.defaults());
    }

    public void delete(TachyonFile file) throws IOException, TachyonException, FileDoesNotExistException {
        this.delete(file, DeleteOptions.defaults());
    }

    public void free(TachyonFile file) throws IOException, TachyonException, FileDoesNotExistException {
        this.free(file, FreeOptions.defaults());
    }

    public FileInfo getInfo(TachyonFile file) throws FileDoesNotExistException, IOException, TachyonException {
        return this.getInfo(file, GetInfoOptions.defaults());
    }

    public FileInStream getInStream(TachyonFile file) throws IOException, TachyonException, FileDoesNotExistException {
        return this.getInStream(file, InStreamOptions.defaults());
    }

    public FileInStream getInStream(TachyonFile file, InStreamOptions options) throws IOException, TachyonException, FileDoesNotExistException {
        FileInfo info = this.getInfo(file, GetInfoOptions.defaults());
        Preconditions.checkState((!info.isIsFolder() ? 1 : 0) != 0, (Object)"Cannot read from a folder");
        return new FileInStream(info, options);
    }

    public FileOutStream getOutStream(TachyonURI path) throws IOException, TachyonException, FileAlreadyExistsException, InvalidPathException {
        return this.getOutStream(path, OutStreamOptions.defaults());
    }

    public FileOutStream getOutStream(TachyonURI path, OutStreamOptions options) throws IOException, TachyonException, FileAlreadyExistsException, InvalidPathException {
        CreateOptions createOptions = new CreateOptions.Builder(ClientContext.getConf()).setBlockSizeBytes(options.getBlockSizeBytes()).setRecursive(true).setTTL(options.getTTL()).setUnderStorageType(options.getUnderStorageType()).build();
        TachyonFile tFile = this.create(path, createOptions);
        long fileId = tFile.getFileId();
        return new FileOutStream(fileId, options);
    }

    @Deprecated
    public FileOutStream getOutStream(long fileId, OutStreamOptions options) throws IOException {
        return new FileOutStream(fileId, options);
    }

    public List<FileInfo> listStatus(TachyonFile file) throws IOException, TachyonException, FileDoesNotExistException {
        return this.listStatus(file, ListStatusOptions.defaults());
    }

    public TachyonFile loadMetadata(TachyonURI path) throws IOException, TachyonException, FileDoesNotExistException {
        return this.loadMetadata(path, LoadMetadataOptions.defaults());
    }

    public boolean mkdir(TachyonURI path) throws IOException, TachyonException, FileAlreadyExistsException, InvalidPathException {
        return this.mkdir(path, MkdirOptions.defaults());
    }

    public boolean mount(TachyonURI tachyonPath, TachyonURI ufsPath) throws IOException, TachyonException {
        return this.mount(tachyonPath, ufsPath, MountOptions.defaults());
    }

    public TachyonFile open(TachyonURI path) throws IOException, InvalidPathException, TachyonException {
        return this.open(path, OpenOptions.defaults());
    }

    public TachyonFile openIfExists(TachyonURI path) throws IOException, TachyonException {
        return this.openIfExists(path, OpenOptions.defaults());
    }

    public boolean rename(TachyonFile src, TachyonURI dst) throws IOException, TachyonException, FileDoesNotExistException {
        return this.rename(src, dst, RenameOptions.defaults());
    }

    public void setState(TachyonFile file) throws IOException, TachyonException {
        this.setState(file, SetStateOptions.defaults());
    }

    public boolean unmount(TachyonURI tachyonPath) throws IOException, TachyonException {
        return this.unmount(tachyonPath, UnmountOptions.defaults());
    }

    public void reportLostFile(TachyonFile file) throws IOException, FileDoesNotExistException, TachyonException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            masterClient.reportLostFile(file.getFileId());
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    public static class TachyonFileSystemFactory {
        public static synchronized TachyonFileSystem get() {
            if (sTachyonFileSystem == null) {
                boolean enableLineage = ClientContext.getConf().getBoolean("tachyon.user.lineage.enabled");
                sTachyonFileSystem = enableLineage ? TachyonLineageFileSystem.get() : new TachyonFileSystem();
            }
            return sTachyonFileSystem;
        }
    }
}

