/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.block;

import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.BlockMasterClient;
import tachyon.client.ClientContext;
import tachyon.client.block.BlockStoreContext;
import tachyon.client.block.BufferedBlockInStream;
import tachyon.client.block.BufferedBlockOutStream;
import tachyon.client.block.LocalBlockOutStream;
import tachyon.client.block.RemoteBlockOutStream;
import tachyon.thrift.BlockInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.network.NetworkAddressUtils;
import tachyon.worker.WorkerClient;

public final class TachyonBlockStore
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static TachyonBlockStore sClient = null;
    private final BlockStoreContext mContext = BlockStoreContext.INSTANCE;

    public static synchronized TachyonBlockStore get() {
        if (sClient == null) {
            sClient = new TachyonBlockStore();
        }
        return sClient;
    }

    private TachyonBlockStore() {
    }

    @Override
    public synchronized void close() {
        sClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockInfo getInfo(long blockId) throws IOException {
        BlockMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            BlockInfo blockInfo = masterClient.getBlockInfo(blockId);
            return blockInfo;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    /*
     * Exception decompiling
     */
    public BufferedBlockInStream getInStream(long blockId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedBlockOutStream getOutStream(long blockId, long blockSize, String location) throws IOException {
        if (blockSize == -1L) {
            BlockMasterClient blockMasterClient = this.mContext.acquireMasterClient();
            try {
                blockSize = blockMasterClient.getBlockInfo(blockId).getLength();
            }
            finally {
                this.mContext.releaseMasterClient(blockMasterClient);
            }
        }
        if (location == null) {
            if (this.mContext.hasLocalWorker()) {
                return new LocalBlockOutStream(blockId, blockSize);
            }
            return new RemoteBlockOutStream(blockId, blockSize);
        }
        if (NetworkAddressUtils.getLocalHostName(ClientContext.getConf()).equals(location)) {
            if (this.mContext.hasLocalWorker()) {
                return new LocalBlockOutStream(blockId, blockSize);
            }
            throw new IOException("Local write requested but there is no local worker.");
        }
        return new RemoteBlockOutStream(blockId, blockSize, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacityBytes() throws IOException {
        BlockMasterClient blockMasterClient = this.mContext.acquireMasterClient();
        try {
            long l = blockMasterClient.getCapacityBytes();
            return l;
        }
        finally {
            this.mContext.releaseMasterClient(blockMasterClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsedBytes() throws IOException {
        BlockMasterClient blockMasterClient = this.mContext.acquireMasterClient();
        try {
            long l = blockMasterClient.getUsedBytes();
            return l;
        }
        finally {
            this.mContext.releaseMasterClient(blockMasterClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void promote(long blockId) throws IOException {
        BlockMasterClient blockMasterClient = this.mContext.acquireMasterClient();
        try {
            BlockInfo info = blockMasterClient.getBlockInfo(blockId);
            if (info.getLocations().isEmpty()) {
                return;
            }
            NetAddress workerAddr = info.getLocations().get(0).getWorkerAddress();
            WorkerClient workerClient = this.mContext.acquireWorkerClient(workerAddr.getHost());
            try {
                workerClient.promoteBlock(blockId);
            }
            finally {
                this.mContext.releaseWorkerClient(workerClient);
            }
        }
        finally {
            this.mContext.releaseMasterClient(blockMasterClient);
        }
    }
}

