/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import tachyon.client.TachyonStorageType;

public enum ReadType {
    NO_CACHE(1),
    CACHE(2),
    CACHE_PROMOTE(3);

    private final int mValue;

    private ReadType(int value) {
        this.mValue = value;
    }

    public TachyonStorageType getTachyonStorageType() {
        if (this.isPromote()) {
            return TachyonStorageType.PROMOTE;
        }
        if (this.isCache()) {
            return TachyonStorageType.STORE;
        }
        return TachyonStorageType.NO_STORE;
    }

    public int getValue() {
        return this.mValue;
    }

    public boolean isCache() {
        return this.mValue == ReadType.CACHE.mValue || this.mValue == ReadType.CACHE_PROMOTE.mValue;
    }

    public boolean isPromote() {
        return this.mValue == ReadType.CACHE_PROMOTE.mValue;
    }
}

