/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.TransformerHelper;

public class SourceAssertionError
extends AssertionError {
    private final String sourceLabel;
    private final Source source;
    private final TransformerHelper transformerHelper = new TransformerHelper();

    public SourceAssertionError(String detailMessage, String sourceLabel, Source source) {
        super((Object)detailMessage);
        this.sourceLabel = sourceLabel;
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMessage());
        String sourceString = this.getSourceString();
        if (sourceString != null) {
            String newLine = System.getProperty("line.separator");
            builder.append(newLine);
            String label = this.sourceLabel != null ? this.sourceLabel : "Source";
            builder.append(label);
            builder.append(": ");
            builder.append(sourceString);
        }
        return builder.toString();
    }

    private String getSourceString() {
        if (this.source != null) {
            try {
                StringResult result = new StringResult();
                Transformer transformer = this.createNonIndentingTransformer();
                transformer.transform(this.source, (Result)result);
                return result.toString();
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        return null;
    }

    private Transformer createNonIndentingTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.transformerHelper.createTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        return transformer;
    }
}

