/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class TrustManagersFactoryBean
implements FactoryBean<TrustManager[]>,
InitializingBean {
    private TrustManager @Nullable [] trustManagers;
    private @Nullable KeyStore keyStore;
    private @Nullable String algorithm;
    private @Nullable String provider;

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public TrustManager @Nullable [] getObject() throws Exception {
        return this.trustManagers;
    }

    public Class<?> getObjectType() {
        return TrustManager[].class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        String algorithm = StringUtils.hasLength((String)this.algorithm) ? this.algorithm : TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = StringUtils.hasLength((String)this.provider) ? TrustManagerFactory.getInstance(algorithm, this.provider) : TrustManagerFactory.getInstance(algorithm);
        trustManagerFactory.init(this.keyStore);
        this.trustManagers = trustManagerFactory.getTrustManagers();
    }
}

