/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.portlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.portlet.FlowUrlHandler;
import org.springframework.webflow.context.portlet.PortletContextMap;
import org.springframework.webflow.context.portlet.PortletRequestMap;
import org.springframework.webflow.context.portlet.PortletRequestParameterMap;
import org.springframework.webflow.context.portlet.PortletSessionMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class PortletExternalContext
implements ExternalContext {
    protected static final short ACTION_PHASE = 1;
    protected static final short RENDER_PHASE = 2;
    protected static final short RESOURCE_PHASE = 3;
    private PortletContext context;
    private PortletRequest request;
    private PortletResponse response;
    private short requestPhase;
    private ParameterMap requestParameterMap;
    private MutableAttributeMap<Object> requestMap;
    private SharedAttributeMap<Object> sessionMap;
    private SharedAttributeMap<Object> applicationMap;
    private boolean responseComplete;
    private boolean flowExecutionRedirectRequested;
    private String flowDefinitionRedirectFlowId;
    private MutableAttributeMap<Object> flowDefinitionRedirectFlowInput;
    private String externalRedirectUrl;
    private FlowUrlHandler flowUrlHandler;
    private boolean redirectInPopup;

    public PortletExternalContext(PortletContext context, PortletRequest request, PortletResponse response) {
        this.init(context, request, response, new DefaultFlowUrlHandler());
    }

    public PortletExternalContext(PortletContext context, PortletRequest request, PortletResponse response, FlowUrlHandler flowUrlHandler) {
        this.init(context, request, response, flowUrlHandler);
    }

    @Override
    public String getContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    @Override
    public MutableAttributeMap<Object> getRequestMap() {
        return this.requestMap;
    }

    @Override
    public SharedAttributeMap<Object> getSessionMap() {
        return this.sessionMap;
    }

    @Override
    public SharedAttributeMap<Object> getGlobalSessionMap() {
        return this.getSessionMap();
    }

    @Override
    public SharedAttributeMap<Object> getApplicationMap() {
        return this.applicationMap;
    }

    @Override
    public Principal getCurrentUser() {
        return this.request.getUserPrincipal();
    }

    @Override
    public Locale getLocale() {
        return this.request.getLocale();
    }

    @Override
    public Object getNativeContext() {
        return this.context;
    }

    @Override
    public Object getNativeRequest() {
        return this.request;
    }

    @Override
    public Object getNativeResponse() {
        return this.response;
    }

    @Override
    public boolean isAjaxRequest() {
        return false;
    }

    @Override
    public String getFlowExecutionUrl(String flowId, String flowExecutionKey) {
        if (this.isRenderPhase()) {
            return this.flowUrlHandler.createFlowExecutionUrl(flowId, flowExecutionKey, (RenderResponse)this.response);
        }
        if (this.isResourcePhase()) {
            return this.flowUrlHandler.createFlowExecutionUrl(flowId, flowExecutionKey, (ResourceResponse)this.response);
        }
        throw new IllegalStateException("A flow execution action URL can only be obtained in a RenderRequest or a ResourceRequest");
    }

    @Override
    public Writer getResponseWriter() throws IllegalStateException {
        this.assertResponseAllowed();
        try {
            return ((MimeResponse)this.response).getWriter();
        }
        catch (IOException e) {
            IllegalStateException ise = new IllegalStateException("Unable to access the response Writer");
            ise.initCause(e);
            throw ise;
        }
    }

    @Override
    public boolean isResponseAllowed() {
        return (this.isRenderPhase() || this.isResourcePhase()) && !this.responseComplete;
    }

    @Override
    public boolean isResponseComplete() {
        return this.responseComplete;
    }

    @Override
    public void recordResponseComplete() {
        this.responseComplete = true;
    }

    @Override
    public boolean isResponseCompleteFlowExecutionRedirect() {
        return this.flowExecutionRedirectRequested;
    }

    @Override
    public void requestFlowExecutionRedirect() throws IllegalStateException {
        this.assertRedirectResponseAllowed();
        this.flowExecutionRedirectRequested = true;
        this.recordResponseComplete();
    }

    @Override
    public void requestFlowDefinitionRedirect(String flowId, MutableAttributeMap<?> input) throws IllegalStateException {
        this.assertRedirectResponseAllowed();
        this.flowDefinitionRedirectFlowId = flowId;
        this.flowDefinitionRedirectFlowInput = new LocalAttributeMap<Object>();
        if (input != null) {
            this.flowDefinitionRedirectFlowInput.putAll(input);
        }
        this.recordResponseComplete();
    }

    @Override
    public void requestExternalRedirect(String uri) throws IllegalStateException {
        this.assertRedirectResponseAllowed();
        this.externalRedirectUrl = uri;
        this.recordResponseComplete();
    }

    @Override
    public void requestRedirectInPopup() throws IllegalStateException {
        if (!this.isRedirectRequested()) {
            throw new IllegalStateException("Only call requestRedirectInPopup after a redirect has been requested by calling requestFlowExecutionRedirect, requestFlowDefinitionRedirect, or requestExternalRedirect");
        }
        this.redirectInPopup = true;
    }

    public boolean getFlowExecutionRedirectRequested() {
        return this.flowExecutionRedirectRequested;
    }

    public boolean getFlowDefinitionRedirectRequested() {
        return this.flowDefinitionRedirectFlowId != null;
    }

    public String getFlowRedirectFlowId() {
        return this.flowDefinitionRedirectFlowId;
    }

    public MutableAttributeMap<Object> getFlowRedirectFlowInput() {
        return this.flowDefinitionRedirectFlowInput;
    }

    public boolean getExternalRedirectRequested() {
        return this.externalRedirectUrl != null;
    }

    public String getExternalRedirectUrl() {
        return this.externalRedirectUrl;
    }

    public boolean getRedirectInPopup() {
        return this.redirectInPopup;
    }

    public boolean isActionPhase() {
        return this.requestPhase == 1;
    }

    public boolean isRenderPhase() {
        return this.requestPhase == 2;
    }

    public boolean isResourcePhase() {
        return this.requestPhase == 3;
    }

    private void init(PortletContext context, PortletRequest request, PortletResponse response, FlowUrlHandler flowUrlHandler) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.requestParameterMap = new LocalParameterMap((Map<String, Object>)((Object)new PortletRequestParameterMap(request)));
        this.requestMap = new LocalAttributeMap<Object>((Map<String, Object>)((Object)new PortletRequestMap(request)));
        this.sessionMap = new LocalSharedAttributeMap<Object>(new PortletSessionMap(request));
        this.applicationMap = new LocalSharedAttributeMap<Object>(new PortletContextMap(context));
        this.flowUrlHandler = flowUrlHandler;
        if (request instanceof ActionRequest && response instanceof ActionResponse) {
            this.requestPhase = 1;
        } else if (request instanceof RenderRequest && response instanceof RenderResponse) {
            this.requestPhase = (short)2;
        } else if (request instanceof ResourceRequest && response instanceof ResourceResponse) {
            this.requestPhase = (short)3;
        } else {
            throw new IllegalArgumentException("Unknown portlet phase, expected: action, render, or resource");
        }
    }

    private void assertResponseAllowed() throws IllegalStateException {
        if (!this.isRenderPhase() && !this.isResourcePhase()) {
            throw new IllegalStateException("A response is not allowed because the current PortletRequest is neither a RenderRequest nor a ResourceRequest");
        }
        if (this.responseComplete) {
            throw new IllegalStateException("A response is not allowed because recordResponseComplete() has already been called on this ExternalContext");
        }
    }

    private void assertRedirectResponseAllowed() throws IllegalStateException {
        if (!this.isActionPhase()) {
            throw new IllegalStateException("A redirect is not allowed because the current PortletRequest is not a ActionRequest");
        }
        if (this.responseComplete) {
            throw new IllegalStateException("A redirect is not allowed because a response has already been completed on this ExternalContext");
        }
    }

    private boolean isRedirectRequested() {
        return this.getFlowExecutionRedirectRequested() || this.getFlowDefinitionRedirectRequested() || this.getExternalRedirectRequested();
    }
}

