/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import org.springframework.faces.webflow.FacesContextHelper;
import org.springframework.faces.webflow.FlowFacesContext;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.webflow.context.servlet.AbstractAjaxHandler;

public class JsfAjaxHandler
extends AbstractAjaxHandler {
    public JsfAjaxHandler() {
        this(null);
    }

    public JsfAjaxHandler(AbstractAjaxHandler delegate) {
        super(delegate);
    }

    protected boolean isAjaxRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        FacesContext facesContext = FlowFacesContext.getCurrentInstance();
        if (facesContext != null) {
            return facesContext.getPartialViewContext().isAjaxRequest();
        }
        String header = request.getHeader("Faces-Request");
        String param = request.getParameter("jakarta.faces.partial.ajax");
        return "partial/ajax".equals(header) || "true".equals(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAjaxRedirectInternal(String targetUrl, HttpServletRequest request, HttpServletResponse response, boolean popup) throws IOException {
        FacesContextHelper helper = new FacesContextHelper();
        try {
            FacesContext facesContext = helper.getFacesContext(this.getServletContext(), request, response);
            PartialResponseWriter writer = this.createPartialResponseWriter(facesContext);
            writer.startDocument();
            writer.redirect(response.encodeRedirectURL(targetUrl));
            writer.endDocument();
        }
        finally {
            helper.releaseIfNecessary();
        }
    }

    private PartialResponseWriter createPartialResponseWriter(FacesContext context) throws IOException {
        ExternalContext externalContext = context.getExternalContext();
        String encoding = externalContext.getRequestCharacterEncoding();
        externalContext.setResponseContentType("application/xml");
        externalContext.setResponseCharacterEncoding(encoding);
        ResponseWriter responseWriter = null;
        Writer out = externalContext.getResponseOutputWriter();
        if (out != null) {
            RenderKitFactory factory = JsfUtils.findFactory(RenderKitFactory.class);
            RenderKit renderKit = factory.getRenderKit(context, "HTML_BASIC");
            responseWriter = renderKit.createResponseWriter(out, "text/xml", encoding);
        }
        if (responseWriter instanceof PartialResponseWriter) {
            return (PartialResponseWriter)responseWriter;
        }
        return new PartialResponseWriter(responseWriter);
    }
}

