/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import jakarta.faces.component.ActionSource2;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.builder.model.FlowModelFlowBuilder;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.validation.BeanValidationHintResolver;
import org.springframework.webflow.validation.ValidationHelper;
import org.springframework.webflow.validation.ValidationHintResolver;
import org.springframework.webflow.validation.WebFlowMessageCodesResolver;

public class FlowActionListener
implements ActionListener {
    private static final Log logger = LogFactory.getLog(FlowActionListener.class);
    private static final String MESSAGES_ID = "messages";
    private final ActionListener delegate;
    private final MessageCodesResolver messageCodesResolver = new WebFlowMessageCodesResolver();

    public FlowActionListener(ActionListener delegate) {
        this.delegate = delegate;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (!JsfUtils.isFlowRequest()) {
            this.delegate.processAction(actionEvent);
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ActionSource2 source = (ActionSource2)actionEvent.getSource();
        String eventId = null;
        if (source.getActionExpression() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking action " + source.getActionExpression()));
            }
            eventId = (String)source.getActionExpression().invoke(context.getELContext(), null);
        }
        if (StringUtils.hasText(eventId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event '" + eventId + "' detected"));
            }
            if (source.isImmediate() || this.validateModel(context, eventId)) {
                context.getExternalContext().getRequestMap().put("org.springframework.webflow.FacesEvent", eventId);
            }
        } else {
            logger.debug((Object)"No action event detected");
            context.getExternalContext().getRequestMap().remove("org.springframework.webflow.FacesEvent");
        }
        context.renderResponse();
    }

    private boolean validateModel(FacesContext facesContext, String eventId) {
        Object model;
        boolean isValid = true;
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        if (this.shouldValidate(requestContext, model = this.getModelObject(requestContext), eventId)) {
            this.validate(requestContext, model, eventId);
            if (requestContext.getMessageContext().hasErrorMessages()) {
                isValid = false;
                if (requestContext.getExternalContext().isAjaxRequest()) {
                    ArrayList<String> fragments = new ArrayList<String>();
                    String formId = this.getModelExpression(requestContext).getExpressionString();
                    if (facesContext.getViewRoot().findComponent(formId) != null) {
                        fragments.add(formId);
                    }
                    if (facesContext.getViewRoot().findComponent(MESSAGES_ID) != null) {
                        fragments.add(MESSAGES_ID);
                    }
                    if (fragments.size() > 0) {
                        String[] fragmentsArray = new String[fragments.size()];
                        for (int i = 0; i < fragments.size(); ++i) {
                            fragmentsArray[i] = (String)fragments.get(i);
                        }
                        requestContext.getFlashScope().put("flowRenderFragments", (Object)fragmentsArray);
                    }
                }
            }
        }
        return isValid;
    }

    private Object getModelObject(RequestContext requestContext) {
        Expression model = this.getModelExpression(requestContext);
        if (model != null) {
            return model.getValue((Object)requestContext);
        }
        return null;
    }

    private Expression getModelExpression(RequestContext requestContext) {
        return (Expression)requestContext.getCurrentState().getAttributes().get("model");
    }

    private boolean shouldValidate(RequestContext requestContext, Object model, String eventId) {
        if (model == null) {
            return false;
        }
        TransitionDefinition transition = requestContext.getMatchingTransition(eventId);
        if (transition != null && transition.getAttributes().contains("validate")) {
            return transition.getAttributes().getBoolean("validate");
        }
        return true;
    }

    private void validate(RequestContext requestContext, Object model, String eventId) {
        String modelName = this.getModelExpression(requestContext).getExpressionString();
        String attr = FlowModelFlowBuilder.VALIDATOR_FLOW_ATTR;
        Validator validator = (Validator)requestContext.getActiveFlow().getAttributes().get(attr);
        ValidationHelper helper = new ValidationHelper(model, requestContext, eventId, modelName, null, this.messageCodesResolver, null, this.getHintResolver(requestContext));
        helper.setValidator(validator);
        helper.validate();
    }

    private ValidationHintResolver getHintResolver(RequestContext requestContext) {
        ValidationHintResolver hintResolver = (ValidationHintResolver)requestContext.getActiveFlow().getAttributes().get(FlowModelFlowBuilder.VALIDATION_HINT_RESOLVER_FLOW_ATTR);
        return hintResolver != null ? hintResolver : new BeanValidationHintResolver();
    }
}

