/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.recipes.persist;

import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.config.StateMachineBuilder;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.recipes.persist.AbstractPersistStateMachineHandler;
import org.springframework.util.Assert;

public class FactoryPersistStateMachineHandler<S, E>
extends AbstractPersistStateMachineHandler<S, E> {
    protected final StateMachineFactory<S, E> factory;
    protected final StateMachineBuilder.Builder<S, E> builder;

    public FactoryPersistStateMachineHandler(StateMachineBuilder.Builder<S, E> builder) {
        Assert.notNull(builder, (String)"State machine builder must be set");
        this.builder = builder;
        this.factory = null;
    }

    public FactoryPersistStateMachineHandler(StateMachineFactory<S, E> factory) {
        Assert.notNull(factory, (String)"State machine factory must be set");
        this.factory = factory;
        this.builder = null;
    }

    @Override
    protected StateMachine<S, E> getInitStateMachine() {
        StateMachine stateMachine;
        if (this.factory != null) {
            stateMachine = this.factory.getStateMachine();
        } else if (this.builder != null) {
            stateMachine = this.builder.build();
        } else {
            throw new StateMachineException("Factory or builder must be set to build state machine for handler");
        }
        this.initStateMachine(stateMachine);
        return stateMachine;
    }
}

