/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.jetty;

import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.springframework.context.Lifecycle;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.concurrent.FutureUtils;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketHandlerAdapter;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketSession;
import org.springframework.web.socket.adapter.jetty.WebSocketToJettyExtensionConfigAdapter;
import org.springframework.web.socket.client.AbstractWebSocketClient;

public class JettyWebSocketClient
extends AbstractWebSocketClient
implements Lifecycle {
    private final WebSocketClient client;
    @Nullable
    private AsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();

    public JettyWebSocketClient() {
        this.client = new WebSocketClient();
    }

    public JettyWebSocketClient(WebSocketClient client) {
        this.client = client;
    }

    public void setTaskExecutor(@Nullable AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Nullable
    public AsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void start() {
        try {
            this.client.start();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to start Jetty WebSocketClient", ex);
        }
    }

    public void stop() {
        try {
            this.client.stop();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to stop Jetty WebSocketClient", (Throwable)ex);
        }
    }

    public boolean isRunning() {
        return this.client.isStarted();
    }

    @Override
    public CompletableFuture<WebSocketSession> executeInternal(WebSocketHandler wsHandler, HttpHeaders headers, URI uri, List<String> protocols, List<WebSocketExtension> extensions, Map<String, Object> attributes) {
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setSubProtocols(protocols);
        for (WebSocketExtension extension : extensions) {
            request.addExtensions(new ExtensionConfig[]{new WebSocketToJettyExtensionConfigAdapter(extension)});
        }
        request.setHeaders((Map)headers);
        Principal user = this.getUser();
        JettyWebSocketSession wsSession = new JettyWebSocketSession(attributes, user);
        Callable<WebSocketSession> connectTask = () -> {
            JettyWebSocketHandlerAdapter adapter = new JettyWebSocketHandlerAdapter(wsHandler, wsSession);
            CompletableFuture future = this.client.connect((Object)adapter, uri, request);
            future.get(this.client.getConnectTimeout() + 2000L, TimeUnit.MILLISECONDS);
            return wsSession;
        };
        if (this.taskExecutor != null) {
            return FutureUtils.callAsync(connectTask, (Executor)this.taskExecutor);
        }
        return FutureUtils.callAsync(connectTask);
    }

    @Nullable
    protected Principal getUser() {
        return null;
    }
}

