/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.context.Lifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.handler.LoggingWebSocketHandlerDecorator;

public class WebSocketConnectionManager
extends ConnectionManagerSupport {
    private final WebSocketClient client;
    private final WebSocketHandler webSocketHandler;
    @Nullable
    private WebSocketSession webSocketSession;
    private final WebSocketHttpHeaders headers = new WebSocketHttpHeaders();

    public WebSocketConnectionManager(WebSocketClient client, WebSocketHandler webSocketHandler, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.client = client;
        this.webSocketHandler = this.decorateWebSocketHandler(webSocketHandler);
    }

    public void setSubProtocols(List<String> protocols) {
        this.headers.setSecWebSocketProtocol(protocols);
    }

    public List<String> getSubProtocols() {
        return this.headers.getSecWebSocketProtocol();
    }

    public void setOrigin(@Nullable String origin) {
        this.headers.setOrigin(origin);
    }

    @Nullable
    public String getOrigin() {
        return this.headers.getOrigin();
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers.clear();
        this.headers.putAll((Map<? extends String, ? extends List<String>>)headers);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void startInternal() {
        Lifecycle lifecycle;
        WebSocketClient webSocketClient = this.client;
        if (webSocketClient instanceof Lifecycle && !(lifecycle = (Lifecycle)webSocketClient).isRunning()) {
            lifecycle.start();
        }
        super.startInternal();
    }

    @Override
    public void stopInternal() throws Exception {
        Lifecycle lifecycle;
        WebSocketClient webSocketClient = this.client;
        if (webSocketClient instanceof Lifecycle && (lifecycle = (Lifecycle)webSocketClient).isRunning()) {
            lifecycle.stop();
        }
        super.stopInternal();
    }

    @Override
    public boolean isConnected() {
        return this.webSocketSession != null && this.webSocketSession.isOpen();
    }

    @Override
    protected void openConnection() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Connecting to WebSocket at " + this.getUri()));
        }
        CompletableFuture<WebSocketSession> future = this.client.execute(this.webSocketHandler, this.headers, this.getUri());
        future.whenComplete((result, ex) -> {
            if (result != null) {
                this.webSocketSession = result;
                this.logger.info((Object)"Successfully connected");
            } else if (ex != null) {
                this.logger.error((Object)"Failed to connect", ex);
            }
        });
    }

    @Override
    protected void closeConnection() throws Exception {
        if (this.webSocketSession != null) {
            this.webSocketSession.close();
        }
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        return new LoggingWebSocketHandlerDecorator(handler);
    }
}

