/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xml;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractJacksonView;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.dataformat.xml.XmlMapper;

public class JacksonXmlView
extends AbstractJacksonView {
    public static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private @Nullable String modelKey;

    public JacksonXmlView() {
        super((MapperBuilder<?, ?>)XmlMapper.builder(), DEFAULT_CONTENT_TYPE);
    }

    public JacksonXmlView(XmlMapper.Builder builder) {
        super((MapperBuilder<?, ?>)builder, DEFAULT_CONTENT_TYPE);
    }

    public JacksonXmlView(XmlMapper mapper) {
        super((ObjectMapper)mapper, DEFAULT_CONTENT_TYPE);
    }

    @Override
    public void setModelKey(String modelKey) {
        this.modelKey = modelKey;
    }

    @Override
    protected Object filterModel(Map<String, Object> model, HttpServletRequest request) {
        Object value = null;
        if (this.modelKey != null) {
            value = model.get(this.modelKey);
            if (value == null) {
                throw new IllegalStateException("Model contains no object with key [" + this.modelKey + "]");
            }
        } else {
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                if (entry.getValue() instanceof BindingResult || entry.getKey().equals(JSON_VIEW_HINT) || entry.getKey().equals(FILTER_PROVIDER_HINT)) continue;
                if (value != null) {
                    throw new IllegalStateException("Model contains more than one object to render, only one is supported");
                }
                value = entry.getValue();
            }
        }
        Assert.state((value != null ? 1 : 0) != 0, (String)"Model contains no object to render");
        return value;
    }
}

