/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import jakarta.servlet.jsp.JspException;
import java.util.Collection;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.OptionWriter;
import org.springframework.web.servlet.tags.form.TagWriter;

public class SelectTag
extends AbstractHtmlInputElementTag {
    public static final String LIST_VALUE_PAGE_ATTRIBUTE = "org.springframework.web.servlet.tags.form.SelectTag.listValue";
    private static final Object EMPTY = new Object();
    private @Nullable Object items;
    private @Nullable String itemValue;
    private @Nullable String itemLabel;
    private @Nullable String size;
    private @Nullable Object multiple;
    private @Nullable TagWriter tagWriter;

    public void setItems(@Nullable Object items) {
        this.items = items != null ? items : EMPTY;
    }

    protected @Nullable Object getItems() {
        return this.items;
    }

    public void setItemValue(String itemValue) {
        this.itemValue = itemValue;
    }

    protected @Nullable String getItemValue() {
        return this.itemValue;
    }

    public void setItemLabel(String itemLabel) {
        this.itemLabel = itemLabel;
    }

    protected @Nullable String getItemLabel() {
        return this.itemLabel;
    }

    public void setSize(String size) {
        this.size = size;
    }

    protected @Nullable String getSize() {
        return this.size;
    }

    public void setMultiple(Object multiple) {
        this.multiple = multiple;
    }

    protected @Nullable Object getMultiple() {
        return this.multiple;
    }

    @Override
    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("select");
        this.writeDefaultAttributes(tagWriter);
        if (this.isMultiple()) {
            tagWriter.writeAttribute("multiple", "multiple");
        }
        tagWriter.writeOptionalAttributeValue("size", this.getDisplayString(this.evaluate("size", this.getSize())));
        Object items = this.getItems();
        if (items != null) {
            Object itemsObject;
            if (items != EMPTY && (itemsObject = this.evaluate("items", items)) != null) {
                final String selectName = this.getName();
                String valueProperty = this.getItemValue() != null ? ObjectUtils.getDisplayString((Object)this.evaluate("itemValue", this.getItemValue())) : null;
                String labelProperty = this.getItemLabel() != null ? ObjectUtils.getDisplayString((Object)this.evaluate("itemLabel", this.getItemLabel())) : null;
                OptionWriter optionWriter = new OptionWriter(this, itemsObject, this.getBindStatus(), valueProperty, labelProperty, this.isHtmlEscape()){
                    final /* synthetic */ SelectTag this$0;
                    {
                        this.this$0 = this$0;
                        super(optionSource, bindStatus, valueProperty, labelProperty, htmlEscape);
                    }

                    @Override
                    protected String processOptionValue(String resolvedValue) {
                        return this.this$0.processFieldValue(selectName, resolvedValue, "option");
                    }
                };
                optionWriter.writeOptions(tagWriter);
            }
            tagWriter.endTag(true);
            this.writeHiddenTagIfNecessary(tagWriter);
            return 0;
        }
        tagWriter.forceBlock();
        this.tagWriter = tagWriter;
        this.pageContext.setAttribute(LIST_VALUE_PAGE_ATTRIBUTE, (Object)this.getBindStatus());
        return 1;
    }

    private void writeHiddenTagIfNecessary(TagWriter tagWriter) throws JspException {
        if (this.isMultiple()) {
            tagWriter.startTag("input");
            tagWriter.writeAttribute("type", "hidden");
            String name = "_" + this.getName();
            tagWriter.writeAttribute("name", name);
            tagWriter.writeAttribute("value", this.processFieldValue(name, "1", "hidden"));
            tagWriter.endTag();
        }
    }

    private boolean isMultiple() throws JspException {
        Object multiple = this.getMultiple();
        if (multiple != null) {
            String stringValue = multiple.toString();
            return "multiple".equalsIgnoreCase(stringValue) || Boolean.parseBoolean(stringValue);
        }
        return this.forceMultiple();
    }

    private boolean forceMultiple() throws JspException {
        Object editorValue;
        BindStatus bindStatus = this.getBindStatus();
        Class<?> valueType = bindStatus.getValueType();
        if (valueType != null && SelectTag.typeRequiresMultiple(valueType)) {
            return true;
        }
        return bindStatus.getEditor() != null && (editorValue = bindStatus.getEditor().getValue()) != null && SelectTag.typeRequiresMultiple(editorValue.getClass());
    }

    private static boolean typeRequiresMultiple(Class<?> type) {
        return type.isArray() || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    public int doEndTag() throws JspException {
        if (this.tagWriter != null) {
            this.tagWriter.endTag();
            this.writeHiddenTagIfNecessary(this.tagWriter);
        }
        return 6;
    }

    @Override
    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
        this.pageContext.removeAttribute(LIST_VALUE_PAGE_ATTRIBUTE);
    }
}

