/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.jstl.core.Config;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jspecify.annotations.Nullable;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.SimpleTimeZoneAwareLocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.EscapedErrors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.LocaleContextResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.support.RequestDataValueProcessor;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class RequestContext {
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = RequestContext.class.getName() + ".CONTEXT";
    protected static final boolean jstlPresent = ClassUtils.isPresent((String)"jakarta.servlet.jsp.jstl.core.Config", (ClassLoader)RequestContext.class.getClassLoader());
    private final HttpServletRequest request;
    private final @Nullable HttpServletResponse response;
    private final @Nullable Map<String, Object> model;
    private final WebApplicationContext webApplicationContext;
    private @Nullable Locale locale;
    private @Nullable TimeZone timeZone;
    private @Nullable Boolean defaultHtmlEscape;
    private final @Nullable Boolean responseEncodedHtmlEscape;
    private UrlPathHelper urlPathHelper;
    private @Nullable RequestDataValueProcessor requestDataValueProcessor;
    private @Nullable Map<String, Errors> errorsMap;

    public RequestContext(HttpServletRequest request) {
        this(request, null, request.getServletContext(), null);
    }

    public RequestContext(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, request.getServletContext(), null);
    }

    public RequestContext(HttpServletRequest request, @Nullable ServletContext servletContext) {
        this(request, null, servletContext, null);
    }

    public RequestContext(HttpServletRequest request, @Nullable Map<String, Object> model) {
        this(request, null, request.getServletContext(), model);
    }

    public RequestContext(HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable ServletContext servletContext, @Nullable Map<String, Object> model) {
        this.request = request;
        this.response = response;
        this.model = model;
        WebApplicationContext wac = (WebApplicationContext)request.getAttribute(WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (wac == null && (wac = RequestContextUtils.findWebApplicationContext(request, servletContext)) == null) {
            throw new IllegalStateException("No WebApplicationContext found: not in a DispatcherServlet request and no ContextLoaderListener registered?");
        }
        this.webApplicationContext = wac;
        Locale locale = null;
        TimeZone timeZone = null;
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request);
        if (localeResolver instanceof LocaleContextResolver) {
            LocaleContextResolver localeContextResolver = (LocaleContextResolver)localeResolver;
            LocaleContext localeContext = localeContextResolver.resolveLocaleContext(request);
            locale = localeContext.getLocale();
            if (localeContext instanceof TimeZoneAwareLocaleContext) {
                TimeZoneAwareLocaleContext timeZoneAwareLocaleContext = (TimeZoneAwareLocaleContext)localeContext;
                timeZone = timeZoneAwareLocaleContext.getTimeZone();
            }
        } else if (localeResolver != null) {
            locale = localeResolver.resolveLocale(request);
        }
        this.locale = locale;
        this.timeZone = timeZone;
        this.defaultHtmlEscape = WebUtils.getDefaultHtmlEscape((ServletContext)this.webApplicationContext.getServletContext());
        this.responseEncodedHtmlEscape = WebUtils.getResponseEncodedHtmlEscape((ServletContext)this.webApplicationContext.getServletContext());
        this.urlPathHelper = new UrlPathHelper();
        if (this.webApplicationContext.containsBean("requestDataValueProcessor")) {
            this.requestDataValueProcessor = (RequestDataValueProcessor)this.webApplicationContext.getBean("requestDataValueProcessor", RequestDataValueProcessor.class);
        }
    }

    protected final HttpServletRequest getRequest() {
        return this.request;
    }

    protected final @Nullable ServletContext getServletContext() {
        return this.webApplicationContext.getServletContext();
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    public final @Nullable Map<String, Object> getModel() {
        return this.model;
    }

    public MessageSource getMessageSource() {
        return this.webApplicationContext;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : this.getFallbackLocale();
    }

    public @Nullable TimeZone getTimeZone() {
        return this.timeZone != null ? this.timeZone : this.getFallbackTimeZone();
    }

    protected Locale getFallbackLocale() {
        Locale locale;
        if (jstlPresent && (locale = JstlLocaleResolver.getJstlLocale(this.getRequest(), this.getServletContext())) != null) {
            return locale;
        }
        return this.getRequest().getLocale();
    }

    protected @Nullable TimeZone getFallbackTimeZone() {
        TimeZone timeZone;
        if (jstlPresent && (timeZone = JstlLocaleResolver.getJstlTimeZone(this.getRequest(), this.getServletContext())) != null) {
            return timeZone;
        }
        return null;
    }

    public void changeLocale(Locale locale) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(this.request);
        if (localeResolver == null) {
            throw new IllegalStateException("Cannot change locale if no LocaleResolver configured");
        }
        localeResolver.setLocale(this.request, this.response, locale);
        this.locale = locale;
    }

    public void changeLocale(Locale locale, TimeZone timeZone) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(this.request);
        if (!(localeResolver instanceof LocaleContextResolver)) {
            throw new IllegalStateException("Cannot change locale context if no LocaleContextResolver configured");
        }
        LocaleContextResolver localeContextResolver = (LocaleContextResolver)localeResolver;
        localeContextResolver.setLocaleContext(this.request, this.response, (LocaleContext)new SimpleTimeZoneAwareLocaleContext(locale, timeZone));
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public void setDefaultHtmlEscape(boolean defaultHtmlEscape) {
        this.defaultHtmlEscape = defaultHtmlEscape;
    }

    public boolean isDefaultHtmlEscape() {
        return this.defaultHtmlEscape != null && this.defaultHtmlEscape != false;
    }

    public @Nullable Boolean getDefaultHtmlEscape() {
        return this.defaultHtmlEscape;
    }

    public boolean isResponseEncodedHtmlEscape() {
        return this.responseEncodedHtmlEscape == null || this.responseEncodedHtmlEscape != false;
    }

    public @Nullable Boolean getResponseEncodedHtmlEscape() {
        return this.responseEncodedHtmlEscape;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public @Nullable RequestDataValueProcessor getRequestDataValueProcessor() {
        return this.requestDataValueProcessor;
    }

    public String getContextPath() {
        return this.urlPathHelper.getOriginatingContextPath(this.request);
    }

    public String getContextUrl(String relativeUrl) {
        Object url = this.getContextPath() + relativeUrl;
        if (this.response != null) {
            url = this.response.encodeURL((String)url);
        }
        return url;
    }

    public String getContextUrl(String relativeUrl, Map<String, ?> params) {
        Object url = this.getContextPath() + relativeUrl;
        url = UriComponentsBuilder.fromUriString((String)url).buildAndExpand(params).encode().toUri().toASCIIString();
        if (this.response != null) {
            url = this.response.encodeURL((String)url);
        }
        return url;
    }

    public String getPathToServlet() {
        Object path = this.urlPathHelper.getOriginatingContextPath(this.request);
        if (StringUtils.hasText((String)this.urlPathHelper.getPathWithinServletMapping(this.request))) {
            path = (String)path + this.urlPathHelper.getOriginatingServletPath(this.request);
        }
        return path;
    }

    public String getRequestUri() {
        return this.urlPathHelper.getOriginatingRequestUri(this.request);
    }

    public String getQueryString() {
        return this.urlPathHelper.getOriginatingQueryString(this.request);
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessage(code, null, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object @Nullable [] args, String defaultMessage) {
        return this.getMessage(code, args, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, @Nullable List<?> args, String defaultMessage) {
        return this.getMessage(code, args != null ? args.toArray() : null, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object @Nullable [] args, String defaultMessage, boolean htmlEscape) {
        String msg = this.getMessageSource().getMessage(code, args, defaultMessage, this.getLocale());
        if (msg == null) {
            return "";
        }
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(String code) throws NoSuchMessageException {
        return this.getMessage(code, null, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object @Nullable [] args) throws NoSuchMessageException {
        return this.getMessage(code, args, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, @Nullable List<?> args) throws NoSuchMessageException {
        return this.getMessage(code, args != null ? args.toArray() : null, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, Object @Nullable [] args, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.getMessageSource().getMessage(code, args, this.getLocale());
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.getMessage(resolvable, this.isDefaultHtmlEscape());
    }

    public String getMessage(MessageSourceResolvable resolvable, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.getMessageSource().getMessage(resolvable, this.getLocale());
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public @Nullable Errors getErrors(String name) {
        return this.getErrors(name, this.isDefaultHtmlEscape());
    }

    public @Nullable Errors getErrors(String name, boolean htmlEscape) {
        if (this.errorsMap == null) {
            this.errorsMap = new HashMap<String, Errors>();
        }
        Errors errors = this.errorsMap.get(name);
        boolean put = false;
        if (errors == null) {
            errors = (Errors)this.getModelObject(BindingResult.MODEL_KEY_PREFIX + name);
            if (errors instanceof BindException) {
                BindException bindException = (BindException)errors;
                errors = bindException.getBindingResult();
            }
            if (errors == null) {
                return null;
            }
            put = true;
        }
        if (htmlEscape && !(errors instanceof EscapedErrors)) {
            errors = new EscapedErrors(errors);
            put = true;
        } else if (!htmlEscape && errors instanceof EscapedErrors) {
            EscapedErrors escapedErrors = (EscapedErrors)errors;
            errors = escapedErrors.getSource();
            put = true;
        }
        if (put) {
            this.errorsMap.put(name, errors);
        }
        return errors;
    }

    protected @Nullable Object getModelObject(String modelName) {
        if (this.model != null) {
            return this.model.get(modelName);
        }
        return this.request.getAttribute(modelName);
    }

    public BindStatus getBindStatus(String path) throws IllegalStateException {
        return new BindStatus(this, path, this.isDefaultHtmlEscape());
    }

    public BindStatus getBindStatus(String path, boolean htmlEscape) throws IllegalStateException {
        return new BindStatus(this, path, htmlEscape);
    }

    private static class JstlLocaleResolver {
        private JstlLocaleResolver() {
        }

        public static @Nullable Locale getJstlLocale(HttpServletRequest request, @Nullable ServletContext servletContext) {
            Locale locale;
            Object localeObject = Config.get((ServletRequest)request, (String)"jakarta.servlet.jsp.jstl.fmt.locale");
            if (localeObject == null) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    localeObject = Config.get((HttpSession)session, (String)"jakarta.servlet.jsp.jstl.fmt.locale");
                }
                if (localeObject == null && servletContext != null) {
                    localeObject = Config.get((ServletContext)servletContext, (String)"jakarta.servlet.jsp.jstl.fmt.locale");
                }
            }
            return localeObject instanceof Locale ? (locale = (Locale)localeObject) : null;
        }

        public static @Nullable TimeZone getJstlTimeZone(HttpServletRequest request, @Nullable ServletContext servletContext) {
            TimeZone timeZone;
            Object timeZoneObject = Config.get((ServletRequest)request, (String)"jakarta.servlet.jsp.jstl.fmt.timeZone");
            if (timeZoneObject == null) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    timeZoneObject = Config.get((HttpSession)session, (String)"jakarta.servlet.jsp.jstl.fmt.timeZone");
                }
                if (timeZoneObject == null && servletContext != null) {
                    timeZoneObject = Config.get((ServletContext)servletContext, (String)"jakarta.servlet.jsp.jstl.fmt.timeZone");
                }
            }
            return timeZoneObject instanceof TimeZone ? (timeZone = (TimeZone)timeZoneObject) : null;
        }
    }
}

