/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.netty5.channel.ChannelId;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.Netty5DataBufferFactory;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.Netty5WebSocketSessionSupport;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty5.Connection;
import reactor.netty5.channel.ChannelOperations;
import reactor.netty5.http.websocket.WebsocketInbound;
import reactor.netty5.http.websocket.WebsocketOutbound;

public class ReactorNetty2WebSocketSession
extends Netty5WebSocketSessionSupport<WebSocketConnection> {
    private final int maxFramePayloadLength;
    private final ChannelId channelId;

    public ReactorNetty2WebSocketSession(WebsocketInbound inbound, WebsocketOutbound outbound, HandshakeInfo info, Netty5DataBufferFactory bufferFactory) {
        this(inbound, outbound, info, bufferFactory, 65536);
    }

    public ReactorNetty2WebSocketSession(WebsocketInbound inbound, WebsocketOutbound outbound, HandshakeInfo info, Netty5DataBufferFactory bufferFactory, int maxFramePayloadLength) {
        super(new WebSocketConnection(inbound, outbound), info, bufferFactory);
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.channelId = ((ChannelOperations)inbound).channel().id();
    }

    public ChannelId getChannelId() {
        return this.channelId;
    }

    @Override
    public Flux<WebSocketMessage> receive() {
        return ((WebSocketConnection)this.getDelegate()).getInbound().aggregateFrames(this.maxFramePayloadLength).receiveFrames().map(x$0 -> super.toMessage((WebSocketFrame)x$0)).doOnNext(message -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.getLogPrefix() + "Received " + message));
            }
        });
    }

    @Override
    public Mono<Void> send(Publisher<WebSocketMessage> messages) {
        Flux frames = Flux.from(messages).doOnNext(message -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.getLogPrefix() + "Sending " + message));
            }
        }).map(this::toFrame);
        return ((WebSocketConnection)this.getDelegate()).getOutbound().sendObject((Publisher)frames).then();
    }

    @Override
    public boolean isOpen() {
        DisposedCallback callback = new DisposedCallback();
        ((WebSocketConnection)this.getDelegate()).getInbound().withConnection((Consumer)callback);
        return !callback.isDisposed();
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        return ((WebSocketConnection)this.getDelegate()).getOutbound().sendClose(status.getCode(), status.getReason());
    }

    @Override
    public Mono<CloseStatus> closeStatus() {
        return ((WebSocketConnection)this.getDelegate()).getInbound().receiveCloseStatus().map(status -> CloseStatus.create(status.code(), status.reasonText()));
    }

    public static class WebSocketConnection {
        private final WebsocketInbound inbound;
        private final WebsocketOutbound outbound;

        public WebSocketConnection(WebsocketInbound inbound, WebsocketOutbound outbound) {
            this.inbound = inbound;
            this.outbound = outbound;
        }

        public WebsocketInbound getInbound() {
            return this.inbound;
        }

        public WebsocketOutbound getOutbound() {
            return this.outbound;
        }
    }

    private static class DisposedCallback
    implements Consumer<Connection> {
        private boolean disposed;

        private DisposedCallback() {
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void accept(Connection connection) {
            this.disposed = connection.isDisposed();
        }
    }
}

