/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.AbstractClientHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;

class JdkClientHttpResponse
extends AbstractClientHttpResponse {
    public JdkClientHttpResponse(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response, DataBufferFactory bufferFactory, MultiValueMap<String, ResponseCookie> cookies) {
        super(HttpStatusCode.valueOf(response.statusCode()), JdkClientHttpResponse.adaptHeaders(response), cookies, JdkClientHttpResponse.adaptBody(response, bufferFactory));
    }

    private static HttpHeaders adaptHeaders(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response) {
        Map<String, List<String>> rawHeaders = response.headers().map();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(rawHeaders.size(), Locale.ROOT);
        MultiValueMap multiValueMap = CollectionUtils.toMultiValueMap((Map)map);
        multiValueMap.putAll(rawHeaders);
        return HttpHeaders.readOnlyHttpHeaders((MultiValueMap<String, String>)multiValueMap);
    }

    private static Flux<DataBuffer> adaptBody(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response, DataBufferFactory bufferFactory) {
        return JdkFlowAdapter.flowPublisherToFlux(response.body()).flatMapIterable(Function.identity()).map(arg_0 -> ((DataBufferFactory)bufferFactory).wrap(arg_0)).doOnDiscard(DataBuffer.class, DataBufferUtils::release).cache(0);
    }
}

