/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.scope.RequestContextHolder;
import org.springframework.web.context.scope.ServletRequestAttributes;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestContextFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            LocaleContextHolder.setLocale((Locale)request.getLocale());
            RequestContextHolder.setRequestAttributes(new ServletRequestAttributes(request));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Bound request context to thread: " + request));
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            RequestContextHolder.setRequestAttributes(null);
            LocaleContextHolder.setLocale(null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleared thread-bound request context: " + request));
            }
        }
    }
}

