/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.jspecify.annotations.Nullable;
import org.springframework.mock.web.MockAsyncContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.DefaultMvcResult;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.WebUtils;

final class TestDispatcherServlet
extends DispatcherServlet {
    private static final String KEY = TestDispatcherServlet.class.getName() + ".interceptor";

    public TestDispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.registerAsyncResultInterceptors(request);
        super.service(request, response);
        if (request.getAsyncContext() != null) {
            MockAsyncContext asyncContext;
            AsyncContext asyncContext2 = request.getAsyncContext();
            if (asyncContext2 instanceof MockAsyncContext) {
                MockAsyncContext mockAsyncContext;
                asyncContext = mockAsyncContext = (MockAsyncContext)asyncContext2;
            } else {
                MockHttpServletRequest mockRequest = (MockHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, MockHttpServletRequest.class);
                Assert.notNull((Object)mockRequest, (String)"Expected MockHttpServletRequest");
                asyncContext = (MockAsyncContext)mockRequest.getAsyncContext();
                String requestClassName = request.getClass().getName();
                Assert.notNull((Object)asyncContext, () -> "Outer request wrapper " + requestClassName + " has an AsyncContext,but it is not a MockAsyncContext, while the nested " + mockRequest.getClass().getName() + " does not have an AsyncContext at all.");
            }
            CountDownLatch dispatchLatch = new CountDownLatch(1);
            asyncContext.addDispatchHandler(dispatchLatch::countDown);
            this.getMvcResult((ServletRequest)request).setAsyncDispatchLatch(dispatchLatch);
        }
    }

    private void registerAsyncResultInterceptors(final HttpServletRequest request) {
        WebAsyncUtils.getAsyncManager((ServletRequest)request).registerCallableInterceptor((Object)KEY, new CallableProcessingInterceptor(){
            final /* synthetic */ TestDispatcherServlet this$0;
            {
                this.this$0 = this$0;
            }

            public <T> void postProcess(NativeWebRequest r, Callable<T> task, @Nullable Object value) {
                this.this$0.getMvcResult((ServletRequest)request).setAsyncResult(value);
            }
        });
        WebAsyncUtils.getAsyncManager((ServletRequest)request).registerDeferredResultInterceptor((Object)KEY, new DeferredResultProcessingInterceptor(){
            final /* synthetic */ TestDispatcherServlet this$0;
            {
                this.this$0 = this$0;
            }

            public <T> void postProcess(NativeWebRequest r, DeferredResult<T> result, @Nullable Object value) {
                this.this$0.getMvcResult((ServletRequest)request).setAsyncResult(value);
            }
        });
    }

    protected DefaultMvcResult getMvcResult(ServletRequest request) {
        return (DefaultMvcResult)request.getAttribute(MockMvc.MVC_RESULT_ATTRIBUTE);
    }

    protected @Nullable HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        HandlerExecutionChain chain = super.getHandler(request);
        if (chain != null) {
            DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request);
            mvcResult.setHandler(chain.getHandler());
            mvcResult.setInterceptors(chain.getInterceptors());
        }
        return chain;
    }

    protected void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request);
        mvcResult.setModelAndView(mv);
        super.render(mv, request, response);
    }

    protected @Nullable ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) throws Exception {
        ModelAndView mav = super.processHandlerException(request, response, handler, ex);
        DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request);
        mvcResult.setResolvedException(ex);
        mvcResult.setModelAndView(mav);
        return mav;
    }
}

