/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.support;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jspecify.annotations.Nullable;
import org.springframework.http.CacheControl;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.CollectionUtils;

public abstract class AbstractHeaderAssertions<E, R> {
    private final E exchangeResult;
    private final R responseSpec;

    protected AbstractHeaderAssertions(E exchangeResult, R responseSpec) {
        this.exchangeResult = exchangeResult;
        this.responseSpec = responseSpec;
    }

    protected E getExchangeResult() {
        return this.exchangeResult;
    }

    protected abstract HttpHeaders getResponseHeaders();

    protected abstract void assertWithDiagnostics(Runnable var1);

    public R valueEquals(String headerName, String ... values) {
        return this.assertHeader(headerName, Arrays.asList(values), this.getResponseHeaders().getOrEmpty(headerName));
    }

    public R valueEquals(String headerName, long value) {
        String actual = this.getResponseHeaders().getFirst(headerName);
        this.assertWithDiagnostics(() -> AssertionErrors.assertNotNull("Response does not contain header '" + headerName + "'", actual));
        return this.assertHeader(headerName, value, Long.parseLong(actual));
    }

    public R valueEqualsDate(String headerName, long value) {
        this.assertWithDiagnostics(() -> {
            String headerValue = this.getResponseHeaders().getFirst(headerName);
            AssertionErrors.assertNotNull("Response does not contain header '" + headerName + "'", headerValue);
            HttpHeaders headers = new HttpHeaders();
            headers.setDate("expected", value);
            headers.set("actual", headerValue);
            AssertionErrors.assertEquals(AbstractHeaderAssertions.getMessage(headerName) + "='" + headerValue + "' does not match expected value '" + headers.getFirst("expected") + "'", headers.getFirstDate("expected"), headers.getFirstDate("actual"));
        });
        return this.responseSpec;
    }

    public R valueMatches(String name, String pattern) {
        String value = this.getRequiredValue(name);
        String message = AbstractHeaderAssertions.getMessage(name) + "=[" + value + "] does not match [" + pattern + "]";
        this.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, value.matches(pattern)));
        return this.responseSpec;
    }

    public R valuesMatch(String name, String ... patterns) {
        List<String> values = this.getRequiredValues(name);
        this.assertWithDiagnostics(() -> {
            AssertionErrors.assertTrue(AbstractHeaderAssertions.getMessage(name) + " has fewer or more values " + String.valueOf(values) + " than number of patterns to match with " + Arrays.toString(patterns), values.size() == patterns.length);
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                String pattern = patterns[i];
                AssertionErrors.assertTrue(AbstractHeaderAssertions.getMessage(name) + "[" + i + "]='" + value + "' does not match '" + pattern + "'", value.matches(pattern));
            }
        });
        return this.responseSpec;
    }

    public R value(String name, Matcher<? super String> matcher) {
        String value = this.getResponseHeaders().getFirst(name);
        this.assertWithDiagnostics(() -> {
            String message = AbstractHeaderAssertions.getMessage(name);
            MatcherAssert.assertThat((String)message, (Object)value, (Matcher)matcher);
        });
        return this.responseSpec;
    }

    public R values(String name, Matcher<? super Iterable<String>> matcher) {
        List values = this.getResponseHeaders().get(name);
        this.assertWithDiagnostics(() -> {
            String message = AbstractHeaderAssertions.getMessage(name);
            MatcherAssert.assertThat((String)message, (Object)values, (Matcher)matcher);
        });
        return this.responseSpec;
    }

    public R value(String name, Consumer<String> consumer) {
        String value = this.getRequiredValue(name);
        this.assertWithDiagnostics(() -> consumer.accept(value));
        return this.responseSpec;
    }

    public R values(String name, Consumer<List<String>> consumer) {
        List<String> values = this.getRequiredValues(name);
        this.assertWithDiagnostics(() -> consumer.accept(values));
        return this.responseSpec;
    }

    public R exists(String name) {
        if (!this.getResponseHeaders().containsHeader(name)) {
            String message = AbstractHeaderAssertions.getMessage(name) + " does not exist";
            this.assertWithDiagnostics(() -> AssertionErrors.fail(message));
        }
        return this.responseSpec;
    }

    public R doesNotExist(String name) {
        if (this.getResponseHeaders().containsHeader(name)) {
            String message = AbstractHeaderAssertions.getMessage(name) + " exists with value=[" + this.getResponseHeaders().getFirst(name) + "]";
            this.assertWithDiagnostics(() -> AssertionErrors.fail(message));
        }
        return this.responseSpec;
    }

    public R cacheControl(CacheControl cacheControl) {
        return this.assertHeader("Cache-Control", cacheControl.getHeaderValue(), this.getResponseHeaders().getCacheControl());
    }

    public R contentDisposition(ContentDisposition contentDisposition) {
        return this.assertHeader("Content-Disposition", contentDisposition, this.getResponseHeaders().getContentDisposition());
    }

    public R contentLength(long contentLength) {
        return this.assertHeader("Content-Length", contentLength, this.getResponseHeaders().getContentLength());
    }

    public R contentType(MediaType mediaType) {
        return this.assertHeader("Content-Type", mediaType, this.getResponseHeaders().getContentType());
    }

    public R contentType(String mediaType) {
        return this.contentType(MediaType.parseMediaType((String)mediaType));
    }

    public R contentTypeCompatibleWith(MediaType mediaType) {
        MediaType actual = this.getResponseHeaders().getContentType();
        String message = AbstractHeaderAssertions.getMessage("Content-Type") + "=[" + String.valueOf(actual) + "] is not compatible with [" + String.valueOf(mediaType) + "]";
        this.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual != null && actual.isCompatibleWith(mediaType)));
        return this.responseSpec;
    }

    public R contentTypeCompatibleWith(String mediaType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType((String)mediaType));
    }

    public R expires(long expires) {
        return this.assertHeader("Expires", expires, this.getResponseHeaders().getExpires());
    }

    public R lastModified(long lastModified) {
        return this.assertHeader("Last-Modified", lastModified, this.getResponseHeaders().getLastModified());
    }

    public R location(String location) {
        return this.assertHeader("Location", URI.create(location), this.getResponseHeaders().getLocation());
    }

    private R assertHeader(String name, @Nullable Object expected, @Nullable Object actual) {
        this.assertWithDiagnostics(() -> {
            String message = AbstractHeaderAssertions.getMessage(name);
            AssertionErrors.assertEquals(message, expected, actual);
        });
        return this.responseSpec;
    }

    private String getRequiredValue(String name) {
        return this.getRequiredValues(name).get(0);
    }

    private List<String> getRequiredValues(String name) {
        List values = this.getResponseHeaders().get(name);
        if (!CollectionUtils.isEmpty((Collection)values)) {
            return values;
        }
        this.assertWithDiagnostics(() -> AssertionErrors.fail(AbstractHeaderAssertions.getMessage(name) + " not found"));
        throw new IllegalStateException("This code path should not be reachable");
    }

    private static String getMessage(String headerName) {
        return "Response header '" + headerName + "'";
    }
}

