/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import jakarta.servlet.DispatcherType;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.assertj.core.api.AssertProvider;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.http.HttpMessageContentConverter;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.assertj.DefaultMvcTestResult;
import org.springframework.test.web.servlet.assertj.MvcTestResult;
import org.springframework.test.web.servlet.assertj.MvcTestResultAssert;
import org.springframework.test.web.servlet.request.AbstractMockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.AbstractMockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.setup.AbstractMockMvcBuilder;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public final class MockMvcTester {
    private final MockMvc mockMvc;
    private final @Nullable HttpMessageContentConverter contentConverter;

    private MockMvcTester(MockMvc mockMvc, @Nullable HttpMessageContentConverter contentConverter) {
        Assert.notNull((Object)mockMvc, (String)"mockMVC should not be null");
        this.mockMvc = mockMvc;
        this.contentConverter = contentConverter;
    }

    public static MockMvcTester create(MockMvc mockMvc) {
        return new MockMvcTester(mockMvc, null);
    }

    public static MockMvcTester from(WebApplicationContext applicationContext, Function<DefaultMockMvcBuilder, MockMvc> customizations) {
        DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup(applicationContext);
        MockMvc mockMvc = customizations.apply(builder);
        return MockMvcTester.create(mockMvc);
    }

    public static MockMvcTester from(WebApplicationContext applicationContext) {
        return MockMvcTester.from(applicationContext, AbstractMockMvcBuilder::build);
    }

    public static MockMvcTester of(Collection<?> controllers, Function<StandaloneMockMvcBuilder, MockMvc> customizations) {
        StandaloneMockMvcBuilder builder = MockMvcBuilders.standaloneSetup(controllers.toArray());
        return MockMvcTester.create(customizations.apply(builder));
    }

    public static MockMvcTester of(Object ... controllers) {
        return MockMvcTester.of(Arrays.asList(controllers), AbstractMockMvcBuilder::build);
    }

    public MockMvcTester withHttpMessageConverters(Iterable<HttpMessageConverter<?>> httpMessageConverters) {
        return new MockMvcTester(this.mockMvc, HttpMessageContentConverter.of(httpMessageConverters));
    }

    public MockMvcRequestBuilder get() {
        return this.method(HttpMethod.GET);
    }

    public MockMvcRequestBuilder head() {
        return this.method(HttpMethod.HEAD);
    }

    public MockMvcRequestBuilder post() {
        return this.method(HttpMethod.POST);
    }

    public MockMvcRequestBuilder put() {
        return this.method(HttpMethod.PUT);
    }

    public MockMvcRequestBuilder patch() {
        return this.method(HttpMethod.PATCH);
    }

    public MockMvcRequestBuilder delete() {
        return this.method(HttpMethod.DELETE);
    }

    public MockMvcRequestBuilder options() {
        return this.method(HttpMethod.OPTIONS);
    }

    public MockMvcRequestBuilder method(HttpMethod method) {
        return new MockMvcRequestBuilder(method);
    }

    public MvcTestResult perform(RequestBuilder requestBuilder) {
        Object result = this.getMvcResultOrFailure(requestBuilder);
        if (result instanceof MvcResult) {
            MvcResult mvcResult = (MvcResult)result;
            return new DefaultMvcTestResult(mvcResult, null, this.contentConverter);
        }
        return new DefaultMvcTestResult(null, (Exception)result, this.contentConverter);
    }

    private Object getMvcResultOrFailure(RequestBuilder requestBuilder) {
        try {
            return this.mockMvc.perform(requestBuilder).andReturn();
        }
        catch (Exception ex) {
            return ex;
        }
    }

    MvcTestResult exchange(RequestBuilder requestBuilder, @Nullable Duration timeToWait) {
        MvcTestResult result = this.perform(requestBuilder);
        if (result.getUnresolvedException() == null && result.getRequest().isAsyncStarted()) {
            long waitMs = timeToWait != null ? timeToWait.toMillis() : -1L;
            result.getMvcResult().getAsyncResult(waitMs);
            RequestBuilder dispatchRequest = servletContext -> {
                MockHttpServletRequest request = result.getMvcResult().getRequest();
                request.setDispatcherType(DispatcherType.ASYNC);
                request.setAsyncStarted(false);
                return request;
            };
            return this.perform(dispatchRequest);
        }
        return result;
    }

    public final class MockMvcRequestBuilder
    extends AbstractMockHttpServletRequestBuilder<MockMvcRequestBuilder>
    implements AssertProvider<MvcTestResultAssert> {
        private final HttpMethod httpMethod;

        private MockMvcRequestBuilder(HttpMethod httpMethod) {
            super(httpMethod);
            this.httpMethod = httpMethod;
        }

        public MockMultipartMvcRequestBuilder multipart() {
            return new MockMultipartMvcRequestBuilder(this);
        }

        public MvcTestResult exchange() {
            return MockMvcTester.this.exchange(this, null);
        }

        public MvcTestResult exchange(Duration timeToWait) {
            return MockMvcTester.this.exchange(this, timeToWait);
        }

        public MvcTestResult asyncExchange() {
            return MockMvcTester.this.perform(this);
        }

        public MvcTestResultAssert assertThat() {
            return new MvcTestResultAssert(this.exchange(), MockMvcTester.this.contentConverter);
        }
    }

    public final class MockMultipartMvcRequestBuilder
    extends AbstractMockMultipartHttpServletRequestBuilder<MockMultipartMvcRequestBuilder>
    implements AssertProvider<MvcTestResultAssert> {
        private MockMultipartMvcRequestBuilder(MockMvcRequestBuilder currentBuilder) {
            super(currentBuilder.httpMethod);
            this.merge(currentBuilder);
        }

        public MvcTestResult exchange() {
            return MockMvcTester.this.exchange(this, null);
        }

        public MvcTestResult exchange(Duration timeToWait) {
            return MockMvcTester.this.exchange(this, timeToWait);
        }

        public MvcTestResult asyncExchange() {
            return MockMvcTester.this.perform(this);
        }

        public MvcTestResultAssert assertThat() {
            return new MvcTestResultAssert(this.exchange(), MockMvcTester.this.contentConverter);
        }
    }
}

