/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.Mergeable;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.DefaultMvcResult;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.SmartRequestBuilder;
import org.springframework.test.web.servlet.TestDispatcherServlet;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.DispatcherServlet;

public final class MockMvc {
    static final String MVC_RESULT_ATTRIBUTE = MockMvc.class.getName().concat(".MVC_RESULT_ATTRIBUTE");
    private final TestDispatcherServlet servlet;
    private final Filter[] filters;
    private final ServletContext servletContext;
    private @Nullable RequestBuilder defaultRequestBuilder;
    private @Nullable Charset defaultResponseCharacterEncoding;
    private List<ResultMatcher> defaultResultMatchers = new ArrayList<ResultMatcher>();
    private List<ResultHandler> defaultResultHandlers = new ArrayList<ResultHandler>();

    MockMvc(TestDispatcherServlet servlet, Filter ... filters) {
        Assert.notNull((Object)((Object)servlet), (String)"DispatcherServlet is required");
        Assert.notNull((Object)filters, (String)"Filters cannot be null");
        Assert.noNullElements((Object[])filters, (String)"Filters cannot contain null values");
        this.servlet = servlet;
        this.filters = filters;
        this.servletContext = servlet.getServletContext();
    }

    void setDefaultRequest(@Nullable RequestBuilder requestBuilder) {
        this.defaultRequestBuilder = requestBuilder;
    }

    void setDefaultResponseCharacterEncoding(@Nullable Charset defaultResponseCharacterEncoding) {
        this.defaultResponseCharacterEncoding = defaultResponseCharacterEncoding;
    }

    void setGlobalResultMatchers(List<ResultMatcher> resultMatchers) {
        Assert.notNull(resultMatchers, (String)"ResultMatcher List is required");
        this.defaultResultMatchers = resultMatchers;
    }

    void setGlobalResultHandlers(List<ResultHandler> resultHandlers) {
        Assert.notNull(resultHandlers, (String)"ResultHandler List is required");
        this.defaultResultHandlers = resultHandlers;
    }

    public DispatcherServlet getDispatcherServlet() {
        return this.servlet;
    }

    public ResultActions perform(RequestBuilder requestBuilder) throws Exception {
        MockHttpServletResponse mockResponse;
        HttpServletResponse servletResponse;
        MockHttpServletRequest request;
        AsyncContext asyncContext;
        if (this.defaultRequestBuilder != null && requestBuilder instanceof Mergeable) {
            Mergeable mergeable = (Mergeable)requestBuilder;
            requestBuilder = (RequestBuilder)mergeable.merge((Object)this.defaultRequestBuilder);
        }
        if ((asyncContext = (request = requestBuilder.buildRequest(this.servletContext)).getAsyncContext()) != null) {
            servletResponse = (HttpServletResponse)asyncContext.getResponse();
            mockResponse = this.unwrapResponseIfNecessary((ServletResponse)servletResponse);
        } else {
            mockResponse = new MockHttpServletResponse();
            servletResponse = mockResponse;
        }
        if (this.defaultResponseCharacterEncoding != null) {
            mockResponse.setDefaultCharacterEncoding(this.defaultResponseCharacterEncoding.name());
        }
        if (requestBuilder instanceof SmartRequestBuilder) {
            SmartRequestBuilder smartRequestBuilder = (SmartRequestBuilder)requestBuilder;
            request = smartRequestBuilder.postProcessRequest(request);
        }
        final DefaultMvcResult mvcResult = new DefaultMvcResult(request, mockResponse);
        request.setAttribute(MVC_RESULT_ATTRIBUTE, mvcResult);
        RequestAttributes previousAttributes = RequestContextHolder.getRequestAttributes();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request, servletResponse));
        MockFilterChain filterChain = new MockFilterChain((Servlet)this.servlet, this.filters);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)servletResponse);
        if (DispatcherType.ASYNC.equals((Object)request.getDispatcherType()) && asyncContext != null && !request.isAsyncStarted()) {
            asyncContext.complete();
        }
        this.applyDefaultResultActions(mvcResult);
        RequestContextHolder.setRequestAttributes((RequestAttributes)previousAttributes);
        return new ResultActions(){
            final /* synthetic */ MockMvc this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ResultActions andExpect(ResultMatcher matcher) throws Exception {
                matcher.match(mvcResult);
                return this;
            }

            @Override
            public ResultActions andDo(ResultHandler handler) throws Exception {
                handler.handle(mvcResult);
                return this;
            }

            @Override
            public MvcResult andReturn() {
                return mvcResult;
            }
        };
    }

    private MockHttpServletResponse unwrapResponseIfNecessary(ServletResponse servletResponse) {
        while (servletResponse instanceof HttpServletResponseWrapper) {
            HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)servletResponse;
            servletResponse = wrapper.getResponse();
        }
        Assert.isInstanceOf(MockHttpServletResponse.class, (Object)servletResponse);
        return (MockHttpServletResponse)servletResponse;
    }

    private void applyDefaultResultActions(MvcResult mvcResult) throws Exception {
        for (ResultHandler handler : this.defaultResultHandlers) {
            handler.handle(mvcResult);
        }
        for (ResultMatcher matcher : this.defaultResultMatchers) {
            matcher.match(mvcResult);
        }
    }
}

