/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.r2dbc.core.ConnectionAccessor;
import org.springframework.r2dbc.core.DelegateConnectionFunction;
import org.springframework.r2dbc.core.FetchSpec;
import org.springframework.r2dbc.core.ResultFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultFetchSpec<T>
implements FetchSpec<T> {
    private final ConnectionAccessor connectionAccessor;
    private final ResultFunction resultFunction;
    private final Function<Connection, Mono<Long>> updatedRowsFunction;
    private final Function<Result, Publisher<T>> resultAdapter;

    DefaultFetchSpec(ConnectionAccessor connectionAccessor, ResultFunction resultFunction, Function<Connection, Mono<Long>> updatedRowsFunction, Function<Result, Publisher<T>> resultAdapter) {
        this.connectionAccessor = connectionAccessor;
        this.resultFunction = resultFunction;
        this.updatedRowsFunction = new DelegateConnectionFunction<Mono<Long>>(resultFunction, updatedRowsFunction);
        this.resultAdapter = resultAdapter;
    }

    @Override
    public Mono<T> one() {
        return this.all().buffer(2).flatMap(list -> {
            if (list.isEmpty()) {
                return Mono.empty();
            }
            if (list.size() > 1) {
                return Mono.error((Throwable)new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result.", this.resultFunction.getSql()), 1));
            }
            return Mono.just(list.get(0));
        }).next();
    }

    @Override
    public Mono<T> first() {
        return this.all().next();
    }

    @Override
    public Flux<T> all() {
        return this.connectionAccessor.inConnectionMany(new DelegateConnectionFunction(this.resultFunction, connection -> this.resultFunction.apply((Connection)connection).flatMap(this.resultAdapter)));
    }

    @Override
    public Mono<Long> rowsUpdated() {
        return this.connectionAccessor.inConnection(this.updatedRowsFunction);
    }
}

