/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jpa;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.springframework.instrument.classloading.ShadowingClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrmXmlOverridingShadowingClassLoader
extends ShadowingClassLoader {
    private List<String> providerPrefixes = new LinkedList<String>();
    private static final Enumeration<URL> EMPTY_URL_ENUMERATION = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new UnsupportedOperationException("Should not be called. I am empty");
        }
    };
    private final String realOrmXmlLocation;

    OrmXmlOverridingShadowingClassLoader(ClassLoader loader, String realOrmXmlLocation) {
        super(loader);
        this.providerPrefixes.add("oracle.toplink.essentials");
        this.providerPrefixes.add("kodo");
        this.realOrmXmlLocation = realOrmXmlLocation;
    }

    protected boolean isClassNameExcludedFromShadowing(String className) {
        for (String providerPrefix : this.providerPrefixes) {
            if (!className.startsWith(providerPrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean askingForDefaultOrmXmlLocation(String requestedPath) {
        return "/META-INF/orm.xml".equals(requestedPath) || "META-INF/orm.xml".equals(requestedPath);
    }

    public URL getResource(String requestedPath) {
        if (this.askingForDefaultOrmXmlLocation(requestedPath)) {
            return this.realOrmXmlLocation == null ? null : super.getResource(this.realOrmXmlLocation);
        }
        return super.getResource(requestedPath);
    }

    public InputStream getResourceAsStream(String requestedPath) {
        if (this.askingForDefaultOrmXmlLocation(requestedPath)) {
            return this.realOrmXmlLocation == null ? null : super.getResourceAsStream(this.realOrmXmlLocation);
        }
        return super.getResourceAsStream(requestedPath);
    }

    public Enumeration<URL> getResources(String requestedPath) throws IOException {
        if (this.askingForDefaultOrmXmlLocation(requestedPath)) {
            return this.realOrmXmlLocation == null ? EMPTY_URL_ENUMERATION : super.getResources(this.realOrmXmlLocation);
        }
        return super.getResources(requestedPath);
    }
}

