/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.service;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.service.DestinationVariableArgumentResolver;
import org.springframework.messaging.rsocket.service.MetadataArgumentResolver;
import org.springframework.messaging.rsocket.service.PayloadArgumentResolver;
import org.springframework.messaging.rsocket.service.RSocketExchange;
import org.springframework.messaging.rsocket.service.RSocketServiceArgumentResolver;
import org.springframework.messaging.rsocket.service.RSocketServiceMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

public final class RSocketServiceProxyFactory {
    private final RSocketRequester rsocketRequester;
    private final List<RSocketServiceArgumentResolver> argumentResolvers;
    private final @Nullable StringValueResolver embeddedValueResolver;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final @Nullable Duration blockTimeout;

    private RSocketServiceProxyFactory(RSocketRequester rsocketRequester, List<RSocketServiceArgumentResolver> argumentResolvers, @Nullable StringValueResolver embeddedValueResolver, ReactiveAdapterRegistry reactiveAdapterRegistry, @Nullable Duration blockTimeout) {
        this.rsocketRequester = rsocketRequester;
        this.argumentResolvers = argumentResolvers;
        this.embeddedValueResolver = embeddedValueResolver;
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        this.blockTimeout = blockTimeout;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<RSocketServiceMethod> serviceMethods = MethodIntrospector.selectMethods(serviceType, this::isExchangeMethod).stream().map(method -> this.createRSocketServiceMethod(serviceType, (Method)method)).toList();
        return (S)ProxyFactory.getProxy(serviceType, (Interceptor)new ServiceMethodInterceptor(serviceMethods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, RSocketExchange.class);
    }

    private <S> RSocketServiceMethod createRSocketServiceMethod(Class<S> serviceType, Method method) {
        Assert.notNull(this.argumentResolvers, (String)"No argument resolvers: afterPropertiesSet was not called");
        return new RSocketServiceMethod(method, serviceType, this.argumentResolvers, this.rsocketRequester, this.embeddedValueResolver, this.reactiveAdapterRegistry, this.blockTimeout);
    }

    public static Builder builder(RSocketRequester requester) {
        return new Builder().rsocketRequester(requester);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class ServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, RSocketServiceMethod> serviceMethods;

        private ServiceMethodInterceptor(List<RSocketServiceMethod> methods) {
            this.serviceMethods = methods.stream().collect(Collectors.toMap(RSocketServiceMethod::getMethod, Function.identity()));
        }

        public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            RSocketServiceMethod serviceMethod = this.serviceMethods.get(method);
            if (serviceMethod != null) {
                @Nullable Object[] arguments = KotlinDetector.isSuspendingFunction((Method)method) ? ServiceMethodInterceptor.resolveCoroutinesArguments(invocation.getArguments()) : invocation.getArguments();
                return serviceMethod.invoke(arguments);
            }
            if (method.isDefault() && invocation instanceof ReflectiveMethodInvocation) {
                ReflectiveMethodInvocation reflectiveMethodInvocation = (ReflectiveMethodInvocation)invocation;
                Object proxy = reflectiveMethodInvocation.getProxy();
                return InvocationHandler.invokeDefault(proxy, method, invocation.getArguments());
            }
            throw new IllegalStateException("Unexpected method invocation: " + String.valueOf(method));
        }

        private static Object[] resolveCoroutinesArguments(@Nullable Object[] args) {
            Object[] functionArgs = new Object[args.length - 1];
            System.arraycopy(args, 0, functionArgs, 0, args.length - 1);
            return functionArgs;
        }
    }

    public static final class Builder {
        private @Nullable RSocketRequester rsocketRequester;
        private final List<RSocketServiceArgumentResolver> customArgumentResolvers = new ArrayList<RSocketServiceArgumentResolver>();
        private @Nullable StringValueResolver embeddedValueResolver;
        private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
        private @Nullable Duration blockTimeout;

        private Builder() {
        }

        public Builder rsocketRequester(RSocketRequester requester) {
            this.rsocketRequester = requester;
            return this;
        }

        public Builder customArgumentResolver(RSocketServiceArgumentResolver resolver) {
            this.customArgumentResolvers.add(resolver);
            return this;
        }

        public Builder embeddedValueResolver(StringValueResolver resolver) {
            this.embeddedValueResolver = resolver;
            return this;
        }

        public Builder reactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
            this.reactiveAdapterRegistry = registry;
            return this;
        }

        public Builder blockTimeout(@Nullable Duration blockTimeout) {
            this.blockTimeout = blockTimeout;
            return this;
        }

        public RSocketServiceProxyFactory build() {
            Assert.notNull((Object)this.rsocketRequester, (String)"RSocketRequester is required");
            return new RSocketServiceProxyFactory(this.rsocketRequester, this.initArgumentResolvers(), this.embeddedValueResolver, this.reactiveAdapterRegistry, this.blockTimeout);
        }

        private List<RSocketServiceArgumentResolver> initArgumentResolvers() {
            ArrayList<RSocketServiceArgumentResolver> resolvers = new ArrayList<RSocketServiceArgumentResolver>(this.customArgumentResolvers);
            resolvers.add(new PayloadArgumentResolver(this.reactiveAdapterRegistry, false));
            resolvers.add(new DestinationVariableArgumentResolver());
            resolvers.add(new MetadataArgumentResolver());
            resolvers.add(new PayloadArgumentResolver(this.reactiveAdapterRegistry, true));
            return resolvers;
        }
    }
}

