/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import java.rmi.Remote;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.jaxrpc.LocalJaxRpcServiceFactory;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;

public class JaxRpcPortClientInterceptor
extends LocalJaxRpcServiceFactory
implements MethodInterceptor,
InitializingBean {
    private Service jaxRpcService;
    private String portName;
    private String username;
    private String password;
    private String endpointAddress;
    private boolean maintainSession;
    private Properties customProperties;
    private Class serviceInterface;
    private Class portInterface;
    private QName portQName;
    private Remote portStub;
    static /* synthetic */ Class class$java$rmi$Remote;

    public void setJaxRpcService(Service jaxRpcService) {
        this.jaxRpcService = jaxRpcService;
    }

    public Service getJaxRpcService() {
        return this.jaxRpcService;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
    }

    public boolean isMaintainSession() {
        return this.maintainSession;
    }

    public void setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setPortInterface(Class portInterface) {
        if (!(portInterface == null || portInterface.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = JaxRpcPortClientInterceptor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(portInterface))) {
            throw new IllegalArgumentException("portInterface must be an interface derived from java.rmi.Remote");
        }
        this.portInterface = portInterface;
    }

    public Class getPortInterface() {
        return this.portInterface;
    }

    public void afterPropertiesSet() throws ServiceException {
        if (this.portName == null) {
            throw new IllegalArgumentException("portName is required");
        }
        if (this.serviceInterface == null && this.portInterface == null) {
            throw new IllegalArgumentException("Either serviceInterface or portInterface is required");
        }
        if (this.jaxRpcService == null) {
            this.jaxRpcService = this.createJaxRpcService();
            this.postProcessJaxRpcService(this.jaxRpcService);
        }
        this.portQName = this.getQName(this.portName);
        Class actualInterface = this.portInterface != null ? this.portInterface : this.serviceInterface;
        Remote remoteObj = this.jaxRpcService.getPort(this.portQName, actualInterface);
        if (this.serviceInterface != null) {
            boolean isImpl = this.serviceInterface.isInstance(remoteObj);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using service interface [" + this.serviceInterface.getName() + "] for JAX-RPC object [" + this.portQName + "] - " + (!isImpl ? "not" : "") + " directly implemented"));
            }
        }
        if (!(remoteObj instanceof Stub)) {
            throw new ServiceException("Returned port stub [" + remoteObj + "] does not implement javax.xml.rpc.Stub");
        }
        Stub stub = (Stub)remoteObj;
        if (this.username != null) {
            stub._setProperty("javax.xml.rpc.security.auth.username", (Object)this.username);
        }
        if (this.password != null) {
            stub._setProperty("javax.xml.rpc.security.auth.password", (Object)this.password);
        }
        if (this.endpointAddress != null) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.endpointAddress);
        }
        if (this.maintainSession) {
            stub._setProperty("javax.xml.rpc.session.maintain", (Object)new Boolean(this.maintainSession));
        }
        if (this.customProperties != null) {
            Enumeration<?> en = this.customProperties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                stub._setProperty(key, (Object)this.customProperties.getProperty(key));
            }
        }
        this.postProcessPortStub(stub);
        this.portStub = remoteObj;
    }

    protected void postProcessJaxRpcService(Service service) {
    }

    protected void postProcessPortStub(Stub portStub) {
    }

    protected Remote getPortStub() {
        return this.portStub;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        return RmiClientInterceptorUtils.invoke(invocation, this.getPortStub(), this.portQName.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

