/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.StaticMessageSource;

public class StaticApplicationContext
extends GenericApplicationContext {
    private final StaticMessageSource messageSource = new StaticMessageSource();

    public StaticApplicationContext() throws BeansException {
        this(null);
    }

    public StaticApplicationContext(ApplicationContext parent) throws BeansException {
        super(parent);
        this.getBeanFactory().registerSingleton("messageSource", (Object)this.messageSource);
    }

    public StaticMessageSource getStaticMessageSource() {
        return this.messageSource;
    }

    public void registerSingleton(String name, Class clazz, MutablePropertyValues pvs) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(clazz, pvs));
    }

    public void registerPrototype(String name, Class clazz, MutablePropertyValues pvs) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(clazz, pvs, false));
    }

    public void addMessage(String code, Locale locale, String defaultMessage) {
        this.getStaticMessageSource().addMessage(code, locale, defaultMessage);
    }
}

