/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.time.Instant;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class SortedSetReactiveRedisSessionExpirationStore {
    private final ReactiveRedisOperations<String, Object> sessionRedisOperations;
    private String namespace;
    private int retrieveCount = 100;

    SortedSetReactiveRedisSessionExpirationStore(ReactiveRedisOperations<String, Object> sessionRedisOperations, String namespace) {
        Assert.notNull(sessionRedisOperations, (String)"sessionRedisOperations cannot be null");
        Assert.hasText((String)namespace, (String)"namespace cannot be null or empty");
        this.sessionRedisOperations = sessionRedisOperations;
        this.namespace = namespace;
    }

    Mono<Void> add(String sessionId, Instant expiration) {
        long expirationInMillis = expiration.toEpochMilli();
        return this.sessionRedisOperations.opsForZSet().add((Object)this.getExpirationsKey(), (Object)sessionId, (double)expirationInMillis).then();
    }

    Mono<Void> remove(String sessionId) {
        return this.sessionRedisOperations.opsForZSet().remove((Object)this.getExpirationsKey(), new Object[]{sessionId}).then();
    }

    Flux<String> retrieveExpiredSessions(Instant expiredBefore) {
        Range range = Range.closed((Object)0.0, (Object)expiredBefore.toEpochMilli());
        Limit limit = Limit.limit().count(this.retrieveCount);
        return this.sessionRedisOperations.opsForZSet().reverseRangeByScore((Object)this.getExpirationsKey(), range, limit).cast(String.class);
    }

    private String getExpirationsKey() {
        return this.namespace + "sessions:expirations";
    }

    void setNamespace(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace cannot be null or empty");
        this.namespace = namespace;
    }
}

