/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class PreAuthenticatedAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 620L;
    private final Object principal;
    private final @Nullable Object credentials;

    public PreAuthenticatedAuthenticationToken(Object aPrincipal, @Nullable Object aCredentials) {
        super((Collection)null);
        this.principal = aPrincipal;
        this.credentials = aCredentials;
    }

    public PreAuthenticatedAuthenticationToken(Object aPrincipal, @Nullable Object aCredentials, Collection<? extends GrantedAuthority> anAuthorities) {
        super(anAuthorities);
        this.principal = aPrincipal;
        this.credentials = aCredentials;
        this.setAuthenticated(true);
    }

    protected PreAuthenticatedAuthenticationToken(Builder<?> builder) {
        super(builder);
        this.principal = builder.principal;
        this.credentials = builder.credentials;
    }

    public @Nullable Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private Object principal;
        private @Nullable Object credentials;

        protected Builder(PreAuthenticatedAuthenticationToken token) {
            super((AbstractAuthenticationToken)token);
            this.principal = token.principal;
            this.credentials = token.credentials;
        }

        public B principal(@Nullable Object principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = principal;
            return (B)((Object)this);
        }

        public B credentials(@Nullable Object credentials) {
            this.credentials = credentials;
            return (B)((Object)this);
        }

        public PreAuthenticatedAuthenticationToken build() {
            return new PreAuthenticatedAuthenticationToken(this);
        }
    }
}

