/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2Utils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.Assert;

public final class Saml2AuthenticationTokenConverter
implements AuthenticationConverter {
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository;
    private boolean shouldConvertGetRequests = true;

    public Saml2AuthenticationTokenConverter(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        Assert.notNull((Object)relyingPartyRegistrationResolver, (String)"relyingPartyRegistrationResolver cannot be null");
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        this.authenticationRequestRepository = new HttpSessionSaml2AuthenticationRequestRepository();
    }

    public Saml2AuthenticationToken convert(HttpServletRequest request) {
        AbstractSaml2AuthenticationRequest authenticationRequest = this.authenticationRequestRepository.loadAuthenticationRequest(request);
        String relyingPartyRegistrationId = authenticationRequest != null ? authenticationRequest.getRelyingPartyRegistrationId() : null;
        RelyingPartyRegistration relyingPartyRegistration = this.relyingPartyRegistrationResolver.resolve(request, relyingPartyRegistrationId);
        if (relyingPartyRegistration == null) {
            return null;
        }
        String saml2Response = this.decode(request);
        if (saml2Response == null) {
            return null;
        }
        return new Saml2AuthenticationToken(relyingPartyRegistration, saml2Response, authenticationRequest);
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.authenticationRequestRepository = authenticationRequestRepository;
    }

    public void setShouldConvertGetRequests(boolean shouldConvertGetRequests) {
        this.shouldConvertGetRequests = shouldConvertGetRequests;
    }

    private String decode(HttpServletRequest request) {
        String encoded = request.getParameter("SAMLResponse");
        if (encoded == null) {
            return null;
        }
        boolean isGet = HttpMethod.GET.matches(request.getMethod());
        if (!this.shouldConvertGetRequests && isGet) {
            return null;
        }
        Saml2Utils.DecodingConfigurer decoding = Saml2Utils.withEncoded(encoded).requireBase64(true).inflate(isGet);
        try {
            return decoding.decode();
        }
        catch (Exception ex) {
            throw new Saml2AuthenticationException(Saml2Error.invalidResponse(ex.getMessage()), ex);
        }
    }
}

