/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.util.Assert;

public final class Saml2LogoutValidatorResult {
    static final Saml2LogoutValidatorResult NO_ERRORS = new Saml2LogoutValidatorResult(Collections.emptyList());
    private final Collection<Saml2Error> errors;

    private Saml2LogoutValidatorResult(Collection<Saml2Error> errors) {
        Assert.notNull(errors, (String)"errors cannot be null");
        this.errors = new ArrayList<Saml2Error>(errors);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Collection<Saml2Error> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }

    public static Saml2LogoutValidatorResult success() {
        return NO_ERRORS;
    }

    public static Builder withErrors(Saml2Error ... errors) {
        return new Builder(errors);
    }

    public static final class Builder {
        private final Collection<Saml2Error> errors;

        private Builder(Saml2Error ... errors) {
            this(Arrays.asList(errors));
        }

        private Builder(Collection<Saml2Error> errors) {
            Assert.noNullElements(errors, (String)"errors cannot have null elements");
            this.errors = new ArrayList<Saml2Error>(errors);
        }

        public Builder errors(Consumer<Collection<Saml2Error>> errorsConsumer) {
            errorsConsumer.accept(this.errors);
            return this;
        }

        public Saml2LogoutValidatorResult build() {
            return new Saml2LogoutValidatorResult(this.errors);
        }
    }
}

