/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.metadata;

import java.util.function.Consumer;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.metadata.BaseOpenSamlMetadataResolver;
import org.springframework.security.saml2.provider.service.metadata.OpenSaml5Template;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResolver;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

public final class OpenSaml5MetadataResolver
implements Saml2MetadataResolver {
    private final BaseOpenSamlMetadataResolver delegate = new BaseOpenSamlMetadataResolver(new OpenSaml5Template());

    @Override
    public String resolve(RelyingPartyRegistration relyingPartyRegistration) {
        return this.delegate.resolve(relyingPartyRegistration);
    }

    @Override
    public String resolve(Iterable<RelyingPartyRegistration> relyingPartyRegistrations) {
        return this.delegate.resolve(relyingPartyRegistrations);
    }

    public void setEntityDescriptorCustomizer(Consumer<EntityDescriptorParameters> entityDescriptorCustomizer) {
        this.delegate.setEntityDescriptorCustomizer((BaseOpenSamlMetadataResolver.EntityDescriptorParameters parameters) -> entityDescriptorCustomizer.accept(new EntityDescriptorParameters((BaseOpenSamlMetadataResolver.EntityDescriptorParameters)parameters)));
    }

    public void setUsePrettyPrint(boolean usePrettyPrint) {
        this.delegate.setUsePrettyPrint(usePrettyPrint);
    }

    public void setSignMetadata(boolean signMetadata) {
        this.delegate.setSignMetadata(signMetadata);
    }

    static {
        OpenSamlInitializationService.initialize();
    }

    public static final class EntityDescriptorParameters {
        private final EntityDescriptor entityDescriptor;
        private final RelyingPartyRegistration registration;

        public EntityDescriptorParameters(EntityDescriptor entityDescriptor, RelyingPartyRegistration registration) {
            this.entityDescriptor = entityDescriptor;
            this.registration = registration;
        }

        EntityDescriptorParameters(BaseOpenSamlMetadataResolver.EntityDescriptorParameters parameters) {
            this.entityDescriptor = parameters.getEntityDescriptor();
            this.registration = parameters.getRelyingPartyRegistration();
        }

        public EntityDescriptor getEntityDescriptor() {
            return this.entityDescriptor;
        }

        public RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }
    }
}

