/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.http.HttpMethod;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.OpenSaml4Template;
import org.springframework.security.saml2.provider.service.web.OpenSamlOperations;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationPlaceholderResolvers;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2Utils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

@Deprecated
public final class OpenSamlAuthenticationTokenConverter
implements AuthenticationConverter {
    private final OpenSamlOperations saml = new OpenSaml4Template();
    private final RelyingPartyRegistrationRepository registrations;
    private RequestMatcher requestMatcher = new OrRequestMatcher(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/login/saml2/sso/{registrationId}"), PathPatternRequestMatcher.withDefaults().matcher("/login/saml2/sso")});
    private Function<HttpServletRequest, AbstractSaml2AuthenticationRequest> loader;

    public OpenSamlAuthenticationTokenConverter(RelyingPartyRegistrationRepository registrations) {
        Assert.notNull((Object)registrations, (String)"relyingPartyRegistrationRepository cannot be null");
        this.registrations = registrations;
        this.loader = new HttpSessionSaml2AuthenticationRequestRepository()::loadAuthenticationRequest;
    }

    public Saml2AuthenticationToken convert(HttpServletRequest request) {
        String serialized = request.getParameter("SAMLResponse");
        if (serialized == null) {
            return null;
        }
        RequestMatcher.MatchResult result = this.requestMatcher.matcher(request);
        if (!result.isMatch()) {
            return null;
        }
        Saml2AuthenticationToken token = this.tokenByAuthenticationRequest(request);
        if (token == null) {
            token = this.tokenByRegistrationId(request, result);
        }
        if (token == null) {
            token = this.tokenByEntityId(request);
        }
        return token;
    }

    private Saml2AuthenticationToken tokenByAuthenticationRequest(HttpServletRequest request) {
        AbstractSaml2AuthenticationRequest authenticationRequest = this.loadAuthenticationRequest(request);
        if (authenticationRequest == null) {
            return null;
        }
        String registrationId = authenticationRequest.getRelyingPartyRegistrationId();
        RelyingPartyRegistration registration = this.registrations.findByRegistrationId(registrationId);
        return this.tokenByRegistration(request, registration, authenticationRequest);
    }

    private Saml2AuthenticationToken tokenByRegistrationId(HttpServletRequest request, RequestMatcher.MatchResult result) {
        String registrationId = (String)result.getVariables().get("registrationId");
        if (registrationId == null) {
            return null;
        }
        RelyingPartyRegistration registration = this.registrations.findByRegistrationId(registrationId);
        return this.tokenByRegistration(request, registration, null);
    }

    private Saml2AuthenticationToken tokenByEntityId(HttpServletRequest request) {
        Response response = (Response)this.saml.deserialize(this.decode(request));
        String issuer = response.getIssuer().getValue();
        RelyingPartyRegistration registration = this.registrations.findUniqueByAssertingPartyEntityId(issuer);
        return this.tokenByRegistration(request, registration, null);
    }

    private Saml2AuthenticationToken tokenByRegistration(HttpServletRequest request, RelyingPartyRegistration registration, AbstractSaml2AuthenticationRequest authenticationRequest) {
        if (registration == null) {
            return null;
        }
        String decoded = this.decode(request);
        RelyingPartyRegistrationPlaceholderResolvers.UriResolver resolver = RelyingPartyRegistrationPlaceholderResolvers.uriResolver(request, registration);
        registration = registration.mutate().entityId(resolver.resolve(registration.getEntityId())).assertionConsumerServiceLocation(resolver.resolve(registration.getAssertionConsumerServiceLocation())).build();
        return new Saml2AuthenticationToken(registration, decoded, authenticationRequest);
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.loader = authenticationRequestRepository::loadAuthenticationRequest;
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }

    private AbstractSaml2AuthenticationRequest loadAuthenticationRequest(HttpServletRequest request) {
        return this.loader.apply(request);
    }

    private String decode(HttpServletRequest request) {
        String encoded = request.getParameter("SAMLResponse");
        try {
            return Saml2Utils.withEncoded(encoded).requireBase64(true).inflate(HttpMethod.GET.matches(request.getMethod())).decode();
        }
        catch (Exception ex) {
            throw new Saml2AuthenticationException(new Saml2Error("invalid_response", ex.getMessage()), ex);
        }
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

