/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

final class LogoutRequestEncryptedIdUtils {
    private static final EncryptedKeyResolver encryptedKeyResolver = new ChainingEncryptedKeyResolver(Arrays.asList(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver()));

    static SAMLObject decryptEncryptedId(EncryptedID encryptedId, RelyingPartyRegistration registration) {
        Decrypter decrypter = LogoutRequestEncryptedIdUtils.decrypter(registration);
        try {
            return decrypter.decrypt(encryptedId);
        }
        catch (Exception ex) {
            throw new Saml2Exception(ex);
        }
    }

    private static Decrypter decrypter(RelyingPartyRegistration registration) {
        ArrayList<BasicX509Credential> credentials = new ArrayList<BasicX509Credential>();
        for (Saml2X509Credential key : registration.getDecryptionX509Credentials()) {
            BasicX509Credential cred = CredentialSupport.getSimpleCredential((X509Certificate)key.getCertificate(), (PrivateKey)key.getPrivateKey());
            credentials.add(cred);
        }
        CollectionKeyInfoCredentialResolver resolver = new CollectionKeyInfoCredentialResolver(credentials);
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)resolver, encryptedKeyResolver);
        decrypter.setRootInNewDocument(true);
        return decrypter;
    }

    private LogoutRequestEncryptedIdUtils() {
    }
}

