/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.web.csrf;

import java.util.Base64;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.util.Assert;

final class XorCsrfTokenUtils {
    private XorCsrfTokenUtils() {
    }

    static String getTokenValue(String actualToken, String token) {
        byte[] actualBytes;
        try {
            actualBytes = Base64.getUrlDecoder().decode(actualToken);
        }
        catch (Exception ex) {
            return null;
        }
        byte[] tokenBytes = Utf8.encode((CharSequence)token);
        int tokenSize = tokenBytes.length;
        if (actualBytes.length != tokenSize * 2) {
            return null;
        }
        byte[] xoredCsrf = new byte[tokenSize];
        byte[] randomBytes = new byte[tokenSize];
        System.arraycopy(actualBytes, 0, randomBytes, 0, tokenSize);
        System.arraycopy(actualBytes, tokenSize, xoredCsrf, 0, tokenSize);
        byte[] csrfBytes = XorCsrfTokenUtils.xorCsrf(randomBytes, xoredCsrf);
        return Utf8.decode((byte[])csrfBytes);
    }

    private static byte[] xorCsrf(byte[] randomBytes, byte[] csrfBytes) {
        Assert.isTrue((randomBytes.length == csrfBytes.length ? 1 : 0) != 0, (String)"arrays must be equal length");
        int len = csrfBytes.length;
        byte[] xoredCsrf = new byte[len];
        System.arraycopy(csrfBytes, 0, xoredCsrf, 0, len);
        for (int i = 0; i < len; ++i) {
            int n = i;
            xoredCsrf[n] = (byte)(xoredCsrf[n] ^ randomBytes[i]);
        }
        return xoredCsrf;
    }
}

