/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.List;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.Ordered;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.security.aot.hint.SecurityHintsRegistrar;
import org.springframework.security.authorization.AuthorizationProxyFactory;
import org.springframework.security.authorization.method.AuthorizationAdvisorProxyFactory;
import org.springframework.security.data.aot.hint.AuthorizeReturnObjectDataHintsRegistrar;

@Configuration(proxyBeanMethods=false)
final class AuthorizationProxyDataConfiguration
implements AopInfrastructureBean {
    AuthorizationProxyDataConfiguration() {
    }

    @Bean
    @Role(value=2)
    static SecurityHintsRegistrar authorizeReturnObjectDataHintsRegistrar(AuthorizationProxyFactory proxyFactory) {
        return new AuthorizeReturnObjectDataHintsRegistrar(proxyFactory);
    }

    @Bean
    @Role(value=2)
    DataTargetVisitor dataTargetVisitor() {
        return new DataTargetVisitor();
    }

    static final class DataTargetVisitor
    implements AuthorizationAdvisorProxyFactory.TargetVisitor,
    Ordered {
        private static final int DEFAULT_ORDER = 200;

        DataTargetVisitor() {
        }

        public Object visit(AuthorizationAdvisorProxyFactory proxyFactory, Object target) {
            if (target instanceof GeoResults) {
                GeoResults geoResults = (GeoResults)target;
                return new GeoResults((List)proxyFactory.proxy((Object)geoResults.getContent()), geoResults.getAverageDistance());
            }
            if (target instanceof GeoResult) {
                GeoResult geoResult = (GeoResult)target;
                return new GeoResult(proxyFactory.proxy(geoResult.getContent()), geoResult.getDistance());
            }
            if (target instanceof GeoPage) {
                GeoPage geoPage = (GeoPage)target;
                GeoResults results = new GeoResults((List)proxyFactory.proxy((Object)geoPage.getContent()), geoPage.getAverageDistance());
                return new GeoPage(results, geoPage.getPageable(), geoPage.getTotalElements());
            }
            if (target instanceof PageImpl) {
                PageImpl page = (PageImpl)target;
                List content = (List)proxyFactory.proxy((Object)page.getContent());
                return new PageImpl(content, page.getPageable(), page.getTotalElements());
            }
            if (target instanceof SliceImpl) {
                SliceImpl slice = (SliceImpl)target;
                List content = (List)proxyFactory.proxy((Object)slice.getContent());
                return new SliceImpl(content, slice.getPageable(), slice.hasNext());
            }
            return null;
        }

        public int getOrder() {
            return 200;
        }
    }
}

