/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.Map;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AopUtils;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;

class PointcutDelegatingAuthorizationManager
implements AuthorizationManager<MethodInvocation> {
    private final Map<Pointcut, AuthorizationManager<MethodInvocation>> managers;

    PointcutDelegatingAuthorizationManager(Map<Pointcut, AuthorizationManager<MethodInvocation>> managers) {
        this.managers = managers;
    }

    public AuthorizationResult authorize(Supplier<? extends @Nullable Authentication> authentication, MethodInvocation object) {
        for (Map.Entry<Pointcut, AuthorizationManager<MethodInvocation>> entry : this.managers.entrySet()) {
            Class targetClass;
            Class clazz = targetClass = object.getThis() != null ? AopUtils.getTargetClass((Object)object.getThis()) : null;
            if (!entry.getKey().getClassFilter().matches(targetClass) || !entry.getKey().getMethodMatcher().matches(object.getMethod(), targetClass)) continue;
            return entry.getValue().authorize(authentication, (Object)object);
        }
        return new AuthorizationDecision(false);
    }
}

